/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.execution.search.SqlSourceBuilder;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.SubstringFunctionProcessor;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;

public class SubstringFunctionPipe
extends Pipe {
    private final Pipe source;
    private final Pipe start;
    private final Pipe length;

    public SubstringFunctionPipe(Source source, Expression expression, Pipe src, Pipe start, Pipe length) {
        super(source, expression, Arrays.asList(src, start, length));
        this.source = src;
        this.start = start;
        this.length = length;
    }

    @Override
    public final Pipe replaceChildren(List<Pipe> newChildren) {
        if (newChildren.size() != 3) {
            throw new IllegalArgumentException("expected [3] children but received [" + newChildren.size() + "]");
        }
        return this.replaceChildren(newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    @Override
    public final Pipe resolveAttributes(Pipe.AttributeResolver resolver) {
        Pipe newSource = this.source.resolveAttributes(resolver);
        Pipe newStart = this.start.resolveAttributes(resolver);
        Pipe newLength = this.length.resolveAttributes(resolver);
        if (newSource == this.source && newStart == this.start && newLength == this.length) {
            return this;
        }
        return this.replaceChildren(newSource, newStart, newLength);
    }

    @Override
    public boolean supportedByAggsOnlyQuery() {
        return this.source.supportedByAggsOnlyQuery() && this.start.supportedByAggsOnlyQuery() && this.length.supportedByAggsOnlyQuery();
    }

    @Override
    public boolean resolved() {
        return this.source.resolved() && this.start.resolved() && this.length.resolved();
    }

    protected Pipe replaceChildren(Pipe newSource, Pipe newStart, Pipe newLength) {
        return new SubstringFunctionPipe(this.source(), this.expression(), newSource, newStart, newLength);
    }

    @Override
    public final void collectFields(SqlSourceBuilder sourceBuilder) {
        this.source.collectFields(sourceBuilder);
        this.start.collectFields(sourceBuilder);
        this.length.collectFields(sourceBuilder);
    }

    @Override
    protected NodeInfo<SubstringFunctionPipe> info() {
        return NodeInfo.create(this, SubstringFunctionPipe::new, this.expression(), this.source, this.start, this.length);
    }

    @Override
    public SubstringFunctionProcessor asProcessor() {
        return new SubstringFunctionProcessor(this.source.asProcessor(), this.start.asProcessor(), this.length.asProcessor());
    }

    public Pipe src() {
        return this.source;
    }

    public Pipe start() {
        return this.start;
    }

    public Pipe length() {
        return this.length;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.source, this.start, this.length);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SubstringFunctionPipe other = (SubstringFunctionPipe)obj;
        return Objects.equals(this.source, other.source) && Objects.equals(this.start, other.start) && Objects.equals(this.length, other.length);
    }
}

