/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.store;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.common.IteratingActionListener;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsDefinition;
import org.elasticsearch.xpack.core.security.authz.permission.LimitedRole;
import org.elasticsearch.xpack.core.security.authz.permission.Role;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ConditionalClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.Privilege;
import org.elasticsearch.xpack.core.security.authz.store.ReservedRolesStore;
import org.elasticsearch.xpack.core.security.authz.store.RoleRetrievalResult;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.core.security.user.BwcXPackUser;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.core.security.user.XPackSecurityUser;
import org.elasticsearch.xpack.core.security.user.XPackUser;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authz.store.FileRolesStore;
import org.elasticsearch.xpack.security.authz.store.NativePrivilegeStore;
import org.elasticsearch.xpack.security.authz.store.NativeRolesStore;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class CompositeRolesStore {
    private static final String ROLES_STORE_SOURCE = "roles_stores";
    private static final Setting<Integer> CACHE_SIZE_SETTING = Setting.intSetting((String)"xpack.security.authz.store.roles.cache.max_size", (int)10000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<Integer> NEGATIVE_LOOKUP_CACHE_SIZE_SETTING = Setting.intSetting((String)"xpack.security.authz.store.roles.negative_lookup_cache.max_size", (int)10000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger(CompositeRolesStore.class);
    private final ReleasableLock readLock;
    private final ReleasableLock writeLock;
    private final FileRolesStore fileRolesStore;
    private final NativeRolesStore nativeRolesStore;
    private final NativePrivilegeStore privilegeStore;
    private final XPackLicenseState licenseState;
    private final FieldPermissionsCache fieldPermissionsCache;
    private final Cache<RoleKey, Role> roleCache;
    private final Cache<String, Boolean> negativeLookupCache;
    private final ThreadContext threadContext;
    private final AtomicLong numInvalidation;
    private final AnonymousUser anonymousUser;
    private final ApiKeyService apiKeyService;
    private final boolean isAnonymousEnabled;
    private final List<BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>>> builtInRoleProviders;
    private final List<BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>>> allRoleProviders;

    public CompositeRolesStore(Settings settings, FileRolesStore fileRolesStore, NativeRolesStore nativeRolesStore, ReservedRolesStore reservedRolesStore, NativePrivilegeStore privilegeStore, List<BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>>> rolesProviders, ThreadContext threadContext, XPackLicenseState licenseState, FieldPermissionsCache fieldPermissionsCache, ApiKeyService apiKeyService) {
        ReentrantReadWriteLock iterationLock = new ReentrantReadWriteLock();
        this.readLock = new ReleasableLock(iterationLock.readLock());
        this.writeLock = new ReleasableLock(iterationLock.writeLock());
        this.numInvalidation = new AtomicLong();
        this.fileRolesStore = fileRolesStore;
        fileRolesStore.addListener(this::invalidate);
        this.nativeRolesStore = nativeRolesStore;
        this.privilegeStore = privilegeStore;
        this.licenseState = licenseState;
        this.fieldPermissionsCache = fieldPermissionsCache;
        this.apiKeyService = apiKeyService;
        CacheBuilder builder = CacheBuilder.builder();
        int cacheSize = (Integer)CACHE_SIZE_SETTING.get(settings);
        if (cacheSize >= 0) {
            builder.setMaximumWeight((long)cacheSize);
        }
        this.roleCache = builder.build();
        this.threadContext = threadContext;
        CacheBuilder nlcBuilder = CacheBuilder.builder();
        int nlcCacheSize = (Integer)NEGATIVE_LOOKUP_CACHE_SIZE_SETTING.get(settings);
        if (nlcCacheSize >= 0) {
            nlcBuilder.setMaximumWeight((long)nlcCacheSize);
        }
        this.negativeLookupCache = nlcBuilder.build();
        this.builtInRoleProviders = Collections.unmodifiableList(Arrays.asList(reservedRolesStore, fileRolesStore, nativeRolesStore));
        if (rolesProviders.isEmpty()) {
            this.allRoleProviders = this.builtInRoleProviders;
        } else {
            ArrayList<BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>>> allList = new ArrayList<BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>>>(this.builtInRoleProviders.size() + rolesProviders.size());
            allList.addAll(this.builtInRoleProviders);
            allList.addAll(rolesProviders);
            this.allRoleProviders = Collections.unmodifiableList(allList);
        }
        this.anonymousUser = new AnonymousUser(settings);
        this.isAnonymousEnabled = AnonymousUser.isAnonymousEnabled((Settings)settings);
    }

    public void roles(Set<String> roleNames, ActionListener<Role> roleActionListener) {
        RoleKey roleKey = new RoleKey(roleNames, ROLES_STORE_SOURCE);
        Role existing = (Role)this.roleCache.get((Object)roleKey);
        if (existing != null) {
            roleActionListener.onResponse((Object)existing);
        } else {
            long invalidationCounter = this.numInvalidation.get();
            this.roleDescriptors(roleNames, (ActionListener<RolesRetrievalResult>)ActionListener.wrap(rolesRetrievalResult -> {
                boolean missingRoles;
                boolean bl = missingRoles = !((RolesRetrievalResult)rolesRetrievalResult).getMissingRoles().isEmpty();
                if (missingRoles) {
                    logger.debug("Could not find roles with names {}", (Object)((RolesRetrievalResult)rolesRetrievalResult).getMissingRoles());
                }
                Set<RoleDescriptor> effectiveDescriptors = this.licenseState.isDocumentAndFieldLevelSecurityAllowed() ? ((RolesRetrievalResult)rolesRetrievalResult).getRoleDescriptors() : ((RolesRetrievalResult)rolesRetrievalResult).getRoleDescriptors().stream().filter(rd -> !rd.isUsingDocumentOrFieldLevelSecurity()).collect(Collectors.toSet());
                this.buildThenMaybeCacheRole(roleKey, effectiveDescriptors, ((RolesRetrievalResult)rolesRetrievalResult).getMissingRoles(), ((RolesRetrievalResult)rolesRetrievalResult).isSuccess(), invalidationCounter, roleActionListener);
            }, arg_0 -> roleActionListener.onFailure(arg_0)));
        }
    }

    public void buildAndCacheRoleFromDescriptors(Collection<RoleDescriptor> roleDescriptors, String source, ActionListener<Role> listener) {
        if (ROLES_STORE_SOURCE.equals(source)) {
            throw new IllegalArgumentException("source [roles_stores] is reserved for internal use");
        }
        RoleKey roleKey = new RoleKey(roleDescriptors.stream().map(RoleDescriptor::getName).collect(Collectors.toSet()), source);
        Role existing = (Role)this.roleCache.get((Object)roleKey);
        if (existing != null) {
            listener.onResponse((Object)existing);
        } else {
            long invalidationCounter = this.numInvalidation.get();
            this.buildThenMaybeCacheRole(roleKey, roleDescriptors, Collections.emptySet(), true, invalidationCounter, listener);
        }
    }

    private void buildThenMaybeCacheRole(RoleKey roleKey, Collection<RoleDescriptor> roleDescriptors, Set<String> missing, boolean tryCache, long invalidationCounter, ActionListener<Role> listener) {
        logger.trace("Building role from descriptors [{}] for names [{}] from source [{}]", roleDescriptors, (Object)roleKey.names, (Object)roleKey.source);
        CompositeRolesStore.buildRoleFromDescriptors(roleDescriptors, this.fieldPermissionsCache, this.privilegeStore, (ActionListener<Role>)ActionListener.wrap(role -> {
            if (role != null && tryCache) {
                try (ReleasableLock ignored = this.readLock.acquire();){
                    if (invalidationCounter == this.numInvalidation.get()) {
                        this.roleCache.computeIfAbsent((Object)roleKey, s -> role);
                    }
                }
                for (String missingRole : missing) {
                    this.negativeLookupCache.computeIfAbsent((Object)missingRole, s -> Boolean.TRUE);
                }
            }
            listener.onResponse(role);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void getRoleDescriptors(Set<String> roleNames, ActionListener<Set<RoleDescriptor>> listener) {
        this.roleDescriptors(roleNames, (ActionListener<RolesRetrievalResult>)ActionListener.wrap(rolesRetrievalResult -> {
            if (((RolesRetrievalResult)rolesRetrievalResult).isSuccess()) {
                listener.onResponse((Object)((RolesRetrievalResult)rolesRetrievalResult).getRoleDescriptors());
            } else {
                listener.onFailure((Exception)new ElasticsearchException("role retrieval had one or more failures", new Object[0]));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void getRoles(User user, Authentication authentication, ActionListener<Role> roleActionListener) {
        if (SystemUser.is((User)user)) {
            throw new IllegalArgumentException("the user [" + user.principal() + "] is the system user and we should never try to get its roles");
        }
        if (XPackUser.is((User)user)) {
            assert (XPackUser.INSTANCE.roles().length == 1);
            roleActionListener.onResponse((Object)XPackUser.ROLE);
            return;
        }
        if (XPackSecurityUser.is((User)user)) {
            roleActionListener.onResponse((Object)ReservedRolesStore.SUPERUSER_ROLE);
            return;
        }
        if (BwcXPackUser.is((User)user)) {
            roleActionListener.onResponse((Object)ReservedRolesStore.SUPERUSER_ROLE);
            return;
        }
        if (authentication.getAuthenticationType() == Authentication.AuthenticationType.API_KEY) {
            this.apiKeyService.getRoleForApiKey(authentication, (ActionListener<ApiKeyService.ApiKeyRoleDescriptors>)ActionListener.wrap(apiKeyRoleDescriptors -> {
                List<RoleDescriptor> descriptors = apiKeyRoleDescriptors.getRoleDescriptors();
                if (descriptors == null) {
                    roleActionListener.onFailure((Exception)new IllegalStateException("missing role descriptors"));
                } else if (apiKeyRoleDescriptors.getLimitedByRoleDescriptors() == null) {
                    this.buildAndCacheRoleFromDescriptors(descriptors, apiKeyRoleDescriptors.getApiKeyId() + "_role_desc", roleActionListener);
                } else {
                    this.buildAndCacheRoleFromDescriptors(descriptors, apiKeyRoleDescriptors.getApiKeyId() + "_role_desc", (ActionListener<Role>)ActionListener.wrap(role -> this.buildAndCacheRoleFromDescriptors(apiKeyRoleDescriptors.getLimitedByRoleDescriptors(), apiKeyRoleDescriptors.getApiKeyId() + "_limited_role_desc", (ActionListener<Role>)ActionListener.wrap(limitedBy -> roleActionListener.onResponse((Object)LimitedRole.createLimitedRole((Role)role, (Role)limitedBy)), arg_0 -> ((ActionListener)roleActionListener).onFailure(arg_0))), arg_0 -> ((ActionListener)roleActionListener).onFailure(arg_0)));
                }
            }, arg_0 -> roleActionListener.onFailure(arg_0)));
        } else {
            HashSet<String> roleNames = new HashSet<String>(Arrays.asList(user.roles()));
            if (this.isAnonymousEnabled && !this.anonymousUser.equals((Object)user)) {
                if (this.anonymousUser.roles().length == 0) {
                    throw new IllegalStateException("anonymous is only enabled when the anonymous user has roles");
                }
                Collections.addAll(roleNames, this.anonymousUser.roles());
            }
            if (roleNames.isEmpty()) {
                roleActionListener.onResponse((Object)Role.EMPTY);
            } else if (roleNames.contains(ReservedRolesStore.SUPERUSER_ROLE_DESCRIPTOR.getName())) {
                roleActionListener.onResponse((Object)ReservedRolesStore.SUPERUSER_ROLE);
            } else {
                this.roles(roleNames, roleActionListener);
            }
        }
    }

    private void roleDescriptors(Set<String> roleNames, ActionListener<RolesRetrievalResult> rolesResultListener) {
        Set<String> filteredRoleNames = roleNames.stream().filter(s -> {
            if (this.negativeLookupCache.get(s) != null) {
                logger.debug("Requested role [{}] does not exist (cached)", s);
                return false;
            }
            return true;
        }).collect(Collectors.toSet());
        this.loadRoleDescriptorsAsync(filteredRoleNames, rolesResultListener);
    }

    private void loadRoleDescriptorsAsync(Set<String> roleNames, ActionListener<RolesRetrievalResult> listener) {
        RolesRetrievalResult rolesResult = new RolesRetrievalResult();
        List<BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>>> asyncRoleProviders = this.licenseState.isCustomRoleProvidersAllowed() ? this.allRoleProviders : this.builtInRoleProviders;
        ContextPreservingActionListener descriptorsListener = ContextPreservingActionListener.wrapPreservingContext((ActionListener)ActionListener.wrap(ignore -> {
            rolesResult.setMissingRoles(roleNames);
            listener.onResponse((Object)rolesResult);
        }, arg_0 -> listener.onFailure(arg_0)), (ThreadContext)this.threadContext);
        Predicate<RoleRetrievalResult> iterationPredicate = result -> !roleNames.isEmpty();
        new IteratingActionListener((ActionListener)descriptorsListener, (rolesProvider, providerListener) -> rolesProvider.accept(roleNames, ActionListener.wrap(result -> {
            if (result.isSuccess()) {
                logger.debug(() -> new ParameterizedMessage("Roles [{}] were resolved by [{}]", (Object)this.names(result.getDescriptors()), rolesProvider));
                Set resolvedDescriptors = result.getDescriptors();
                rolesResult.addDescriptors(resolvedDescriptors);
                for (RoleDescriptor descriptor : resolvedDescriptors) {
                    roleNames.remove(descriptor.getName());
                }
            } else {
                logger.warn((Message)new ParameterizedMessage("role retrieval failed from [{}]", rolesProvider), (Throwable)result.getFailure());
                rolesResult.setFailure();
            }
            providerListener.onResponse(result);
        }, arg_0 -> ((ActionListener)providerListener).onFailure(arg_0))), asyncRoleProviders, this.threadContext, Function.identity(), iterationPredicate).run();
    }

    private String names(Collection<RoleDescriptor> descriptors) {
        return descriptors.stream().map(RoleDescriptor::getName).collect(Collectors.joining(","));
    }

    public static void buildRoleFromDescriptors(Collection<RoleDescriptor> roleDescriptors, FieldPermissionsCache fieldPermissionsCache, NativePrivilegeStore privilegeStore, ActionListener<Role> listener) {
        if (roleDescriptors.isEmpty()) {
            listener.onResponse((Object)Role.EMPTY);
            return;
        }
        HashSet<String> clusterPrivileges = new HashSet<String>();
        ArrayList<ConditionalClusterPrivilege> conditionalClusterPrivileges = new ArrayList<ConditionalClusterPrivilege>();
        HashSet<String> runAs = new HashSet<String>();
        HashMap restrictedIndicesPrivilegesMap = new HashMap();
        HashMap indicesPrivilegesMap = new HashMap();
        HashMap<Tuple, Set> applicationPrivilegesMap = new HashMap<Tuple, Set>();
        ArrayList<String> roleNames = new ArrayList<String>(roleDescriptors.size());
        for (RoleDescriptor descriptor : roleDescriptors) {
            roleNames.add(descriptor.getName());
            if (descriptor.getClusterPrivileges() != null) {
                clusterPrivileges.addAll(Arrays.asList(descriptor.getClusterPrivileges()));
            }
            if (descriptor.getConditionalClusterPrivileges() != null) {
                conditionalClusterPrivileges.addAll(Arrays.asList(descriptor.getConditionalClusterPrivileges()));
            }
            if (descriptor.getRunAs() != null) {
                runAs.addAll(Arrays.asList(descriptor.getRunAs()));
            }
            MergeableIndicesPrivilege.collatePrivilegesByIndices(descriptor.getIndicesPrivileges(), true, restrictedIndicesPrivilegesMap);
            MergeableIndicesPrivilege.collatePrivilegesByIndices(descriptor.getIndicesPrivileges(), false, indicesPrivilegesMap);
            for (RoleDescriptor.ApplicationResourcePrivileges appPrivilege : descriptor.getApplicationPrivileges()) {
                Tuple key = new Tuple((Object)appPrivilege.getApplication(), (Object)Sets.newHashSet((Object[])appPrivilege.getResources()));
                applicationPrivilegesMap.compute(key, (k, v) -> {
                    if (v == null) {
                        return Sets.newHashSet((Object[])appPrivilege.getPrivileges());
                    }
                    v.addAll(Arrays.asList(appPrivilege.getPrivileges()));
                    return v;
                });
            }
        }
        Privilege runAsPrivilege = runAs.isEmpty() ? Privilege.NONE : new Privilege(runAs, runAs.toArray(Strings.EMPTY_ARRAY));
        Role.Builder builder = Role.builder((String[])roleNames.toArray(new String[roleNames.size()]), (FieldPermissionsCache)fieldPermissionsCache).cluster(clusterPrivileges, conditionalClusterPrivileges).runAs(runAsPrivilege);
        indicesPrivilegesMap.entrySet().forEach(entry -> {
            MergeableIndicesPrivilege privilege = (MergeableIndicesPrivilege)entry.getValue();
            builder.add(fieldPermissionsCache.getFieldPermissions(privilege.fieldPermissionsDefinition), privilege.query, IndexPrivilege.get((Set)privilege.privileges), false, privilege.indices.toArray(Strings.EMPTY_ARRAY));
        });
        restrictedIndicesPrivilegesMap.entrySet().forEach(entry -> {
            MergeableIndicesPrivilege privilege = (MergeableIndicesPrivilege)entry.getValue();
            builder.add(fieldPermissionsCache.getFieldPermissions(privilege.fieldPermissionsDefinition), privilege.query, IndexPrivilege.get((Set)privilege.privileges), true, privilege.indices.toArray(Strings.EMPTY_ARRAY));
        });
        if (applicationPrivilegesMap.isEmpty()) {
            listener.onResponse((Object)builder.build());
        } else {
            Set<String> applicationNames = applicationPrivilegesMap.keySet().stream().map(Tuple::v1).collect(Collectors.toSet());
            Set<String> applicationPrivilegeNames = applicationPrivilegesMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            privilegeStore.getPrivileges(applicationNames, applicationPrivilegeNames, (ActionListener<Collection<ApplicationPrivilegeDescriptor>>)ActionListener.wrap(appPrivileges -> {
                applicationPrivilegesMap.forEach((key, names) -> builder.addApplicationPrivilege(ApplicationPrivilege.get((String)((String)key.v1()), (Set)names, (Collection)appPrivileges), (Set)key.v2()));
                listener.onResponse((Object)builder.build());
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }

    public void invalidateAll() {
        this.numInvalidation.incrementAndGet();
        this.negativeLookupCache.invalidateAll();
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.roleCache.invalidateAll();
        }
    }

    public void invalidate(String role) {
        this.numInvalidation.incrementAndGet();
        try (ReleasableLock ignored = this.writeLock.acquire();){
            Iterator keyIter = this.roleCache.keys().iterator();
            while (keyIter.hasNext()) {
                RoleKey key = (RoleKey)keyIter.next();
                if (!key.names.contains(role)) continue;
                keyIter.remove();
            }
        }
        this.negativeLookupCache.invalidate((Object)role);
    }

    public void invalidate(Set<String> roles) {
        this.numInvalidation.incrementAndGet();
        try (ReleasableLock ignored = this.writeLock.acquire();){
            Iterator keyIter = this.roleCache.keys().iterator();
            while (keyIter.hasNext()) {
                RoleKey key = (RoleKey)keyIter.next();
                if (Sets.haveEmptyIntersection((Set)key.names, roles)) continue;
                keyIter.remove();
            }
        }
        roles.forEach(arg_0 -> this.negativeLookupCache.invalidate(arg_0));
    }

    public void usageStats(ActionListener<Map<String, Object>> listener) {
        HashMap<String, Map<String, Object>> usage = new HashMap<String, Map<String, Object>>(2);
        usage.put("file", this.fileRolesStore.usageStats());
        this.nativeRolesStore.usageStats((ActionListener<Map<String, Object>>)ActionListener.wrap(map -> {
            usage.put("native", (Map<String, Object>)map);
            listener.onResponse((Object)usage);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void onSecurityIndexStateChange(SecurityIndexManager.State previousState, SecurityIndexManager.State currentState) {
        if (SecurityIndexManager.isMoveFromRedToNonRed(previousState, currentState) || SecurityIndexManager.isIndexDeleted(previousState, currentState) || previousState.isIndexUpToDate != currentState.isIndexUpToDate) {
            this.invalidateAll();
        }
    }

    boolean isValueInNegativeLookupCache(String key) {
        return this.negativeLookupCache.get((Object)key) != null;
    }

    public static List<Setting<?>> getSettings() {
        return Arrays.asList(CACHE_SIZE_SETTING, NEGATIVE_LOOKUP_CACHE_SIZE_SETTING);
    }

    private static final class RoleKey {
        private final Set<String> names;
        private final String source;

        private RoleKey(Set<String> names, String source) {
            this.names = Objects.requireNonNull(names);
            this.source = Objects.requireNonNull(source);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RoleKey roleKey = (RoleKey)o;
            return this.names.equals(roleKey.names) && this.source.equals(roleKey.source);
        }

        public int hashCode() {
            return Objects.hash(this.names, this.source);
        }
    }

    private static final class RolesRetrievalResult {
        private final Set<RoleDescriptor> roleDescriptors = new HashSet<RoleDescriptor>();
        private Set<String> missingRoles = Collections.emptySet();
        private boolean success = true;

        private RolesRetrievalResult() {
        }

        private void addDescriptors(Set<RoleDescriptor> descriptors) {
            this.roleDescriptors.addAll(descriptors);
        }

        private Set<RoleDescriptor> getRoleDescriptors() {
            return this.roleDescriptors;
        }

        private void setFailure() {
            this.success = false;
        }

        private boolean isSuccess() {
            return this.success;
        }

        private void setMissingRoles(Set<String> missingRoles) {
            this.missingRoles = missingRoles;
        }

        private Set<String> getMissingRoles() {
            return this.missingRoles;
        }
    }

    private static class MergeableIndicesPrivilege {
        private Set<String> indices;
        private Set<String> privileges;
        private FieldPermissionsDefinition fieldPermissionsDefinition;
        private Set<BytesReference> query = null;

        MergeableIndicesPrivilege(String[] indices, String[] privileges, @Nullable String[] grantedFields, @Nullable String[] deniedFields, @Nullable BytesReference query) {
            this.indices = Sets.newHashSet((Object[])Objects.requireNonNull(indices));
            this.privileges = Sets.newHashSet((Object[])Objects.requireNonNull(privileges));
            this.fieldPermissionsDefinition = new FieldPermissionsDefinition(grantedFields, deniedFields);
            if (query != null) {
                this.query = Sets.newHashSet((Object[])new BytesReference[]{query});
            }
        }

        void merge(MergeableIndicesPrivilege other) {
            assert (this.indices.equals(other.indices)) : "index names must be equivalent in order to merge";
            HashSet groups = new HashSet();
            groups.addAll(this.fieldPermissionsDefinition.getFieldGrantExcludeGroups());
            groups.addAll(other.fieldPermissionsDefinition.getFieldGrantExcludeGroups());
            this.fieldPermissionsDefinition = new FieldPermissionsDefinition(groups);
            this.privileges.addAll(other.privileges);
            if (this.query == null || other.query == null) {
                this.query = null;
            } else {
                this.query.addAll(other.query);
            }
        }

        private static void collatePrivilegesByIndices(RoleDescriptor.IndicesPrivileges[] indicesPrivileges, boolean allowsRestrictedIndices, Map<Set<String>, MergeableIndicesPrivilege> indicesPrivilegesMap) {
            for (RoleDescriptor.IndicesPrivileges indicesPrivilege : indicesPrivileges) {
                boolean isExplicitDenial;
                boolean bl = isExplicitDenial = indicesPrivileges.length == 1 && "none".equalsIgnoreCase(indicesPrivilege.getPrivileges()[0]);
                if (isExplicitDenial || indicesPrivilege.allowRestrictedIndices() != allowsRestrictedIndices) continue;
                HashSet key = Sets.newHashSet((Object[])indicesPrivilege.getIndices());
                indicesPrivilegesMap.compute(key, (k, value) -> {
                    if (value == null) {
                        return new MergeableIndicesPrivilege(indicesPrivilege.getIndices(), indicesPrivilege.getPrivileges(), indicesPrivilege.getGrantedFields(), indicesPrivilege.getDeniedFields(), indicesPrivilege.getQuery());
                    }
                    value.merge(new MergeableIndicesPrivilege(indicesPrivilege.getIndices(), indicesPrivilege.getPrivileges(), indicesPrivilege.getGrantedFields(), indicesPrivilege.getDeniedFields(), indicesPrivilege.getQuery()));
                    return value;
                });
            }
        }
    }
}

