/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.privilege;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParseException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.action.privilege.ApplicationPrivilegesRequest;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ConditionalClusterPrivilege;
import org.elasticsearch.xpack.core.security.support.Automatons;
import org.elasticsearch.xpack.core.security.xcontent.XContentUtils;

public final class ConditionalClusterPrivileges {
    public static final ConditionalClusterPrivilege[] EMPTY_ARRAY = new ConditionalClusterPrivilege[0];
    public static final Writeable.Reader<ConditionalClusterPrivilege> READER = in1 -> (ConditionalClusterPrivilege)in1.readNamedWriteable(ConditionalClusterPrivilege.class);
    public static final Writeable.Writer<ConditionalClusterPrivilege> WRITER = (out1, value) -> out1.writeNamedWriteable((NamedWriteable)value);

    private ConditionalClusterPrivileges() {
    }

    public static ConditionalClusterPrivilege[] readArray(StreamInput in) throws IOException {
        return (ConditionalClusterPrivilege[])in.readArray(READER, ConditionalClusterPrivilege[]::new);
    }

    public static void writeArray(StreamOutput out, ConditionalClusterPrivilege[] privileges) throws IOException {
        out.writeArray(WRITER, (Object[])privileges);
    }

    public static XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, Collection<ConditionalClusterPrivilege> privileges) throws IOException {
        builder.startObject();
        for (ConditionalClusterPrivilege.Category category : ConditionalClusterPrivilege.Category.values()) {
            builder.startObject(category.field.getPreferredName());
            for (ConditionalClusterPrivilege privilege : privileges) {
                if (category != privilege.getCategory()) continue;
                privilege.toXContent(builder, params);
            }
            builder.endObject();
        }
        return builder.endObject();
    }

    public static List<ConditionalClusterPrivilege> parse(XContentParser parser) throws IOException {
        ArrayList<ConditionalClusterPrivilege> privileges = new ArrayList<ConditionalClusterPrivilege>();
        ConditionalClusterPrivileges.expectedToken(parser.currentToken(), parser, XContentParser.Token.START_OBJECT);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            ConditionalClusterPrivileges.expectedToken(parser.currentToken(), parser, XContentParser.Token.FIELD_NAME);
            ConditionalClusterPrivileges.expectFieldName(parser, ConditionalClusterPrivilege.Category.APPLICATION.field);
            ConditionalClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.START_OBJECT);
            ConditionalClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.FIELD_NAME);
            ConditionalClusterPrivileges.expectFieldName(parser, ManageApplicationPrivileges.Fields.MANAGE);
            privileges.add(ManageApplicationPrivileges.parse(parser));
            ConditionalClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.END_OBJECT);
        }
        return privileges;
    }

    private static void expectedToken(XContentParser.Token read, XContentParser parser, XContentParser.Token expected) {
        if (read != expected) {
            throw new XContentParseException(parser.getTokenLocation(), "failed to parse privilege. expected [" + expected + "] but found [" + read + "] instead");
        }
    }

    private static void expectFieldName(XContentParser parser, ParseField ... fields) throws IOException {
        String fieldName = parser.currentName();
        if (!Arrays.stream(fields).anyMatch(pf -> pf.match(fieldName, parser.getDeprecationHandler()))) {
            throw new XContentParseException(parser.getTokenLocation(), "failed to parse privilege. expected " + (fields.length == 1 ? "field name" : "one of") + " [" + Strings.arrayToCommaDelimitedString((Object[])fields) + "] but found [" + fieldName + "] instead");
        }
    }

    public static class ManageApplicationPrivileges
    implements ConditionalClusterPrivilege {
        private static final ClusterPrivilege PRIVILEGE = ClusterPrivilege.get(Collections.singleton("cluster:admin/xpack/security/privilege/*"));
        public static final String WRITEABLE_NAME = "manage-application-privileges";
        private final Set<String> applicationNames;
        private final Predicate<String> applicationPredicate;
        private final Predicate<TransportRequest> requestPredicate;

        public ManageApplicationPrivileges(Set<String> applicationNames) {
            this.applicationNames = Collections.unmodifiableSet(applicationNames);
            this.applicationPredicate = Automatons.predicate(applicationNames);
            this.requestPredicate = request -> {
                if (request instanceof ApplicationPrivilegesRequest) {
                    ApplicationPrivilegesRequest privRequest = (ApplicationPrivilegesRequest)request;
                    Collection<String> requestApplicationNames = privRequest.getApplicationNames();
                    return requestApplicationNames.isEmpty() ? this.applicationNames.contains("*") : requestApplicationNames.stream().allMatch(application -> this.applicationPredicate.test((String)application));
                }
                return false;
            };
        }

        @Override
        public ConditionalClusterPrivilege.Category getCategory() {
            return ConditionalClusterPrivilege.Category.APPLICATION;
        }

        @Override
        public ClusterPrivilege getPrivilege() {
            return PRIVILEGE;
        }

        @Override
        public Predicate<TransportRequest> getRequestPredicate() {
            return this.requestPredicate;
        }

        public Collection<String> getApplicationNames() {
            return Collections.unmodifiableCollection(this.applicationNames);
        }

        public String getWriteableName() {
            return WRITEABLE_NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.applicationNames, StreamOutput::writeString);
        }

        public static ManageApplicationPrivileges createFrom(StreamInput in) throws IOException {
            Set applications = in.readSet(StreamInput::readString);
            return new ManageApplicationPrivileges(applications);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.field(Fields.MANAGE.getPreferredName(), Collections.singletonMap(Fields.APPLICATIONS.getPreferredName(), this.applicationNames));
        }

        public static ManageApplicationPrivileges parse(XContentParser parser) throws IOException {
            ConditionalClusterPrivileges.expectedToken(parser.currentToken(), parser, XContentParser.Token.FIELD_NAME);
            ConditionalClusterPrivileges.expectFieldName(parser, new ParseField[]{Fields.MANAGE});
            ConditionalClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.START_OBJECT);
            ConditionalClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.FIELD_NAME);
            ConditionalClusterPrivileges.expectFieldName(parser, new ParseField[]{Fields.APPLICATIONS});
            ConditionalClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.START_ARRAY);
            String[] applications = XContentUtils.readStringArray(parser, false);
            ConditionalClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.END_OBJECT);
            return new ManageApplicationPrivileges(new LinkedHashSet<String>(Arrays.asList(applications)));
        }

        public String toString() {
            return "{" + (Object)((Object)this.getCategory()) + ":" + Fields.MANAGE.getPreferredName() + ":" + Fields.APPLICATIONS.getPreferredName() + "=" + Strings.collectionToDelimitedString(this.applicationNames, (String)",") + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ManageApplicationPrivileges that = (ManageApplicationPrivileges)o;
            return this.applicationNames.equals(that.applicationNames);
        }

        public int hashCode() {
            return this.applicationNames.hashCode();
        }

        private static interface Fields {
            public static final ParseField MANAGE = new ParseField("manage", new String[0]);
            public static final ParseField APPLICATIONS = new ParseField("applications", new String[0]);
        }
    }
}

