/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.jicofo.util.PreferenceAggregator;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.json.simple.JSONArray;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001eB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u0017\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0014\u0010\u001b\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0006\u0010\u001c\u001a\u00020\bJ\b\u0010\u001d\u001a\u00020\bH\u0002R*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jitsi/jicofo/util/PreferenceAggregator;", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "onChanged", "Lkotlin/Function1;", "", "", "", "(Lorg/jitsi/utils/logging2/Logger;Lkotlin/jvm/functions/Function1;)V", "<set-?>", "aggregate", "getAggregate", "()Ljava/util/List;", "", "count", "getCount", "()I", "lock", "logger", "values", "", "Lorg/jitsi/jicofo/util/PreferenceAggregator$ValueInfo;", "addPreference", "prefs", "debugState", "Lorg/jitsi/utils/OrderedJsonObject;", "removePreference", "reset", "updateAggregate", "ValueInfo", "jicofo"})
@SourceDebugExtension(value={"SMAP\nPreferenceAggregator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreferenceAggregator.kt\norg/jitsi/jicofo/util/PreferenceAggregator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n1872#2,3:152\n1872#2,3:155\n607#3:158\n1317#3,2:159\n607#3:162\n1#4:161\n*S KotlinDebug\n*F\n+ 1 PreferenceAggregator.kt\norg/jitsi/jicofo/util/PreferenceAggregator\n*L\n58#1:152,3\n80#1:155,3\n120#1:158\n121#1:159,2\n131#1:162\n*E\n"})
public final class PreferenceAggregator {
    @NotNull
    private final Function1<List<String>, Unit> onChanged;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Object lock;
    @NotNull
    private List<String> aggregate;
    private int count;
    @NotNull
    private final Map<String, ValueInfo> values;

    public PreferenceAggregator(@NotNull Logger parentLogger, @NotNull Function1<? super List<String>, Unit> onChanged) {
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        Intrinsics.checkNotNullParameter(onChanged, (String)"onChanged");
        this.onChanged = onChanged;
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
        this.lock = new Object();
        this.aggregate = CollectionsKt.emptyList();
        this.values = new LinkedHashMap();
    }

    @NotNull
    public final List<String> getAggregate() {
        return this.aggregate;
    }

    public final int getCount() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void addPreference(@NotNull List<String> prefs) {
        Intrinsics.checkNotNullParameter(prefs, (String)"prefs");
        List distinctPrefs = CollectionsKt.distinct((Iterable)prefs);
        if (!Intrinsics.areEqual((Object)distinctPrefs, prefs)) {
            this.logger.warn((Object)("Preferences " + prefs + " contains repeated values"));
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            int n = this.count;
            this.count = n + 1;
            Iterable $this$forEachIndexed$iv = distinctPrefs;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                ValueInfo info2;
                void element;
                int n2;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int index = n2;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)this.values.computeIfAbsent((String)element, arg_0 -> PreferenceAggregator.addPreference$lambda$2$lambda$1$lambda$0(addPreference.1.1.info.1.INSTANCE, arg_0)), (String)"computeIfAbsent(...)");
                int n3 = info2.getCount();
                info2.setCount(n3 + 1);
                info2.setRankAggregate(info2.getRankAggregate() + index);
            }
            this.updateAggregate();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void removePreference(@NotNull List<String> prefs) {
        Intrinsics.checkNotNullParameter(prefs, (String)"prefs");
        List distinctPrefs = CollectionsKt.distinct((Iterable)prefs);
        if (!Intrinsics.areEqual((Object)distinctPrefs, prefs)) {
            this.logger.warn((Object)("Preferences " + prefs + " contains repeated values"));
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            int n = this.count;
            this.count = n + -1;
            if (!(this.count >= 0)) {
                boolean $i$a$-check-PreferenceAggregator$removePreference$1$22 = false;
                String $i$a$-check-PreferenceAggregator$removePreference$1$22 = "Preference count " + this.count + " should not be negative";
                throw new IllegalStateException($i$a$-check-PreferenceAggregator$removePreference$1$22.toString());
            }
            Iterable $this$forEachIndexed$iv = distinctPrefs;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void element;
                int n2;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int index = n2;
                boolean bl2 = false;
                ValueInfo info2 = this.values.get(element);
                if (!(info2 != null)) {
                    boolean $i$a$-check-PreferenceAggregator$removePreference$1$2$52 = false;
                    String $i$a$-check-PreferenceAggregator$removePreference$1$2$52 = "Preference info for " + (String)element + " should exist when preferences are being removed";
                    throw new IllegalStateException($i$a$-check-PreferenceAggregator$removePreference$1$2$52.toString());
                }
                int n3 = info2.getCount();
                info2.setCount(n3 + -1);
                if (!(info2.getCount() >= 0)) {
                    boolean $i$a$-check-PreferenceAggregator$removePreference$1$2$62 = false;
                    String $i$a$-check-PreferenceAggregator$removePreference$1$2$62 = "Preference count for " + (String)element + " " + info2.getCount() + " should not be negative";
                    throw new IllegalStateException($i$a$-check-PreferenceAggregator$removePreference$1$2$62.toString());
                }
                info2.setRankAggregate(info2.getRankAggregate() - index);
                if (!(info2.getRankAggregate() >= 0)) {
                    boolean $i$a$-check-PreferenceAggregator$removePreference$1$2$72 = false;
                    String $i$a$-check-PreferenceAggregator$removePreference$1$2$72 = "Preference rank aggregate for " + (String)element + " " + info2.getRankAggregate() + " should not be negative";
                    throw new IllegalStateException($i$a$-check-PreferenceAggregator$removePreference$1$2$72.toString());
                }
                if (info2.getCount() != 0) continue;
                if (!(info2.getRankAggregate() == 0)) {
                    boolean bl3 = false;
                    String string2 = "Preference rank aggregate for " + (String)element + " " + info2.getRankAggregate() + " should be zero when preference count is 0";
                    throw new IllegalStateException(string2.toString());
                }
                this.values.remove(element);
            }
            this.updateAggregate();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.aggregate = CollectionsKt.emptyList();
            this.count = 0;
            this.values.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final OrderedJsonObject debugState() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$debugState_u24lambda_u2416 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        Object object = this.lock;
        synchronized (object) {
            void $this$debugState_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414;
            OrderedJsonObject $this$debugState_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413;
            void $this$forEach$iv;
            Sequence $this$sortedBy$iv;
            OrderedJsonObject orderedJsonObject2;
            boolean bl2 = false;
            $this$debugState_u24lambda_u2416.put((Object)"count", (Object)this.count);
            OrderedJsonObject orderedJsonObject3 = orderedJsonObject2 = new OrderedJsonObject();
            String string = "ranks";
            OrderedJsonObject orderedJsonObject4 = $this$debugState_u24lambda_u2416;
            boolean bl3 = false;
            Sequence sequence = MapsKt.asSequence(this.values);
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Map.Entry it = (Map.Entry)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(((ValueInfo)it.getValue()).getRankAggregate());
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((ValueInfo)it.getValue()).getRankAggregate()));
                }
            });
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl4 = false;
                $this$debugState_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413.put(it.getKey(), (Object)((ValueInfo)it.getValue()).debugState());
            }
            Unit unit = Unit.INSTANCE;
            orderedJsonObject4.put((Object)string, (Object)orderedJsonObject2);
            $this$debugState_u24lambda_u2416_u24lambda_u2415_u24lambda_u2413 = orderedJsonObject2 = new JSONArray();
            string = "aggregate";
            orderedJsonObject4 = $this$debugState_u24lambda_u2416;
            boolean bl5 = false;
            $this$debugState_u24lambda_u2416_u24lambda_u2415_u24lambda_u2414.addAll((Collection)this.aggregate);
            unit = Unit.INSTANCE;
            orderedJsonObject4.put((Object)string, (Object)orderedJsonObject2);
            Unit unit2 = Unit.INSTANCE;
        }
        return orderedJsonObject;
    }

    private final void updateAggregate() {
        Sequence $this$sortedBy$iv = SequencesKt.filter((Sequence)MapsKt.asSequence(this.values), (Function1)((Function1)new Function1<Map.Entry<? extends String, ? extends ValueInfo>, Boolean>(this){
            final /* synthetic */ PreferenceAggregator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<String, ValueInfo> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return it.getValue().getCount() == this.this$0.getCount();
            }
        }));
        boolean $i$f$sortedBy = false;
        List newAggregate2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((ValueInfo)it.getValue()).getRankAggregate());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((ValueInfo)it.getValue()).getRankAggregate()));
            }
        }), (Function1)updateAggregate.newAggregate.3.INSTANCE));
        if (!Intrinsics.areEqual(this.aggregate, (Object)newAggregate2)) {
            this.aggregate = newAggregate2;
            this.onChanged.invoke(this.aggregate);
        }
    }

    private static final ValueInfo addPreference$lambda$2$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ValueInfo)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\b\u00a8\u0006\u000e"}, d2={"Lorg/jitsi/jicofo/util/PreferenceAggregator$ValueInfo;", "", "()V", "count", "", "getCount", "()I", "setCount", "(I)V", "rankAggregate", "getRankAggregate", "setRankAggregate", "debugState", "Lorg/jitsi/utils/OrderedJsonObject;", "jicofo"})
    private static final class ValueInfo {
        private int count;
        private int rankAggregate;

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int n) {
            this.count = n;
        }

        public final int getRankAggregate() {
            return this.rankAggregate;
        }

        public final void setRankAggregate(int n) {
            this.rankAggregate = n;
        }

        @NotNull
        public final OrderedJsonObject debugState() {
            OrderedJsonObject orderedJsonObject;
            OrderedJsonObject $this$debugState_u24lambda_u240 = orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            $this$debugState_u24lambda_u240.put((Object)"count", (Object)this.count);
            $this$debugState_u24lambda_u240.put((Object)"rank_aggregate", (Object)this.rankAggregate);
            return orderedJsonObject;
        }
    }
}

