/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp;

import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.ConferenceStore;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.xmpp.JsonMessage;
import org.jitsi.jicofo.xmpp.RoomMetadata;
import org.jitsi.jicofo.xmpp.XmppProvider;
import org.jitsi.jicofo.xmpp.muc.ChatRoom;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.utils.queue.PacketQueue;
import org.jitsi.xmpp.extensions.jitsimeet.JsonMessageExtension;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.packet.Stanza;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0006\u0010\u001d\u001a\u00020\u0014R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jitsi/jicofo/xmpp/RoomMetadataHandler;", "Lorg/jitsi/jicofo/xmpp/XmppProvider$Listener;", "Lorg/jivesoftware/smack/StanzaListener;", "xmppProvider", "Lorg/jitsi/jicofo/xmpp/XmppProvider;", "conferenceStore", "Lorg/jitsi/jicofo/ConferenceStore;", "(Lorg/jitsi/jicofo/xmpp/XmppProvider;Lorg/jitsi/jicofo/ConferenceStore;)V", "componentAddress", "Lorg/jxmpp/jid/DomainBareJid;", "debugState", "Lorg/jitsi/utils/OrderedJsonObject;", "getDebugState", "()Lorg/jitsi/utils/OrderedJsonObject;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "queue", "Lorg/jitsi/utils/queue/PacketQueue;", "Lorg/jitsi/xmpp/extensions/jitsimeet/JsonMessageExtension;", "componentsChanged", "", "components", "", "Lorg/jitsi/jicofo/xmpp/XmppProvider$Component;", "doProcess", "jsonMessage", "processStanza", "stanza", "Lorg/jivesoftware/smack/packet/Stanza;", "shutdown", "jicofo"})
@SourceDebugExtension(value={"SMAP\nRoomMetadataHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoomMetadataHandler.kt\norg/jitsi/jicofo/xmpp/RoomMetadataHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
public final class RoomMetadataHandler
implements XmppProvider.Listener,
StanzaListener {
    @NotNull
    private final XmppProvider xmppProvider;
    @NotNull
    private final ConferenceStore conferenceStore;
    @Nullable
    private DomainBareJid componentAddress;
    @NotNull
    private final Logger logger;
    @NotNull
    private final PacketQueue<JsonMessageExtension> queue;

    public RoomMetadataHandler(@NotNull XmppProvider xmppProvider, @NotNull ConferenceStore conferenceStore) {
        Intrinsics.checkNotNullParameter((Object)xmppProvider, (String)"xmppProvider");
        Intrinsics.checkNotNullParameter((Object)conferenceStore, (String)"conferenceStore");
        this.xmppProvider = xmppProvider;
        this.conferenceStore = conferenceStore;
        this.logger = LoggerExtensionsKt.createLogger$default((Object)this, null, null, (int)3, null);
        this.queue = new PacketQueue(Integer.MAX_VALUE, Boolean.valueOf(false), "room_metadata queue", arg_0 -> RoomMetadataHandler.queue$lambda$0(this, arg_0), TaskPools.Companion.getIoPool());
        this.xmppProvider.getXmppConnection().addSyncStanzaListener((StanzaListener)this, MessageTypeFilter.NORMAL);
        this.xmppProvider.addListener((XmppProvider.Listener)this);
        this.registrationChanged(this.xmppProvider.getRegistered());
        this.componentsChanged(this.xmppProvider.getComponents());
    }

    @NotNull
    public final OrderedJsonObject getDebugState() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$_get_debugState__u24lambda_u241 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        ((Map)$this$_get_debugState__u24lambda_u241).put("address", String.valueOf(this.componentAddress));
        return orderedJsonObject;
    }

    private final void doProcess(JsonMessageExtension jsonMessage) {
        try {
            Object object = jsonMessage.getAttribute("room");
            EntityBareJid conferenceJid = JidCreate.entityBareFrom((String)(object != null ? object.toString() : null));
            String string = jsonMessage.getJson();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getJson(...)");
            JsonMessage roomMetadata = JsonMessage.Companion.parse(string);
            if (!(roomMetadata instanceof RoomMetadata)) {
                throw new IllegalArgumentException("Received invalid message type: " + jsonMessage.getJson());
            }
            Intrinsics.checkNotNull((Object)conferenceJid);
            JitsiMeetConference jitsiMeetConference = this.conferenceStore.getConference(conferenceJid);
            if (jitsiMeetConference == null) {
                throw new IllegalStateException("Conference " + conferenceJid + " does not exist.");
            }
            JitsiMeetConference conference = jitsiMeetConference;
            ChatRoom chatRoom = conference.getChatRoom();
            if (chatRoom == null) {
                throw new IllegalStateException("Conference has no associated chatRoom.");
            }
            ChatRoom chatRoom2 = chatRoom;
            chatRoom2.setRoomMetadata((RoomMetadata)roomMetadata);
        }
        catch (Exception e) {
            this.logger.info((Object)("Failed to process room_metadata request: " + jsonMessage.toXML()));
        }
    }

    public void processStanza(@NotNull Stanza stanza) {
        Intrinsics.checkNotNullParameter((Object)stanza, (String)"stanza");
        if (!Intrinsics.areEqual((Object)stanza.getFrom(), (Object)this.componentAddress)) {
            return;
        }
        JsonMessageExtension jsonMessageExtension = (JsonMessageExtension)stanza.getExtension(JsonMessageExtension.class);
        if (jsonMessageExtension == null) {
            Unit unit;
            Unit it = unit = Unit.INSTANCE;
            boolean bl = false;
            this.logger.warn((Object)"Skip processing stanza without JsonMessageExtension.");
            return;
        }
        JsonMessageExtension jsonMessage = jsonMessageExtension;
        this.queue.add((Object)jsonMessage);
    }

    public void componentsChanged(@NotNull Set<XmppProvider.Component> components) {
        DomainBareJid domainBareJid;
        String address;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter(components, (String)"components");
            Iterable iterable = components;
            for (Object t : iterable) {
                XmppProvider.Component it = (XmppProvider.Component)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)"room_metadata")) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        XmppProvider.Component component = v0;
        String string = address = component != null ? component.getAddress() : null;
        if (address == null) {
            this.logger.info((Object)"No room_metadata component discovered.");
            domainBareJid = null;
        } else {
            this.logger.info((Object)("Using room_metadata component at " + address + "."));
            domainBareJid = JidCreate.domainBareFrom((String)address);
        }
        this.componentAddress = domainBareJid;
    }

    public final void shutdown() {
        this.xmppProvider.getXmppConnection().removeSyncStanzaListener((StanzaListener)this);
    }

    public void registrationChanged(boolean registered) {
        XmppProvider.Listener.DefaultImpls.registrationChanged((XmppProvider.Listener)this, (boolean)registered);
    }

    private static final boolean queue$lambda$0(RoomMetadataHandler this$0, JsonMessageExtension it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)it);
        this$0.doProcess(it);
        return true;
    }
}

