/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.api.ApiUtils$;
import kafka.api.PartitionMetadata;
import kafka.api.TopicMetadata$;
import kafka.cluster.BrokerEndPoint;
import kafka.utils.Logging;
import org.apache.kafka.common.protocol.Errors;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005=w!B\u0001\u0003\u0011\u00039\u0011!\u0004+pa&\u001cW*\u001a;bI\u0006$\u0018M\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\t\u00135\t!AB\u0003\u000b\u0005!\u00051BA\u0007U_BL7-T3uC\u0012\fG/Y\n\u0004\u00131\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u000e'%\u0011AC\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006-%!\taF\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001dAq!G\u0005C\u0002\u0013\u0005!$\u0001\bO_2+\u0017\rZ3s\u001d>$W-\u00133\u0016\u0003m\u0001\"!\u0004\u000f\n\u0005uq!aA%oi\"1q$\u0003Q\u0001\nm\tqBT8MK\u0006$WM\u001d(pI\u0016LE\r\t\u0005\u0006C%!\tAI\u0001\te\u0016\fGM\u0012:p[R)1%!!\u0002\u0004B\u0011\u0001\u0002\n\u0004\u0005\u0015\t\u0001UeE\u0003%\u0019\u0019b#\u0003\u0005\u0002(U5\t\u0001F\u0003\u0002*\t\u0005)Q\u000f^5mg&\u00111\u0006\u000b\u0002\b\u0019><w-\u001b8h!\tiQ&\u0003\u0002/\u001d\t9\u0001K]8ek\u000e$\b\u0002\u0003\u0019%\u0005+\u0007I\u0011A\u0019\u0002\u000bQ|\u0007/[2\u0016\u0003I\u0002\"a\r\u001e\u000f\u0005QB\u0004CA\u001b\u000f\u001b\u00051$BA\u001c\u0007\u0003\u0019a$o\\8u}%\u0011\u0011HD\u0001\u0007!J,G-\u001a4\n\u0005mb$AB*ue&twM\u0003\u0002:\u001d!Aa\b\nB\tB\u0003%!'\u0001\u0004u_BL7\r\t\u0005\t\u0001\u0012\u0012)\u001a!C\u0001\u0003\u0006\u0011\u0002/\u0019:uSRLwN\\:NKR\fG-\u0019;b+\u0005\u0011\u0005cA\"I\u0017:\u0011AI\u0012\b\u0003k\u0015K\u0011aD\u0005\u0003\u000f:\tq\u0001]1dW\u0006<W-\u0003\u0002J\u0015\n\u00191+Z9\u000b\u0005\u001ds\u0001C\u0001\u0005M\u0013\ti%AA\tQCJ$\u0018\u000e^5p]6+G/\u00193bi\u0006D\u0001b\u0014\u0013\u0003\u0012\u0003\u0006IAQ\u0001\u0014a\u0006\u0014H/\u001b;j_:\u001cX*\u001a;bI\u0006$\u0018\r\t\u0005\t#\u0012\u0012)\u001a!C\u0001%\u0006)QM\u001d:peV\t1\u000b\u0005\u0002U=6\tQK\u0003\u0002W/\u0006A\u0001O]8u_\u000e|GN\u0003\u0002Y3\u000611m\\7n_:T!!\u0002.\u000b\u0005mc\u0016AB1qC\u000eDWMC\u0001^\u0003\ry'oZ\u0005\u0003?V\u0013a!\u0012:s_J\u001c\b\u0002C1%\u0005#\u0005\u000b\u0011B*\u0002\r\u0015\u0014(o\u001c:!\u0011\u00151B\u0005\"\u0001d)\u0011\u0019C-\u001a4\t\u000bA\u0012\u0007\u0019\u0001\u001a\t\u000b\u0001\u0013\u0007\u0019\u0001\"\t\u000fE\u0013\u0007\u0013!a\u0001'\")\u0001\u000e\nC\u00015\u0005Y1/\u001b>f\u0013:\u0014\u0015\u0010^3t\u0011\u0015QG\u0005\"\u0001l\u0003\u001d9(/\u001b;f)>$\"\u0001\\8\u0011\u00055i\u0017B\u00018\u000f\u0005\u0011)f.\u001b;\t\u000bAL\u0007\u0019A9\u0002\r\t,hMZ3s!\t\u0011x/D\u0001t\u0015\t!X/A\u0002oS>T\u0011A^\u0001\u0005U\u00064\u0018-\u0003\u0002yg\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000bi$C\u0011I>\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A\r\u0005\b{\u0012\n\t\u0011\"\u0001\u007f\u0003\u0011\u0019w\u000e]=\u0015\r\rz\u0018\u0011AA\u0002\u0011\u001d\u0001D\u0010%AA\u0002IBq\u0001\u0011?\u0011\u0002\u0003\u0007!\tC\u0004RyB\u0005\t\u0019A*\t\u0013\u0005\u001dA%%A\u0005\u0002\u0005%\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0017Q3AMA\u0007W\t\ty\u0001\u0005\u0003\u0002\u0012\u0005mQBAA\n\u0015\u0011\t)\"a\u0006\u0002\u0013Ut7\r[3dW\u0016$'bAA\r\u001d\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00111\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\u0011IE\u0005I\u0011AA\u0012\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!\n+\u0007\t\u000bi\u0001C\u0005\u0002*\u0011\n\n\u0011\"\u0001\u0002,\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAA\u0017U\r\u0019\u0016Q\u0002\u0005\n\u0003c!\u0013\u0011!C!\u0003g\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u001b!\u0011\t9$!\u0010\u000e\u0005\u0005e\"bAA\u001ek\u0006!A.\u00198h\u0013\rY\u0014\u0011\b\u0005\t\u0003\u0003\"\u0013\u0011!C\u00015\u0005a\u0001O]8ek\u000e$\u0018I]5us\"I\u0011Q\t\u0013\u0002\u0002\u0013\u0005\u0011qI\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tI%a\u0014\u0011\u00075\tY%C\u0002\u0002N9\u00111!\u00118z\u0011%\t\t&a\u0011\u0002\u0002\u0003\u00071$A\u0002yIEB\u0011\"!\u0016%\u0003\u0003%\t%a\u0016\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u0017\u0011\r\u0005m\u0013\u0011MA%\u001b\t\tiFC\u0002\u0002`9\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019'!\u0018\u0003\u0011%#XM]1u_JD\u0011\"a\u001a%\u0003\u0003%\t!!\u001b\u0002\u0011\r\fg.R9vC2$B!a\u001b\u0002rA\u0019Q\"!\u001c\n\u0007\u0005=dBA\u0004C_>dW-\u00198\t\u0015\u0005E\u0013QMA\u0001\u0002\u0004\tI\u0005C\u0005\u0002v\u0011\n\t\u0011\"\u0011\u0002x\u0005A\u0001.Y:i\u0007>$W\rF\u0001\u001c\u0011%\tY\bJA\u0001\n\u0003\ni(\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003W\ny\b\u0003\u0006\u0002R\u0005e\u0014\u0011!a\u0001\u0003\u0013BQ\u0001\u001d\u0011A\u0002EDq!!\"!\u0001\u0004\t9)A\u0004ce>\\WM]:\u0011\rM\nIiGAG\u0013\r\tY\t\u0010\u0002\u0004\u001b\u0006\u0004\b\u0003BAH\u0003+k!!!%\u000b\u0007\u0005ME!A\u0004dYV\u001cH/\u001a:\n\t\u0005]\u0015\u0011\u0013\u0002\u000f\u0005J|7.\u001a:F]\u0012\u0004v.\u001b8u\u0011%\tY*CA\u0001\n\u0003\u000bi*A\u0003baBd\u0017\u0010F\u0004$\u0003?\u000b\t+a)\t\rA\nI\n1\u00013\u0011\u0019\u0001\u0015\u0011\u0014a\u0001\u0005\"A\u0011+!'\u0011\u0002\u0003\u00071\u000bC\u0005\u0002(&\t\t\u0011\"!\u0002*\u00069QO\\1qa2LH\u0003BAV\u0003o\u0003R!DAW\u0003cK1!a,\u000f\u0005\u0019y\u0005\u000f^5p]B1Q\"a-3\u0005NK1!!.\u000f\u0005\u0019!V\u000f\u001d7fg!I\u0011\u0011XAS\u0003\u0003\u0005\raI\u0001\u0004q\u0012\u0002\u0004\"CA_\u0013E\u0005I\u0011AA\u0016\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g!I\u0011\u0011Y\u0005\u0012\u0002\u0013\u0005\u00111F\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g!I\u0011QY\u0005\u0002\u0002\u0013%\u0011qY\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002JB!\u0011qGAf\u0013\u0011\ti-!\u000f\u0003\r=\u0013'.Z2u\u0001")
public class TopicMetadata
implements Logging,
Product,
scala.Serializable {
    private final String topic;
    private final Seq<PartitionMetadata> partitionsMetadata;
    private final Errors error;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Errors apply$default$3() {
        return TopicMetadata$.MODULE$.apply$default$3();
    }

    public static Errors $lessinit$greater$default$3() {
        return TopicMetadata$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<String, Seq<PartitionMetadata>, Errors>> unapply(TopicMetadata topicMetadata) {
        return TopicMetadata$.MODULE$.unapply(topicMetadata);
    }

    public static TopicMetadata apply(String string, Seq<PartitionMetadata> seq, Errors errors) {
        return TopicMetadata$.MODULE$.apply(string, seq, errors);
    }

    public static TopicMetadata readFrom(ByteBuffer byteBuffer, Map<Object, BrokerEndPoint> map) {
        return TopicMetadata$.MODULE$.readFrom(byteBuffer, map);
    }

    public static int NoLeaderNodeId() {
        return TopicMetadata$.MODULE$.NoLeaderNodeId();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TopicMetadata topicMetadata = this;
        synchronized (topicMetadata) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public Seq<PartitionMetadata> partitionsMetadata() {
        return this.partitionsMetadata;
    }

    public Errors error() {
        return this.error;
    }

    public int sizeInBytes() {
        return 2 + ApiUtils$.MODULE$.shortStringLength(this.topic()) + 4 + BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.partitionsMetadata().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public void writeTo(ByteBuffer buffer) {
        buffer.putShort(this.error().code());
        ApiUtils$.MODULE$.writeShortString(buffer, this.topic());
        buffer.putInt(this.partitionsMetadata().size());
        this.partitionsMetadata().foreach((Function1 & Serializable & scala.Serializable)m -> {
            m.writeTo(buffer);
            return BoxedUnit.UNIT;
        });
    }

    public String toString() {
        BoxedUnit boxedUnit;
        StringBuilder topicMetadataInfo = new StringBuilder();
        topicMetadataInfo.append(new StringOps(Predef$.MODULE$.augmentString("{TopicMetadata for topic %s -> ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic()})));
        Errors errors = this.error();
        if (Errors.NONE.equals(errors)) {
            this.partitionsMetadata().foreach((Function1 & Serializable & scala.Serializable)partitionMetadata -> {
                StringBuilder stringBuilder;
                Errors errors = partitionMetadata.error();
                if (Errors.NONE.equals(errors)) {
                    stringBuilder = topicMetadataInfo.append(new StringOps(Predef$.MODULE$.augmentString("\nMetadata for partition [%s,%d] is %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)partitionMetadata.partitionId()), partitionMetadata.toString()})));
                } else if (Errors.REPLICA_NOT_AVAILABLE.equals(errors)) {
                    stringBuilder = topicMetadataInfo.append(new StringOps(Predef$.MODULE$.augmentString("\nMetadata for partition [%s,%d] is %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)partitionMetadata.partitionId()), partitionMetadata.toString()})));
                } else if (errors != null) {
                    Errors errors2 = errors;
                    stringBuilder = topicMetadataInfo.append(new StringOps(Predef$.MODULE$.augmentString("\nMetadata for partition [%s,%d] is not available due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)partitionMetadata.partitionId()), errors2.exceptionName()})));
                } else {
                    throw new MatchError((Object)errors);
                }
                return stringBuilder;
            });
            boxedUnit = BoxedUnit.UNIT;
        } else if (errors != null) {
            Errors errors2 = errors;
            boxedUnit = topicMetadataInfo.append(new StringOps(Predef$.MODULE$.augmentString("\nNo partition metadata for topic %s due to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), errors2.exceptionName()})));
        } else {
            throw new MatchError((Object)errors);
        }
        topicMetadataInfo.append("}");
        return topicMetadataInfo.toString();
    }

    public TopicMetadata copy(String topic, Seq<PartitionMetadata> partitionsMetadata, Errors error) {
        return new TopicMetadata(topic, partitionsMetadata, error);
    }

    public String copy$default$1() {
        return this.topic();
    }

    public Seq<PartitionMetadata> copy$default$2() {
        return this.partitionsMetadata();
    }

    public Errors copy$default$3() {
        return this.error();
    }

    public String productPrefix() {
        return "TopicMetadata";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Errors errors;
        int n = x$1;
        switch (n) {
            case 0: {
                errors = this.topic();
                break;
            }
            case 1: {
                errors = this.partitionsMetadata();
                break;
            }
            case 2: {
                errors = this.error();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return errors;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TopicMetadata;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TopicMetadata)) return false;
        boolean bl = true;
        if (!bl) return false;
        TopicMetadata topicMetadata = (TopicMetadata)x$1;
        String string = this.topic();
        String string2 = topicMetadata.topic();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Seq<PartitionMetadata> seq = this.partitionsMetadata();
        Seq<PartitionMetadata> seq2 = topicMetadata.partitionsMetadata();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Errors errors = this.error();
        Errors errors2 = topicMetadata.error();
        if (errors == null) {
            if (errors2 != null) {
                return false;
            }
        } else if (!errors.equals(errors2)) return false;
        if (!topicMetadata.canEqual(this)) return false;
        return true;
    }

    public TopicMetadata(String topic, Seq<PartitionMetadata> partitionsMetadata, Errors error) {
        this.topic = topic;
        this.partitionsMetadata = partitionsMetadata;
        this.error = error;
        Logging.$init$(this);
        Product.$init$((Product)this);
    }
}

