/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans.cag;

import uk.ac.ic.doc.scenebeans.CAGComposite;
import uk.ac.ic.doc.scenebeans.CompositeNode;
import uk.ac.ic.doc.scenebeans.Input;
import uk.ac.ic.doc.scenebeans.Primitive;
import uk.ac.ic.doc.scenebeans.SceneGraphProcessor;
import uk.ac.ic.doc.scenebeans.Style;
import uk.ac.ic.doc.scenebeans.Transform;

public class CAGDirty
implements SceneGraphProcessor {
    private boolean _is_dirty = false;

    public static boolean areChildrenDirty(CAGComposite cAGComposite) {
        CAGDirty cAGDirty = new CAGDirty();
        int n = 0;
        while (n < cAGComposite.getSubgraphCount()) {
            cAGComposite.getSubgraph(n).accept(cAGDirty);
            if (cAGDirty.isDirty()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isDirty() {
        return this._is_dirty;
    }

    public void process(Primitive primitive) {
        this._is_dirty = primitive.isDirty();
    }

    public void process(Transform transform) {
        if (transform.isDirty()) {
            this._is_dirty = true;
        } else {
            transform.getTransformedGraph().accept(this);
        }
    }

    public void process(Input input) {
        if (input.isDirty()) {
            this._is_dirty = true;
        } else {
            input.getSensitiveGraph().accept(this);
        }
    }

    public void process(Style style) {
        if (style.isDirty()) {
            this._is_dirty = true;
        } else {
            style.getStyledGraph().accept(this);
        }
    }

    public void process(CompositeNode compositeNode) {
        if (compositeNode.isDirty()) {
            this._is_dirty = true;
        } else {
            int n = 0;
            while (n < compositeNode.getVisibleSubgraphCount()) {
                compositeNode.getVisibleSubgraph(n).accept(this);
                if (this._is_dirty) {
                    return;
                }
                ++n;
            }
        }
    }
}

