/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opensolaris.opengrok.OpenGrokLogger;

public class HistoryEntry {
    private String revision;
    private Date date;
    private String author;
    private String tags;
    private final StringBuffer message;
    private boolean active;
    private SortedSet<String> files;
    private List<String> changeRequests;

    public HistoryEntry() {
        this.message = new StringBuffer();
        this.files = new TreeSet<String>();
        this.changeRequests = new ArrayList<String>();
    }

    public HistoryEntry(HistoryEntry that) {
        this.revision = that.revision;
        this.date = that.date;
        this.author = that.author;
        this.tags = that.tags;
        this.message = that.message;
        this.active = that.active;
        this.files = that.files;
        this.changeRequests = that.changeRequests;
    }

    public HistoryEntry(String revision, Date date, String author, String tags, String message, boolean active) {
        this.revision = revision;
        this.setDate(date);
        this.author = author;
        this.tags = tags;
        this.message = new StringBuffer(message);
        this.active = active;
        this.files = new TreeSet<String>();
        this.changeRequests = new ArrayList<String>();
    }

    public String getLine() {
        return this.revision + " " + this.date + " " + this.author + " " + this.message + "\n";
    }

    public void dump() {
        Logger log = OpenGrokLogger.getLogger();
        log.log(Level.FINE, "HistoryEntry : revision       = {0}", this.revision);
        log.log(Level.FINE, "HistoryEntry : tags           = {0}", this.tags);
        log.log(Level.FINE, "HistoryEntry : date           = {0}", this.date);
        log.log(Level.FINE, "HistoryEntry : author         = {0}", this.author);
        log.log(Level.FINE, "HistoryEntry : active         = {0}", this.active ? "True" : "False");
        String[] lines = this.message.toString().split("\n");
        String separator = "=";
        for (String line : lines) {
            log.log(Level.FINE, "HistoryEntry : message        {0} {1}", new Object[]{separator, line});
            separator = ">";
        }
        separator = "=";
        for (String cr : this.changeRequests) {
            log.log(Level.FINE, "HistoryEntry : changeRequests {0} {1}", new Object[]{separator, cr});
            separator = ">";
        }
        separator = "=";
        for (String file : this.files) {
            log.log(Level.FINE, "HistoryEntry : files          {0} {1}", new Object[]{separator, file});
            separator = ">";
        }
    }

    public String getAuthor() {
        return this.author;
    }

    public String getTags() {
        return this.tags;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.clone();
    }

    public String getMessage() {
        return this.message.toString().trim();
    }

    public String getRevision() {
        return this.revision;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public final void setDate(Date date) {
        this.date = date == null ? null : (Date)date.clone();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void setMessage(String message) {
        this.message.setLength(0);
        this.message.append(message);
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void appendMessage(String message) {
        this.message.append(message);
        this.message.append("\n");
    }

    public void addFile(String file) {
        this.files.add(file);
    }

    public SortedSet<String> getFiles() {
        return this.files;
    }

    public void setFiles(SortedSet<String> files) {
        this.files = files;
    }

    public String toString() {
        return this.getLine();
    }

    public void addChangeRequest(String changeRequest) {
        if (!this.changeRequests.contains(changeRequest)) {
            this.changeRequests.add(changeRequest);
        }
    }

    public List<String> getChangeRequests() {
        return this.changeRequests;
    }

    public void setChangeRequests(List<String> changeRequests) {
        this.changeRequests = changeRequests;
    }

    public void strip() {
        this.files.clear();
        this.tags = null;
    }
}

