/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class BandCombineOp
implements RasterOp {
    private RenderingHints hints;
    private float[][] matrix;

    public WritableRaster filter(Raster src, WritableRaster dest) {
        if (dest == null) {
            dest = this.createCompatibleDestRaster(src);
        }
        float[] spix = new float[this.matrix[0].length];
        float[] dpix = new float[this.matrix.length];
        int y = src.getMinY();
        while (y < src.getHeight() + src.getMinY()) {
            int x = src.getMinX();
            while (x < src.getWidth() + src.getMinX()) {
                spix[spix.length - 1] = 1.0f;
                src.getPixel(x, y, spix);
                int i = 0;
                while (i < this.matrix.length) {
                    dpix[i] = 0.0f;
                    int j = 0;
                    while (j < this.matrix[0].length) {
                        int n = i;
                        dpix[n] = dpix[n] + spix[j] * this.matrix[i][j];
                        ++j;
                    }
                    ++i;
                }
                dest.setPixel(x, y, dpix);
                ++x;
            }
            ++y;
        }
        return dest;
    }

    public Rectangle2D getBounds2D(Raster src) {
        return src.getBounds();
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        return Raster.createBandedRaster(4, src.getWidth(), src.getHeight(), this.matrix.length, new Point(src.getMinX(), src.getMinY()));
    }

    public Point2D getPoint2D(Point2D src, Point2D dst) {
        if (dst == null) {
            return (Point2D)src.clone();
        }
        dst.setLocation(src);
        return dst;
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public float[][] getMatrix() {
        return this.matrix;
    }

    public BandCombineOp(float[][] matrix, RenderingHints hints) {
        this.matrix = matrix;
        this.hints = hints;
    }
}

