/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnchorPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;

public class ContextItemExpression
extends Expression {
    ItemType itemType = Type.ITEM_TYPE;
    boolean contextPossiblyUndefined = true;

    public String getExpressionName() {
        return "contextItem";
    }

    public Expression copy() {
        ContextItemExpression cie2 = new ContextItemExpression();
        cie2.itemType = this.itemType;
        cie2.contextPossiblyUndefined = this.contextPossiblyUndefined;
        return cie2;
    }

    protected String getErrorCodeForUndefinedContext() {
        return "XPDY0002";
    }

    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        if (contextItemType == null || contextItemType.itemType == null) {
            XPathException err = new XPathException("There is no context item");
            err.setErrorCode(this.getErrorCodeForUndefinedContext());
            err.setIsTypeError(true);
            err.setLocator(this);
            visitor.issueWarning("Evaluation will always fail: there is no context item", this);
            return new ErrorExpression(err);
        }
        this.contextPossiblyUndefined = contextItemType.contextMaybeUndefined;
        this.itemType = contextItemType.itemType;
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        if (contextItemType == null) {
            XPathException err = new XPathException("The context item is undefined at this point");
            err.setErrorCode(this.getErrorCodeForUndefinedContext());
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        return this;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return this.itemType;
    }

    public boolean isContextPossiblyUndefined() {
        return this.contextPossiblyUndefined;
    }

    public int computeCardinality() {
        return 16384;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000 | 0x10000;
    }

    public boolean equals(Object other) {
        return other instanceof ContextItemExpression;
    }

    public int hashCode() {
        return "ContextItemExpression".hashCode();
    }

    public int getIntrinsicDependencies() {
        return 2;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        if (pathMapNodeSet == null) {
            pathMapNodeSet = new PathMap.PathMapNodeSet(pathMap.makeNewRoot(this));
        }
        return pathMapNodeSet;
    }

    public boolean isSubtreeExpression() {
        return true;
    }

    public Pattern toPattern(Configuration config, boolean is30) throws XPathException {
        return new AnchorPattern();
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        Item item = context.getContextItem();
        if (item == null) {
            this.dynamicError("The context item is absent", this.getErrorCodeForUndefinedContext(), context);
        }
        return SingletonIterator.makeIterator(item);
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        Item item = context.getContextItem();
        if (item == null) {
            this.dynamicError("The context item is absent", this.getErrorCodeForUndefinedContext(), context);
        }
        return item;
    }

    public String toString() {
        return ".";
    }

    public void explain(ExpressionPresenter destination) {
        destination.startElement("dot");
        destination.endElement();
    }
}

