/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class NormalizeSpace_0
extends SystemFunctionCall
implements Callable {
    public int getIntrinsicDependencies() {
        return 2;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        if (contextItemType == null) {
            XPathException err = new XPathException("The context item for normalize-space() is absent");
            err.setErrorCode("XPDY0002");
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        return super.typeCheck(visitor, contextItemType);
    }

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public StringValue evaluateItem(XPathContext c) throws XPathException {
        Item item = c.getContextItem();
        if (item == null) {
            this.dynamicError("Context item for normalize-space() is absent", "XPDY0002", c);
            return null;
        }
        return StringValue.makeStringValue(Whitespace.collapseWhitespace(item.getStringValueCS()));
    }

    public boolean effectiveBooleanValue(XPathContext c) throws XPathException {
        Item item = c.getContextItem();
        if (item == null) {
            this.dynamicError("Context item for normalize-space() is absent", "XPDY0002", c);
            return false;
        }
        return !Whitespace.isWhite(item.getStringValueCS());
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return this.evaluateItem(context);
    }
}

