/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.squirrel_sql.fw.gui.action.ResultSetExportDialog;
import net.sourceforge.squirrel_sql.fw.gui.action.TableExportCsvController;

public class ResultSetExportCsvController
extends TableExportCsvController {
    private static final String PREF_KEY_LIMIT_ROWS = "SquirrelSQL.sqlexport.limitRows";

    public ResultSetExportCsvController(JFrame owner) {
        super(owner);
    }

    @Override
    protected boolean shouldWarnIfExcel() {
        return true;
    }

    @Override
    protected ResultSetExportDialog createDialog(JFrame owner) {
        final ResultSetExportDialog dlg = new ResultSetExportDialog(owner);
        dlg.radComplete.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (dlg.radComplete.isSelected()) {
                    dlg.txtLimitRows.setEnabled(false);
                } else {
                    dlg.txtLimitRows.setEnabled(true);
                }
            }
        });
        return dlg;
    }

    @Override
    protected void writePrefs() {
        super.writePrefs();
        ResultSetExportDialog dlg = (ResultSetExportDialog)super.getDialog();
        Preferences.userRoot().put(PREF_KEY_LIMIT_ROWS, dlg.txtLimitRows.getText());
    }

    @Override
    protected void initSelectionPanel(Preferences userRoot) {
        super.initSelectionPanel(userRoot);
        ResultSetExportDialog dlg = (ResultSetExportDialog)super.getDialog();
        dlg.txtLimitRows.setText(userRoot.get(PREF_KEY_LIMIT_ROWS, "100"));
        if (dlg.radComplete.isSelected()) {
            dlg.txtLimitRows.setEnabled(false);
        }
    }

    public int getMaxRows() {
        ResultSetExportDialog dlg = (ResultSetExportDialog)super.getDialog();
        return dlg.txtLimitRows.getInt();
    }
}

