/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbcopy.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.dbcopy.prefs.DBCopyPreferenceBean;
import net.sourceforge.squirrel_sql.plugins.dbcopy.prefs.PreferencesManager;

public class PreferencesPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    DBCopyPreferenceBean _prefs = null;
    JCheckBox truncateCheckBox = null;
    JCheckBox fileCachingCheckBox = null;
    JTextField bufferSizeTextField = null;
    JLabel bufferSizeLabel = null;
    JCheckBox autoCommitCheckBox = null;
    JCheckBox commitAfterCreateTableCheckBox = null;
    JLabel commitRecordCountLabel = null;
    JTextField commitRecordCountTextField = null;
    JCheckBox saveScriptCheckBox = null;
    JCheckBox copyTableRecords = null;
    JCheckBox copyIndexDefs = null;
    JCheckBox copyForeignKeys = null;
    JCheckBox copyPrimaryKeys = null;
    JCheckBox pruneDuplicateIndexDefs = null;
    JCheckBox writeScriptCheckBox = null;
    JCheckBox appendRecordsToExistingCheckBox = null;
    JCheckBox promptForHibernateCheckBox = null;
    JCheckBox checkKeywordsCheckBox = null;
    JCheckBox testColumnNamesCheckBox = null;
    JLabel selectFetchSizeLabel = null;
    JTextField selectFetchSizeTextField = null;
    JCheckBox delayBetweenObjects = null;
    JLabel delayTablesLabel = null;
    JTextField delayTablesTextField = null;
    JLabel delayRecordsLabel = null;
    JTextField delayRecordsTextField = null;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(PreferencesPanel.class);

    public PreferencesPanel(DBCopyPreferenceBean prefs) {
        this._prefs = prefs;
        this.createGUI();
        this.loadData();
    }

    private void createGUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.4;
        this.add((Component)this.createTopPanel(), c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.6;
        this.add((Component)this.createBottomPanel(), c);
    }

    private JPanel createTopPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        String tranferOptionsBorderLabel = s_stringMgr.getString("PreferencesPanel.transferOptionsBorderLabel");
        result.setBorder(this.getTitledBorder(tranferOptionsBorderLabel));
        String cbLabel = s_stringMgr.getString("PreferencesPanel.truncateLabel");
        this.truncateCheckBox = new JCheckBox(cbLabel);
        this.addUseTruncateCheckBox(result, 0, 0);
        this.addCopyTableRecordsCheckBox(result, 0, 1);
        this.addFetchSizeLabel(result, 0, 2);
        this.addFetchSizeTextField(result, 1, 2);
        this.addCopyPrimaryKeysCheckBox(result, 0, 3);
        this.addCopyForeignKeysCheckBox(result, 0, 4);
        this.addCopyIndexDefsCheckBox(result, 0, 5);
        this.addPruneDuplicateIndexDefsCheckBox(result, 0, 6);
        this.addFileCacheCheckBox(result, 0, 7);
        this.addBufferSizeLabel(result, 0, 8);
        this.addBufferSizeTextField(result, 1, 8);
        this.addAutoCommitCheckcBox(result, 0, 9);
        this.addCommitAfterCreateTableCheckBox(result, 0, 10);
        this.addRecordCountLabel(result, 0, 11);
        this.addCommitRecordCountTextField(result, 1, 11);
        this.addDelayCheckBox(result, 0, 12);
        this.addDelayTablesLabel(result, 0, 13);
        this.addDelayTablesTextField(result, 1, 13);
        this.addDelayRecordsLabel(result, 0, 14);
        this.addDelayRecordsTextField(result, 1, 14);
        this.addWriteScriptCheckBox(result, 0, 15);
        this.addAppendRecordsToExistingCheckBox(result, 0, 16);
        return result;
    }

    private void addPruneDuplicateIndexDefsCheckBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.insets = new Insets(10, 25, 0, 0);
        c.anchor = 17;
        String cbLabelStr = s_stringMgr.getString("PreferencesPanel.pruneDuplicateIndexDefs");
        String toolTipText = s_stringMgr.getString("PreferencesPanel.pruneDuplicateIndexDefsToolTip");
        this.pruneDuplicateIndexDefs = new JCheckBox(cbLabelStr);
        this.pruneDuplicateIndexDefs.setToolTipText(toolTipText);
        panel.add((Component)this.pruneDuplicateIndexDefs, c);
    }

    private void addWriteScriptCheckBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.insets = new Insets(10, 0, 0, 0);
        c.anchor = 17;
        String cbLabelStr = s_stringMgr.getString("PreferencesPanel.writeScript");
        String toolTipText = s_stringMgr.getString("PreferencesPanel.writeScriptToolTip");
        this.writeScriptCheckBox = new JCheckBox(cbLabelStr);
        this.writeScriptCheckBox.setToolTipText(toolTipText);
        panel.add((Component)this.writeScriptCheckBox, c);
    }

    private void addAppendRecordsToExistingCheckBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.insets = new Insets(10, 0, 0, 0);
        c.anchor = 17;
        String cbLabelStr = s_stringMgr.getString("PreferencesPanel.appendRecordsToExistingCheckBox");
        String toolTipText = s_stringMgr.getString("PreferencesPanel.appendRecordsToExistingCheckBoxToolTip");
        this.appendRecordsToExistingCheckBox = new JCheckBox(cbLabelStr);
        this.appendRecordsToExistingCheckBox.setToolTipText(toolTipText);
        panel.add((Component)this.appendRecordsToExistingCheckBox, c);
    }

    private void addUseTruncateCheckBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.insets = new Insets(10, 0, 0, 0);
        c.anchor = 17;
        String cbToolTipText = s_stringMgr.getString("PreferencesPanel.truncateLabelTipText");
        this.truncateCheckBox.setToolTipText(cbToolTipText);
        panel.add((Component)this.truncateCheckBox, c);
    }

    private void addCopyTableRecordsCheckBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.insets = new Insets(10, 0, 0, 0);
        c.anchor = 17;
        String cbLabelStr = s_stringMgr.getString("PreferencesPanel.copyTableRecords");
        String toolTipText = s_stringMgr.getString("PreferencesPanel.copyTableRecordsToolTip");
        this.copyTableRecords = new JCheckBox(cbLabelStr);
        this.copyTableRecords.setToolTipText(toolTipText);
        this.copyTableRecords.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesPanel.this.selectFetchSizeLabel.setEnabled(PreferencesPanel.this.copyTableRecords.isSelected());
                PreferencesPanel.this.selectFetchSizeTextField.setEnabled(PreferencesPanel.this.copyTableRecords.isSelected());
            }
        });
        panel.add((Component)this.copyTableRecords, c);
    }

    private void addFetchSizeLabel(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.insets = new Insets(5, 25, 0, 0);
        String bsLabel = s_stringMgr.getString("PreferencesPanel.fetchSizeLabel");
        this.selectFetchSizeLabel = new JLabel(bsLabel);
        this.selectFetchSizeLabel.setHorizontalAlignment(2);
        String labelToolTipText = s_stringMgr.getString("PreferencesPanel.fetchSizeToolTip");
        this.selectFetchSizeLabel.setToolTipText(labelToolTipText);
        panel.add((Component)this.selectFetchSizeLabel, c);
    }

    private void addFetchSizeTextField(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.ipadx = 40;
        c.insets = new Insets(5, 5, 0, 0);
        c.anchor = 17;
        this.selectFetchSizeTextField = new JTextField(10);
        this.selectFetchSizeTextField.setHorizontalAlignment(4);
        String toolTip = s_stringMgr.getString("PreferencesPanel.fetchSizeTextFieldToolTip");
        this.selectFetchSizeTextField.setToolTipText(toolTip);
        panel.add((Component)this.selectFetchSizeTextField, c);
    }

    private void addCopyPrimaryKeysCheckBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.insets = new Insets(10, 0, 0, 0);
        c.anchor = 17;
        String cbLabelStr = s_stringMgr.getString("PreferencesPanel.copyPrimaryKeys");
        String toolTipText = s_stringMgr.getString("PreferencesPanel.copyPrimaryKeysToolTip");
        this.copyPrimaryKeys = new JCheckBox(cbLabelStr);
        this.copyPrimaryKeys.setToolTipText(toolTipText);
        panel.add((Component)this.copyPrimaryKeys, c);
    }

    private void addCopyForeignKeysCheckBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.insets = new Insets(10, 0, 0, 0);
        c.anchor = 17;
        String cbLabelStr = s_stringMgr.getString("PreferencesPanel.copyForeignKeys");
        String toolTipText = s_stringMgr.getString("PreferencesPanel.copyForeignKeysToolTip");
        this.copyForeignKeys = new JCheckBox(cbLabelStr);
        this.copyForeignKeys.setToolTipText(toolTipText);
        panel.add((Component)this.copyForeignKeys, c);
    }

    private void addCopyIndexDefsCheckBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.insets = new Insets(10, 0, 0, 0);
        c.anchor = 17;
        String cbLabelStr = s_stringMgr.getString("PreferencesPanel.copyIndexDefs");
        String toolTipText = s_stringMgr.getString("PreferencesPanel.copyIndexDefsToolTip");
        this.copyIndexDefs = new JCheckBox(cbLabelStr);
        this.copyIndexDefs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PreferencesPanel.this.copyIndexDefs.isSelected()) {
                    PreferencesPanel.this.pruneDuplicateIndexDefs.setEnabled(true);
                } else {
                    PreferencesPanel.this.pruneDuplicateIndexDefs.setEnabled(false);
                }
            }
        });
        this.copyIndexDefs.setToolTipText(toolTipText);
        panel.add((Component)this.copyIndexDefs, c);
    }

    private void addFileCacheCheckBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.insets = new Insets(10, 0, 0, 0);
        c.anchor = 17;
        String cbLabelStr = s_stringMgr.getString("PreferencesPanel.useFileCachingLabel");
        this.fileCachingCheckBox = new JCheckBox(cbLabelStr);
        this.fileCachingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PreferencesPanel.this.fileCachingCheckBox.isSelected()) {
                    PreferencesPanel.this.bufferSizeTextField.setEnabled(true);
                    PreferencesPanel.this.bufferSizeLabel.setEnabled(true);
                } else {
                    PreferencesPanel.this.bufferSizeTextField.setEnabled(false);
                    PreferencesPanel.this.bufferSizeLabel.setEnabled(false);
                }
            }
        });
        String toolTipText = s_stringMgr.getString("PreferencesPanel.useFileCachingToolTip");
        this.fileCachingCheckBox.setToolTipText(toolTipText);
        panel.add((Component)this.fileCachingCheckBox, c);
    }

    private void addBufferSizeLabel(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.insets = new Insets(5, 25, 0, 0);
        String bsLabel = s_stringMgr.getString("PreferencesPanel.copyBufferSizeLabel");
        this.bufferSizeLabel = new JLabel(bsLabel);
        this.bufferSizeLabel.setHorizontalAlignment(2);
        String labelToolTipText = s_stringMgr.getString("PreferencesPanel.copyBufferSizeToolTip");
        this.bufferSizeLabel.setToolTipText(labelToolTipText);
        panel.add((Component)this.bufferSizeLabel, c);
    }

    private void addBufferSizeTextField(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.ipadx = 40;
        c.insets = new Insets(5, 5, 0, 0);
        c.anchor = 17;
        this.bufferSizeTextField = new JTextField(10);
        this.bufferSizeTextField.setHorizontalAlignment(4);
        String toolTip = s_stringMgr.getString("PreferencesPanel.bufferSizeTextFieldToolTip");
        this.bufferSizeTextField.setToolTipText(toolTip);
        panel.add((Component)this.bufferSizeTextField, c);
    }

    private void addAutoCommitCheckcBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.insets = new Insets(10, 0, 0, 0);
        c.anchor = 17;
        String cbLabelStr = s_stringMgr.getString("PreferencesPanel.autoCommitLabel");
        this.autoCommitCheckBox = new JCheckBox(cbLabelStr);
        this.autoCommitCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PreferencesPanel.this.autoCommitCheckBox.isSelected()) {
                    PreferencesPanel.this.commitRecordCountLabel.setEnabled(false);
                    PreferencesPanel.this.commitRecordCountTextField.setEnabled(false);
                    PreferencesPanel.this.commitAfterCreateTableCheckBox.setEnabled(false);
                } else {
                    PreferencesPanel.this.commitRecordCountLabel.setEnabled(true);
                    PreferencesPanel.this.commitRecordCountTextField.setEnabled(true);
                    PreferencesPanel.this.commitAfterCreateTableCheckBox.setEnabled(true);
                }
            }
        });
        panel.add((Component)this.autoCommitCheckBox, c);
    }

    private void addCommitAfterCreateTableCheckBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.insets = new Insets(10, 25, 0, 0);
        c.anchor = 17;
        String cbLabelStr = s_stringMgr.getString("PreferencesPanel.commitAfterCreateTable");
        String toolTipText = s_stringMgr.getString("PreferencesPanel.commitAfterCreateTableToolTip");
        this.commitAfterCreateTableCheckBox = new JCheckBox(cbLabelStr);
        this.commitAfterCreateTableCheckBox.setToolTipText(toolTipText);
        panel.add((Component)this.commitAfterCreateTableCheckBox, c);
    }

    private void addRecordCountLabel(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.insets = new Insets(5, 25, 0, 0);
        String commitLabel = s_stringMgr.getString("PreferencesPanel.commitRecordCountLabel");
        this.commitRecordCountLabel = new JLabel(commitLabel);
        this.commitRecordCountLabel.setHorizontalAlignment(4);
        String commitlabelToolTipText = s_stringMgr.getString("PreferencesPanel.commitRecordCountToolTip");
        this.commitRecordCountLabel.setToolTipText(commitlabelToolTipText);
        panel.add((Component)this.commitRecordCountLabel, c);
    }

    private void addCommitRecordCountTextField(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.ipadx = 40;
        c.insets = new Insets(5, 5, 0, 0);
        c.anchor = 17;
        this.commitRecordCountTextField = new JTextField(10);
        this.commitRecordCountTextField.setHorizontalAlignment(4);
        String commitlabelToolTipText = s_stringMgr.getString("PreferencesPanel.commitRecordCountToolTip");
        this.commitRecordCountTextField.setToolTipText(commitlabelToolTipText);
        panel.add((Component)this.commitRecordCountTextField, c);
    }

    private void addDelayCheckBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.gridwidth = 2;
        c.insets = new Insets(10, 0, 0, 0);
        c.anchor = 17;
        String label = s_stringMgr.getString("PreferencesPanel.delayLabel");
        this.delayBetweenObjects = new JCheckBox(label);
        String delayToolTip = s_stringMgr.getString("PreferencesPanel.delayToolTip");
        this.delayBetweenObjects.setToolTipText(delayToolTip);
        this.delayBetweenObjects.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesPanel.this.delayRecordsLabel.setEnabled(PreferencesPanel.this.delayBetweenObjects.isSelected());
                PreferencesPanel.this.delayRecordsTextField.setEnabled(PreferencesPanel.this.delayBetweenObjects.isSelected());
                PreferencesPanel.this.delayTablesLabel.setEnabled(PreferencesPanel.this.delayBetweenObjects.isSelected());
                PreferencesPanel.this.delayTablesTextField.setEnabled(PreferencesPanel.this.delayBetweenObjects.isSelected());
            }
        });
        panel.add((Component)this.delayBetweenObjects, c);
    }

    private void addDelayTablesLabel(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.insets = new Insets(5, 25, 0, 0);
        String label = s_stringMgr.getString("PreferencesPanel.delayTablesLabel");
        this.delayTablesLabel = new JLabel(label);
        this.delayTablesLabel.setHorizontalAlignment(2);
        panel.add((Component)this.delayTablesLabel, c);
    }

    private void addDelayTablesTextField(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.ipadx = 40;
        c.insets = new Insets(5, 5, 0, 0);
        c.anchor = 17;
        this.delayTablesTextField = new JTextField(10);
        this.delayTablesTextField.setHorizontalAlignment(4);
        panel.add((Component)this.delayTablesTextField, c);
    }

    private void addDelayRecordsLabel(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.insets = new Insets(5, 25, 0, 0);
        String label = s_stringMgr.getString("PreferencesPanel.delayRecordsLabel");
        this.delayRecordsLabel = new JLabel(label);
        this.delayRecordsLabel.setHorizontalAlignment(2);
        panel.add((Component)this.delayRecordsLabel, c);
    }

    private void addDelayRecordsTextField(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.ipadx = 40;
        c.insets = new Insets(5, 5, 0, 0);
        c.anchor = 17;
        this.delayRecordsTextField = new JTextField(10);
        this.delayRecordsTextField.setHorizontalAlignment(4);
        panel.add((Component)this.delayRecordsTextField, c);
    }

    private JPanel createBottomPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        String colTypeMappingBorderLabel = s_stringMgr.getString("PreferencesPanel.colTypeMappingBorderLabel");
        result.setBorder(this.getTitledBorder(colTypeMappingBorderLabel));
        this.addPromptForHibernateCheckBox(result, 0, 0);
        this.addCheckKeywordsCheckBox(result, 0, 1);
        this.addTestColumnNamesCheckBox(result, 0, 2);
        return result;
    }

    private void addPromptForHibernateCheckBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.anchor = 17;
        String cbLabelStr = s_stringMgr.getString("PreferencesPanel.promptForHibernate");
        String cbToolTipText = s_stringMgr.getString("PreferencesPanel.promptForHibernateToolTip");
        this.promptForHibernateCheckBox = new JCheckBox(cbLabelStr);
        this.promptForHibernateCheckBox.setToolTipText(cbToolTipText);
        panel.add((Component)this.promptForHibernateCheckBox, c);
    }

    private void addCheckKeywordsCheckBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.anchor = 17;
        String cbLabelStr = s_stringMgr.getString("PreferencesPanel.checkKeywords");
        String cbToolTipText = s_stringMgr.getString("PreferencesPanel.checkKeywordsToolTip");
        this.checkKeywordsCheckBox = new JCheckBox(cbLabelStr);
        this.checkKeywordsCheckBox.setToolTipText(cbToolTipText);
        panel.add((Component)this.checkKeywordsCheckBox, c);
    }

    private void addTestColumnNamesCheckBox(JPanel panel, int col, int row) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = col;
        c.gridy = row;
        c.anchor = 17;
        String cbLabelStr = s_stringMgr.getString("PreferencesPanel.testColumnNames");
        String cbToolTipText = s_stringMgr.getString("PreferencesPanel.testColumnNamesToolTip");
        this.testColumnNamesCheckBox = new JCheckBox(cbLabelStr);
        this.testColumnNamesCheckBox.setToolTipText(cbToolTipText);
        panel.add((Component)this.testColumnNamesCheckBox, c);
    }

    private Border getTitledBorder(String title) {
        CompoundBorder border = new CompoundBorder(new EmptyBorder(10, 10, 10, 10), new TitledBorder(title));
        return border;
    }

    private void loadData() {
        this.fileCachingCheckBox.setSelected(this._prefs.isUseFileCaching());
        this.bufferSizeTextField.setText("" + this._prefs.getFileCacheBufferSize());
        this.commitRecordCountTextField.setText("" + this._prefs.getCommitCount());
        this.autoCommitCheckBox.setSelected(this._prefs.isAutoCommitEnabled());
        if (this._prefs.isUseFileCaching()) {
            this.bufferSizeLabel.setEnabled(true);
            this.bufferSizeTextField.setEnabled(true);
        } else {
            this.bufferSizeLabel.setEnabled(false);
            this.bufferSizeTextField.setEnabled(false);
        }
        if (this._prefs.isAutoCommitEnabled()) {
            this.commitRecordCountLabel.setEnabled(false);
            this.commitRecordCountTextField.setEnabled(false);
            this.commitAfterCreateTableCheckBox.setEnabled(false);
        } else {
            this.commitRecordCountLabel.setEnabled(true);
            this.commitRecordCountTextField.setEnabled(true);
            this.commitAfterCreateTableCheckBox.setEnabled(true);
        }
        this.truncateCheckBox.setSelected(this._prefs.isUseTruncate());
        this.copyTableRecords.setSelected(this._prefs.isCopyData());
        this.selectFetchSizeLabel.setEnabled(this._prefs.isCopyData());
        this.selectFetchSizeTextField.setEnabled(this._prefs.isCopyData());
        this.selectFetchSizeTextField.setText("" + this._prefs.getSelectFetchSize());
        this.copyIndexDefs.setSelected(this._prefs.isCopyIndexDefs());
        this.copyForeignKeys.setSelected(this._prefs.isCopyForeignKeys());
        this.copyPrimaryKeys.setSelected(this._prefs.isCopyPrimaryKeys());
        this.writeScriptCheckBox.setSelected(this._prefs.isWriteScript());
        this.appendRecordsToExistingCheckBox.setSelected(this._prefs.isAppendRecordsToExisting());
        this.pruneDuplicateIndexDefs.setSelected(this._prefs.isPruneDuplicateIndexDefs());
        this.commitAfterCreateTableCheckBox.setSelected(this._prefs.isCommitAfterTableDefs());
        this.promptForHibernateCheckBox.setSelected(this._prefs.isPromptForDialect());
        this.checkKeywordsCheckBox.setSelected(this._prefs.isCheckKeywords());
        this.testColumnNamesCheckBox.setSelected(this._prefs.isTestColumnNames());
        this.delayTablesTextField.setText("" + this._prefs.getTableDelayMillis());
        this.delayRecordsTextField.setText("" + this._prefs.getRecordDelayMillis());
        this.delayTablesTextField.setEnabled(this._prefs.isDelayBetweenObjects());
        this.delayRecordsTextField.setEnabled(this._prefs.isDelayBetweenObjects());
        this.delayBetweenObjects.setSelected(this._prefs.isDelayBetweenObjects());
        this.delayTablesLabel.setEnabled(this._prefs.isDelayBetweenObjects());
        this.delayRecordsLabel.setEnabled(this._prefs.isDelayBetweenObjects());
    }

    private void save() {
        String value;
        this._prefs.setUseFileCaching(this.fileCachingCheckBox.isSelected());
        this._prefs.setUseTruncate(this.truncateCheckBox.isSelected());
        this._prefs.setCopyData(this.copyTableRecords.isSelected());
        this._prefs.setCopyIndexDefs(this.copyIndexDefs.isSelected());
        this._prefs.setAutoCommitEnabled(this.autoCommitCheckBox.isSelected());
        this._prefs.setCopyForeignKeys(this.copyForeignKeys.isSelected());
        this._prefs.setCopyPrimaryKeys(this.copyPrimaryKeys.isSelected());
        this._prefs.setWriteScript(this.writeScriptCheckBox.isSelected());
        this._prefs.setAppendRecordsToExisting(this.appendRecordsToExistingCheckBox.isSelected());
        this._prefs.setPruneDuplicateIndexDefs(this.pruneDuplicateIndexDefs.isSelected());
        this._prefs.setCommitAfterTableDefs(this.commitAfterCreateTableCheckBox.isSelected());
        this._prefs.setPromptForDialect(this.promptForHibernateCheckBox.isSelected());
        this._prefs.setCheckKeywords(this.checkKeywordsCheckBox.isSelected());
        this._prefs.setTestColumnNames(this.testColumnNamesCheckBox.isSelected());
        this._prefs.setDelayBetweenObjects(this.delayBetweenObjects.isSelected());
        try {
            value = this.bufferSizeTextField.getText();
            this._prefs.setFileCacheBufferSize(Integer.parseInt(value));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            value = this.commitRecordCountTextField.getText();
            this._prefs.setCommitCount(Integer.parseInt(value));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            value = this.selectFetchSizeTextField.getText();
            this._prefs.setSelectFetchSize(Integer.parseInt(value));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            value = this.delayRecordsTextField.getText();
            this._prefs.setRecordDelayMillis(Long.parseLong(value));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            value = this.delayTablesTextField.getText();
            this._prefs.setTableDelayMillis(Long.parseLong(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        PreferencesManager.savePrefs();
    }

    public void applyChanges() {
        this.save();
    }

    public Component getPanelComponent() {
        return this;
    }
}

