/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.rng;

import com.thaiopensource.relaxng.edit.AbstractRefPattern;
import com.thaiopensource.relaxng.edit.Annotated;
import com.thaiopensource.relaxng.edit.AnnotationChild;
import com.thaiopensource.relaxng.edit.AnyNameNameClass;
import com.thaiopensource.relaxng.edit.AttributeAnnotation;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoiceNameClass;
import com.thaiopensource.relaxng.edit.ChoicePattern;
import com.thaiopensource.relaxng.edit.Comment;
import com.thaiopensource.relaxng.edit.Component;
import com.thaiopensource.relaxng.edit.ComponentVisitor;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.Container;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.ElementAnnotation;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.EmptyPattern;
import com.thaiopensource.relaxng.edit.ExternalRefPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.GroupPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.InterleavePattern;
import com.thaiopensource.relaxng.edit.ListPattern;
import com.thaiopensource.relaxng.edit.MixedPattern;
import com.thaiopensource.relaxng.edit.NameClass;
import com.thaiopensource.relaxng.edit.NameClassVisitor;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.NotAllowedPattern;
import com.thaiopensource.relaxng.edit.NsNameNameClass;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OpenNameClass;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.Param;
import com.thaiopensource.relaxng.edit.ParentRefPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.PatternVisitor;
import com.thaiopensource.relaxng.edit.RefPattern;
import com.thaiopensource.relaxng.edit.TextAnnotation;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.UnaryPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import com.thaiopensource.relaxng.output.OutputDirectory;
import com.thaiopensource.relaxng.output.common.XmlWriter;
import com.thaiopensource.util.VoidValue;
import java.io.IOException;
import java.util.List;
import java.util.Map;

class Output
implements PatternVisitor<VoidValue>,
NameClassVisitor<VoidValue>,
ComponentVisitor<VoidValue> {
    private final String sourceUri;
    private final OutputDirectory od;
    private final XmlWriter xw;
    private final String datatypeLibrary;
    private final Map<String, String> prefixMap;
    private String localNs = null;

    public static void output(Pattern pattern, String string, String string2, OutputDirectory outputDirectory, String string3, Map<String, String> map) throws IOException {
        try {
            Output output = new Output(string2, string, outputDirectory, string3, map);
            pattern.accept(output);
            output.xw.close();
        }
        catch (XmlWriter.WrappedException wrappedException) {
            throw wrappedException.getIOException();
        }
    }

    private Output(String string, String string2, OutputDirectory outputDirectory, String string3, Map<String, String> map) throws IOException {
        this.sourceUri = string;
        this.od = outputDirectory;
        this.datatypeLibrary = string3;
        this.prefixMap = map;
        OutputDirectory.Stream stream = outputDirectory.open(string, string2);
        this.xw = new XmlWriter(stream.getWriter(), stream.getEncoding(), stream.getCharRepertoire(), outputDirectory.getLineSeparator(), outputDirectory.getIndent(), this.getTopLevelAttributes());
    }

    private String[] getTopLevelAttributes() {
        int n = this.prefixMap.size();
        if (this.datatypeLibrary != null) {
            ++n;
        }
        String[] stringArray = new String[n * 2];
        int n2 = 0;
        for (Map.Entry<String, String> entry : this.prefixMap.entrySet()) {
            String string = entry.getKey();
            if (string.equals("xml")) continue;
            stringArray[n2++] = string.equals("") ? "ns" : "xmlns:" + string;
            stringArray[n2++] = entry.getValue();
        }
        stringArray[n2++] = "xmlns";
        stringArray[n2++] = "http://relaxng.org/ns/structure/1.0";
        if (this.datatypeLibrary != null) {
            stringArray[n2++] = "datatypeLibrary";
            stringArray[n2++] = this.datatypeLibrary;
        }
        return stringArray;
    }

    @Override
    public VoidValue visitElement(ElementPattern elementPattern) {
        this.leadingAnnotations(elementPattern);
        this.xw.startElement("element");
        boolean bl = this.tryNameAttribute(elementPattern.getNameClass(), false);
        this.innerAnnotations(elementPattern);
        if (!bl) {
            elementPattern.getNameClass().accept(this);
        }
        this.implicitGroup(elementPattern.getChild());
        this.end(elementPattern);
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitAttribute(AttributePattern attributePattern) {
        Pattern pattern;
        this.leadingAnnotations(attributePattern);
        this.xw.startElement("attribute");
        boolean bl = this.tryNameAttribute(attributePattern.getNameClass(), true);
        this.innerAnnotations(attributePattern);
        if (!bl) {
            attributePattern.getNameClass().accept(this);
        }
        if (!((pattern = attributePattern.getChild()) instanceof TextPattern) || Output.hasAnnotations(pattern)) {
            pattern.accept(this);
        }
        this.end(attributePattern);
        return VoidValue.VOID;
    }

    private boolean tryNameAttribute(NameClass nameClass, boolean bl) {
        if (Output.hasAnnotations(nameClass)) {
            return false;
        }
        if (!(nameClass instanceof NameNameClass)) {
            return false;
        }
        NameNameClass nameNameClass = (NameNameClass)nameClass;
        String string = nameNameClass.getNamespaceUri();
        if (string == NameClass.INHERIT_NS) {
            if (bl || this.lookupPrefix("") != null) {
                return false;
            }
            this.xw.attribute("name", nameNameClass.getLocalName());
            return true;
        }
        if (string.length() == 0) {
            if (!bl && !"".equals(this.lookupPrefix(""))) {
                return false;
            }
            this.xw.attribute("name", nameNameClass.getLocalName());
            return true;
        }
        String string2 = nameNameClass.getPrefix();
        if (string2 == null) {
            if (bl || !string.equals(this.lookupPrefix(""))) {
                return false;
            }
            this.xw.attribute("name", nameNameClass.getLocalName());
        } else {
            if (!string.equals(this.prefixMap.get(string2))) {
                this.xw.attribute("xmlns:" + string2, string);
            }
            this.xw.attribute("name", string2 + ":" + nameNameClass.getLocalName());
        }
        return true;
    }

    @Override
    public VoidValue visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
        return this.visitUnary("oneOrMore", oneOrMorePattern);
    }

    @Override
    public VoidValue visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
        return this.visitUnary("zeroOrMore", zeroOrMorePattern);
    }

    @Override
    public VoidValue visitOptional(OptionalPattern optionalPattern) {
        return this.visitUnary("optional", optionalPattern);
    }

    @Override
    public VoidValue visitInterleave(InterleavePattern interleavePattern) {
        return this.visitComposite("interleave", interleavePattern);
    }

    @Override
    public VoidValue visitGroup(GroupPattern groupPattern) {
        return this.visitComposite("group", groupPattern);
    }

    @Override
    public VoidValue visitChoice(ChoicePattern choicePattern) {
        return this.visitComposite("choice", choicePattern);
    }

    @Override
    public VoidValue visitGrammar(GrammarPattern grammarPattern) {
        this.leadingAnnotations(grammarPattern);
        this.xw.startElement("grammar");
        this.finishContainer(grammarPattern, grammarPattern);
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitExternalRef(ExternalRefPattern externalRefPattern) {
        this.leadingAnnotations(externalRefPattern);
        this.xw.startElement("externalRef");
        this.xw.attribute("href", this.od.reference(this.sourceUri, externalRefPattern.getUri()));
        this.nsAttribute(externalRefPattern.getNs());
        this.innerAnnotations(externalRefPattern);
        this.end(externalRefPattern);
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitRef(RefPattern refPattern) {
        return this.visitAbstractRef("ref", refPattern);
    }

    @Override
    public VoidValue visitParentRef(ParentRefPattern parentRefPattern) {
        return this.visitAbstractRef("parentRef", parentRefPattern);
    }

    private VoidValue visitAbstractRef(String string, AbstractRefPattern abstractRefPattern) {
        this.leadingAnnotations(abstractRefPattern);
        this.xw.startElement(string);
        this.xw.attribute("name", abstractRefPattern.getName());
        this.innerAnnotations(abstractRefPattern);
        this.end(abstractRefPattern);
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitValue(ValuePattern valuePattern) {
        this.leadingAnnotations(valuePattern);
        this.xw.startElement("value");
        if (!valuePattern.getType().equals("token") || !valuePattern.getDatatypeLibrary().equals("")) {
            this.xw.attribute("type", valuePattern.getType());
            if (!valuePattern.getDatatypeLibrary().equals(this.datatypeLibrary)) {
                this.xw.attribute("datatypeLibrary", valuePattern.getDatatypeLibrary());
            }
            for (Map.Entry<String, String> entry : valuePattern.getPrefixMap().entrySet()) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                if (string.length() == 0) {
                    this.nsAttribute(string2);
                    continue;
                }
                if (string2 == NameClass.INHERIT_NS || string2.equals(this.lookupPrefix(string))) continue;
                this.xw.attribute("xmlns:" + string, string2);
            }
        }
        this.innerAnnotations(valuePattern);
        this.xw.text(valuePattern.getValue());
        this.end(valuePattern);
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitData(DataPattern dataPattern) {
        this.leadingAnnotations(dataPattern);
        this.xw.startElement("data");
        this.xw.attribute("type", dataPattern.getType());
        if (!dataPattern.getDatatypeLibrary().equals(this.datatypeLibrary)) {
            this.xw.attribute("datatypeLibrary", dataPattern.getDatatypeLibrary());
        }
        this.innerAnnotations(dataPattern);
        List<Param> list = dataPattern.getParams();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Param param = list.get(i);
            this.leadingAnnotations(param);
            this.xw.startElement("param");
            this.xw.attribute("name", param.getName());
            this.innerAnnotations(param);
            this.xw.text(param.getValue());
            this.end(param);
        }
        Pattern pattern = dataPattern.getExcept();
        if (pattern != null) {
            this.xw.startElement("except");
            this.implicitChoice(pattern);
            this.xw.endElement();
        }
        this.end(dataPattern);
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitMixed(MixedPattern mixedPattern) {
        return this.visitUnary("mixed", mixedPattern);
    }

    @Override
    public VoidValue visitList(ListPattern listPattern) {
        return this.visitUnary("list", listPattern);
    }

    @Override
    public VoidValue visitText(TextPattern textPattern) {
        return this.visitNullary("text", textPattern);
    }

    @Override
    public VoidValue visitEmpty(EmptyPattern emptyPattern) {
        return this.visitNullary("empty", emptyPattern);
    }

    @Override
    public VoidValue visitNotAllowed(NotAllowedPattern notAllowedPattern) {
        return this.visitNullary("notAllowed", notAllowedPattern);
    }

    private VoidValue visitNullary(String string, Pattern pattern) {
        this.leadingAnnotations(pattern);
        this.xw.startElement(string);
        this.innerAnnotations(pattern);
        this.end(pattern);
        return VoidValue.VOID;
    }

    private VoidValue visitUnary(String string, UnaryPattern unaryPattern) {
        this.leadingAnnotations(unaryPattern);
        this.xw.startElement(string);
        this.innerAnnotations(unaryPattern);
        this.implicitGroup(unaryPattern.getChild());
        this.end(unaryPattern);
        return VoidValue.VOID;
    }

    private VoidValue visitComposite(String string, CompositePattern compositePattern) {
        this.leadingAnnotations(compositePattern);
        this.xw.startElement(string);
        this.innerAnnotations(compositePattern);
        List<Pattern> list = compositePattern.getChildren();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            list.get(i).accept(this);
        }
        this.end(compositePattern);
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitChoice(ChoiceNameClass choiceNameClass) {
        this.leadingAnnotations(choiceNameClass);
        this.xw.startElement("choice");
        this.innerAnnotations(choiceNameClass);
        List<NameClass> list = choiceNameClass.getChildren();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            list.get(i).accept(this);
        }
        this.end(choiceNameClass);
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitAnyName(AnyNameNameClass anyNameNameClass) {
        this.leadingAnnotations(anyNameNameClass);
        this.xw.startElement("anyName");
        this.innerAnnotations(anyNameNameClass);
        this.visitExcept(anyNameNameClass);
        this.end(anyNameNameClass);
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitNsName(NsNameNameClass nsNameNameClass) {
        this.leadingAnnotations(nsNameNameClass);
        this.xw.startElement("nsName");
        String string = this.localNs;
        this.localNs = this.nsAttribute(nsNameNameClass.getNs());
        this.innerAnnotations(nsNameNameClass);
        this.visitExcept(nsNameNameClass);
        this.localNs = string;
        this.end(nsNameNameClass);
        return VoidValue.VOID;
    }

    private void visitExcept(OpenNameClass openNameClass) {
        NameClass nameClass = openNameClass.getExcept();
        if (nameClass == null) {
            return;
        }
        this.xw.startElement("except");
        this.implicitChoice(nameClass);
        this.xw.endElement();
    }

    @Override
    public VoidValue visitName(NameNameClass nameNameClass) {
        this.leadingAnnotations(nameNameClass);
        this.xw.startElement("name");
        String string = nameNameClass.getNamespaceUri();
        if (string == NameClass.INHERIT_NS) {
            this.nsAttribute(string);
            this.innerAnnotations(nameNameClass);
            this.xw.text(nameNameClass.getLocalName());
        } else {
            String string2 = nameNameClass.getPrefix();
            if (string2 == null || string.length() == 0) {
                this.nsAttribute(string);
                this.innerAnnotations(nameNameClass);
                this.xw.text(nameNameClass.getLocalName());
            } else {
                if (!string.equals(this.prefixMap.get(string2))) {
                    this.xw.attribute("xmlns:" + string2, string);
                }
                this.innerAnnotations(nameNameClass);
                this.xw.text(string2 + ":" + nameNameClass.getLocalName());
            }
        }
        this.end(nameNameClass);
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitDefine(DefineComponent defineComponent) {
        this.leadingAnnotations(defineComponent);
        String string = defineComponent.getName();
        if (string == DefineComponent.START) {
            this.xw.startElement("start");
        } else {
            this.xw.startElement("define");
            this.xw.attribute("name", string);
        }
        if (defineComponent.getCombine() != null) {
            this.xw.attribute("combine", defineComponent.getCombine().toString());
        }
        this.innerAnnotations(defineComponent);
        if (string == DefineComponent.START) {
            defineComponent.getBody().accept(this);
        } else {
            this.implicitGroup(defineComponent.getBody());
        }
        this.end(defineComponent);
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitDiv(DivComponent divComponent) {
        this.leadingAnnotations(divComponent);
        this.xw.startElement("div");
        this.finishContainer(divComponent, divComponent);
        return VoidValue.VOID;
    }

    @Override
    public VoidValue visitInclude(IncludeComponent includeComponent) {
        this.leadingAnnotations(includeComponent);
        this.xw.startElement("include");
        this.xw.attribute("href", this.od.reference(this.sourceUri, includeComponent.getUri()));
        String string = this.localNs;
        this.localNs = this.nsAttribute(includeComponent.getNs());
        this.finishContainer(includeComponent, includeComponent);
        this.localNs = string;
        return VoidValue.VOID;
    }

    private void finishContainer(Annotated annotated, Container container) {
        this.innerAnnotations(annotated);
        List<Component> list = container.getComponents();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            list.get(i).accept(this);
        }
        this.end(annotated);
    }

    private void leadingAnnotations(Annotated annotated) {
        this.annotationChildren(annotated.getLeadingComments(), true);
    }

    private void innerAnnotations(Annotated annotated) {
        this.annotationAttributes(annotated.getAttributeAnnotations());
        this.annotationChildren(annotated.getChildElementAnnotations(), true);
    }

    private void outerAnnotations(Annotated annotated) {
        this.annotationChildren(annotated.getFollowingElementAnnotations(), true);
    }

    private void annotationAttributes(List<AttributeAnnotation> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AttributeAnnotation attributeAnnotation = list.get(i);
            String string = attributeAnnotation.getLocalName();
            String string2 = attributeAnnotation.getPrefix();
            this.xw.attribute(string2 == null ? string : string2 + ":" + string, attributeAnnotation.getValue());
        }
    }

    private void annotationChildren(List<? extends AnnotationChild> list, boolean bl) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            AnnotationChild annotationChild = list.get(i);
            if (annotationChild instanceof ElementAnnotation) {
                ElementAnnotation elementAnnotation = (ElementAnnotation)annotationChild;
                String string = elementAnnotation.getLocalName();
                String string2 = elementAnnotation.getPrefix();
                if (string2 == null) {
                    this.xw.startElement(string);
                    if (bl) {
                        this.xw.attribute("xmlns", "");
                        bl = false;
                    }
                } else {
                    this.xw.startElement(string2 + ":" + string);
                }
                this.annotationAttributes(elementAnnotation.getAttributes());
                this.annotationChildren(elementAnnotation.getChildren(), bl);
                this.xw.endElement();
                continue;
            }
            if (annotationChild instanceof TextAnnotation) {
                this.xw.text(((TextAnnotation)annotationChild).getValue());
                continue;
            }
            if (!(annotationChild instanceof Comment)) continue;
            this.xw.comment(Output.fixupComment(((Comment)annotationChild).getValue()));
        }
    }

    private static String fixupComment(String string) {
        int n;
        int n2 = 0;
        while ((n = string.indexOf(45, n2)) >= 0) {
            if (n == string.length() - 1) {
                return string + " ";
            }
            if (string.charAt(n + 1) == '-') {
                return string.substring(0, n) + "- " + Output.fixupComment(string.substring(n + 1));
            }
            n2 = n + 1;
        }
        return string;
    }

    private void end(Annotated annotated) {
        this.xw.endElement();
        this.outerAnnotations(annotated);
    }

    private void implicitGroup(Pattern pattern) {
        if (!Output.hasAnnotations(pattern) && pattern instanceof GroupPattern) {
            List<Pattern> list = ((GroupPattern)pattern).getChildren();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                list.get(i).accept(this);
            }
        } else {
            pattern.accept(this);
        }
    }

    private void implicitChoice(Pattern pattern) {
        if (!Output.hasAnnotations(pattern) && pattern instanceof ChoicePattern) {
            List<Pattern> list = ((ChoicePattern)pattern).getChildren();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                list.get(i).accept(this);
            }
        } else {
            pattern.accept(this);
        }
    }

    private void implicitChoice(NameClass nameClass) {
        if (!Output.hasAnnotations(nameClass) && nameClass instanceof ChoiceNameClass) {
            List<NameClass> list = ((ChoiceNameClass)nameClass).getChildren();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                list.get(i).accept(this);
            }
        } else {
            nameClass.accept(this);
        }
    }

    private static boolean hasAnnotations(Annotated annotated) {
        return !annotated.getLeadingComments().isEmpty() || !annotated.getAttributeAnnotations().isEmpty() || !annotated.getChildElementAnnotations().isEmpty() || !annotated.getFollowingElementAnnotations().isEmpty();
    }

    private String nsAttribute(String string) {
        if (string == NameClass.INHERIT_NS) {
            if (this.lookupPrefix("") != null) {
                this.xw.attribute("ns", "");
                return "";
            }
        } else if (!string.equals(this.lookupPrefix(""))) {
            this.xw.attribute("ns", string);
            return string;
        }
        return this.localNs;
    }

    private String lookupPrefix(String string) {
        if (string.equals("") && this.localNs != null) {
            return this.localNs;
        }
        return this.prefixMap.get(string);
    }
}

