/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.igoweb.util.Defs;
import org.igoweb.util.swing.AutolinkTextPane;

public class Motd
extends JScrollPane {
    private final AutolinkTextPane text = new AutolinkTextPane();
    private boolean showingMotd = true;
    private final Font textFont;
    private final Font boldFont;
    private Thread loadingThread = null;
    private String realMotd;

    public Motd() {
        super(22, 31);
        this.setViewportView(this.text);
        this.text.setEditable(false);
        this.realMotd = Defs.getString(-903340688);
        this.text.setText(this.realMotd);
        this.textFont = this.text.getFont();
        this.boldFont = this.textFont.deriveFont(1);
        this.text.setFont(this.textFont);
        this.text.setBackground(UIManager.getColor("org.igoweb.outputBg"));
        this.showLocale(Defs.getString(2031923656));
    }

    public void showLocale(final String localeName) {
        this.loadingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Motd.this.doShowLocale(localeName);
            }
        });
        this.loadingThread.start();
    }

    private void doShowLocale(String localeName) {
        String newMotd;
        try {
            int c;
            StringBuilder motdBuffer = new StringBuilder();
            URL motdURL = new URL("http://files.gokgs.com/motd-" + localeName + ".txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(motdURL.openStream(), "UTF-8"));
            while ((c = ((Reader)reader).read()) != -1) {
                motdBuffer.append((char)c);
            }
            ((Reader)reader).close();
            newMotd = motdBuffer.toString();
        }
        catch (IOException ioe) {
            newMotd = Defs.getString(-903340689, ioe.toString());
        }
        final Thread me = Thread.currentThread();
        final String finalNewMotd = newMotd;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Motd.this.changeMotd(me, finalNewMotd);
            }
        });
    }

    private void changeMotd(Thread loadedBy, String newMotd) {
        if (loadedBy == this.loadingThread) {
            this.loadingThread = null;
            this.realMotd = newMotd;
            if (this.showingMotd) {
                this.text.setText(newMotd);
                this.text.setCaretPosition(0);
            }
        }
    }

    public void setEditable(boolean isEditable) {
        this.text.setEditable(isEditable);
        this.text.setBackground(UIManager.getColor("org.igoweb.inputBg"));
    }

    @Override
    public boolean isFocusTraversable() {
        return this.text.isEditable();
    }

    public void setMessage(String newMessage) {
        this.showingMotd = false;
        this.text.setFont(this.boldFont);
        this.text.setText(newMessage);
        this.text.setCaretPosition(0);
    }

    public void setMotd() {
        if (this.showingMotd) {
            return;
        }
        this.showingMotd = true;
        this.text.setFont(this.textFont);
        this.text.setText(this.realMotd);
        this.text.setCaretPosition(0);
    }

    public boolean isEditable() {
        return this.text.isEditable();
    }

    public String getText() {
        return this.text.getText();
    }
}

