/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.job;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.rounding.DateTimeUnit;
import org.elasticsearch.common.rounding.Rounding;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.joda.time.DateTimeZone;

public class DateHistogramGroupConfig
implements Writeable,
ToXContentObject {
    static final String NAME = "date_histogram";
    public static final String INTERVAL = "interval";
    private static final String FIELD = "field";
    public static final String TIME_ZONE = "time_zone";
    public static final String DELAY = "delay";
    private static final String DEFAULT_TIMEZONE = "UTC";
    private static final ConstructingObjectParser<DateHistogramGroupConfig, Void> PARSER = new ConstructingObjectParser("date_histogram", a -> new DateHistogramGroupConfig((String)a[0], (DateHistogramInterval)a[1], (DateHistogramInterval)a[2], (String)a[3]));
    private final String field;
    private final DateHistogramInterval interval;
    private final DateHistogramInterval delay;
    private final String timeZone;

    public DateHistogramGroupConfig(String field, DateHistogramInterval interval) {
        this(field, interval, null, null);
    }

    public DateHistogramGroupConfig(String field, DateHistogramInterval interval, @Nullable DateHistogramInterval delay, @Nullable String timeZone) {
        if (field == null || field.isEmpty()) {
            throw new IllegalArgumentException("Field must be a non-null, non-empty string");
        }
        if (interval == null) {
            throw new IllegalArgumentException("Interval must be non-null");
        }
        this.interval = interval;
        this.field = field;
        this.delay = delay;
        this.timeZone = timeZone != null && !timeZone.isEmpty() ? timeZone : DEFAULT_TIMEZONE;
        DateHistogramGroupConfig.createRounding(this.interval.toString(), this.timeZone);
        if (delay != null) {
            TimeValue.parseTimeValue((String)this.delay.toString(), (String)DELAY);
        }
    }

    DateHistogramGroupConfig(StreamInput in) throws IOException {
        this.interval = new DateHistogramInterval(in);
        this.field = in.readString();
        this.delay = (DateHistogramInterval)in.readOptionalWriteable(DateHistogramInterval::new);
        this.timeZone = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.interval.writeTo(out);
        out.writeString(this.field);
        out.writeOptionalWriteable((Writeable)this.delay);
        out.writeString(this.timeZone);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INTERVAL, this.interval.toString());
        builder.field(FIELD, this.field);
        if (this.delay != null) {
            builder.field(DELAY, this.delay.toString());
        }
        builder.field(TIME_ZONE, this.timeZone);
        return builder.endObject();
    }

    public String getField() {
        return this.field;
    }

    public DateHistogramInterval getInterval() {
        return this.interval;
    }

    public DateHistogramInterval getDelay() {
        return this.delay;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public Rounding createRounding() {
        return DateHistogramGroupConfig.createRounding(this.interval.toString(), this.timeZone);
    }

    public void validateMappings(Map<String, Map<String, FieldCapabilities>> fieldCapsResponse, ActionRequestValidationException validationException) {
        Map<String, FieldCapabilities> fieldCaps = fieldCapsResponse.get(this.field);
        if (fieldCaps != null && !fieldCaps.isEmpty()) {
            if (fieldCaps.containsKey("date") && fieldCaps.size() == 1) {
                if (fieldCaps.get("date").isAggregatable()) {
                    return;
                }
                validationException.addValidationError("The field [" + this.field + "] must be aggregatable across all indices, but is not.");
            } else {
                validationException.addValidationError("The field referenced by a date_histo group must be a [date] type across all indices in the index pattern.  Found: " + fieldCaps.keySet().toString() + " for field [" + this.field + "]");
            }
        }
        validationException.addValidationError("Could not find a [date] field with name [" + this.field + "] in any of the indices matching the index pattern.");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DateHistogramGroupConfig that = (DateHistogramGroupConfig)other;
        return Objects.equals(this.interval, that.interval) && Objects.equals(this.field, that.field) && Objects.equals(this.delay, that.delay) && Objects.equals(this.timeZone, that.timeZone);
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.field, this.delay, this.timeZone);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    public static DateHistogramGroupConfig fromXContent(XContentParser parser) throws IOException {
        return (DateHistogramGroupConfig)PARSER.parse(parser, null);
    }

    private static Rounding createRounding(String expr, String timeZone) {
        DateTimeUnit timeUnit = (DateTimeUnit)DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(expr);
        Rounding.Builder rounding = timeUnit != null ? new Rounding.Builder(timeUnit) : new Rounding.Builder(TimeValue.parseTimeValue((String)expr, (String)"createRounding"));
        rounding.timeZone(DateHistogramGroupConfig.toDateTimeZone(timeZone));
        return rounding.build();
    }

    private static DateTimeZone toDateTimeZone(String timezone) {
        try {
            return DateTimeZone.forOffsetHours((int)Integer.parseInt(timezone));
        }
        catch (NumberFormatException e) {
            return DateTimeZone.forID((String)timezone);
        }
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(FIELD, new String[0]));
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> new DateHistogramInterval(p.text()), new ParseField(INTERVAL, new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> new DateHistogramInterval(p.text()), new ParseField(DELAY, new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(TIME_ZONE, new String[0]));
    }
}

