/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.util.LazyInitializable;

public abstract class NotificationService<Account>
extends AbstractComponent {
    private final String type;
    private final Settings bootSettings;
    private final List<Setting<?>> pluginSecureSettings;
    private volatile Map<String, LazyInitializable<Account, SettingsException>> accounts;
    private volatile LazyInitializable<Account, SettingsException> defaultAccount;
    private volatile Settings cachedClusterSettings;
    private volatile SecureSettings cachedSecureSettings;

    public NotificationService(String type, Settings settings, ClusterSettings clusterSettings, List<Setting<?>> pluginDynamicSettings, List<Setting<?>> pluginSecureSettings) {
        this(type, settings, pluginSecureSettings);
        clusterSettings.addSettingsUpdateConsumer(this::clusterSettingsConsumer, pluginDynamicSettings);
    }

    NotificationService(String type, Settings settings, List<Setting<?>> pluginSecureSettings) {
        this.type = type;
        this.bootSettings = settings;
        this.pluginSecureSettings = pluginSecureSettings;
    }

    protected synchronized void clusterSettingsConsumer(Settings settings) {
        this.cachedClusterSettings = settings;
        this.buildAccounts();
    }

    public synchronized void reload(Settings settings) {
        try {
            this.cachedSecureSettings = NotificationService.extractSecureSettings(settings, this.pluginSecureSettings);
        }
        catch (GeneralSecurityException e) {
            this.logger.error("Keystore exception while reloading watcher notification service", (Throwable)e);
            return;
        }
        this.buildAccounts();
    }

    private void buildAccounts() {
        Settings.Builder completeSettingsBuilder = Settings.builder().put(this.bootSettings, false);
        if (this.cachedClusterSettings != null) {
            completeSettingsBuilder.put(this.cachedClusterSettings, false);
        }
        if (this.cachedSecureSettings != null) {
            completeSettingsBuilder.setSecureSettings(this.cachedSecureSettings);
        }
        Settings completeSettings = completeSettingsBuilder.build();
        Set<String> accountNames = this.getAccountNames(completeSettings);
        this.accounts = this.createAccounts(completeSettings, accountNames, this::createAccount);
        this.defaultAccount = this.findDefaultAccountOrNull(completeSettings, this.accounts);
    }

    protected abstract Account createAccount(String var1, Settings var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Account getAccount(String name) {
        LazyInitializable<Account, SettingsException> defaultAccount;
        Map<String, LazyInitializable<Account, SettingsException>> accounts;
        NotificationService notificationService = this;
        synchronized (notificationService) {
            accounts = this.accounts;
            defaultAccount = this.defaultAccount;
        }
        LazyInitializable<Account, SettingsException> theAccount = accounts.getOrDefault(name, defaultAccount);
        if (theAccount == null && name == null) {
            throw new IllegalArgumentException("no accounts of type [" + this.type + "] configured. Please set up an account using the [xpack.notification." + this.type + "] settings");
        }
        if (theAccount == null) {
            throw new IllegalArgumentException("no account found for name: [" + name + "]");
        }
        return (Account)theAccount.getOrCompute();
    }

    private String getNotificationsAccountPrefix() {
        return "xpack.notification." + this.type + ".account.";
    }

    private Set<String> getAccountNames(Settings settings) {
        return settings.getByPrefix(this.getNotificationsAccountPrefix()).names();
    }

    @Nullable
    private String getDefaultAccountName(Settings settings) {
        return settings.get("xpack.notification." + this.type + ".default_account");
    }

    private Map<String, LazyInitializable<Account, SettingsException>> createAccounts(Settings settings, Set<String> accountNames, BiFunction<String, Settings, Account> accountFactory) {
        HashMap<String, LazyInitializable> accounts = new HashMap<String, LazyInitializable>();
        for (String accountName : accountNames) {
            Settings accountSettings = settings.getAsSettings(this.getNotificationsAccountPrefix() + accountName);
            accounts.put(accountName, new LazyInitializable(() -> accountFactory.apply(accountName, accountSettings)));
        }
        return Collections.unmodifiableMap(accounts);
    }

    @Nullable
    private LazyInitializable<Account, SettingsException> findDefaultAccountOrNull(Settings settings, Map<String, LazyInitializable<Account, SettingsException>> accounts) {
        String defaultAccountName = this.getDefaultAccountName(settings);
        if (defaultAccountName == null) {
            if (accounts.isEmpty()) {
                return null;
            }
            return accounts.values().iterator().next();
        }
        LazyInitializable<Account, SettingsException> account = accounts.get(defaultAccountName);
        if (account == null) {
            throw new SettingsException("could not find default account [" + defaultAccountName + "]");
        }
        return account;
    }

    private static SecureSettings extractSecureSettings(Settings source, List<Setting<?>> securePluginSettings) throws GeneralSecurityException {
        SecureSettings sourceSecureSettings = Settings.builder().put(source, true).getSecureSettings();
        final HashMap<String, SecureString> cache = new HashMap<String, SecureString>();
        if (sourceSecureSettings != null && securePluginSettings != null) {
            for (String settingKey : sourceSecureSettings.getSettingNames()) {
                for (Setting<?> secureSetting : securePluginSettings) {
                    if (!secureSetting.match(settingKey)) continue;
                    cache.put(settingKey, sourceSecureSettings.getString(settingKey));
                }
            }
        }
        return new SecureSettings(){

            public boolean isLoaded() {
                return true;
            }

            public SecureString getString(String setting) throws GeneralSecurityException {
                return (SecureString)cache.get(setting);
            }

            public Set<String> getSettingNames() {
                return cache.keySet();
            }

            public InputStream getFile(String setting) throws GeneralSecurityException {
                throw new IllegalStateException("A NotificationService setting cannot be File.");
            }

            public void close() throws IOException {
            }
        };
    }
}

