/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.elasticsearch.Version;
import org.elasticsearch.analysis.common.SnowballAnalyzer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.Analysis;

public class SnowballAnalyzerProvider
extends AbstractIndexAnalyzerProvider<SnowballAnalyzer> {
    private static final Map<String, CharArraySet> DEFAULT_LANGUAGE_STOPWORDS;
    private final SnowballAnalyzer analyzer;

    SnowballAnalyzerProvider(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        String language = settings.get("language", settings.get("name", "English"));
        CharArraySet defaultStopwords = DEFAULT_LANGUAGE_STOPWORDS.getOrDefault(language, CharArraySet.EMPTY_SET);
        CharArraySet stopWords = Analysis.parseStopWords((Environment)env, (Version)indexSettings.getIndexVersionCreated(), (Settings)settings, (CharArraySet)defaultStopwords);
        this.analyzer = new SnowballAnalyzer(language, stopWords);
        this.analyzer.setVersion(this.version);
    }

    public SnowballAnalyzer get() {
        return this.analyzer;
    }

    static {
        HashMap<String, CharArraySet> defaultLanguageStopwords = new HashMap<String, CharArraySet>();
        defaultLanguageStopwords.put("English", StopAnalyzer.ENGLISH_STOP_WORDS_SET);
        defaultLanguageStopwords.put("Dutch", DutchAnalyzer.getDefaultStopSet());
        defaultLanguageStopwords.put("German", GermanAnalyzer.getDefaultStopSet());
        defaultLanguageStopwords.put("German2", GermanAnalyzer.getDefaultStopSet());
        defaultLanguageStopwords.put("French", FrenchAnalyzer.getDefaultStopSet());
        DEFAULT_LANGUAGE_STOPWORDS = Collections.unmodifiableMap(defaultLanguageStopwords);
    }
}

