/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant.heuristics;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.SignificantTermsHeuristicScoreScript;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptHeuristic
extends SignificanceHeuristic {
    public static final String NAME = "script_heuristic";
    private final Script script;

    public ScriptHeuristic(Script script) {
        this.script = script;
    }

    public ScriptHeuristic(StreamInput in) throws IOException {
        this(new Script(in));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.script.writeTo(out);
    }

    @Override
    public SignificanceHeuristic rewrite(InternalAggregation.ReduceContext context) {
        SignificantTermsHeuristicScoreScript.Factory factory = context.scriptService().compile(this.script, SignificantTermsHeuristicScoreScript.CONTEXT);
        return new ExecutableScriptHeuristic(this.script, factory.newInstance());
    }

    @Override
    public SignificanceHeuristic rewrite(SearchContext context) {
        QueryShardContext shardContext = context.getQueryShardContext();
        SignificantTermsHeuristicScoreScript.Factory compiledScript = shardContext.getScriptService().compile(this.script, SignificantTermsHeuristicScoreScript.CONTEXT);
        return new ExecutableScriptHeuristic(this.script, compiledScript.newInstance());
    }

    @Override
    public double getScore(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize) {
        throw new UnsupportedOperationException("This scoring heuristic must have 'rewrite' called on it to provide a version ready for use");
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
        builder.startObject(NAME);
        builder.field(Script.SCRIPT_PARSE_FIELD.getPreferredName());
        this.script.toXContent(builder, builderParams);
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.script);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScriptHeuristic other = (ScriptHeuristic)obj;
        return Objects.equals(this.script, other.script);
    }

    public static SignificanceHeuristic parse(XContentParser parser) throws IOException, QueryShardException {
        XContentParser.Token token;
        String heuristicName = parser.currentName();
        Script script = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token.equals((Object)XContentParser.Token.FIELD_NAME)) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (Script.SCRIPT_PARSE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                script = Script.parse(parser);
                continue;
            }
            throw new ElasticsearchParseException("failed to parse [{}] significance heuristic. unknown object [{}]", heuristicName, currentFieldName);
        }
        if (script == null) {
            throw new ElasticsearchParseException("failed to parse [{}] significance heuristic. no script found in script_heuristic", heuristicName);
        }
        return new ScriptHeuristic(script);
    }

    public final class LongAccessor
    extends Number {
        public long value;

        @Override
        public int intValue() {
            return (int)this.value;
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public float floatValue() {
            return this.value;
        }

        @Override
        public double doubleValue() {
            return this.value;
        }

        public String toString() {
            return Long.toString(this.value);
        }
    }

    static class ExecutableScriptHeuristic
    extends ScriptHeuristic {
        private final LongAccessor subsetSizeHolder;
        private final LongAccessor supersetSizeHolder;
        private final LongAccessor subsetDfHolder;
        private final LongAccessor supersetDfHolder;
        private final SignificantTermsHeuristicScoreScript executableScript;
        private final Map<String, Object> params = new HashMap<String, Object>();

        ExecutableScriptHeuristic(Script script, SignificantTermsHeuristicScoreScript executableScript) {
            super(script);
            this.subsetSizeHolder = new LongAccessor();
            this.supersetSizeHolder = new LongAccessor();
            this.subsetDfHolder = new LongAccessor();
            this.supersetDfHolder = new LongAccessor();
            this.executableScript = executableScript;
            this.params.putAll(script.getParams());
            this.params.put("_subset_freq", this.subsetDfHolder);
            this.params.put("_subset_size", this.subsetSizeHolder);
            this.params.put("_superset_freq", this.supersetDfHolder);
            this.params.put("_superset_size", this.supersetSizeHolder);
        }

        @Override
        public double getScore(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize) {
            this.subsetSizeHolder.value = subsetSize;
            this.supersetSizeHolder.value = supersetSize;
            this.subsetDfHolder.value = subsetFreq;
            this.supersetDfHolder.value = supersetFreq;
            return this.executableScript.execute(this.params);
        }
    }
}

