/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.bridge;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.bridge.Bridge;
import org.jitsi.jicofo.bridge.BridgeSelectionStrategy;
import org.jitsi.jicofo.bridge.ConferenceBridgeProperties;
import org.jitsi.jicofo.bridge.ParticipantProperties;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jitsi/jicofo/bridge/SingleBridgeSelectionStrategy;", "Lorg/jitsi/jicofo/bridge/BridgeSelectionStrategy;", "()V", "doSelect", "Lorg/jitsi/jicofo/bridge/Bridge;", "bridges", "", "conferenceBridges", "", "Lorg/jitsi/jicofo/bridge/ConferenceBridgeProperties;", "participantProperties", "Lorg/jitsi/jicofo/bridge/ParticipantProperties;", "Companion", "jicofo-selector"})
public final class SingleBridgeSelectionStrategy
extends BridgeSelectionStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger = (Logger)new LoggerImpl(SingleBridgeSelectionStrategy.class.getName());

    @Override
    @Nullable
    public Bridge doSelect(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties) {
        Intrinsics.checkNotNullParameter(bridges, (String)"bridges");
        Intrinsics.checkNotNullParameter(conferenceBridges, (String)"conferenceBridges");
        Intrinsics.checkNotNullParameter((Object)participantProperties, (String)"participantProperties");
        if (conferenceBridges.isEmpty()) {
            Bridge bridge2 = this.leastLoadedInRegion(bridges, MapsKt.emptyMap(), participantProperties, participantProperties.getRegion());
            if (bridge2 == null) {
                bridge2 = this.leastLoaded(bridges, MapsKt.emptyMap(), participantProperties);
            }
            return bridge2;
        }
        if (conferenceBridges.size() != 1) {
            logger.error((Object)("Unexpected number of bridges with SingleBridgeSelectionStrategy: " + conferenceBridges.size()));
            return null;
        }
        Bridge bridge3 = (Bridge)CollectionsKt.first((Iterable)conferenceBridges.keySet());
        if (!bridge3.isOperational()) {
            logger.error((Object)("The conference already has a bridge, but it is not operational: bridge=" + bridge3));
            return null;
        }
        return bridge3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jitsi/jicofo/bridge/SingleBridgeSelectionStrategy$Companion;", "", "()V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "jicofo-selector"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

