/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.xml;

import java.io.Reader;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smack.xml.XmlPullParserFactory;

public class SmackXmlParser {
    private static final ServiceLoader<XmlPullParserFactory> xmlPullParserFactoryServiceLoader = ServiceLoader.load(XmlPullParserFactory.class);
    private static XmlPullParserFactory xmlPullParserFactory;

    public static XmlPullParserFactory getXmlPullParserFactory() {
        XmlPullParserFactory xmlPullParserFactory = SmackXmlParser.xmlPullParserFactory;
        if (xmlPullParserFactory != null) {
            return xmlPullParserFactory;
        }
        Iterator<XmlPullParserFactory> iterator = xmlPullParserFactoryServiceLoader.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException("No XmlPullParserFactory registered with Service Provider Interface (SPI). Is smack-xmlparser-xpp3 or smack-xmlparser-stax in classpath?");
        }
        return iterator.next();
    }

    public static void setXmlPullParserFactory(XmlPullParserFactory xmlPullParserFactory) {
        SmackXmlParser.xmlPullParserFactory = xmlPullParserFactory;
    }

    public static XmlPullParser newXmlParser(Reader reader) throws XmlPullParserException {
        XmlPullParserFactory xmlPullParserFactory = SmackXmlParser.getXmlPullParserFactory();
        return xmlPullParserFactory.newXmlPullParser(reader);
    }
}

