/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamRequest;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamSession;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.si.packet.StreamInitiation;
import org.jxmpp.jid.Jid;

public class Socks5TransferNegotiator
extends StreamNegotiator {
    private final Socks5BytestreamManager manager;

    Socks5TransferNegotiator(XMPPConnection connection) {
        super(connection);
        this.manager = Socks5BytestreamManager.getBytestreamManager(connection);
    }

    @Override
    public OutputStream createOutgoingStream(String streamID, Jid initiator, Jid target) throws SmackException, XMPPException {
        try {
            return this.manager.establishSession(target, streamID).getOutputStream();
        }
        catch (IOException e) {
            throw new SmackException.SmackWrappedException("error establishing SOCKS5 Bytestream", (Exception)e);
        }
        catch (InterruptedException e) {
            throw new SmackException.SmackWrappedException("error establishing SOCKS5 Bytestream", (Exception)e);
        }
    }

    @Override
    public InputStream createIncomingStream(StreamInitiation initiation) throws XMPPException.XMPPErrorException, InterruptedException, SmackException {
        this.manager.ignoreBytestreamRequestOnce(initiation.getSessionID());
        IQ streamInitiation = this.initiateIncomingStream(this.connection(), initiation);
        return this.negotiateIncomingStream((Stanza)streamInitiation);
    }

    @Override
    public void newStreamInitiation(Jid from, String streamID) {
        this.manager.ignoreBytestreamRequestOnce(streamID);
    }

    @Override
    public String getNamespace() {
        return "http://jabber.org/protocol/bytestreams";
    }

    @Override
    InputStream negotiateIncomingStream(Stanza streamInitiation) throws InterruptedException, SmackException, XMPPException.XMPPErrorException {
        ByteStreamRequest request = new ByteStreamRequest(this.manager, (Bytestream)streamInitiation);
        Socks5BytestreamSession session = request.accept();
        try {
            PushbackInputStream stream = new PushbackInputStream(session.getInputStream());
            int firstByte = stream.read();
            stream.unread(firstByte);
            return stream;
        }
        catch (IOException e) {
            throw new SmackException.SmackWrappedException("Error establishing input stream", (Exception)e);
        }
    }

    private static final class ByteStreamRequest
    extends Socks5BytestreamRequest {
        private ByteStreamRequest(Socks5BytestreamManager manager, Bytestream byteStreamRequest) {
            super(manager, byteStreamRequest);
        }
    }
}

