/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.jicofo.ConferenceStore;
import org.jitsi.jicofo.MediaType;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.conference.MuteResult;
import org.jitsi.jicofo.xmpp.IqProcessingResult;
import org.jitsi.jicofo.xmpp.MuteRequest;
import org.jitsi.jicofo.xmpp.UtilKt;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.extensions.jitsimeet.AbstractMuteIq;
import org.jitsi.xmpp.extensions.jitsimeet.MuteDesktopIq;
import org.jitsi.xmpp.extensions.jitsimeet.MuteIq;
import org.jitsi.xmpp.extensions.jitsimeet.MuteVideoIq;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"logger", "Lorg/jitsi/utils/logging2/LoggerImpl;", "createMuteIq", "Lorg/jitsi/xmpp/extensions/jitsimeet/AbstractMuteIq;", "mediaType", "Lorg/jitsi/jicofo/MediaType;", "handleRequest", "Lorg/jitsi/jicofo/xmpp/IqProcessingResult;", "request", "Lorg/jitsi/jicofo/xmpp/MuteRequest;", "jicofo"})
public final class MuteIqHandlerKt {
    @NotNull
    private static final LoggerImpl logger = new LoggerImpl("org.jitsi.jicofo.xmpp.MuteIqHandler");

    private static final IqProcessingResult handleRequest(MuteRequest request) {
        Jid jidToMute = request.getJidToMute();
        Boolean doMute = request.getDoMute();
        MediaType mediaType = request.getMediaType();
        if (doMute == null || jidToMute == null) {
            logger.warn((Object)("Mute request missing required fields: " + request.getIq().toXML()));
            return (IqProcessingResult)new IqProcessingResult.RejectedWithError(request.getIq(), StanzaError.Condition.bad_request);
        }
        ConferenceStore conferenceStore = request.getConferenceStore();
        EntityBareJid entityBareJid = request.getIq().getFrom().asEntityBareJidIfPossible();
        Intrinsics.checkNotNullExpressionValue((Object)entityBareJid, (String)"asEntityBareJidIfPossible(...)");
        JitsiMeetConference jitsiMeetConference = conferenceStore.getConference(entityBareJid);
        if (jitsiMeetConference == null) {
            IqProcessingResult.RejectedWithError rejectedWithError;
            IqProcessingResult.RejectedWithError it = rejectedWithError = new IqProcessingResult.RejectedWithError(request.getIq(), StanzaError.Condition.item_not_found);
            boolean bl = false;
            logger.warn((Object)("Mute request for unknown conference: " + request.getIq().toXML()));
            return (IqProcessingResult)rejectedWithError;
        }
        JitsiMeetConference conference = jitsiMeetConference;
        TaskPools.Companion.getIoPool().execute(() -> MuteIqHandlerKt.handleRequest$lambda$2(conference, request, jidToMute, doMute, mediaType));
        return (IqProcessingResult)new IqProcessingResult.AcceptedWithNoResponse();
    }

    @NotNull
    public static final AbstractMuteIq createMuteIq(@NotNull MediaType mediaType) {
        AbstractMuteIq abstractMuteIq;
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
        switch (WhenMappings.$EnumSwitchMapping$1[mediaType.ordinal()]) {
            case 1: {
                abstractMuteIq = (AbstractMuteIq)new MuteIq();
                break;
            }
            case 2: {
                abstractMuteIq = (AbstractMuteIq)new MuteVideoIq();
                break;
            }
            case 3: {
                abstractMuteIq = (AbstractMuteIq)new MuteDesktopIq();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported media type: " + mediaType);
            }
        }
        return abstractMuteIq;
    }

    /*
     * WARNING - void declaration
     */
    private static final void handleRequest$lambda$2(JitsiMeetConference $conference, MuteRequest $request, Jid $jidToMute, Boolean $doMute, MediaType $mediaType) {
        Intrinsics.checkNotNullParameter((Object)$conference, (String)"$conference");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)$mediaType, (String)"$mediaType");
        try {
            switch (WhenMappings.$EnumSwitchMapping$0[$conference.handleMuteRequest($request.getIq().getFrom(), $jidToMute, $doMute, $mediaType).ordinal()]) {
                case 1: {
                    XMPPConnection xMPPConnection = (XMPPConnection)$request.getConnection();
                    IQ iQ = IQ.createResultIQ((IQ)$request.getIq());
                    Intrinsics.checkNotNullExpressionValue((Object)iQ, (String)"createResultIQ(...)");
                    UtilKt.tryToSendStanza((XMPPConnection)xMPPConnection, (Stanza)((Stanza)iQ));
                    if (!Intrinsics.areEqual((Object)$request.getIq().getFrom(), (Object)$request.getJidToMute())) {
                        void $this$handleRequest_u24lambda_u242_u24lambda_u241;
                        AbstractMuteIq abstractMuteIq;
                        AbstractMuteIq abstractMuteIq2 = abstractMuteIq = MuteIqHandlerKt.createMuteIq($mediaType);
                        XMPPConnection xMPPConnection2 = (XMPPConnection)$request.getConnection();
                        boolean bl = false;
                        $this$handleRequest_u24lambda_u242_u24lambda_u241.setActor($request.getIq().getFrom());
                        $this$handleRequest_u24lambda_u242_u24lambda_u241.setType(IQ.Type.set);
                        $this$handleRequest_u24lambda_u242_u24lambda_u241.setTo($request.getJidToMute());
                        $this$handleRequest_u24lambda_u242_u24lambda_u241.setMute($request.getDoMute());
                        UtilKt.tryToSendStanza((XMPPConnection)xMPPConnection2, (Stanza)((Stanza)abstractMuteIq));
                    }
                    break;
                }
                case 2: {
                    XMPPConnection xMPPConnection = (XMPPConnection)$request.getConnection();
                    ErrorIQ errorIQ = IQ.createErrorResponse((IQ)$request.getIq(), (StanzaError)StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.not_allowed).build());
                    Intrinsics.checkNotNullExpressionValue((Object)errorIQ, (String)"createErrorResponse(...)");
                    UtilKt.tryToSendStanza((XMPPConnection)xMPPConnection, (Stanza)((Stanza)errorIQ));
                    break;
                }
                case 3: {
                    XMPPConnection xMPPConnection = (XMPPConnection)$request.getConnection();
                    ErrorIQ errorIQ = IQ.createErrorResponse((IQ)$request.getIq(), (StanzaError)StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.internal_server_error).build());
                    Intrinsics.checkNotNullExpressionValue((Object)errorIQ, (String)"createErrorResponse(...)");
                    UtilKt.tryToSendStanza((XMPPConnection)xMPPConnection, (Stanza)((Stanza)errorIQ));
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to handle mute request: " + $request.getIq().toXML()), (Throwable)e);
            XMPPConnection xMPPConnection = (XMPPConnection)$request.getConnection();
            ErrorIQ errorIQ = IQ.createErrorResponse((IQ)$request.getIq(), (StanzaError.Condition)StanzaError.Condition.internal_server_error);
            Intrinsics.checkNotNullExpressionValue((Object)errorIQ, (String)"createErrorResponse(...)");
            UtilKt.tryToSendStanza((XMPPConnection)xMPPConnection, (Stanza)((Stanza)errorIQ));
        }
    }

    public static final /* synthetic */ IqProcessingResult access$handleRequest(MuteRequest request) {
        return MuteIqHandlerKt.handleRequest(request);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MuteResult.values().length];
            try {
                nArray[MuteResult.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MuteResult.NOT_ALLOWED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MuteResult.ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MediaType.values().length];
            try {
                nArray[MediaType.AUDIO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaType.VIDEO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MediaType.DESKTOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

