/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.commons;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.wiztools.commons.ArrayUtil;
import org.wiztools.commons.Characters;

public class Base58Util {
    private static final Map<Character, Long> MAP_BASE58;

    public static String encode(long value) {
        long val = value;
        if (val < Long.valueOf(Characters.BASE58.length)) {
            return String.valueOf(Characters.BASE58[(int)val]);
        }
        LinkedList<Long> reminderList = new LinkedList<Long>();
        do {
            long reminder = val % (long)Characters.BASE58.length;
            reminderList.addFirst(reminder);
        } while ((val /= (long)Characters.BASE58.length) >= (long)Characters.BASE58.length);
        reminderList.addFirst(val);
        StringBuilder sb = new StringBuilder();
        Iterator iterator = reminderList.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            sb.append(Characters.BASE58[(int)l]);
        }
        return sb.toString();
    }

    public static long decode(String value) {
        String val = value.trim();
        char[] chars = val.toCharArray();
        ArrayUtil.reverse(chars);
        long result = 0L;
        long mul = 1L;
        for (int i = 0; i < chars.length; ++i) {
            if (MAP_BASE58.get(Character.valueOf(chars[i])) == null) {
                throw new IllegalArgumentException("Invalid character encountered: " + chars[i]);
            }
            long v = MAP_BASE58.get(Character.valueOf(chars[i]));
            result += v * mul;
            mul *= (long)Characters.BASE58.length;
        }
        return result;
    }

    static {
        HashMap<Character, Long> base54 = new HashMap<Character, Long>();
        for (long i = 0L; i < (long)Characters.BASE58.length; ++i) {
            base54.put(Character.valueOf(Characters.BASE58[(int)i]), i);
        }
        MAP_BASE58 = Collections.unmodifiableMap(base54);
    }
}

