/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd;

import com.thaiopensource.relaxng.output.OutputDirectory;
import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.relaxng.output.common.XmlWriter;
import com.thaiopensource.relaxng.output.xsd.AbstractElementTypeSelector;
import com.thaiopensource.relaxng.output.xsd.ComplexTypeComplexContentExtension;
import com.thaiopensource.relaxng.output.xsd.ComplexTypeSelector;
import com.thaiopensource.relaxng.output.xsd.ComplexTypeSimpleContentExtension;
import com.thaiopensource.relaxng.output.xsd.Guide;
import com.thaiopensource.relaxng.output.xsd.NamespaceManager;
import com.thaiopensource.relaxng.output.xsd.PrefixManager;
import com.thaiopensource.relaxng.output.xsd.basic.AbstractAttributeUseVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.AbstractSchemaVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.Annotated;
import com.thaiopensource.relaxng.output.xsd.basic.Annotation;
import com.thaiopensource.relaxng.output.xsd.basic.Attribute;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroup;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroupDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroupRef;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeUse;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeUseVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.Comment;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexType;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeComplexContent;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeNotAllowedContent;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeSimpleContent;
import com.thaiopensource.relaxng.output.xsd.basic.ComplexTypeVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.Element;
import com.thaiopensource.relaxng.output.xsd.basic.Facet;
import com.thaiopensource.relaxng.output.xsd.basic.GroupDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.GroupRef;
import com.thaiopensource.relaxng.output.xsd.basic.Occurs;
import com.thaiopensource.relaxng.output.xsd.basic.OptionalAttribute;
import com.thaiopensource.relaxng.output.xsd.basic.Particle;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleAll;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleChoice;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleRepeat;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleSequence;
import com.thaiopensource.relaxng.output.xsd.basic.ParticleVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.RootDeclaration;
import com.thaiopensource.relaxng.output.xsd.basic.Schema;
import com.thaiopensource.relaxng.output.xsd.basic.SchemaVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.SchemaWalker;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleType;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeList;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeRef;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeRestriction;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeUnion;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.Structure;
import com.thaiopensource.relaxng.output.xsd.basic.StructureVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.Wildcard;
import com.thaiopensource.relaxng.output.xsd.basic.WildcardAttribute;
import com.thaiopensource.relaxng.output.xsd.basic.WildcardElement;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.util.Name;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class BasicOutput {
    private final XmlWriter xw;
    private final Schema schema;
    private final SimpleTypeOutput simpleTypeOutput = new SimpleTypeOutput();
    private final ComplexTypeOutput complexTypeOutput = new ComplexTypeOutput();
    private final AttributeUseOutput attributeUseOutput = new AttributeUseOutput();
    private final AttributeUseVisitor<VoidValue> attributeWildcardOutput = new AttributeWildcardOutput();
    private final ParticleOutput particleOutput = new ParticleOutput();
    private final ParticleVisitor<VoidValue> globalElementOutput = new GlobalElementOutput();
    private final GlobalAttributeOutput globalAttributeOutput = new GlobalAttributeOutput();
    private final SchemaVisitor schemaOutput = new SchemaOutput();
    private final StructureVisitor<VoidValue> movedStructureOutput = new MovedStructureOutput();
    private final SimpleTypeVisitor<String> simpleTypeNamer = new SimpleTypeNamer();
    private final NamespaceManager nsm;
    private final PrefixManager pm;
    private final String targetNamespace;
    private final OutputDirectory od;
    private final String sourceUri;
    private final ComplexTypeSelector complexTypeSelector;
    private final AbstractElementTypeSelector abstractElementTypeSelector;
    private final Set<Name> globalElementsDefined;
    private final Set<Name> globalAttributesDefined;
    private final String xsPrefix;
    private final Options options;
    private static final int NORMAL_CONTEXT = 0;
    private static final int COMPLEX_TYPE_CONTEXT = 1;
    private static final int NAMED_GROUP_CONTEXT = 2;

    static void output(Schema schema, Guide guide, PrefixManager prefixManager, OutputDirectory outputDirectory, Options options, ErrorReporter errorReporter) throws IOException {
        NamespaceManager namespaceManager = new NamespaceManager(schema, guide, prefixManager);
        ComplexTypeSelector complexTypeSelector = new ComplexTypeSelector(schema);
        AbstractElementTypeSelector abstractElementTypeSelector = new AbstractElementTypeSelector(schema, namespaceManager, complexTypeSelector);
        HashSet<Name> hashSet = new HashSet<Name>();
        HashSet<Name> hashSet2 = new HashSet<Name>();
        try {
            for (Schema schema2 : schema.getSubSchemas()) {
                new BasicOutput(schema2, errorReporter, outputDirectory, options, namespaceManager, prefixManager, complexTypeSelector, abstractElementTypeSelector, hashSet, hashSet2).output();
            }
        }
        catch (XmlWriter.WrappedException wrappedException) {
            throw wrappedException.getIOException();
        }
    }

    private BasicOutput(Schema schema, ErrorReporter errorReporter, OutputDirectory outputDirectory, Options options, NamespaceManager namespaceManager, PrefixManager prefixManager, ComplexTypeSelector complexTypeSelector, AbstractElementTypeSelector abstractElementTypeSelector, Set<Name> set, Set<Name> set2) throws IOException {
        this.schema = schema;
        this.nsm = namespaceManager;
        this.pm = prefixManager;
        this.complexTypeSelector = complexTypeSelector;
        this.abstractElementTypeSelector = abstractElementTypeSelector;
        this.globalElementsDefined = set;
        this.globalAttributesDefined = set2;
        this.sourceUri = schema.getUri();
        this.od = outputDirectory;
        this.targetNamespace = namespaceManager.getTargetNamespace(schema.getUri());
        this.xsPrefix = prefixManager.getPrefix("http://www.w3.org/2001/XMLSchema");
        this.options = options;
        OutputDirectory.Stream stream = outputDirectory.open(schema.getUri(), schema.getEncoding());
        this.xw = new XmlWriter(stream.getWriter(), stream.getEncoding(), stream.getCharRepertoire(), outputDirectory.getLineSeparator(), outputDirectory.getIndent(), new String[0]);
    }

    private String topLevelPrefix(String string) {
        if (!this.nsm.isTargetNamespace(string)) {
            return null;
        }
        if (string.equals("")) {
            return "";
        }
        return this.pm.getPrefix(string);
    }

    private void output() {
        this.outputCommentList(this.schema.getLeadingComments());
        this.xw.startElement(this.xs("schema"));
        this.xw.attribute("xmlns:" + this.xsPrefix, "http://www.w3.org/2001/XMLSchema");
        this.xw.attribute("elementFormDefault", "qualified");
        if (!this.targetNamespace.equals("")) {
            this.xw.attribute("targetNamespace", this.targetNamespace);
        }
        for (String object22 : this.nsm.getTargetNamespaces()) {
            String string;
            if (object22.equals("") || (string = this.pm.getPrefix(object22)).equals("xml")) continue;
            this.xw.attribute("xmlns:" + this.pm.getPrefix(object22), object22);
        }
        for (String string : this.nsm.effectiveIncludes(this.schema.getUri())) {
            this.outputInclude(string);
        }
        Vector vector = new Vector();
        vector.addAll(this.nsm.getTargetNamespaces());
        Collections.sort(vector);
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals(this.targetNamespace)) continue;
            this.outputImport(string, this.nsm.getRootSchema(string));
        }
        this.schema.accept(this.schemaOutput);
        if (this.nsm.getRootSchema(this.targetNamespace).equals(this.sourceUri)) {
            for (Structure structure : this.nsm.getMovedStructures(this.targetNamespace)) {
                structure.accept(this.movedStructureOutput);
            }
            this.outputOther();
        }
        this.xw.endElement();
        this.outputCommentList(this.schema.getTrailingComments());
        this.xw.close();
    }

    private String xs(String string) {
        return this.xsPrefix + ":" + string;
    }

    private boolean namespaceIsLocal(String string) {
        return string.equals(this.targetNamespace) || string.equals("");
    }

    private void outputAttributeUse(AttributeUse attributeUse) {
        attributeUse.accept(this.attributeUseOutput);
        attributeUse.accept(this.attributeWildcardOutput);
    }

    private void namespaceAttribute(Wildcard wildcard) {
        if (wildcard.isPositive()) {
            StringBuffer stringBuffer = new StringBuffer();
            Vector<String> vector = new Vector<String>(wildcard.getNamespaces());
            Collections.sort(vector);
            for (String string : vector) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(' ');
                }
                if (string.equals("")) {
                    stringBuffer.append("##local");
                    continue;
                }
                if (string.equals(this.targetNamespace)) {
                    stringBuffer.append("##targetNamespace");
                    continue;
                }
                stringBuffer.append(string);
            }
            this.xw.attribute("namespace", stringBuffer.toString());
        } else if (this.targetNamespace.equals(NamespaceManager.otherNamespace(wildcard))) {
            this.xw.attribute("namespace", "##other");
        }
    }

    private String qualifyRef(String string, String string2) {
        return this.qualifyName(this.nsm.getTargetNamespace(string), string2);
    }

    private String qualifyName(Name name) {
        return this.qualifyName(name.getNamespaceUri(), name.getLocalName());
    }

    private String qualifyName(String string, String string2) {
        if (string.equals("")) {
            return string2;
        }
        return this.pm.getPrefix(string) + ":" + string2;
    }

    private void outputOther() {
        String string = this.nsm.getOtherElementName(this.targetNamespace);
        if (string != null) {
            this.xw.startElement(this.xs("group"));
            this.xw.attribute("name", string);
            this.xw.startElement(this.xs("sequence"));
            this.xw.startElement(this.xs("any"));
            this.xw.attribute("namespace", "##other");
            this.xw.attribute("processContents", this.options.anyProcessContents);
            this.xw.endElement();
            this.xw.endElement();
            this.xw.endElement();
        }
        if ((string = this.nsm.getOtherAttributeName(this.targetNamespace)) != null) {
            this.xw.startElement(this.xs("attributeGroup"));
            this.xw.attribute("name", string);
            this.xw.startElement(this.xs("anyAttribute"));
            this.xw.attribute("namespace", "##other");
            this.xw.attribute("processContents", this.options.anyAttributeProcessContents);
            this.xw.endElement();
            this.xw.endElement();
        }
    }

    private void outputInclude(String string) {
        this.xw.startElement(this.xs("include"));
        this.xw.attribute("schemaLocation", this.od.reference(this.sourceUri, string));
        this.xw.endElement();
    }

    private void outputImport(String string, String string2) {
        this.xw.startElement(this.xs("import"));
        if (!string.equals("")) {
            this.xw.attribute("namespace", string);
        }
        this.xw.attribute("schemaLocation", this.od.reference(this.sourceUri, string2));
        this.xw.endElement();
    }

    private void outputComplexTypeComplexContent(ComplexTypeComplexContentExtension complexTypeComplexContentExtension, String string, Annotated annotated) {
        String string2 = complexTypeComplexContentExtension.getBase();
        if (string2 != null) {
            string2 = this.qualifyRef(this.schema.getGroup(string2).getParentSchema().getUri(), string2);
            if (string == null && complexTypeComplexContentExtension.getParticle() == null && !complexTypeComplexContentExtension.isMixed() && complexTypeComplexContentExtension.getAttributeUses().equals(AttributeGroup.EMPTY)) {
                this.xw.attribute("type", string2);
                if (annotated != null) {
                    this.outputAnnotation(annotated);
                }
                return;
            }
        }
        if (string == null && annotated != null) {
            this.outputAnnotation(annotated);
        }
        this.xw.startElement(this.xs("complexType"));
        if (string != null) {
            this.xw.attribute("name", string);
        }
        if (complexTypeComplexContentExtension.isMixed()) {
            this.xw.attribute("mixed", "true");
        }
        if (string != null && annotated != null) {
            this.outputAnnotation(annotated);
        }
        if (string2 != null) {
            this.xw.startElement(this.xs("complexContent"));
            this.xw.startElement(this.xs("extension"));
            this.xw.attribute("base", string2);
        }
        if (complexTypeComplexContentExtension.getParticle() != null) {
            this.particleOutput.context = 1;
            complexTypeComplexContentExtension.getParticle().accept(this.particleOutput);
        }
        this.outputAttributeUse(complexTypeComplexContentExtension.getAttributeUses());
        if (string2 != null) {
            this.xw.endElement();
            this.xw.endElement();
        }
        this.xw.endElement();
    }

    private void outputComplexTypeSimpleContent(ComplexTypeSimpleContentExtension complexTypeSimpleContentExtension, String string, Annotated annotated) {
        String string2 = complexTypeSimpleContentExtension.getBase();
        AttributeUse attributeUse = complexTypeSimpleContentExtension.getAttributeUses();
        if (string2 != null) {
            string2 = this.qualifyRef(this.schema.getSimpleType(string2).getParentSchema().getUri(), string2);
            if (string == null && attributeUse.equals(AttributeGroup.EMPTY)) {
                this.xw.attribute("type", string2);
                if (annotated != null) {
                    this.outputAnnotation(annotated);
                }
                return;
            }
        } else if (attributeUse.equals(AttributeGroup.EMPTY)) {
            this.simpleTypeOutput.outputWrap(complexTypeSimpleContentExtension.getSimpleType(), annotated);
            return;
        }
        if (string == null && annotated != null) {
            this.outputAnnotation(annotated);
        }
        this.xw.startElement(this.xs("complexType"));
        if (string != null) {
            this.xw.attribute("name", string);
        }
        if (string != null && annotated != null) {
            this.outputAnnotation(annotated);
        }
        this.xw.startElement(this.xs("simpleContent"));
        if (string2 == null) {
            string2 = complexTypeSimpleContentExtension.getSimpleType().accept(this.simpleTypeNamer);
        }
        if (string2 != null) {
            this.xw.startElement(this.xs("extension"));
            this.xw.attribute("base", string2);
        } else {
            this.xw.startElement(this.xs("restriction"));
            this.xw.attribute("base", this.xs("anyType"));
            this.simpleTypeOutput.outputWrap(complexTypeSimpleContentExtension.getSimpleType(), null);
        }
        this.outputAttributeUse(attributeUse);
        this.xw.endElement();
        this.xw.endElement();
        this.xw.endElement();
    }

    private void outputComplexType(Name name, ComplexType complexType, Annotated annotated) {
        Name name2 = this.nsm.getSubstitutionGroup(name);
        if (name2 != null) {
            this.xw.attribute("substitutionGroup", this.qualifyName(name2));
            if (complexType != null && complexType.equals(this.abstractElementTypeSelector.getAbstractElementType(name2))) {
                complexType = null;
            }
        }
        if (complexType != null) {
            if (complexType instanceof ComplexTypeNotAllowedContent) {
                this.xw.attribute("abstract", "true");
                this.outputAnnotation(annotated);
            } else {
                this.complexTypeOutput.parent = annotated;
                complexType.accept(this.complexTypeOutput);
            }
        } else {
            this.outputAnnotation(annotated);
        }
    }

    private void outputAnnotation(Annotated annotated) {
        Annotation annotation = annotated.getAnnotation();
        if (annotation == null) {
            return;
        }
        this.xw.startElement(this.xs("annotation"));
        String string = annotation.getDocumentation();
        if (string != null) {
            this.xw.startElement(this.xs("documentation"));
            this.xw.text(string);
            this.xw.endElement();
        }
        this.xw.endElement();
    }

    private void outputCommentList(List<Comment> list) {
        for (Comment comment : list) {
            this.xw.comment(comment.getContent());
        }
    }

    class AttributeUseOutput
    extends SchemaWalker {
        boolean isOptional = false;
        String defaultValue = null;

        AttributeUseOutput() {
        }

        @Override
        public VoidValue visitOptionalAttribute(OptionalAttribute optionalAttribute) {
            this.isOptional = true;
            this.defaultValue = optionalAttribute.getDefaultValue();
            optionalAttribute.getAttribute().accept(this);
            this.isOptional = false;
            this.defaultValue = null;
            return null;
        }

        @Override
        public VoidValue visitAttribute(Attribute attribute) {
            if (BasicOutput.this.nsm.isGlobal(attribute)) {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("attribute"));
                BasicOutput.this.xw.attribute("ref", BasicOutput.this.qualifyName(attribute.getName()));
                if (!this.isOptional) {
                    BasicOutput.this.xw.attribute("use", "required");
                } else if (this.defaultValue != null) {
                    BasicOutput.this.xw.attribute("default", this.defaultValue);
                }
                BasicOutput.this.xw.endElement();
            } else if (BasicOutput.this.namespaceIsLocal(attribute.getName().getNamespaceUri())) {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("attribute"));
                BasicOutput.this.xw.attribute("name", attribute.getName().getLocalName());
                if (!this.isOptional) {
                    BasicOutput.this.xw.attribute("use", "required");
                } else if (this.defaultValue != null) {
                    BasicOutput.this.xw.attribute("default", this.defaultValue);
                }
                if (!attribute.getName().getNamespaceUri().equals("")) {
                    BasicOutput.this.xw.attribute("form", "qualified");
                }
                if (attribute.getType() != null) {
                    BasicOutput.this.simpleTypeOutput.outputWrap(attribute.getType(), attribute);
                } else {
                    BasicOutput.this.outputAnnotation(attribute);
                }
                BasicOutput.this.xw.endElement();
            } else {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("attributeGroup"));
                BasicOutput.this.xw.attribute("ref", BasicOutput.this.qualifyName(attribute.getName().getNamespaceUri(), BasicOutput.this.nsm.getProxyName(attribute)));
                BasicOutput.this.xw.endElement();
            }
            return null;
        }

        @Override
        public VoidValue visitAttributeGroupRef(AttributeGroupRef attributeGroupRef) {
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("attributeGroup"));
            String string = attributeGroupRef.getName();
            BasicOutput.this.xw.attribute("ref", BasicOutput.this.qualifyRef(BasicOutput.this.schema.getAttributeGroup(string).getParentSchema().getUri(), string));
            BasicOutput.this.xw.endElement();
            return null;
        }
    }

    class GlobalAttributeOutput
    extends AbstractAttributeUseVisitor<VoidValue> {
        GlobalAttributeOutput() {
        }

        @Override
        public VoidValue visitAttributeGroup(AttributeGroup attributeGroup) {
            for (AttributeUse attributeUse : attributeGroup.getChildren()) {
                attributeUse.accept(this);
            }
            return null;
        }

        @Override
        public VoidValue visitAttribute(Attribute attribute) {
            Name name = attribute.getName();
            if (BasicOutput.this.nsm.isGlobal(attribute) && name.getNamespaceUri().equals(BasicOutput.this.targetNamespace) && !BasicOutput.this.globalAttributesDefined.contains(name)) {
                BasicOutput.this.globalAttributesDefined.add(name);
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("attribute"));
                BasicOutput.this.xw.attribute("name", name.getLocalName());
                if (attribute.getType() != null) {
                    BasicOutput.this.simpleTypeOutput.outputWrap(attribute.getType(), attribute);
                }
                BasicOutput.this.xw.endElement();
            }
            return null;
        }

        @Override
        public VoidValue visitOptionalAttribute(OptionalAttribute optionalAttribute) {
            return optionalAttribute.getAttribute().accept(this);
        }

        @Override
        public VoidValue visitAttributeGroupRef(AttributeGroupRef attributeGroupRef) {
            return null;
        }

        @Override
        public VoidValue visitWildcardAttribute(WildcardAttribute wildcardAttribute) {
            return null;
        }
    }

    class ParticleOutput
    implements ParticleVisitor<VoidValue> {
        private Occurs occ = Occurs.EXACTLY_ONE;
        private int context = 0;

        ParticleOutput() {
        }

        private boolean startWrapperForElement() {
            boolean bl = this.context >= 1;
            this.context = 0;
            if (bl) {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("sequence"));
            }
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("element"));
            this.outputOccurAttributes();
            return bl;
        }

        private boolean startWrapperForAny() {
            boolean bl = this.context >= 1;
            this.context = 0;
            if (bl) {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("sequence"));
            }
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("any"));
            this.outputOccurAttributes();
            return bl;
        }

        private boolean startWrapperForGroupRef() {
            boolean bl = this.context == 2;
            this.context = 0;
            if (bl) {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("sequence"));
            }
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("group"));
            this.outputOccurAttributes();
            return bl;
        }

        private boolean startWrapperForGroup(String string) {
            boolean bl = this.context == 2 && !this.occ.equals(Occurs.EXACTLY_ONE);
            this.context = 0;
            if (bl) {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("sequence"));
            }
            BasicOutput.this.xw.startElement(BasicOutput.this.xs(string));
            this.outputOccurAttributes();
            return bl;
        }

        private void endWrapper(boolean bl) {
            BasicOutput.this.xw.endElement();
            if (bl) {
                BasicOutput.this.xw.endElement();
            }
        }

        @Override
        public VoidValue visitElement(Element element) {
            boolean bl;
            if (BasicOutput.this.nsm.isGlobal(element)) {
                bl = this.startWrapperForElement();
                BasicOutput.this.xw.attribute("ref", BasicOutput.this.qualifyName(element.getName()));
            } else if (!BasicOutput.this.namespaceIsLocal(element.getName().getNamespaceUri())) {
                bl = this.startWrapperForGroupRef();
                BasicOutput.this.xw.attribute("ref", BasicOutput.this.qualifyName(element.getName().getNamespaceUri(), BasicOutput.this.nsm.getProxyName(element)));
            } else {
                bl = this.startWrapperForElement();
                BasicOutput.this.xw.attribute("name", element.getName().getLocalName());
                if (!element.getName().getNamespaceUri().equals(BasicOutput.this.targetNamespace)) {
                    BasicOutput.this.xw.attribute("form", "unqualified");
                }
                ((BasicOutput)BasicOutput.this).complexTypeOutput.parent = element;
                element.getComplexType().accept(BasicOutput.this.complexTypeOutput);
            }
            this.endWrapper(bl);
            return null;
        }

        @Override
        public VoidValue visitWildcardElement(WildcardElement wildcardElement) {
            boolean bl;
            String string = NamespaceManager.otherNamespace(wildcardElement.getWildcard());
            if (string != null && !string.equals(BasicOutput.this.targetNamespace)) {
                bl = this.startWrapperForGroupRef();
                BasicOutput.this.xw.attribute("ref", BasicOutput.this.qualifyName(string, BasicOutput.this.nsm.getOtherElementName(string)));
            } else {
                bl = this.startWrapperForAny();
                BasicOutput.this.namespaceAttribute(wildcardElement.getWildcard());
                BasicOutput.this.xw.attribute("processContents", ((BasicOutput)BasicOutput.this).options.anyProcessContents);
                BasicOutput.this.outputAnnotation(wildcardElement);
            }
            this.endWrapper(bl);
            return null;
        }

        @Override
        public VoidValue visitRepeat(ParticleRepeat particleRepeat) {
            this.occ = Occurs.multiply(this.occ, particleRepeat.getOccurs());
            particleRepeat.getChild().accept(this);
            return null;
        }

        @Override
        public VoidValue visitSequence(ParticleSequence particleSequence) {
            boolean bl = this.startWrapperForGroup("sequence");
            BasicOutput.this.outputAnnotation(particleSequence);
            this.outputParticles(particleSequence.getChildren());
            this.endWrapper(bl);
            return null;
        }

        @Override
        public VoidValue visitChoice(ParticleChoice particleChoice) {
            boolean bl = this.startWrapperForGroup("choice");
            BasicOutput.this.outputAnnotation(particleChoice);
            this.outputParticles(particleChoice.getChildren());
            this.endWrapper(bl);
            return null;
        }

        @Override
        public VoidValue visitAll(ParticleAll particleAll) {
            boolean bl = this.startWrapperForGroup("all");
            BasicOutput.this.outputAnnotation(particleAll);
            this.outputParticles(particleAll.getChildren());
            this.endWrapper(bl);
            return null;
        }

        private void outputParticles(List<Particle> list) {
            for (Particle particle : list) {
                particle.accept(this);
            }
        }

        @Override
        public VoidValue visitGroupRef(GroupRef groupRef) {
            boolean bl;
            String string = groupRef.getName();
            GroupDefinition groupDefinition = BasicOutput.this.schema.getGroup(string);
            Name name = BasicOutput.this.nsm.getElementNameForGroupRef(groupDefinition);
            if (name != null) {
                bl = this.startWrapperForElement();
                BasicOutput.this.xw.attribute("ref", BasicOutput.this.qualifyName(name));
            } else {
                bl = this.startWrapperForGroupRef();
                BasicOutput.this.xw.attribute("ref", BasicOutput.this.qualifyRef(groupDefinition.getParentSchema().getUri(), string));
            }
            BasicOutput.this.outputAnnotation(groupRef);
            this.endWrapper(bl);
            return null;
        }

        void outputOccurAttributes() {
            if (this.occ.getMin() != 1) {
                BasicOutput.this.xw.attribute("minOccurs", Integer.toString(this.occ.getMin()));
            }
            if (this.occ.getMax() != 1) {
                BasicOutput.this.xw.attribute("maxOccurs", this.occ.getMax() == Integer.MAX_VALUE ? "unbounded" : Integer.toString(this.occ.getMax()));
            }
            this.occ = Occurs.EXACTLY_ONE;
        }
    }

    class SimpleTypeOutput
    implements SimpleTypeVisitor<VoidValue> {
        SimpleTypeOutput() {
        }

        @Override
        public VoidValue visitRestriction(SimpleTypeRestriction simpleTypeRestriction) {
            boolean bl = false;
            for (Facet facet : simpleTypeRestriction.getFacets()) {
                if (!facet.getName().equals("pattern")) continue;
                if (!bl) {
                    bl = true;
                    continue;
                }
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("restriction"));
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("simpleType"));
            }
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("restriction"));
            BasicOutput.this.xw.attribute("base", BasicOutput.this.xs(simpleTypeRestriction.getName()));
            bl = false;
            for (Facet facet : simpleTypeRestriction.getFacets()) {
                if (facet.getName().equals("pattern")) {
                    if (bl) continue;
                    bl = true;
                    this.outputFacet(facet);
                    continue;
                }
                this.outputFacet(facet);
            }
            BasicOutput.this.xw.endElement();
            bl = false;
            for (Facet facet : simpleTypeRestriction.getFacets()) {
                if (!facet.getName().equals("pattern")) continue;
                if (!bl) {
                    bl = true;
                    continue;
                }
                BasicOutput.this.xw.endElement();
                this.outputFacet(facet);
                BasicOutput.this.xw.endElement();
            }
            return null;
        }

        private void outputFacet(Facet facet) {
            BasicOutput.this.xw.startElement(BasicOutput.this.xs(facet.getName()));
            BasicOutput.this.xw.attribute("value", facet.getValue());
            String string = facet.getPrefix();
            if (string != null && !string.equals(BasicOutput.this.topLevelPrefix(facet.getNamespace()))) {
                BasicOutput.this.xw.attribute(string.equals("") ? "xmlns" : "xmlns:" + string, facet.getNamespace());
            }
            BasicOutput.this.outputAnnotation(facet);
            BasicOutput.this.xw.endElement();
        }

        @Override
        public VoidValue visitRef(SimpleTypeRef simpleTypeRef) {
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("restriction"));
            BasicOutput.this.xw.attribute("base", BasicOutput.this.qualifyRef(BasicOutput.this.schema.getSimpleType(simpleTypeRef.getName()).getParentSchema().getUri(), simpleTypeRef.getName()));
            BasicOutput.this.xw.endElement();
            return null;
        }

        @Override
        public VoidValue visitUnion(SimpleTypeUnion simpleTypeUnion) {
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("union"));
            StringBuffer stringBuffer = new StringBuffer();
            for (SimpleType simpleType : simpleTypeUnion.getChildren()) {
                String string = (String)simpleType.accept(BasicOutput.this.simpleTypeNamer);
                if (string == null) continue;
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(string);
            }
            if (stringBuffer.length() != 0) {
                BasicOutput.this.xw.attribute("memberTypes", stringBuffer.toString());
            }
            BasicOutput.this.outputAnnotation(simpleTypeUnion);
            for (SimpleType simpleType : simpleTypeUnion.getChildren()) {
                if (simpleType.accept(BasicOutput.this.simpleTypeNamer) != null) continue;
                this.outputWrap(simpleType, null);
            }
            BasicOutput.this.xw.endElement();
            return null;
        }

        @Override
        public VoidValue visitList(SimpleTypeList simpleTypeList) {
            Occurs occurs = simpleTypeList.getOccurs();
            if (!occurs.equals(Occurs.ZERO_OR_MORE)) {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("restriction"));
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("simpleType"));
            }
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("list"));
            this.outputWrap(simpleTypeList.getItemType(), "itemType", simpleTypeList);
            BasicOutput.this.xw.endElement();
            if (!occurs.equals(Occurs.ZERO_OR_MORE)) {
                BasicOutput.this.xw.endElement();
                if (occurs.getMin() == occurs.getMax()) {
                    BasicOutput.this.xw.startElement(BasicOutput.this.xs("length"));
                    BasicOutput.this.xw.attribute("value", Integer.toString(occurs.getMin()));
                    BasicOutput.this.xw.endElement();
                } else {
                    if (occurs.getMin() != 0) {
                        BasicOutput.this.xw.startElement(BasicOutput.this.xs("minLength"));
                        BasicOutput.this.xw.attribute("value", Integer.toString(occurs.getMin()));
                        BasicOutput.this.xw.endElement();
                    }
                    if (occurs.getMax() != Integer.MAX_VALUE) {
                        BasicOutput.this.xw.startElement(BasicOutput.this.xs("maxLength"));
                        BasicOutput.this.xw.attribute("value", Integer.toString(occurs.getMax()));
                        BasicOutput.this.xw.endElement();
                    }
                }
                BasicOutput.this.xw.endElement();
            }
            return null;
        }

        void outputWrap(SimpleType simpleType, Annotated annotated) {
            this.outputWrap(simpleType, "type", annotated);
        }

        void outputWrap(SimpleType simpleType, String string, Annotated annotated) {
            String string2 = (String)simpleType.accept(BasicOutput.this.simpleTypeNamer);
            if (string2 != null) {
                BasicOutput.this.xw.attribute(string, string2);
                if (annotated != null) {
                    BasicOutput.this.outputAnnotation(annotated);
                }
            } else {
                if (annotated != null) {
                    BasicOutput.this.outputAnnotation(annotated);
                }
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("simpleType"));
                simpleType.accept(this);
                BasicOutput.this.xw.endElement();
            }
        }
    }

    static class Options {
        String anyProcessContents = "skip";
        String anyAttributeProcessContents = "skip";

        Options() {
        }
    }

    class ComplexTypeOutput
    implements ComplexTypeVisitor<VoidValue> {
        Annotated parent;

        ComplexTypeOutput() {
        }

        @Override
        public VoidValue visitComplexContent(ComplexTypeComplexContent complexTypeComplexContent) {
            BasicOutput.this.outputComplexTypeComplexContent(BasicOutput.this.complexTypeSelector.transformComplexContent(complexTypeComplexContent), null, this.parent);
            return null;
        }

        @Override
        public VoidValue visitSimpleContent(ComplexTypeSimpleContent complexTypeSimpleContent) {
            BasicOutput.this.outputComplexTypeSimpleContent(BasicOutput.this.complexTypeSelector.transformSimpleContent(complexTypeSimpleContent), null, this.parent);
            return null;
        }

        @Override
        public VoidValue visitNotAllowedContent(ComplexTypeNotAllowedContent complexTypeNotAllowedContent) {
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("complexType"));
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("choice"));
            BasicOutput.this.xw.endElement();
            BasicOutput.this.xw.endElement();
            return null;
        }
    }

    class AttributeWildcardOutput
    extends SchemaWalker {
        AttributeWildcardOutput() {
        }

        @Override
        public VoidValue visitWildcardAttribute(WildcardAttribute wildcardAttribute) {
            String string = NamespaceManager.otherNamespace(wildcardAttribute.getWildcard());
            if (string != null && !string.equals(BasicOutput.this.targetNamespace)) {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("attributeGroup"));
                BasicOutput.this.xw.attribute("ref", BasicOutput.this.qualifyName(string, BasicOutput.this.nsm.getOtherAttributeName(string)));
                BasicOutput.this.xw.endElement();
            } else {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("anyAttribute"));
                BasicOutput.this.namespaceAttribute(wildcardAttribute.getWildcard());
                BasicOutput.this.xw.attribute("processContents", ((BasicOutput)BasicOutput.this).options.anyAttributeProcessContents);
                BasicOutput.this.xw.endElement();
            }
            return null;
        }
    }

    class GlobalElementOutput
    implements ParticleVisitor<VoidValue>,
    ComplexTypeVisitor<VoidValue> {
        GlobalElementOutput() {
        }

        @Override
        public VoidValue visitElement(Element element) {
            Name name = element.getName();
            if (BasicOutput.this.nsm.isGlobal(element) && name.getNamespaceUri().equals(BasicOutput.this.targetNamespace) && !BasicOutput.this.globalElementsDefined.contains(name)) {
                BasicOutput.this.globalElementsDefined.add(name);
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("element"));
                BasicOutput.this.xw.attribute("name", name.getLocalName());
                BasicOutput.this.outputComplexType(name, element.getComplexType(), element);
                BasicOutput.this.xw.endElement();
            }
            return element.getComplexType().accept(this);
        }

        @Override
        public VoidValue visitRepeat(ParticleRepeat particleRepeat) {
            return particleRepeat.getChild().accept(this);
        }

        void visitList(List<Particle> list) {
            for (Particle particle : list) {
                particle.accept(this);
            }
        }

        @Override
        public VoidValue visitSequence(ParticleSequence particleSequence) {
            this.visitList(particleSequence.getChildren());
            return null;
        }

        @Override
        public VoidValue visitChoice(ParticleChoice particleChoice) {
            this.visitList(particleChoice.getChildren());
            return null;
        }

        @Override
        public VoidValue visitAll(ParticleAll particleAll) {
            this.visitList(particleAll.getChildren());
            return null;
        }

        @Override
        public VoidValue visitGroupRef(GroupRef groupRef) {
            return null;
        }

        @Override
        public VoidValue visitWildcardElement(WildcardElement wildcardElement) {
            return null;
        }

        @Override
        public VoidValue visitComplexContent(ComplexTypeComplexContent complexTypeComplexContent) {
            if (complexTypeComplexContent.getParticle() == null) {
                return null;
            }
            return complexTypeComplexContent.getParticle().accept(this);
        }

        @Override
        public VoidValue visitSimpleContent(ComplexTypeSimpleContent complexTypeSimpleContent) {
            return null;
        }

        @Override
        public VoidValue visitNotAllowedContent(ComplexTypeNotAllowedContent complexTypeNotAllowedContent) {
            return null;
        }
    }

    class SchemaOutput
    extends AbstractSchemaVisitor {
        SchemaOutput() {
        }

        @Override
        public void visitGroup(GroupDefinition groupDefinition) {
            Particle particle = groupDefinition.getParticle();
            ComplexTypeComplexContentExtension complexTypeComplexContentExtension = BasicOutput.this.complexTypeSelector.createComplexTypeForGroup(groupDefinition.getName(), BasicOutput.this.nsm);
            if (complexTypeComplexContentExtension != null) {
                GroupDefinition groupDefinition2 = this.tryAbstractElement(groupDefinition) ? null : groupDefinition;
                BasicOutput.this.outputComplexTypeComplexContent(complexTypeComplexContentExtension, groupDefinition.getName(), groupDefinition2);
            } else if (!(BasicOutput.this.nsm.isGroupDefinitionOmitted(groupDefinition) || this.tryAbstractElement(groupDefinition) || this.tryElementChoiceSameType(groupDefinition))) {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("group"));
                BasicOutput.this.xw.attribute("name", groupDefinition.getName());
                BasicOutput.this.outputAnnotation(groupDefinition);
                BasicOutput.this.particleOutput.context = 2;
                particle.accept(BasicOutput.this.particleOutput);
                BasicOutput.this.xw.endElement();
            }
            particle.accept(BasicOutput.this.globalElementOutput);
        }

        private boolean tryAbstractElement(GroupDefinition groupDefinition) {
            Name name = BasicOutput.this.nsm.getGroupDefinitionAbstractElementName(groupDefinition);
            if (name == null) {
                return false;
            }
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("element"));
            BasicOutput.this.xw.attribute("name", name.getLocalName());
            BasicOutput.this.xw.attribute("abstract", "true");
            BasicOutput.this.outputComplexType(name, BasicOutput.this.abstractElementTypeSelector.getAbstractElementType(name), groupDefinition);
            BasicOutput.this.xw.endElement();
            return true;
        }

        private boolean tryElementChoiceSameType(GroupDefinition groupDefinition) {
            Particle particle = groupDefinition.getParticle();
            if (!(particle instanceof ParticleChoice)) {
                return false;
            }
            List<Particle> list = ((ParticleChoice)particle).getChildren();
            if (list.size() <= 1) {
                return false;
            }
            Iterator<Particle> iterator = list.iterator();
            Particle particle2 = iterator.next();
            if (!(particle2 instanceof Element)) {
                return false;
            }
            if (!((Element)particle2).getName().getNamespaceUri().equals(BasicOutput.this.targetNamespace)) {
                return false;
            }
            ComplexType complexType = ((Element)particle2).getComplexType();
            do {
                Particle object2;
                if (!((object2 = iterator.next()) instanceof Element)) {
                    return false;
                }
                if (!((Element)object2).getComplexType().equals(complexType)) {
                    return false;
                }
                if (((Element)object2).getName().getNamespaceUri().equals(BasicOutput.this.targetNamespace)) continue;
                return false;
            } while (iterator.hasNext());
            if (complexType instanceof ComplexTypeComplexContent) {
                ComplexTypeComplexContentExtension complexTypeComplexContentExtension = BasicOutput.this.complexTypeSelector.transformComplexContent((ComplexTypeComplexContent)complexType);
                if (complexTypeComplexContentExtension.getBase() != null && complexTypeComplexContentExtension.getParticle() == null && !complexTypeComplexContentExtension.isMixed() && complexTypeComplexContentExtension.getAttributeUses().equals(AttributeGroup.EMPTY)) {
                    return false;
                }
                BasicOutput.this.outputComplexTypeComplexContent(complexTypeComplexContentExtension, groupDefinition.getName(), null);
            } else {
                ComplexTypeSimpleContentExtension complexTypeSimpleContentExtension = BasicOutput.this.complexTypeSelector.transformSimpleContent((ComplexTypeSimpleContent)complexType);
                if (complexTypeSimpleContentExtension.getAttributeUses().equals(AttributeGroup.EMPTY) && (complexTypeSimpleContentExtension.getBase() != null || complexTypeSimpleContentExtension.getSimpleType().accept(BasicOutput.this.simpleTypeNamer) != null)) {
                    return false;
                }
                BasicOutput.this.outputComplexTypeSimpleContent(complexTypeSimpleContentExtension, groupDefinition.getName(), null);
            }
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("group"));
            BasicOutput.this.xw.attribute("name", groupDefinition.getName());
            BasicOutput.this.outputAnnotation(groupDefinition);
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("choice"));
            for (Element element : list) {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("element"));
                if (BasicOutput.this.nsm.isGlobal(element)) {
                    BasicOutput.this.xw.attribute("ref", BasicOutput.this.qualifyName(element.getName()));
                } else {
                    BasicOutput.this.xw.attribute("name", element.getName().getLocalName());
                    BasicOutput.this.xw.attribute("type", groupDefinition.getName());
                    BasicOutput.this.outputAnnotation(element);
                }
                BasicOutput.this.xw.endElement();
            }
            BasicOutput.this.xw.endElement();
            BasicOutput.this.xw.endElement();
            for (Element element : list) {
                if (!BasicOutput.this.nsm.isGlobal(element) || BasicOutput.this.globalElementsDefined.contains(element.getName())) continue;
                BasicOutput.this.globalElementsDefined.add(element.getName());
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("element"));
                BasicOutput.this.xw.attribute("name", element.getName().getLocalName());
                BasicOutput.this.xw.attribute("type", groupDefinition.getName());
                BasicOutput.this.outputAnnotation(element);
                BasicOutput.this.xw.endElement();
            }
            return true;
        }

        @Override
        public void visitSimpleType(SimpleTypeDefinition simpleTypeDefinition) {
            ComplexTypeSimpleContentExtension complexTypeSimpleContentExtension = BasicOutput.this.complexTypeSelector.createComplexTypeForSimpleType(simpleTypeDefinition.getName());
            if (complexTypeSimpleContentExtension != null) {
                BasicOutput.this.outputComplexTypeSimpleContent(complexTypeSimpleContentExtension, simpleTypeDefinition.getName(), simpleTypeDefinition);
            } else {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("simpleType"));
                BasicOutput.this.xw.attribute("name", simpleTypeDefinition.getName());
                BasicOutput.this.outputAnnotation(simpleTypeDefinition);
                simpleTypeDefinition.getSimpleType().accept(BasicOutput.this.simpleTypeOutput);
                BasicOutput.this.xw.endElement();
            }
        }

        @Override
        public void visitAttributeGroup(AttributeGroupDefinition attributeGroupDefinition) {
            if (BasicOutput.this.complexTypeSelector.isComplexType(attributeGroupDefinition.getName())) {
                return;
            }
            BasicOutput.this.xw.startElement(BasicOutput.this.xs("attributeGroup"));
            BasicOutput.this.xw.attribute("name", attributeGroupDefinition.getName());
            BasicOutput.this.outputAnnotation(attributeGroupDefinition);
            BasicOutput.this.outputAttributeUse(attributeGroupDefinition.getAttributeUses());
            BasicOutput.this.xw.endElement();
            attributeGroupDefinition.getAttributeUses().accept(BasicOutput.this.globalAttributeOutput);
        }

        @Override
        public void visitRoot(RootDeclaration rootDeclaration) {
            rootDeclaration.getParticle().accept(BasicOutput.this.globalElementOutput);
        }

        @Override
        public void visitComment(Comment comment) {
            BasicOutput.this.xw.comment(comment.getContent());
        }
    }

    class MovedStructureOutput
    implements StructureVisitor<VoidValue> {
        MovedStructureOutput() {
        }

        @Override
        public VoidValue visitElement(Element element) {
            if (!BasicOutput.this.nsm.isGlobal(element)) {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("group"));
                BasicOutput.this.xw.attribute("name", BasicOutput.this.nsm.getProxyName(element));
                BasicOutput.this.particleOutput.context = 2;
                BasicOutput.this.particleOutput.visitElement(element);
                BasicOutput.this.xw.endElement();
            }
            BasicOutput.this.globalElementOutput.visitElement(element);
            return null;
        }

        @Override
        public VoidValue visitAttribute(Attribute attribute) {
            if (!BasicOutput.this.nsm.isGlobal(attribute)) {
                BasicOutput.this.xw.startElement(BasicOutput.this.xs("attributeGroup"));
                BasicOutput.this.xw.attribute("name", BasicOutput.this.nsm.getProxyName(attribute));
                BasicOutput.this.attributeUseOutput.visitAttribute(attribute);
                BasicOutput.this.xw.endElement();
            }
            BasicOutput.this.globalAttributeOutput.visitAttribute(attribute);
            return null;
        }
    }

    class SimpleTypeNamer
    implements SimpleTypeVisitor<String> {
        SimpleTypeNamer() {
        }

        @Override
        public String visitRestriction(SimpleTypeRestriction simpleTypeRestriction) {
            if (simpleTypeRestriction.getFacets().size() > 0) {
                return null;
            }
            if (simpleTypeRestriction.getAnnotation() != null) {
                return null;
            }
            return BasicOutput.this.xs(simpleTypeRestriction.getName());
        }

        @Override
        public String visitRef(SimpleTypeRef simpleTypeRef) {
            if (simpleTypeRef.getAnnotation() != null) {
                return null;
            }
            return BasicOutput.this.qualifyRef(BasicOutput.this.schema.getSimpleType(simpleTypeRef.getName()).getParentSchema().getUri(), simpleTypeRef.getName());
        }

        @Override
        public String visitList(SimpleTypeList simpleTypeList) {
            return null;
        }

        @Override
        public String visitUnion(SimpleTypeUnion simpleTypeUnion) {
            return null;
        }
    }
}

