/* Generated by wayland-scanner 1.23.0 */

#ifndef FULLSCREEN_SHELL_UNSTABLE_V1_ENUM_PROTOCOL_H
#define FULLSCREEN_SHELL_UNSTABLE_V1_ENUM_PROTOCOL_H

#ifdef  __cplusplus
extern "C" {
#endif

#ifndef ZWP_FULLSCREEN_SHELL_V1_CAPABILITY_ENUM
#define ZWP_FULLSCREEN_SHELL_V1_CAPABILITY_ENUM
/**
 * @ingroup iface_zwp_fullscreen_shell_v1
 * capabilities advertised by the compositor
 *
 * Various capabilities that can be advertised by the compositor.  They
 * are advertised one-at-a-time when the wl_fullscreen_shell interface is
 * bound.  See the wl_fullscreen_shell.capability event for more details.
 *
 * ARBITRARY_MODES:
 * This is a hint to the client that indicates that the compositor is
 * capable of setting practically any mode on its outputs.  If this
 * capability is provided, wl_fullscreen_shell.present_surface_for_mode
 * will almost never fail and clients should feel free to set whatever
 * mode they like.  If the compositor does not advertise this, it may
 * still support some modes that are not advertised through wl_global.mode
 * but it is less likely.
 *
 * CURSOR_PLANE:
 * This is a hint to the client that indicates that the compositor can
 * handle a cursor surface from the client without actually compositing.
 * This may be because of a hardware cursor plane or some other mechanism.
 * If the compositor does not advertise this capability then setting
 * wl_pointer.cursor may degrade performance or be ignored entirely.  If
 * CURSOR_PLANE is not advertised, it is recommended that the client draw
 * its own cursor and set wl_pointer.cursor(NULL).
 */
enum zwp_fullscreen_shell_v1_capability {
	/**
	 * compositor is capable of almost any output mode
	 */
	ZWP_FULLSCREEN_SHELL_V1_CAPABILITY_ARBITRARY_MODES = 1,
	/**
	 * compositor has a separate cursor plane
	 */
	ZWP_FULLSCREEN_SHELL_V1_CAPABILITY_CURSOR_PLANE = 2,
};
#endif /* ZWP_FULLSCREEN_SHELL_V1_CAPABILITY_ENUM */

#ifndef ZWP_FULLSCREEN_SHELL_V1_PRESENT_METHOD_ENUM
#define ZWP_FULLSCREEN_SHELL_V1_PRESENT_METHOD_ENUM
/**
 * @ingroup iface_zwp_fullscreen_shell_v1
 * different method to set the surface fullscreen
 *
 * Hints to indicate to the compositor how to deal with a conflict
 * between the dimensions of the surface and the dimensions of the
 * output. The compositor is free to ignore this parameter.
 */
enum zwp_fullscreen_shell_v1_present_method {
	/**
	 * no preference, apply default policy
	 */
	ZWP_FULLSCREEN_SHELL_V1_PRESENT_METHOD_DEFAULT = 0,
	/**
	 * center the surface on the output
	 */
	ZWP_FULLSCREEN_SHELL_V1_PRESENT_METHOD_CENTER = 1,
	/**
	 * scale the surface, preserving aspect ratio, to the largest size that will fit on the output
	 */
	ZWP_FULLSCREEN_SHELL_V1_PRESENT_METHOD_ZOOM = 2,
	/**
	 * scale the surface, preserving aspect ratio, to fully fill the output cropping if needed
	 */
	ZWP_FULLSCREEN_SHELL_V1_PRESENT_METHOD_ZOOM_CROP = 3,
	/**
	 * scale the surface to the size of the output ignoring aspect ratio
	 */
	ZWP_FULLSCREEN_SHELL_V1_PRESENT_METHOD_STRETCH = 4,
};
#endif /* ZWP_FULLSCREEN_SHELL_V1_PRESENT_METHOD_ENUM */

#ifndef ZWP_FULLSCREEN_SHELL_V1_ERROR_ENUM
#define ZWP_FULLSCREEN_SHELL_V1_ERROR_ENUM
/**
 * @ingroup iface_zwp_fullscreen_shell_v1
 * wl_fullscreen_shell error values
 *
 * These errors can be emitted in response to wl_fullscreen_shell requests.
 */
enum zwp_fullscreen_shell_v1_error {
	/**
	 * present_method is not known
	 */
	ZWP_FULLSCREEN_SHELL_V1_ERROR_INVALID_METHOD = 0,
	/**
	 * given wl_surface has another role
	 */
	ZWP_FULLSCREEN_SHELL_V1_ERROR_ROLE = 1,
};
#endif /* ZWP_FULLSCREEN_SHELL_V1_ERROR_ENUM */

#ifdef  __cplusplus
}
#endif

#endif
