/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivileges;

public final class ResourcePrivilegesMap {
    private final boolean allAllowed;
    private final Map<String, ResourcePrivileges> resourceToResourcePrivileges;

    public ResourcePrivilegesMap(boolean allAllowed, Map<String, ResourcePrivileges> resToResPriv) {
        this.allAllowed = allAllowed;
        this.resourceToResourcePrivileges = Collections.unmodifiableMap(Objects.requireNonNull(resToResPriv));
    }

    public boolean allAllowed() {
        return this.allAllowed;
    }

    public Map<String, ResourcePrivileges> getResourceToResourcePrivileges() {
        return this.resourceToResourcePrivileges;
    }

    public int hashCode() {
        return Objects.hash(this.allAllowed, this.resourceToResourcePrivileges);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourcePrivilegesMap other = (ResourcePrivilegesMap)obj;
        return this.allAllowed == other.allAllowed && Objects.equals(this.resourceToResourcePrivileges, other.resourceToResourcePrivileges);
    }

    public String toString() {
        return "ResourcePrivilegesMap [allAllowed=" + this.allAllowed + ", resourceToResourcePrivileges=" + this.resourceToResourcePrivileges + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ResourcePrivilegesMap intersection(ResourcePrivilegesMap left, ResourcePrivilegesMap right) {
        Objects.requireNonNull(left);
        Objects.requireNonNull(right);
        Builder builder = ResourcePrivilegesMap.builder();
        for (Map.Entry<String, ResourcePrivileges> leftResPrivsEntry : left.getResourceToResourcePrivileges().entrySet()) {
            ResourcePrivileges leftResPrivs = leftResPrivsEntry.getValue();
            ResourcePrivileges rightResPrivs = right.getResourceToResourcePrivileges().get(leftResPrivsEntry.getKey());
            builder.addResourcePrivilege(leftResPrivsEntry.getKey(), leftResPrivs.getPrivileges());
            builder.addResourcePrivilege(leftResPrivsEntry.getKey(), rightResPrivs.getPrivileges());
        }
        return builder.build();
    }

    public static final class Builder {
        private boolean allowAll = true;
        private Map<String, ResourcePrivileges.Builder> resourceToResourcePrivilegesBuilder = new LinkedHashMap<String, ResourcePrivileges.Builder>();

        public Builder addResourcePrivilege(String resource, String privilege, Boolean allowed) {
            assert (resource != null && privilege != null && allowed != null) : "resource, privilege and permission(allowed or denied) are required";
            ResourcePrivileges.Builder builder = this.resourceToResourcePrivilegesBuilder.computeIfAbsent(resource, ResourcePrivileges::builder);
            builder.addPrivilege(privilege, allowed);
            this.allowAll = this.allowAll && allowed != false;
            return this;
        }

        public Builder addResourcePrivilege(String resource, Map<String, Boolean> privilegePermissions) {
            assert (resource != null && privilegePermissions != null) : "resource, privilege permissions(allowed or denied) are required";
            ResourcePrivileges.Builder builder = this.resourceToResourcePrivilegesBuilder.computeIfAbsent(resource, ResourcePrivileges::builder);
            builder.addPrivileges(privilegePermissions);
            this.allowAll = this.allowAll && privilegePermissions.values().stream().allMatch(b -> Boolean.TRUE.equals(b));
            return this;
        }

        public Builder addResourcePrivilegesMap(ResourcePrivilegesMap resourcePrivilegesMap) {
            resourcePrivilegesMap.getResourceToResourcePrivileges().entrySet().stream().forEach(e -> this.addResourcePrivilege((String)e.getKey(), ((ResourcePrivileges)e.getValue()).getPrivileges()));
            return this;
        }

        public ResourcePrivilegesMap build() {
            Map<String, ResourcePrivileges> result = this.resourceToResourcePrivilegesBuilder.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((ResourcePrivileges.Builder)e.getValue()).build()));
            return new ResourcePrivilegesMap(this.allowAll, result);
        }
    }
}

