/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ssl.CertParsingUtils;
import org.elasticsearch.xpack.core.ssl.DefaultJDKTrustConfig;
import org.elasticsearch.xpack.core.ssl.KeyConfig;
import org.elasticsearch.xpack.core.ssl.PEMTrustConfig;
import org.elasticsearch.xpack.core.ssl.RestrictedTrustConfig;
import org.elasticsearch.xpack.core.ssl.SSLClientAuth;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;
import org.elasticsearch.xpack.core.ssl.StoreKeyConfig;
import org.elasticsearch.xpack.core.ssl.StoreTrustConfig;
import org.elasticsearch.xpack.core.ssl.TrustAllConfig;
import org.elasticsearch.xpack.core.ssl.TrustConfig;
import org.elasticsearch.xpack.core.ssl.VerificationMode;
import org.elasticsearch.xpack.core.ssl.cert.CertificateInfo;

public final class SSLConfiguration {
    static final SSLConfigurationSettings SETTINGS_PARSER = SSLConfigurationSettings.withoutPrefix();
    private final KeyConfig keyConfig;
    private final TrustConfig trustConfig;
    private final List<String> ciphers;
    private final List<String> supportedProtocols;
    private final SSLClientAuth sslClientAuth;
    private final VerificationMode verificationMode;

    SSLConfiguration(Settings settings) {
        this.keyConfig = SSLConfiguration.createKeyConfig(settings, null);
        this.trustConfig = SSLConfiguration.createTrustConfig(settings, this.keyConfig, null);
        this.ciphers = SSLConfiguration.getListOrDefault(SSLConfiguration.SETTINGS_PARSER.ciphers, settings, XPackSettings.DEFAULT_CIPHERS);
        this.supportedProtocols = SSLConfiguration.getListOrDefault(SSLConfiguration.SETTINGS_PARSER.supportedProtocols, settings, XPackSettings.DEFAULT_SUPPORTED_PROTOCOLS);
        this.sslClientAuth = ((Optional)SSLConfiguration.SETTINGS_PARSER.clientAuth.get(settings)).orElse(XPackSettings.CLIENT_AUTH_DEFAULT);
        this.verificationMode = ((Optional)SSLConfiguration.SETTINGS_PARSER.verificationMode.get(settings)).orElse(XPackSettings.VERIFICATION_MODE_DEFAULT);
    }

    SSLConfiguration(Settings settings, SSLConfiguration globalSSLConfiguration) {
        Objects.requireNonNull(globalSSLConfiguration);
        this.keyConfig = SSLConfiguration.createKeyConfig(settings, globalSSLConfiguration);
        this.trustConfig = SSLConfiguration.createTrustConfig(settings, this.keyConfig, globalSSLConfiguration);
        this.ciphers = SSLConfiguration.getListOrDefault(SSLConfiguration.SETTINGS_PARSER.ciphers, settings, globalSSLConfiguration.cipherSuites());
        this.supportedProtocols = SSLConfiguration.getListOrDefault(SSLConfiguration.SETTINGS_PARSER.supportedProtocols, settings, globalSSLConfiguration.supportedProtocols());
        this.sslClientAuth = ((Optional)SSLConfiguration.SETTINGS_PARSER.clientAuth.get(settings)).orElse(globalSSLConfiguration.sslClientAuth());
        this.verificationMode = ((Optional)SSLConfiguration.SETTINGS_PARSER.verificationMode.get(settings)).orElse(globalSSLConfiguration.verificationMode());
    }

    KeyConfig keyConfig() {
        return this.keyConfig;
    }

    TrustConfig trustConfig() {
        return this.trustConfig;
    }

    List<String> cipherSuites() {
        return this.ciphers;
    }

    List<String> supportedProtocols() {
        return this.supportedProtocols;
    }

    public VerificationMode verificationMode() {
        return this.verificationMode;
    }

    SSLClientAuth sslClientAuth() {
        return this.sslClientAuth;
    }

    List<Path> filesToMonitor(@Nullable Environment environment) {
        if (this.keyConfig() == this.trustConfig()) {
            return this.keyConfig().filesToMonitor(environment);
        }
        ArrayList<Path> paths = new ArrayList<Path>(this.keyConfig().filesToMonitor(environment));
        paths.addAll(this.trustConfig().filesToMonitor(environment));
        return paths;
    }

    public String toString() {
        return "SSLConfiguration{keyConfig=[" + this.keyConfig + "], trustConfig=" + this.trustConfig + "], cipherSuites=[" + this.ciphers + "], supportedProtocols=[" + this.supportedProtocols + "], sslClientAuth=[" + (Object)((Object)this.sslClientAuth) + "], verificationMode=[" + (Object)((Object)this.verificationMode) + "]}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SSLConfiguration)) {
            return false;
        }
        SSLConfiguration that = (SSLConfiguration)o;
        if (this.keyConfig() != null ? !this.keyConfig().equals(that.keyConfig()) : that.keyConfig() != null) {
            return false;
        }
        if (this.trustConfig() != null ? !this.trustConfig().equals(that.trustConfig()) : that.trustConfig() != null) {
            return false;
        }
        if (this.cipherSuites() != null ? !this.cipherSuites().equals(that.cipherSuites()) : that.cipherSuites() != null) {
            return false;
        }
        if (!this.supportedProtocols().equals(that.supportedProtocols())) {
            return false;
        }
        if (this.verificationMode() != that.verificationMode()) {
            return false;
        }
        if (this.sslClientAuth() != that.sslClientAuth()) {
            return false;
        }
        return this.supportedProtocols() != null ? this.supportedProtocols().equals(that.supportedProtocols()) : that.supportedProtocols() == null;
    }

    public int hashCode() {
        int result = this.keyConfig() != null ? this.keyConfig().hashCode() : 0;
        result = 31 * result + (this.trustConfig() != null ? this.trustConfig().hashCode() : 0);
        result = 31 * result + (this.cipherSuites() != null ? this.cipherSuites().hashCode() : 0);
        result = 31 * result + (this.supportedProtocols() != null ? this.supportedProtocols().hashCode() : 0);
        result = 31 * result + this.verificationMode().hashCode();
        result = 31 * result + this.sslClientAuth().hashCode();
        return result;
    }

    private static KeyConfig createKeyConfig(Settings settings, SSLConfiguration global) {
        String trustStoreAlgorithm = (String)SSLConfiguration.SETTINGS_PARSER.truststoreAlgorithm.get(settings);
        KeyConfig config = CertParsingUtils.createKeyConfig(SSLConfiguration.SETTINGS_PARSER.x509KeyPair, settings, trustStoreAlgorithm);
        if (config != null) {
            return config;
        }
        if (global != null) {
            return global.keyConfig();
        }
        if (System.getProperty("javax.net.ssl.keyStore") != null && !System.getProperty("javax.net.ssl.keyStore").equals("NONE")) {
            try (SecureString keystorePassword = new SecureString(System.getProperty("javax.net.ssl.keyStorePassword", ""));){
                StoreKeyConfig storeKeyConfig = new StoreKeyConfig(System.getProperty("javax.net.ssl.keyStore"), KeyStore.getDefaultType(), keystorePassword, keystorePassword, System.getProperty("ssl.KeyManagerFactory.algorithm", KeyManagerFactory.getDefaultAlgorithm()), System.getProperty("ssl.TrustManagerFactory.algorithm", TrustManagerFactory.getDefaultAlgorithm()));
                return storeKeyConfig;
            }
        }
        return KeyConfig.NONE;
    }

    private static TrustConfig createTrustConfig(Settings settings, KeyConfig keyConfig, SSLConfiguration global) {
        TrustConfig trustConfig = SSLConfiguration.createCertChainTrustConfig(settings, keyConfig, global);
        return ((Optional)SSLConfiguration.SETTINGS_PARSER.trustRestrictionsPath.get(settings)).map(path -> new RestrictedTrustConfig((String)path, trustConfig)).orElse(trustConfig);
    }

    private static TrustConfig createCertChainTrustConfig(Settings settings, KeyConfig keyConfig, SSLConfiguration global) {
        String trustStorePath = ((Optional)SSLConfiguration.SETTINGS_PARSER.truststorePath.get(settings)).orElse(null);
        String trustStoreType = SSLConfigurationSettings.getKeyStoreType(SSLConfiguration.SETTINGS_PARSER.truststoreType, settings, trustStorePath);
        List<String> caPaths = SSLConfiguration.getListOrNull(SSLConfiguration.SETTINGS_PARSER.caPaths, settings);
        if (trustStorePath != null && caPaths != null) {
            throw new IllegalArgumentException("you cannot specify a truststore and ca files");
        }
        VerificationMode verificationMode = ((Optional)SSLConfiguration.SETTINGS_PARSER.verificationMode.get(settings)).orElseGet(() -> {
            if (global != null) {
                return global.verificationMode();
            }
            return XPackSettings.VERIFICATION_MODE_DEFAULT;
        });
        if (!verificationMode.isCertificateVerificationEnabled()) {
            return TrustAllConfig.INSTANCE;
        }
        if (caPaths != null) {
            return new PEMTrustConfig(caPaths);
        }
        if (trustStorePath != null || trustStoreType.equalsIgnoreCase("pkcs11")) {
            String trustStoreAlgorithm = (String)SSLConfiguration.SETTINGS_PARSER.truststoreAlgorithm.get(settings);
            SecureString trustStorePassword = (SecureString)SSLConfiguration.SETTINGS_PARSER.truststorePassword.get(settings);
            return new StoreTrustConfig(trustStorePath, trustStoreType, trustStorePassword, trustStoreAlgorithm);
        }
        if (global == null && System.getProperty("javax.net.ssl.trustStore") != null && !System.getProperty("javax.net.ssl.trustStore").equals("NONE")) {
            try (SecureString truststorePassword = new SecureString(System.getProperty("javax.net.ssl.trustStorePassword", ""));){
                StoreTrustConfig storeTrustConfig = new StoreTrustConfig(System.getProperty("javax.net.ssl.trustStore"), KeyStore.getDefaultType(), truststorePassword, System.getProperty("ssl.TrustManagerFactory.algorithm", TrustManagerFactory.getDefaultAlgorithm()));
                return storeTrustConfig;
            }
        }
        if (global != null && keyConfig == global.keyConfig()) {
            return global.trustConfig();
        }
        if (keyConfig != KeyConfig.NONE) {
            return DefaultJDKTrustConfig.merge(keyConfig, SSLConfiguration.getDefaultTrustStorePassword(settings));
        }
        return new DefaultJDKTrustConfig(SSLConfiguration.getDefaultTrustStorePassword(settings));
    }

    private static SecureString getDefaultTrustStorePassword(Settings settings) {
        if (System.getProperty("javax.net.ssl.trustStoreType", "").equalsIgnoreCase("PKCS11")) {
            try (SecureString systemTrustStorePassword = new SecureString(System.getProperty("javax.net.ssl.trustStorePassword", "").toCharArray());){
                if (systemTrustStorePassword.length() == 0) {
                    try (SecureString trustStorePassword = (SecureString)SSLConfiguration.SETTINGS_PARSER.truststorePassword.get(settings);){
                        SecureString secureString = trustStorePassword;
                        return secureString;
                    }
                }
                SecureString secureString = systemTrustStorePassword.clone();
                return secureString;
            }
        }
        return null;
    }

    private static List<String> getListOrNull(Setting<List<String>> listSetting, Settings settings) {
        return SSLConfiguration.getListOrDefault(listSetting, settings, null);
    }

    private static List<String> getListOrDefault(Setting<List<String>> listSetting, Settings settings, List<String> defaultValue) {
        if (listSetting.exists(settings)) {
            return (List)listSetting.get(settings);
        }
        return defaultValue;
    }

    List<CertificateInfo> getDefinedCertificates(@Nullable Environment environment) throws GeneralSecurityException, IOException {
        ArrayList<CertificateInfo> certificates = new ArrayList<CertificateInfo>();
        certificates.addAll(this.keyConfig.certificates(environment));
        certificates.addAll(this.trustConfig.certificates(environment));
        return certificates;
    }
}

