/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.util.StaticUtils;

public enum ContentSyncRequestMode {
    REFRESH_ONLY(1),
    REFRESH_AND_PERSIST(3);

    private final int intValue;

    private ContentSyncRequestMode(int intValue) {
        this.intValue = intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    public static ContentSyncRequestMode valueOf(int intValue) {
        if (intValue == REFRESH_ONLY.intValue()) {
            return REFRESH_ONLY;
        }
        if (intValue == REFRESH_AND_PERSIST.intValue()) {
            return REFRESH_AND_PERSIST;
        }
        return null;
    }

    public static ContentSyncRequestMode forName(String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "refreshonly": 
            case "refresh-only": 
            case "refresh_only": {
                return REFRESH_ONLY;
            }
            case "refreshandpersist": 
            case "refresh-and-persist": 
            case "refresh_and_persist": {
                return REFRESH_AND_PERSIST;
            }
        }
        return null;
    }
}

