/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process.diagnostics;

import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.ml.job.process.diagnostics.BucketDiagnostics;

public class DataStreamDiagnostics {
    private static final int DATA_SPARSITY_THRESHOLD = 2;
    private static final Logger LOGGER = LogManager.getLogger(DataStreamDiagnostics.class);
    private final BucketDiagnostics bucketDiagnostics;
    private long bucketCount = 0L;
    private long emptyBucketCount = 0L;
    private long latestEmptyBucketTime = -1L;
    private long sparseBucketCount = 0L;
    private long latestSparseBucketTime = -1L;

    public DataStreamDiagnostics(Job job, DataCounts dataCounts) {
        this.bucketDiagnostics = new BucketDiagnostics(job, dataCounts, this.createBucketFlushListener());
    }

    private BucketDiagnostics.BucketFlushListener createBucketFlushListener() {
        return (flushedBucketStartMs, flushedBucketCount) -> {
            ++this.bucketCount;
            if (flushedBucketCount == 0L) {
                ++this.emptyBucketCount;
                this.latestEmptyBucketTime = flushedBucketStartMs;
            } else {
                double logBucketSize;
                double averageBucketSize = this.bucketDiagnostics.averageBucketCount();
                double logAverageBucketSize = Math.log(averageBucketSize);
                double sparsityScore = logAverageBucketSize - (logBucketSize = Math.log(flushedBucketCount));
                if (sparsityScore > 2.0) {
                    LOGGER.debug("Sparse bucket {}, this bucket: {} average: {}, sparsity score: {}", (Object)flushedBucketStartMs, (Object)flushedBucketCount, (Object)averageBucketSize, (Object)sparsityScore);
                    ++this.sparseBucketCount;
                    this.latestSparseBucketTime = flushedBucketStartMs;
                }
            }
        };
    }

    public void checkRecord(long recordTimestampInMs) {
        this.bucketDiagnostics.addRecord(recordTimestampInMs);
    }

    public void flush() {
        this.bucketDiagnostics.flush();
    }

    public long getBucketCount() {
        return this.bucketCount;
    }

    public long getEmptyBucketCount() {
        return this.emptyBucketCount;
    }

    public Date getLatestEmptyBucketTime() {
        return this.latestEmptyBucketTime > 0L ? new Date(this.latestEmptyBucketTime) : null;
    }

    public long getSparseBucketCount() {
        return this.sparseBucketCount;
    }

    public Date getLatestSparseBucketTime() {
        return this.latestSparseBucketTime > 0L ? new Date(this.latestSparseBucketTime) : null;
    }

    public void resetCounts() {
        this.bucketCount = 0L;
        this.emptyBucketCount = 0L;
        this.sparseBucketCount = 0L;
    }
}

