/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.StringFunctionUtils;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;

public class SubstringFunctionProcessor
implements Processor {
    public static final String NAME = "ssub";
    private final Processor source;
    private final Processor start;
    private final Processor length;

    public SubstringFunctionProcessor(Processor source, Processor start, Processor length) {
        this.source = source;
        this.start = start;
        this.length = length;
    }

    public SubstringFunctionProcessor(StreamInput in) throws IOException {
        this.source = (Processor)in.readNamedWriteable(Processor.class);
        this.start = (Processor)in.readNamedWriteable(Processor.class);
        this.length = (Processor)in.readNamedWriteable(Processor.class);
    }

    public final void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.source);
        out.writeNamedWriteable((NamedWriteable)this.start);
        out.writeNamedWriteable((NamedWriteable)this.length);
    }

    @Override
    public Object process(Object input) {
        return SubstringFunctionProcessor.doProcess(this.source.process(input), this.start.process(input), this.length.process(input));
    }

    public static Object doProcess(Object source, Object start, Object length) {
        if (source == null) {
            return null;
        }
        if (!(source instanceof String) && !(source instanceof Character)) {
            throw new SqlIllegalArgumentException("A string/char is required; received [{}]", source);
        }
        if (start == null || length == null) {
            return source;
        }
        if (!(start instanceof Number)) {
            throw new SqlIllegalArgumentException("A number is required; received [{}]", start);
        }
        if (!(length instanceof Number)) {
            throw new SqlIllegalArgumentException("A number is required; received [{}]", length);
        }
        if (((Number)length).intValue() < 0) {
            throw new SqlIllegalArgumentException("A positive number is required for [length]; received [{}]", length);
        }
        return StringFunctionUtils.substring(source instanceof Character ? source.toString() : (String)source, ((Number)start).intValue() - 1, ((Number)length).intValue());
    }

    protected Processor source() {
        return this.source;
    }

    protected Processor start() {
        return this.start;
    }

    protected Processor length() {
        return this.length;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SubstringFunctionProcessor other = (SubstringFunctionProcessor)obj;
        return Objects.equals(this.source(), other.source()) && Objects.equals(this.start(), other.start()) && Objects.equals(this.length(), other.length());
    }

    public int hashCode() {
        return Objects.hash(this.source(), this.start(), this.length());
    }

    public String getWriteableName() {
        return NAME;
    }
}

