/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util.io;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.jna.JnaLoader;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfo;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileAttributes;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.win32.FileInfo;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.win32.IdeaWin32;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.CharsetToolkit;
import org.jetbrains.kotlin.com.intellij.util.SystemProperties;
import org.jetbrains.kotlin.com.intellij.util.containers.LimitedPool;
import org.jetbrains.kotlin.com.intellij.util.system.CpuArch;

public final class FileSystemUtil {
    @ApiStatus.Internal
    public static final boolean DO_NOT_RESOLVE_SYMLINKS = Boolean.getBoolean("idea.symlinks.no.resolve");
    private static final Logger LOG = Logger.getInstance(FileSystemUtil.class);
    private static final Mediator ourMediator = FileSystemUtil.computeMediator();
    private static volatile boolean ourLibExt2FsPresent = true;

    @NotNull
    static Mediator computeMediator() {
        block7: {
            if (!Boolean.getBoolean("idea.io.use.nio2")) {
                Mediator mediator;
                block6: {
                    if (!SystemInfo.isWindows || !IdeaWin32.isAvailable()) break block6;
                    Mediator mediator2 = FileSystemUtil.check(new IdeaWin32MediatorImpl());
                    if (mediator2 == null) {
                        FileSystemUtil.$$$reportNull$$$0(0);
                    }
                    return mediator2;
                }
                try {
                    if (!SystemInfo.isLinux && !SystemInfo.isMac || !CpuArch.isIntel64() || !JnaLoader.isLoaded() || !JnaLoader.isSupportsDirectMapping()) break block7;
                    mediator = FileSystemUtil.check(new JnaUnixMediatorImpl());
                }
                catch (Throwable t) {
                    LOG.warn("Failed to load filesystem access layer: " + SystemInfo.OS_NAME + ", " + SystemInfo.JAVA_VERSION, t);
                }
                if (mediator == null) {
                    FileSystemUtil.$$$reportNull$$$0(1);
                }
                return mediator;
            }
        }
        return new Nio2MediatorImpl();
    }

    private static Mediator check(Mediator mediator) throws Exception {
        String quickTestPath = SystemInfo.isWindows ? "C:\\" : "/";
        mediator.getAttributes(quickTestPath);
        return mediator;
    }

    private FileSystemUtil() {
    }

    @Nullable
    public static FileAttributes getAttributes(@NotNull String path) {
        if (path == null) {
            FileSystemUtil.$$$reportNull$$$0(2);
        }
        try {
            if (LOG.isTraceEnabled()) {
                long t = System.nanoTime();
                FileAttributes result2 = ourMediator.getAttributes(path);
                t = System.nanoTime() - t;
                LOG.trace("getAttributes(" + path + ") = " + result2 + " in " + TimeUnit.NANOSECONDS.toMicros(t) + " mks");
                return result2;
            }
            return ourMediator.getAttributes(path);
        }
        catch (Exception e) {
            LOG.warn("getAttributes(" + path + ")", e);
            return null;
        }
    }

    public static boolean isSymLink(@NotNull String path) {
        FileAttributes attributes2;
        if (path == null) {
            FileSystemUtil.$$$reportNull$$$0(5);
        }
        return (attributes2 = FileSystemUtil.getAttributes(path)) != null && attributes2.isSymLink();
    }

    public static boolean isSymLink(@NotNull File file2) {
        if (file2 == null) {
            FileSystemUtil.$$$reportNull$$$0(6);
        }
        return FileSystemUtil.isSymLink(file2.getAbsolutePath());
    }

    public static boolean clonePermissionsToExecute(@NotNull String source, @NotNull String target) {
        if (source == null) {
            FileSystemUtil.$$$reportNull$$$0(11);
        }
        if (target == null) {
            FileSystemUtil.$$$reportNull$$$0(12);
        }
        try {
            return ourMediator.clonePermissions(source, target, true);
        }
        catch (Exception e) {
            LOG.warn(e);
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 23: 
            case 25: 
            case 26: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 23: 
            case 25: 
            case 26: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/io/FileSystemUtil";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 13: 
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anyChild";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "computeMediator";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 23: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/io/FileSystemUtil";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "readParentCaseSensitivity";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "readParentCaseSensitivityByJavaIO";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "readCaseSensitivityByNativeAPI";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lastModified";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSymLink";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymLink";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "clonePermissions";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "clonePermissionsToExecute";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readParentCaseSensitivity";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readParentCaseSensitivityByJavaIO";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "readCaseSensitivityByNativeAPI";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isCaseToggleable";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findCaseToggleableChild";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 23: 
            case 25: 
            case 26: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Nio2MediatorImpl
    implements Mediator {
        private final LinkOption[] myNoFollowLinkOptions = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
        private final PosixFilePermission[] myExecPermissions = new PosixFilePermission[]{PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE};

        private Nio2MediatorImpl() {
        }

        @Override
        public FileAttributes getAttributes(@NotNull String pathStr) {
            if (pathStr == null) {
                Nio2MediatorImpl.$$$reportNull$$$0(0);
            }
            try {
                boolean isWritable;
                boolean isHidden;
                boolean isSymbolicLink;
                Path path = Paths.get(pathStr, new String[0]);
                Class schema = SystemInfo.isWindows ? DosFileAttributes.class : PosixFileAttributes.class;
                DosFileAttributes attributes2 = Files.readAttributes(path, schema, this.myNoFollowLinkOptions);
                boolean bl = isSymbolicLink = attributes2.isSymbolicLink() || SystemInfo.isWindows && attributes2.isOther() && attributes2.isDirectory() && path.getParent() != null;
                if (isSymbolicLink) {
                    try {
                        attributes2 = Files.readAttributes(path, schema, new LinkOption[0]);
                    }
                    catch (NoSuchFileException e) {
                        return FileAttributes.BROKEN_SYMLINK;
                    }
                }
                boolean isDirectory = attributes2.isDirectory();
                boolean isOther = attributes2.isOther();
                long size = attributes2.size();
                long lastModified = attributes2.lastModifiedTime().toMillis();
                if (SystemInfo.isWindows) {
                    isHidden = path.getParent() != null && attributes2.isHidden();
                    isWritable = isDirectory || !attributes2.isReadOnly();
                } else {
                    isHidden = false;
                    try {
                        isWritable = Files.isWritable(path);
                    }
                    catch (SecurityException e) {
                        isWritable = false;
                    }
                }
                return new FileAttributes(isDirectory, isOther, isSymbolicLink, isHidden, size, lastModified, isWritable);
            }
            catch (IOException | InvalidPathException e) {
                LOG.debug(pathStr, e);
                return null;
            }
        }

        @Override
        public boolean clonePermissions(@NotNull String source, @NotNull String target, boolean execOnly) throws IOException {
            Set<PosixFilePermission> newPermissions;
            if (source == null) {
                Nio2MediatorImpl.$$$reportNull$$$0(2);
            }
            if (target == null) {
                Nio2MediatorImpl.$$$reportNull$$$0(3);
            }
            if (!SystemInfo.isUnix) {
                return false;
            }
            Path sourcePath = Paths.get(source, new String[0]);
            Path targetPath = Paths.get(target, new String[0]);
            Set<PosixFilePermission> sourcePermissions = Files.readAttributes(sourcePath, PosixFileAttributes.class, new LinkOption[0]).permissions();
            Set<PosixFilePermission> targetPermissions = Files.readAttributes(targetPath, PosixFileAttributes.class, new LinkOption[0]).permissions();
            if (execOnly) {
                newPermissions = EnumSet.copyOf(targetPermissions);
                for (PosixFilePermission permission : this.myExecPermissions) {
                    if (sourcePermissions.contains((Object)permission)) {
                        newPermissions.add(permission);
                        continue;
                    }
                    newPermissions.remove((Object)permission);
                }
            } else {
                newPermissions = sourcePermissions;
            }
            Files.setAttribute(targetPath, "posix:permissions", newPermissions, new LinkOption[0]);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathStr";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/io/FileSystemUtil$Nio2MediatorImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAttributes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveSymLink";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clonePermissions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class JnaUnixMediatorImpl
    implements Mediator {
        private static final int[] LINUX_64 = new int[]{24, 48, 88, 28, 32};
        private static final int[] BSD_64 = new int[]{8, 72, 40, 12, 16};
        private final int[] myOffsets;
        private final int myUid;
        private final int myGid;
        private final boolean myCoarseTs = SystemProperties.getBooleanProperty("idea.io.coarse.ts", false);
        private final LimitedPool<Memory> myMemoryPool = new LimitedPool.Sync<Memory>(10, () -> new Memory(256L));

        JnaUnixMediatorImpl() {
            assert (JnaLoader.isSupportsDirectMapping()) : "Direct mapping not available on " + Platform.RESOURCE_PREFIX;
            if ("linux-x86-64".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = LINUX_64;
            } else if ("darwin-x86-64".equals(Platform.RESOURCE_PREFIX)) {
                this.myOffsets = BSD_64;
            } else {
                throw new IllegalStateException("Unsupported OS/arch: " + Platform.RESOURCE_PREFIX);
            }
            Map<String, String> options = Collections.singletonMap("string-encoding", CharsetToolkit.getPlatformCharset().name());
            NativeLibrary lib = NativeLibrary.getInstance((String)"c", options);
            Native.register(LibC.class, (NativeLibrary)lib);
            Native.register(SystemInfo.isLinux ? LinuxLibC.class : UnixLibC.class, (NativeLibrary)lib);
            this.myUid = LibC.getuid();
            this.myGid = LibC.getgid();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileAttributes getAttributes(@NotNull String path) {
            if (path == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(0);
            }
            Memory buffer = this.myMemoryPool.alloc();
            try {
                long mTime1;
                boolean isSymlink;
                int res2;
                int n = res2 = SystemInfo.isLinux ? LinuxLibC.__lxstat64(1, path, (Pointer)buffer) : UnixLibC.lstat(path, (Pointer)buffer);
                if (res2 != 0) {
                    FileAttributes fileAttributes = null;
                    return fileAttributes;
                }
                int mode = this.getModeFlags(buffer) & 0xFFFF;
                boolean bl = isSymlink = (mode & 0xF000) == 40960;
                if (isSymlink) {
                    if (!JnaUnixMediatorImpl.loadFileStatus(path, buffer)) {
                        FileAttributes fileAttributes = FileAttributes.BROKEN_SYMLINK;
                        return fileAttributes;
                    }
                    mode = this.getModeFlags(buffer) & 0xFFFF;
                }
                if (DO_NOT_RESOLVE_SYMLINKS) {
                    isSymlink = false;
                }
                boolean isDirectory = (mode & 0xF000) == 16384;
                boolean isSpecial = !isDirectory && (mode & 0xF000) != 32768;
                long size = buffer.getLong((long)this.myOffsets[1]);
                long l = mTime1 = Native.LONG_SIZE == 4 ? (long)buffer.getInt((long)this.myOffsets[2]) : buffer.getLong((long)this.myOffsets[2]);
                long mTime2 = this.myCoarseTs ? 0L : (Native.LONG_SIZE == 4 ? (long)buffer.getInt((long)(this.myOffsets[2] + 4)) : buffer.getLong((long)(this.myOffsets[2] + 8)));
                long mTime = mTime1 * 1000L + mTime2 / 1000000L;
                boolean writable = this.ownFile(buffer) ? (mode & 0x92) != 0 : LibC.access(path, 2) == 0;
                FileAttributes fileAttributes = new FileAttributes(isDirectory, isSpecial, isSymlink, false, size, mTime, writable);
                return fileAttributes;
            }
            finally {
                this.myMemoryPool.recycle(buffer);
            }
        }

        @Override
        public boolean clonePermissions(@NotNull String source, @NotNull String target, boolean execOnly) {
            int permissions;
            Memory buffer;
            if (source == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(2);
            }
            if (target == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(3);
            }
            if (!JnaUnixMediatorImpl.loadFileStatus(source, buffer = new Memory(256L))) {
                return false;
            }
            int sourcePermissions = this.getModeFlags(buffer) & 0x1FF;
            if (execOnly) {
                if (!JnaUnixMediatorImpl.loadFileStatus(target, buffer)) {
                    return false;
                }
                int targetPermissions = this.getModeFlags(buffer) & 0x1FF;
                permissions = targetPermissions & 0xFFFFFFB6 | sourcePermissions & 0x49;
            } else {
                permissions = sourcePermissions;
            }
            return LibC.chmod(target, permissions) == 0;
        }

        private static boolean loadFileStatus(@NotNull String path, @NotNull Memory buffer) {
            if (path == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(4);
            }
            if (buffer == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(5);
            }
            return (SystemInfo.isLinux ? LinuxLibC.__xstat64(1, path, (Pointer)buffer) : UnixLibC.stat(path, (Pointer)buffer)) == 0;
        }

        private int getModeFlags(@NotNull Memory buffer) {
            if (buffer == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(6);
            }
            return SystemInfo.isLinux ? buffer.getInt((long)this.myOffsets[0]) : (int)buffer.getShort((long)this.myOffsets[0]);
        }

        private boolean ownFile(@NotNull Memory buffer) {
            if (buffer == null) {
                JnaUnixMediatorImpl.$$$reportNull$$$0(7);
            }
            return buffer.getInt((long)this.myOffsets[3]) == this.myUid && buffer.getInt((long)this.myOffsets[4]) == this.myGid;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/io/FileSystemUtil$JnaUnixMediatorImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAttributes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveSymLink";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clonePermissions";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadFileStatus";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getModeFlags";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "ownFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static final class LinuxLibC {
            private LinuxLibC() {
            }

            static native int __lxstat64(int var0, String var1, Pointer var2);

            static native int __xstat64(int var0, String var1, Pointer var2);
        }

        private static final class UnixLibC {
            private UnixLibC() {
            }

            static native int lstat(String var0, Pointer var1);

            static native int stat(String var0, Pointer var1);
        }

        private static final class LibC {
            private LibC() {
            }

            static native int getuid();

            static native int getgid();

            static native int chmod(String var0, int var1);

            static native int access(String var0, int var1);
        }
    }

    private static class IdeaWin32MediatorImpl
    implements Mediator {
        private final IdeaWin32 myInstance = IdeaWin32.getInstance();

        private IdeaWin32MediatorImpl() {
        }

        @Override
        public FileAttributes getAttributes(@NotNull String path) {
            FileInfo fileInfo;
            if (path == null) {
                IdeaWin32MediatorImpl.$$$reportNull$$$0(0);
            }
            return (fileInfo = this.myInstance.getInfo(path)) != null ? fileInfo.toFileAttributes() : null;
        }

        @Override
        public boolean clonePermissions(@NotNull String source, @NotNull String target, boolean execOnly) {
            if (source == null) {
                IdeaWin32MediatorImpl.$$$reportNull$$$0(2);
            }
            if (target == null) {
                IdeaWin32MediatorImpl.$$$reportNull$$$0(3);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/io/FileSystemUtil$IdeaWin32MediatorImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAttributes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "resolveSymLink";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clonePermissions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface Mediator {
        @Nullable
        public FileAttributes getAttributes(@NotNull String var1) throws IOException;

        public boolean clonePermissions(@NotNull String var1, @NotNull String var2, boolean var3) throws IOException;
    }
}

