--
-- (C) 2019-24 - ntop.org
--

local alerts_api = require("alerts_api")
local alert_consts = require("alert_consts")
local alert_categories = require "alert_categories"

local script = {
  -- Script category
  category = alert_categories.internals,
  severity = alert_consts.get_printable_severities().error,

  -- See below
  hooks = {},

  gui = {
    i18n_title = "internals.system_alert_drops",
    i18n_description = "internals.system_alert_drops_descr",
  },
}

-- #################################################################

local function dropped_alerts_check(params)
   -- Fetch system host stats
   local system_host_stats =  ntop.systemHostStat()

   -- Fetch the number of dropped alerts out of system host stats
   -- The number fetched is the number of drops occured in the internal queue, that is,
   -- in the queue currently used to generate alerts from C
   local dropped_alerts = system_host_stats["alerts_stats"]["alert_queues"]["internal_alerts_queue"]["num_not_enqueued"]

   -- Compute the delta with the previous value for drops
   local delta_drops = alerts_api.interface_delta_val(script.key, params.granularity, dropped_alerts, true --[[ skip first --]])
   
   local alert = alert_consts.alert_types.alert_dropped_alerts.new(
      interface.getId(),
      delta_drops
      )

   alert:set_info(params)
   
   if(delta_drops > 0) then
      alert:trigger(params.alert_entity, nil, params.cur_alerts)
   else
      alert:release(params.alert_entity, nil, params.cur_alerts)
   end
end

-- #################################################################

script.hooks.min = dropped_alerts_check

-- #################################################################

return script
