/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ProfilingUtil;
import com.jetbrains.performancePlugin.MessagesBundle;
import com.jetbrains.performancePlugin.profilers.ProfilersController;
import com.jetbrains.performancePlugin.utils.StatisticCollector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FinishScriptDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private JTextField fileLabel;
    private JTextArea metricsPanel;
    private final File file;

    public FinishScriptDialog(@Nullable Project project) {
        super(project);
        File snapshot = null;
        this.$$$setupUI$$$();
        if (ProfilersController.getInstance().isStoppedByScript()) {
            String path = ProfilersController.getInstance().getReportsPath();
            try {
                snapshot = ProfilersController.getInstance().getCurrentProfilerHandler().compressResults(path, ProfilingUtil.formatSnapshotName());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage());
            }
        }
        assert (snapshot != null);
        this.file = snapshot;
        ProfilersController.getInstance().setReportsPath(snapshot.getParentFile().getAbsolutePath());
        this.fileLabel.setText(MessagesBundle.message("finish.path", snapshot.getAbsolutePath()));
        this.setTitle(MessagesBundle.message("finish.title", new Object[0]));
        this.fileLabel.setEditable(false);
        this.fileLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        String metrics = new StatisticCollector(project).collectMetrics();
        this.metricsPanel.setText(metrics);
        this.metricsPanel.setLineWrap(true);
        this.init();
        this.pack();
    }

    @NotNull
    protected Action[] createActions() {
        DialogWrapper.DialogWrapperAction send = new DialogWrapper.DialogWrapperAction(MessagesBundle.message("summary.action", new Object[0])){

            protected void doAction(ActionEvent e) {
                BrowserUtil.browse((String)MessagesBundle.message("summary.link", new Object[0]));
            }
        };
        DialogWrapper.DialogWrapperAction open = new DialogWrapper.DialogWrapperAction(MessagesBundle.message("finish.open", ShowFilePathAction.getFileManagerName())){

            protected void doAction(ActionEvent e) {
                ShowFilePathAction.openDirectory((File)FinishScriptDialog.this.file.getParentFile());
            }
        };
        Action[] actionArray = new Action[]{send, open, this.getOKAction()};
        if (actionArray == null) {
            FinishScriptDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/performancePlugin/ui/FinishScriptDialog", "createActions"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextArea jTextArea;
        JTextField jTextField;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        this.fileLabel = jTextField = new JTextField();
        Font font = this.$$$getFont$$$(null, 1, -1, jTextField.getFont());
        if (font != null) {
            jTextField.setFont(font);
        }
        jTextField.setText("");
        jPanel.add((Component)jTextField, "South");
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, "Center");
        this.metricsPanel = jTextArea = new JTextArea();
        jBScrollPane.setViewportView(jTextArea);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }
}

