/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInspection.LocalQuickFixBase;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;

class RoundPxValueQuickFix
extends LocalQuickFixBase {
    private static final String EMPTY_STRING = "";

    RoundPxValueQuickFix() {
        super(CssBundle.message((String)"css.inspections.float.px.length.fix.message", (Object[])new Object[0]));
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        if (project == null) {
            RoundPxValueQuickFix.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            RoundPxValueQuickFix.$$$reportNull$$$0(1);
        }
        if ((element = descriptor.getPsiElement()) instanceof CssTokenImpl) {
            String elementText = element.getText();
            try {
                double doubleValue = Double.parseDouble(elementText);
                ((CssTokenImpl)element).replaceWithText(String.valueOf(Math.round(doubleValue)));
            }
            catch (NumberFormatException e) {
                CommonRefactoringUtil.showErrorHint((Project)project, null, (String)CssBundle.message((String)"css.inspections.float.px.length.fix.error", (Object[])new Object[]{elementText}), (String)EMPTY_STRING, null);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptor";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/css/inspections/RoundPxValueQuickFix";
        objectArray[2] = "applyFix";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

