/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.importing;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.importing.ImportSpecImpl;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportSpecBuilder {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private ProgressExecutionMode myProgressExecutionMode;
    private boolean myForceWhenUptodate;
    private boolean myWhenAutoImportEnabled;
    @Nullable
    private ExternalProjectRefreshCallback myCallback;
    private boolean isPreviewMode;
    private boolean isReportRefreshError;
    @Nullable
    private String myVmOptions;
    @Nullable
    private String myArguments;
    private boolean myUseDefaultCallback;
    private boolean myCreateDirectoriesForEmptyContentRoots;

    public ImportSpecBuilder(@NotNull Project project, @NotNull ProjectSystemId id) {
        if (project == null) {
            ImportSpecBuilder.$$$reportNull$$$0(0);
        }
        if (id == null) {
            ImportSpecBuilder.$$$reportNull$$$0(1);
        }
        this.isReportRefreshError = true;
        this.myProject = project;
        this.myExternalSystemId = id;
        this.myProgressExecutionMode = ProgressExecutionMode.IN_BACKGROUND_ASYNC;
    }

    public ImportSpecBuilder(ImportSpec importSpec) {
        this(importSpec.getProject(), importSpec.getExternalSystemId());
        this.apply(importSpec);
    }

    public ImportSpecBuilder whenAutoImportEnabled() {
        this.myWhenAutoImportEnabled = true;
        return this;
    }

    public ImportSpecBuilder use(@NotNull ProgressExecutionMode executionMode) {
        if (executionMode == null) {
            ImportSpecBuilder.$$$reportNull$$$0(2);
        }
        this.myProgressExecutionMode = executionMode;
        return this;
    }

    public ImportSpecBuilder forceWhenUptodate() {
        return this.forceWhenUptodate(true);
    }

    public ImportSpecBuilder forceWhenUptodate(boolean force) {
        this.myForceWhenUptodate = force;
        return this;
    }

    public ImportSpecBuilder callback(@Nullable ExternalProjectRefreshCallback callback) {
        this.myCallback = callback;
        return this;
    }

    public ImportSpecBuilder usePreviewMode() {
        this.isPreviewMode = true;
        return this;
    }

    public ImportSpecBuilder createDirectoriesForEmptyContentRoots() {
        this.myCreateDirectoriesForEmptyContentRoots = true;
        return this;
    }

    public ImportSpecBuilder dontReportRefreshErrors() {
        this.isReportRefreshError = false;
        return this;
    }

    public ImportSpecBuilder withVmOptions(@Nullable String vmOptions) {
        this.myVmOptions = vmOptions;
        return this;
    }

    public ImportSpecBuilder withArguments(@Nullable String arguments) {
        this.myArguments = arguments;
        return this;
    }

    public ImportSpecBuilder useDefaultCallback() {
        this.myUseDefaultCallback = true;
        return this;
    }

    public ImportSpec build() {
        final ImportSpecImpl mySpec = new ImportSpecImpl(this.myProject, this.myExternalSystemId);
        mySpec.setWhenAutoImportEnabled(this.myWhenAutoImportEnabled);
        mySpec.setProgressExecutionMode(this.myProgressExecutionMode);
        mySpec.setForceWhenUptodate(this.myForceWhenUptodate);
        mySpec.setCreateDirectoriesForEmptyContentRoots(this.myCreateDirectoriesForEmptyContentRoots);
        if (this.myUseDefaultCallback) {
            mySpec.setCallback(new ExternalProjectRefreshCallback(){

                @Override
                public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                    if (externalProject == null) {
                        return;
                    }
                    boolean synchronous = mySpec.getProgressExecutionMode() == ProgressExecutionMode.MODAL_SYNC;
                    ServiceManager.getService(ProjectDataManager.class).importData(externalProject, mySpec.getProject(), synchronous);
                }
            });
        } else {
            mySpec.setCallback(this.myCallback);
        }
        mySpec.setPreviewMode(this.isPreviewMode);
        mySpec.setReportRefreshError(this.isReportRefreshError);
        mySpec.setArguments(this.myArguments);
        mySpec.setVmOptions(this.myVmOptions);
        return mySpec;
    }

    private void apply(ImportSpec spec) {
        this.myWhenAutoImportEnabled = spec.whenAutoImportEnabled();
        this.myProgressExecutionMode = spec.getProgressExecutionMode();
        this.myForceWhenUptodate = spec.isForceWhenUptodate();
        this.myCreateDirectoriesForEmptyContentRoots = spec.shouldCreateDirectoriesForEmptyContentRoots();
        this.myCallback = spec.getCallback();
        this.isPreviewMode = spec.isPreviewMode();
        this.isReportRefreshError = spec.isReportRefreshError();
        this.myArguments = spec.getArguments();
        this.myVmOptions = spec.getVmOptions();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionMode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/importing/ImportSpecBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "use";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

