/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.ID;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.completion.smartEnter.PhpSmartKeysConfiguration;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpClassIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFieldIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFunctionIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpNamespaceIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpVariableIndex;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpLookupElement
extends LookupElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.completion");
    private static final Set<String> KEYWORDS_TO_IGNORE = ContainerUtil.newHashSet((Object[])new String[]{"this", "parent", "self", "static"});
    @Nullable
    public InsertHandler handler;
    @NotNull
    public String lookupString;
    private ID myId;
    protected final String myFQN;
    @NotNull
    private final Project myProject;
    @NotNull
    public String typeText;
    @NotNull
    public String tailText;
    public boolean bold;
    public Icon icon;
    @Nullable
    private SmartPsiElementPointer<PhpNamedElement> myNamedElementPointer;
    PhpType myPhpType;
    private static final ID PARAM_FAKE_KEY = ID.create((String)"PARAM_FAKE_KEY");
    private static final ID CLASS_CONSTANT_FAKE_KEY = ID.create((String)"CLASS_CONSTANT_FAKE_KEY");

    public PhpLookupElement(@NotNull String name, @NotNull StubIndexKey indexKey, @NotNull Icon ico, PhpType phpType, @NotNull Project project, InsertHandler handler) {
        if (name == null) {
            PhpLookupElement.$$$reportNull$$$0(0);
        }
        if (indexKey == null) {
            PhpLookupElement.$$$reportNull$$$0(1);
        }
        if (ico == null) {
            PhpLookupElement.$$$reportNull$$$0(2);
        }
        if (project == null) {
            PhpLookupElement.$$$reportNull$$$0(3);
        }
        this.lookupString = "";
        this.typeText = "";
        this.tailText = "";
        this.bold = false;
        this.lookupString = name;
        this.myFQN = name;
        this.icon = ico;
        this.myId = indexKey;
        this.myPhpType = phpType;
        this.myProject = project;
        this.handler = handler;
    }

    public PhpLookupElement(@NotNull String name, @NotNull StubIndexKey indexKey, @NotNull Project project, InsertHandler handler) {
        if (name == null) {
            PhpLookupElement.$$$reportNull$$$0(4);
        }
        if (indexKey == null) {
            PhpLookupElement.$$$reportNull$$$0(5);
        }
        if (project == null) {
            PhpLookupElement.$$$reportNull$$$0(6);
        }
        this.lookupString = "";
        this.typeText = "";
        this.tailText = "";
        this.bold = false;
        this.lookupString = name;
        this.myFQN = name;
        this.myId = indexKey;
        this.myProject = project;
        this.handler = handler;
    }

    public PhpLookupElement(@NotNull PhpNamedElement namedElement) {
        if (namedElement == null) {
            PhpLookupElement.$$$reportNull$$$0(7);
        }
        this.lookupString = "";
        this.typeText = "";
        this.tailText = "";
        this.bold = false;
        this.myProject = namedElement.getProject();
        this.myNamedElementPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)namedElement);
        this.updatePresentation();
        this.myFQN = namedElement instanceof PhpClass || namedElement instanceof PhpNamespace || namedElement instanceof Function && !(namedElement instanceof Method) || namedElement instanceof Constant ? namedElement.getFQN() : this.lookupString;
    }

    private void updatePresentation() {
        PhpNamedElement myNamedElement = this.getNamedElement();
        assert (myNamedElement != null);
        try {
            this.icon = myNamedElement.getIcon();
            this.lookupString = myNamedElement.getName();
        }
        catch (PsiInvalidElementAccessException e) {
            throw new RuntimeException("myNamedElement = " + myNamedElement + " '" + myNamedElement.getName(), e);
        }
    }

    @NotNull
    public Object getObject() {
        PhpNamedElement myNamedElement = this.getNamedElement();
        String string = myNamedElement == null ? "" : myNamedElement;
        if (string == null) {
            PhpLookupElement.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getLookupString() {
        String string = this.lookupString;
        if (string == null) {
            PhpLookupElement.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void handleInsert(@NotNull InsertionContext context) {
        if (context == null) {
            PhpLookupElement.$$$reportNull$$$0(10);
        }
        if (this.handler != null) {
            boolean smartParametersTemplateActive;
            boolean shouldInsertArrow = context.getCompletionChar() == '.' && this.canInsertArrow(context);
            Template template = TemplateManager.getInstance((Project)this.myProject).getActiveTemplate(context.getEditor());
            boolean bl = smartParametersTemplateActive = template != null && "params".equals(template.getKey());
            if (smartParametersTemplateActive || shouldInsertArrow) {
                context.setAddCompletionChar(false);
            }
            this.handler.handleInsert(context, (LookupElement)this);
            if (!smartParametersTemplateActive && shouldInsertArrow) {
                PhpLookupElement.insertArrowAtTailOffset(context);
                AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
            }
        }
    }

    private boolean canInsertArrow(@NotNull InsertionContext context) {
        PsiElement element;
        if (context == null) {
            PhpLookupElement.$$$reportNull$$$0(11);
        }
        if ((element = context.getFile().findElementAt(context.getStartOffset())) == null || context.getEditor().getCaretModel().getCaretCount() != 1 || PhpUseImpl.getUseList(element) != null || PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)StringLiteralExpression.INSTANCEOF) != null || "self".equals(this.lookupString) || "parent".equals(this.lookupString) || "static".equals(this.lookupString) || this.hasPrimitiveOrArrayType(element)) {
            return false;
        }
        PsiElement targetElement = this.getPsiElement();
        if (targetElement instanceof Function) {
            return !PhpLookupElement.shouldHandleParameters((Function)targetElement);
        }
        if (targetElement instanceof PhpClass) {
            ClassReference classReference = (ClassReference)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)ClassReference.INSTANCEOF);
            return classReference != null && classReference.getUsageContext().isInNew() && !PhpLookupElement.shouldHandleParameters((Function)((PhpClass)targetElement).getConstructor());
        }
        return true;
    }

    private boolean hasPrimitiveOrArrayType(@NotNull PsiElement elementAt) {
        PhpNamedElement namedElement;
        if (elementAt == null) {
            PhpLookupElement.$$$reportNull$$$0(12);
        }
        PhpNamedElement typedElement = (namedElement = this.getNamedElement()) != null ? namedElement : elementAt.getParent();
        PhpType type = typedElement instanceof PhpTypedElement ? ((PhpTypedElement)typedElement).getType().global(elementAt.getProject()).filterUnknown() : null;
        return PhpLookupElement.isNotExtendablePrimitiveOrArrayType(type);
    }

    private static boolean isNotExtendablePrimitiveOrArrayType(@Nullable PhpType type) {
        return type != null && !type.isEmpty() && type.getTypes().stream().allMatch(t -> PhpType.isNotExtendablePrimitiveType((String)t) || PhpType.isArray((String)t) || PhpType.isPluralType((String)t));
    }

    private static boolean shouldHandleParameters(@Nullable Function function) {
        return function != null && function.getParameters().length > 0 && PhpSmartKeysConfiguration.getInstance().isSmartFunctionParametersCompletion();
    }

    private static void insertArrowAtTailOffset(@NotNull InsertionContext context) {
        if (context == null) {
            PhpLookupElement.$$$reportNull$$$0(13);
        }
        Editor editor = context.getEditor();
        ClassReference classReference = (ClassReference)PhpPsiUtil.getParentByCondition(context.getFile().findElementAt(context.getStartOffset()), (Condition<? super PsiElement>)ClassReference.INSTANCEOF);
        if (classReference != null) {
            PhpLookupElement.wrapConstructorInParens(editor, classReference);
        } else {
            editor.getCaretModel().moveToOffset(context.getTailOffset());
        }
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"->", (boolean)true, (int)2);
    }

    private static void wrapConstructorInParens(@NotNull Editor editor, @NotNull ClassReference classReference) {
        if (editor == null) {
            PhpLookupElement.$$$reportNull$$$0(14);
        }
        if (classReference == null) {
            PhpLookupElement.$$$reportNull$$$0(15);
        }
        PsiElement constructor = classReference.getParent();
        editor.getSelectionModel().setSelection(constructor.getTextRange().getStartOffset(), constructor.getTextRange().getEndOffset());
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("(" + constructor.getText() + ")"), (boolean)true);
    }

    public void renderElement(LookupElementPresentation presentation) {
        presentation.setItemText(this.getLookupString());
        PhpNamedElement myNamedElement = this.getNamedElement();
        if (myNamedElement != null) {
            if (this.myPhpType == null && presentation.isReal()) {
                this.myPhpType = myNamedElement.getType().global(this.myProject);
            }
            if (presentation.isReal()) {
                presentation.setStrikeout(myNamedElement.isDeprecated());
            }
            if (myNamedElement instanceof PhpClass) {
                this.typeText = "";
                this.tailText = PhpLookupElement.getNamespaceName(this.myFQN, myNamedElement);
                presentation.setItemText(myNamedElement.getName());
            } else {
                String value;
                String string = this.typeText = this.myPhpType != null ? this.myPhpType.toStringRelativized("\\") : "";
                if (myNamedElement instanceof Function) {
                    StringBuilder builder = new StringBuilder();
                    PhpPresentationUtil.formatParameters(builder, ((Function)myNamedElement).getParameters());
                    if (!(myNamedElement instanceof Method)) {
                        builder.append(PhpLookupElement.getNamespaceName(this.myFQN, myNamedElement));
                    }
                    this.tailText = builder.toString();
                } else if (myNamedElement instanceof Constant) {
                    StringBuilder builder = new StringBuilder();
                    String value2 = ((Constant)myNamedElement).getValuePresentation();
                    if (value2 != null) {
                        builder.append(" = ").append(value2);
                    }
                    builder.append(PhpLookupElement.getNamespaceName(this.myFQN, myNamedElement));
                    this.tailText = builder.toString();
                } else if (myNamedElement instanceof Field && (value = ((Field)myNamedElement).getDefaultValuePresentation()) != null) {
                    this.tailText = " = " + value;
                }
            }
        }
        if (this.typeText.isEmpty() && this.myPhpType != null) {
            this.typeText = this.myPhpType.toStringRelativized("\\");
        }
        if (!this.tailText.isEmpty()) {
            presentation.setTailText(this.tailText, true);
        }
        if (this.bold) {
            presentation.setItemTextBold(true);
        }
        if (!StringUtil.isEmpty((String)this.typeText) && !(myNamedElement instanceof PhpClass)) {
            presentation.setTypeText(this.typeText);
        }
        presentation.setIcon(this.icon);
    }

    private static String getNamespaceName(@Nullable String fqn, @NotNull PhpNamedElement namedElement) {
        if (namedElement == null) {
            PhpLookupElement.$$$reportNull$$$0(16);
        }
        String namespaceName = fqn != null ? PhpLangUtil.getParentNamespaceFQN(fqn) : namedElement.getNamespaceName();
        return namespaceName.length() > 2 ? " [" + namespaceName.substring(1, namespaceName.length() - 1) + "]" : "";
    }

    @Nullable
    public PhpNamedElement getNamedElement() {
        PhpNamedElement myNamedElement = null;
        if (this.myNamedElementPointer == null) {
            PhpIndex index = PhpIndex.getInstance((Project)this.myProject);
            if (!KEYWORDS_TO_IGNORE.contains(this.lookupString)) {
                String name;
                Collection items;
                Collection items2;
                if (this.myId == PhpFunctionIndex.KEY && (items2 = index.getFunctionsByName(this.lookupString)).size() > 0) {
                    myNamedElement = (PhpNamedElement)items2.iterator().next();
                }
                if (this.myId == PhpClassIndex.KEY && (items2 = index.getClassesByName(this.lookupString)).size() > 0) {
                    myNamedElement = (PhpNamedElement)items2.iterator().next();
                }
                if (this.myId == PhpConstantIndex.KEY && (items2 = index.getConstantsByName(this.lookupString)).size() > 0) {
                    myNamedElement = (PhpNamedElement)items2.iterator().next();
                }
                if (this.myId == PhpVariableIndex.KEY && (items = index.getVariablesByName(name = this.lookupString)).size() > 0) {
                    myNamedElement = (PhpNamedElement)items.iterator().next();
                }
                if (this.myId == PhpNamespaceIndex.KEY && (items2 = index.getNamespacesByName(this.lookupString)).size() > 0) {
                    myNamedElement = (PhpNamedElement)items2.iterator().next();
                }
            }
            if (myNamedElement == null) {
                if (!KEYWORDS_TO_IGNORE.contains(this.lookupString) && ApplicationManagerEx.getApplicationEx().isInternal()) {
                    LOG.warn("target element not found for lookupString = " + this.lookupString + " index=" + this.myId);
                }
                if (this.myId == null) {
                    this.myId = PhpVariableIndex.KEY;
                }
            } else {
                this.myNamedElementPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)myNamedElement);
                this.updatePresentation();
            }
        } else {
            myNamedElement = (PhpNamedElement)this.myNamedElementPointer.getElement();
        }
        return myNamedElement;
    }

    @Nullable
    public PhpType getPhpType() {
        PhpNamedElement namedElement;
        if (this.myPhpType == null && (namedElement = this.getNamedElement()) != null) {
            this.myPhpType = namedElement.getType().global(this.myProject);
        }
        return this.myPhpType;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            PhpLookupElement.$$$reportNull$$$0(17);
        }
        return project;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PhpLookupElement)) {
            return false;
        }
        PhpLookupElement that = (PhpLookupElement)((Object)o);
        return this.myFQN.equals(that.myFQN) && this.getId() == that.getId();
    }

    public int hashCode() {
        return this.myFQN.hashCode() * 31 + this.getId().hashCode();
    }

    private ID getId() {
        if (this.myId != null) {
            return this.myId;
        }
        PhpNamedElement myNamedElement = this.getNamedElement();
        if (myNamedElement instanceof Function) {
            this.myId = PhpFunctionIndex.KEY;
        } else if (myNamedElement instanceof Variable || myNamedElement instanceof PhpDocVariable) {
            this.myId = PhpVariableIndex.KEY;
        } else if (myNamedElement instanceof Field) {
            this.myId = ((Field)myNamedElement).isConstant() ? CLASS_CONSTANT_FAKE_KEY : PhpFieldIndex.KEY;
        } else if (myNamedElement instanceof Constant) {
            this.myId = PhpConstantIndex.KEY;
        } else if (myNamedElement instanceof PhpClass) {
            this.myId = PhpClassIndex.KEY;
        } else if (myNamedElement instanceof Parameter) {
            this.myId = PARAM_FAKE_KEY;
        } else if (myNamedElement instanceof PhpUse) {
            this.myId = PARAM_FAKE_KEY;
        } else if (myNamedElement instanceof PhpNamespace) {
            this.myId = PhpNamespaceIndex.KEY;
        }
        assert (myNamedElement != null);
        assert (this.myId != null) : myNamedElement.getClass().getName();
        return this.myId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ico";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 8: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/completion/PhpLookupElement";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAt";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/completion/PhpLookupElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 17: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canInsertArrow";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasPrimitiveOrArrayType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "insertArrowAtTailOffset";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "wrapConstructorInParens";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

