/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.actions.generation;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.MemberChooser;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.actions.PhpNamedElementNode;
import com.jetbrains.php.lang.actions.generation.PhpAddDocOptionsForm;
import com.jetbrains.php.lang.actions.generation.PhpDocCreationOption;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.refactoring.importReferences.PhpClassReferenceResolver;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpOverrideImplementMethodsHandlerBase
implements LanguageCodeInsightActionHandler {
    @Nullable
    private static Customizer ourCustomizer;
    private static final Condition<PsiElement> CLASS_MEMBER;

    public boolean isValidFor(Editor editor, PsiFile file) {
        PhpClass phpClass = PhpCodeEditUtil.findClassAtCaret(editor, file);
        return phpClass != null && !phpClass.isInterface();
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Object member;
        PhpDocCreationOption docOption;
        if (project == null) {
            PhpOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PhpOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(1);
        }
        if (file == null) {
            PhpOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(2);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        PhpClass me = PhpCodeEditUtil.findClassAtCaret(editor, file);
        if (me == null) {
            return;
        }
        LinkedHashMap methodsToOverride = ContainerUtil.newLinkedHashMap();
        ArrayList ownMethods = new ArrayList();
        PhpClassHierarchyUtils.processMethods((PhpClass)me, (PhpClass)me, (method, baseClass, subClass) -> {
            if (baseClass != subClass) {
                String name = method.getName();
                if (!methodsToOverride.containsKey(name) && this.canOverrideOrImplement(subClass, method)) {
                    methodsToOverride.put(name, method);
                }
            } else {
                ownMethods.add(method);
            }
            return true;
        }, (boolean)false);
        PhpClass obj = PhpClassHierarchyUtils.getObject((Project)project);
        if (obj != null) {
            for (Method method2 : obj.getMethods()) {
                if (methodsToOverride.containsKey(method2.getName())) continue;
                methodsToOverride.put(method2.getName(), method2);
            }
        }
        for (Method m : ownMethods) {
            methodsToOverride.remove(m.getName());
        }
        if (methodsToOverride.isEmpty()) {
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                HintManager.getInstance().showErrorHint(editor, this.getNoCandidatesHintMessage());
            }
            return;
        }
        Collection<PhpNamedElementNode> selectedElements = new ArrayList<PhpNamedElementNode>();
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            for (Method m : methodsToOverride.values()) {
                selectedElements.add(new PhpNamedElementNode((PhpNamedElement)m));
            }
            MyMemberChooser chooser = new MyMemberChooser(selectedElements.toArray(new PhpNamedElementNode[0]), project, this.getDialogTitle());
            chooser.show();
            if (chooser.getExitCode() != 0) {
                return;
            }
            docOption = chooser.getDocOption();
            Collection<Object> selected = chooser.getSelectedElements();
            if (selected == null) {
                selectedElements = Collections.emptyList();
            } else {
                selected = PhpOverrideImplementMethodsHandlerBase.fixOrderToBeAsOriginalFiles(selected);
                selectedElements = selected;
            }
        } else {
            if (ourCustomizer != null) {
                docOption = ourCustomizer.getDocCreationOption();
                for (Method m : methodsToOverride.values()) {
                    if (!ourCustomizer.shouldOverrideOrImplement(m)) continue;
                    selectedElements.add(new PhpNamedElementNode((PhpNamedElement)m));
                }
            } else {
                docOption = PhpDocCreationOption.COPY_IF_ABSTRACT;
                for (Method m : methodsToOverride.values()) {
                    selectedElements.add(new PhpNamedElementNode((PhpNamedElement)m));
                }
            }
            selectedElements = PhpOverrideImplementMethodsHandlerBase.fixOrderToBeAsOriginalFiles(selectedElements);
        }
        THashSet methodNames = new THashSet();
        PhpClassReferenceResolver resolver = new PhpClassReferenceResolver();
        StringBuilder text = new StringBuilder();
        for (PhpNamedElementNode n : selectedElements) {
            PhpReturnType returnType;
            Parameter[] parameters;
            Method m = (Method)n.getPsiElement();
            for (Parameter parameter : parameters = m.getParameters()) {
                resolver.processElement((PsiElement)parameter, false);
            }
            PhpDocComment comment = this.createChildPhpDocComment(m);
            if (comment != null) {
                resolver.processElement((PsiElement)comment);
            }
            if ((returnType = m.getReturnType()) != null) {
                resolver.processElement((PsiElement)returnType);
            }
            methodNames.add(m.getNameCS());
            if (text.length() > 0) {
                text.append("\n");
            }
            text.append(PhpCodeUtil.createOverridingMethodText(me, m, docOption));
        }
        PsiElement child = null;
        Object v0 = member = at == null ? null : PhpPsiUtil.getParentByCondition(at, false, CLASS_MEMBER);
        if (member != null && (child = member.getNextSibling()) instanceof PsiWhiteSpace) {
            child = child.getNextSibling();
        }
        if (at instanceof PsiWhiteSpace && at.getParent() == me) {
            boolean okplace = false;
            for (PsiElement e = at.getNextSibling(); e != null; e = e.getNextSibling()) {
                if (e instanceof Field || e instanceof Method) {
                    okplace = true;
                    break;
                }
                IElementType type = e.getNode().getElementType();
                if (type == PhpTokenTypes.chLBRACE) break;
                if (type != PhpTokenTypes.chRBRACE) continue;
                okplace = true;
                break;
            }
            if (okplace) {
                child = at;
            }
        }
        if (child == null) {
            child = me.getLastChild();
            text.append("\n");
        }
        if (child != null) {
            ASTNode childNode = child.getNode();
            assert (childNode != null);
            ASTNode prevNode = childNode.getTreePrev();
            if (prevNode != null) {
                if (prevNode.getElementType() == PhpTokenTypes.LINE_COMMENT) {
                    text.insert(0, '\n');
                } else if (prevNode.getElementType() == PhpDocElementTypes.DOC_COMMENT) {
                    child = prevNode.getPsi();
                }
            }
        }
        assert (child != null);
        int textOffset = child.getTextRange().getStartOffset();
        RangeMarker rangeMarker = editor.getDocument().createRangeMarker(textOffset, textOffset);
        rangeMarker.setGreedyToRight(true);
        editor.getCaretModel().moveToOffset(textOffset);
        ApplicationManager.getApplication().runWriteAction(() -> PhpOverrideImplementMethodsHandlerBase.lambda$invoke$2(me, editor, text, project, file, rangeMarker, (Set)methodNames, resolver));
    }

    @Nullable
    protected abstract PhpDocComment createChildPhpDocComment(@NotNull Method var1);

    @Nullable
    private static List<PsiElement> collectInsertedMethods(@NotNull PsiFile file, @NotNull CharSequence className, @NotNull Set<CharSequence> methodNames) {
        if (file == null) {
            PhpOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(3);
        }
        if (className == null) {
            PhpOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(4);
        }
        if (methodNames == null) {
            PhpOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(5);
        }
        if (!(file instanceof PhpFile)) {
            return null;
        }
        PhpClass clazz = PhpPsiUtil.findClass((PhpFile)file, (Condition<? super PhpClass>)((Condition)aClass -> {
            if (className == null) {
                PhpOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(6);
            }
            return PhpLangUtil.equalsClassNames(aClass.getNameCS(), className);
        }));
        if (clazz == null) {
            return null;
        }
        ArrayList<PsiElement> insertedMethods = new ArrayList<PsiElement>();
        for (Method method : clazz.getOwnMethods()) {
            if (!methodNames.contains(method.getNameCS())) continue;
            insertedMethods.add((PsiElement)method);
        }
        return insertedMethods;
    }

    private static Collection<PhpNamedElementNode> fixOrderToBeAsOriginalFiles(Collection<PhpNamedElementNode> selected) {
        selected = new ArrayList<PhpNamedElementNode>(selected);
        Collections.sort((List)selected, (o1, o2) -> {
            PsiFile containingFile2;
            PsiElement psiElement = o1.getPsiElement();
            PsiElement psiElement2 = o2.getPsiElement();
            PsiFile containingFile = psiElement.getContainingFile();
            if (containingFile == (containingFile2 = psiElement2.getContainingFile())) {
                return psiElement.getTextOffset() - psiElement2.getTextOffset();
            }
            return containingFile.getName().compareTo(containingFile2.getName());
        });
        return selected;
    }

    protected abstract String getNoCandidatesHintMessage();

    protected boolean canOverrideOrImplement(PhpClass baseClass, Method method) {
        return !(method instanceof PhpDocMethod) && PhpClassHierarchyUtils.methodCanHaveOverride((Method)method) && !method.getModifier().isFinal();
    }

    protected abstract String getDialogTitle();

    public boolean startInWriteAction() {
        return false;
    }

    public static void setCustomizer(@Nullable Customizer customizer) {
        ourCustomizer = customizer;
    }

    private static /* synthetic */ void lambda$invoke$2(PhpClass me, @NotNull Editor editor, StringBuilder text, @NotNull Project project, @NotNull PsiFile file, RangeMarker rangeMarker, Set methodNames, PhpClassReferenceResolver resolver) {
        if (editor == null) {
            PhpOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(7);
        }
        if (project == null) {
            PhpOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(8);
        }
        if (file == null) {
            PhpOverrideImplementMethodsHandlerBase.$$$reportNull$$$0(9);
        }
        PhpPsiElement scopeHolder = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)me);
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)text.toString());
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        CodeStyleManager.getInstance((Project)project).reformatText(file, rangeMarker.getStartOffset(), rangeMarker.getEndOffset() + 1);
        List<PsiElement> insertedMethods = PhpOverrideImplementMethodsHandlerBase.collectInsertedMethods(file, me.getNameCS(), methodNames);
        if (insertedMethods != null && scopeHolder != null) {
            resolver.importReferences(scopeHolder, insertedMethods);
        }
    }

    static {
        CLASS_MEMBER = element -> element instanceof Method || PhpPsiUtil.isOfType(element, PhpElementTypes.CLASS_FIELDS) || PhpPsiUtil.isOfType(element, PhpElementTypes.CLASS_CONSTANTS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodNames";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/actions/generation/PhpOverrideImplementMethodsHandlerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "collectInsertedMethods";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$collectInsertedMethods$3";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$invoke$2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Customizer {
        public PhpDocCreationOption getDocCreationOption() {
            return PhpDocCreationOption.COPY_IF_ABSTRACT;
        }

        public boolean shouldOverrideOrImplement(@NotNull Method m) {
            if (m == null) {
                Customizer.$$$reportNull$$$0(0);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/jetbrains/php/lang/actions/generation/PhpOverrideImplementMethodsHandlerBase$Customizer", "shouldOverrideOrImplement"));
        }
    }

    private static class MyMemberChooser
    extends MemberChooser<PhpNamedElementNode> {
        private static final String PHP_DOC_PROPERTY = "php.override.implement.member.chooser.php.doc";
        private final Project myProject;
        private final PhpAddDocOptionsForm myOptionsForm;

        MyMemberChooser(PhpNamedElementNode[] elements, @NotNull Project project, @NotNull String title) {
            if (project == null) {
                MyMemberChooser.$$$reportNull$$$0(0);
            }
            if (title == null) {
                MyMemberChooser.$$$reportNull$$$0(1);
            }
            super(false, true, project, false, null, null);
            this.myProject = project;
            this.setTitle(title);
            this.setCopyJavadocVisible(false);
            this.myOptionsForm = new PhpAddDocOptionsForm();
            this.myOptionControls = new JComponent[]{this.myOptionsForm.getTopPanel()};
            this.resetElements(elements);
            this.init();
            this.myOptionsForm.init(PropertiesComponent.getInstance((Project)this.myProject).getValue(PHP_DOC_PROPERTY));
        }

        public void dispose() {
            super.dispose();
            Disposer.dispose((Disposable)this.myOptionsForm);
        }

        public PhpDocCreationOption getDocOption() {
            return this.myOptionsForm.getDocOption();
        }

        protected void doOKAction() {
            super.doOKAction();
            PropertiesComponent.getInstance((Project)this.myProject).setValue(PHP_DOC_PROPERTY, this.myOptionsForm.getDocOption().name());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/actions/generation/PhpOverrideImplementMethodsHandlerBase$MyMemberChooser";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

