/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.patterns;

import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.injection.PhpElementPattern;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import dk.brics.automaton.AutomatonProvider;
import dk.brics.automaton.DatatypesAutomatonProvider;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpPatterns
extends PlatformPatterns {
    private static final int STRING_LITERAL_LIMIT = 10000;
    static final Map<String, RunAutomaton> map = ContainerUtil.createWeakKeyWeakValueMap();

    public static PhpElementPattern phpElement() {
        return new PhpElementPattern.Capture<PhpPsiElement>(PhpPsiElement.class);
    }

    public static PhpElementPattern phpFunctionReference() {
        return new PhpElementPattern.Capture<FunctionReference>(FunctionReference.class);
    }

    public static PhpElementPattern.Capture<StringLiteralExpression> phpLiteralExpression() {
        return PhpPatterns.phpLiteralExpression(null);
    }

    public static synchronized PhpElementPattern.Capture<StringLiteralExpression> phpLiteralMatchesBrics(@NotNull String pattern) {
        if (pattern == null) {
            PhpPatterns.$$$reportNull$$$0(0);
        }
        final RunAutomaton runAutomaton = map.computeIfAbsent(pattern, s -> {
            StringBuilder sb = new StringBuilder(s.length() * 5);
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == ' ') {
                    sb.append("<whitespacechar>");
                    continue;
                }
                if (Character.isUpperCase(c) && !PhpPatterns.notInSymbolRange(s, i)) {
                    sb.append('[').append(Character.toUpperCase(c)).append(Character.toLowerCase(c)).append(']');
                    continue;
                }
                sb.append(c);
            }
            RegExp regExp = new RegExp(sb.toString());
            return new RunAutomaton(regExp.toAutomaton((AutomatonProvider)new DatatypesAutomatonProvider()), true);
        });
        return new PhpElementPattern.Capture<StringLiteralExpression>(new InitialPatternCondition<StringLiteralExpression>(StringLiteralExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                StringLiteralExpression expr;
                if (o instanceof StringLiteralExpression && (expr = (StringLiteralExpression)o).getTextLength() < 10000) {
                    String value = expr.getContents();
                    boolean run = runAutomaton.run(value);
                    return run;
                }
                return false;
            }
        });
    }

    private static boolean notInSymbolRange(String s, int i) {
        return i + 1 < s.length() && s.charAt(i + 1) == '-' || i - 1 >= 0 && s.charAt(i - 1) == '-';
    }

    public static PhpElementPattern.Capture<StringLiteralExpression> phpLiteralExpression(final String name) {
        return new PhpElementPattern.Capture<StringLiteralExpression>(new InitialPatternCondition<StringLiteralExpression>(StringLiteralExpression.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                StringLiteralExpression s;
                return o instanceof StringLiteralExpression && (!PhpPsiUtil.isOfType((s = (StringLiteralExpression)o).getParent(), PhpElementTypes.CONCATENATION_EXPRESSION) || s.getPrevPsiSibling() == null) && (name == null && s.getName() == null || name != null && name.equalsIgnoreCase(s.getName()));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/jetbrains/php/lang/patterns/PhpPatterns", "phpLiteralMatchesBrics"));
    }
}

