/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.uml;

import com.intellij.diagram.ChangeTracker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.PsiChangeTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiFilter;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class PhpUmlChangeTracker
extends ChangeTracker<PhpClass, PsiNamedElement, ClassReference> {
    private static final PsiFilter<Method> METHOD_FILTER = new PsiFilter<Method>(Method.class){

        public boolean accept(Method element) {
            return true;
        }

        public boolean areEquivalent(Method e1, Method e2) {
            return PhpUmlChangeTracker.namedAreEquivalent((PhpNamedElement)e1, (PhpNamedElement)e2);
        }
    };
    private static final PsiFilter<Field> FIELD_FILTER = new PsiFilter<Field>(Field.class){

        public boolean accept(Field element) {
            return true;
        }

        public boolean areEquivalent(Field e1, Field e2) {
            return PhpUmlChangeTracker.namedAreEquivalent((PhpNamedElement)e1, (PhpNamedElement)e2);
        }
    };
    private static final PsiFilter<PhpClass> CLASS_FILTER = new PsiFilter<PhpClass>(PhpClass.class){

        public boolean accept(PhpClass element) {
            return true;
        }

        public boolean areEquivalent(PhpClass e1, PhpClass e2) {
            return PhpUmlChangeTracker.namedAreEquivalent((PhpNamedElement)e1, (PhpNamedElement)e2);
        }
    };
    private static final PsiFilter<PhpClass>[] NODE_FILTERS = new PsiFilter[]{CLASS_FILTER};
    private static final PsiFilter[] CONTENT_FILTERS = new PsiFilter[]{FIELD_FILTER, METHOD_FILTER};
    private static final PhpRefFilter EXTENDS_FILTER = new PhpRefFilter(PhpElementTypes.EXTENDS_LIST);
    private static final PhpRefFilter IMPLEMENTS_FILTER = new PhpRefFilter(PhpElementTypes.IMPLEMENTS_LIST);
    private static final PhpRefFilter[] REL_FILTERS = new PhpRefFilter[]{EXTENDS_FILTER, IMPLEMENTS_FILTER};
    private Map<PhpClass, FileStatus> map = null;

    private static boolean namedAreEquivalent(PhpNamedElement e1, PhpNamedElement e2) {
        try {
            return e1.getFQN().equals(e2.getFQN());
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public PhpUmlChangeTracker(Project project, PsiFile before, PsiFile after) {
        super(project, before, after);
    }

    public PsiFilter<PhpClass>[] getNodeFilters() {
        return NODE_FILTERS;
    }

    public PsiFilter<PsiNamedElement>[] getNodeContentFilters() {
        return CONTENT_FILTERS;
    }

    public PsiFilter<ClassReference>[] getRelationshipFilters() {
        return REL_FILTERS;
    }

    public String getPresentableName(PsiNamedElement e) {
        return super.getPresentableName(e);
    }

    public String getQualifiedName(PhpClass psiClass, VirtualFile containingFile) {
        return psiClass.getFQN();
    }

    public String getType(PsiNamedElement member) {
        PhpType type = null;
        if (member instanceof Method) {
            type = ((Method)member).getType();
        } else if (member instanceof Field) {
            type = ((Field)member).getType();
        }
        return type == null ? super.getType(member) : type.global(member.getProject()).toStringResolved();
    }

    public Map<PhpClass, FileStatus> getNodeElements() {
        if (this.map == null) {
            this.map = new HashMap<PhpClass, FileStatus>();
            for (PsiFilter<PhpClass> filter : this.getNodeFilters()) {
                this.map.putAll(PsiChangeTracker.getElementsChanged((PsiElement)this.getAfter(), (PsiElement)this.getBefore(), filter));
            }
        }
        return this.map;
    }

    public ChangeTracker.RelationshipInfo[] getRelationships() {
        ArrayList<ChangeTracker.RelationshipInfo> result = new ArrayList<ChangeTracker.RelationshipInfo>();
        for (PsiFilter<ClassReference> filter : this.getRelationshipFilters()) {
            Map map = PsiChangeTracker.getElementsChanged((PsiElement)this.getAfter(), (PsiElement)this.getBefore(), filter);
            ChangeTracker.EdgeType type = filter == EXTENDS_FILTER ? ChangeTracker.EdgeType.EXTENDS : ChangeTracker.EdgeType.IMPLEMENTS;
            for (ClassReference key : map.keySet()) {
                PhpClass cls = PhpUmlChangeTracker.getContainingClass((PhpPsiElement)key);
                if (cls == null) continue;
                result.add(new ChangeTracker.RelationshipInfo(cls.getFQN(), key.getFQN(), type, (FileStatus)map.get(key)));
            }
        }
        return result.toArray(ChangeTracker.RelationshipInfo.EMPTY);
    }

    @Nullable
    private static PhpClass getContainingClass(PhpPsiElement ref) {
        PsiElement cls;
        PsiElement p = ref.getParent();
        if (p != null && (cls = p.getParent()) instanceof PhpClass) {
            return (PhpClass)cls;
        }
        return null;
    }

    public PsiNamedElement findElementByFQN(Project project, String fqn) {
        Collection classes = PhpIndex.getInstance((Project)project).getClassesByFQN(fqn);
        return !classes.isEmpty() ? (PsiNamedElement)classes.iterator().next() : null;
    }

    private static class PhpRefFilter
    extends PsiFilter<ClassReference> {
        private final IElementType myRole;

        PhpRefFilter(IElementType role) {
            super(ClassReference.class);
            this.myRole = role;
        }

        public boolean accept(ClassReference element) {
            PsiElement parent = element.getParent();
            return PhpPsiUtil.isOfType(parent, this.myRole);
        }

        public boolean areEquivalent(ClassReference e1, ClassReference e2) {
            try {
                return e1.getFQN().equals(e2.getFQN()) && PhpUmlChangeTracker.getContainingClass((PhpPsiElement)e1).getFQN().equals(PhpUmlChangeTracker.getContainingClass((PhpPsiElement)e2).getFQN());
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException cce) {
                return false;
            }
        }
    }
}

