/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathBuilder;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.modules.ES6ImportAction;
import com.intellij.lang.javascript.modules.JSModuleFixDescriptor;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.modules.ModuleFixCreator;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJSModulesSearcher {
    private static final String[] FILES_WITH_EXPORTS = new String[]{"js", "jsx", "ts", "coffee", "csx"};
    @NotNull
    private final VirtualFile myModuleRoot;
    @NotNull
    private final ModuleFixCreator myModuleFixCreator;
    @NotNull
    private final ModuleReferenceInfo myModuleReferenceInfo;
    @NotNull
    private final PsiElement myNode;
    @NotNull
    private final ResolveResult[] myResolveResults;
    private final boolean myOnlyCommonJs;

    public NodeJSModulesSearcher(@NotNull VirtualFile moduleRoot, @NotNull ModuleReferenceInfo info, @NotNull PsiElement node, @NotNull ResolveResult[] results, @NotNull Set<VirtualFile> predefinedFiles, boolean onlyCommonJs) {
        if (moduleRoot == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(0);
        }
        if (info == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(1);
        }
        if (node == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(2);
        }
        if (results == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(3);
        }
        if (predefinedFiles == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(4);
        }
        this.myModuleReferenceInfo = info;
        this.myNode = node;
        this.myResolveResults = results;
        this.myModuleRoot = moduleRoot;
        this.myOnlyCommonJs = onlyCommonJs;
        this.myModuleFixCreator = new ModuleFixCreator(node.getProject(), predefinedFiles, this.myModuleReferenceInfo);
    }

    @NotNull
    public List<JSModuleFixDescriptor> find() {
        if (this.hasGlobalResolvedElement()) {
            List<JSModuleFixDescriptor> list = Collections.emptyList();
            if (list == null) {
                NodeJSModulesSearcher.$$$reportNull$$$0(5);
            }
            return list;
        }
        String referenceName = this.myModuleReferenceInfo.getContextName();
        if (StringUtil.isEmpty((String)referenceName)) {
            List<JSModuleFixDescriptor> list = Collections.emptyList();
            if (list == null) {
                NodeJSModulesSearcher.$$$reportNull$$$0(6);
            }
            return list;
        }
        this.processForName(referenceName);
        if (this.myModuleFixCreator.isEmpty()) {
            this.processAsNodeModuleName(referenceName);
        }
        List<JSModuleFixDescriptor> list = this.myModuleFixCreator.getFixDescriptors();
        if (list == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(7);
        }
        return list;
    }

    private void processForName(@NotNull String referenceName) {
        if (referenceName == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(8);
        }
        this.processHardcodedVariants();
        if (this.myModuleReferenceInfo.getParentName() != null) {
            this.processVariantsForQualifiedReference(this.myModuleReferenceInfo);
        } else {
            if (!this.processCoreModule(referenceName)) {
                return;
            }
            this.processMatchingExports(referenceName);
        }
        this.myModuleFixCreator.addShortModulesFor(this.myModuleFixCreator.getFixDescriptors());
    }

    private void processAsNodeModuleName(@NotNull String referenceName) {
        VirtualFile byName;
        if (referenceName == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(9);
        }
        if ((byName = NodeModuleUtil.getProjectChildModuleByName(this.myNode.getProject(), this.myModuleRoot, referenceName)) != null && byName.getNameWithoutExtension().equals(referenceName)) {
            this.myModuleFixCreator.addFix(new JSModuleFixDescriptor(ModuleFixCreator.ModuleType.nodejs, referenceName, byName, referenceName, null));
        }
    }

    private boolean processCoreModule(@NotNull String referenceName) {
        VirtualFile coreModule;
        if (referenceName == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(10);
        }
        if ((coreModule = NodeCoreLibraryManager.getInstance(this.myNode.getProject()).findCoreModuleFileByName(referenceName)) == null) {
            return true;
        }
        this.myModuleFixCreator.addFix(new JSModuleFixDescriptor(ModuleFixCreator.ModuleType.nodejs, coreModule.getNameWithoutExtension(), coreModule, referenceName, null));
        return false;
    }

    public boolean hasGlobalResolvedElement() {
        for (ResolveResult result2 : this.myResolveResults) {
            PsiElement element = result2.getElement();
            if (element == null || !this.myModuleFixCreator.isGlobalPredefinedElement(element)) continue;
            return true;
        }
        return false;
    }

    private void processHardcodedVariants() {
        ResolvedModuleInfo info;
        String referenceName = this.myModuleReferenceInfo.getContextName();
        if (!"React".equals(referenceName)) {
            return;
        }
        VirtualFile byName = NodeModuleUtil.getProjectChildModuleByName(this.myNode.getProject(), this.myModuleRoot, "react");
        if (byName != null && byName.isDirectory() && (info = NodeModuleDirectorySearchProcessor.PROCESSOR.loadDirectory(this.myModuleRoot, byName, ModuleType.NODE_MODULES_DIR, true)) != null) {
            VirtualFile moduleFile = info.getModuleMainFile();
            JSModuleFixDescriptor descriptor2 = new JSModuleFixDescriptor(ModuleFixCreator.ModuleType.nodejs, "react", moduleFile, "React", null);
            descriptor2.setDefaultExport(true);
            this.myModuleFixCreator.addFix(descriptor2);
        }
    }

    private void processCandidatesFromImportedFiles(@NotNull String referenceName) {
        PsiFile file2;
        if (referenceName == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(11);
        }
        if (!((file2 = this.myNode.getContainingFile()) instanceof JSFile)) {
            return;
        }
        Collection<ES6ImportDeclaration> imports = NodeJSModulesSearcher.findImportsInFile(file2);
        Set<JSFile> filesFromImport = NodeJSModulesSearcher.collectFilesFromImports(imports);
        for (JSFile jsFile : filesFromImport) {
            ResolveResult[] symbols = ES6PsiUtil.resolveSymbolInModule(referenceName, this.myNode, (JSElement)jsFile);
            List<PsiElement> elements = JSResolveResult.toElements(symbols);
            for (PsiElement element : elements) {
                if (!(element instanceof JSElementBase) || ((JSElementBase)element).getNamespace() != null || !referenceName.equals(((JSNamedElementBase)element).getName())) continue;
                this.processCandidate(element, true);
            }
        }
    }

    @NotNull
    private static Set<JSFile> collectFilesFromImports(@NotNull Collection<ES6ImportDeclaration> imports) {
        if (imports == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(12);
        }
        HashSet<JSFile> filesFromImport = new HashSet<JSFile>();
        for (ES6ImportDeclaration anImport : imports) {
            PsiFile psiFile;
            ES6FromClause fromClause = anImport.getFromClause();
            if (fromClause == null) continue;
            Collection elements = fromClause.resolveReferencedElements();
            if ((elements = ContainerUtil.filter((Collection)elements, element -> element != null && element.isValid())).size() != 1 || !((psiFile = ((PsiElement)elements.iterator().next()).getContainingFile()) instanceof JSFile)) continue;
            filesFromImport.add((JSFile)psiFile);
        }
        HashSet<JSFile> hashSet = filesFromImport;
        if (hashSet == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    private static Collection<ES6ImportDeclaration> findImportsInFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(14);
        }
        return ES6ImportPsiUtil.getImportDeclarations((PsiElement)file2);
    }

    private void processMatchingExports(@NotNull String referenceName) {
        if (referenceName == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(15);
        }
        Set resolveResultElements = ((StreamEx)StreamEx.of((Object[])this.myResolveResults).map(el -> (JSResolveResult)ObjectUtils.tryCast((Object)el, JSResolveResult.class)).nonNull().filter(el -> el.isValidResult() || "javascript.element.need.to.be.imported".equals(el.getResolveProblemKey()))).map(el -> el.getElement()).nonNull().toSet();
        for (PsiElement element : resolveResultElements) {
            this.processCandidate(element, true);
        }
        if (!this.myOnlyCommonJs) {
            HashSet indexCandidates = ContainerUtil.newHashSet(this.getES6OnlyCandidates(referenceName));
            indexCandidates.removeAll(resolveResultElements);
            this.processES6Candidates(indexCandidates, referenceName);
            if (this.myModuleFixCreator.isEmpty()) {
                this.processDefaultExportsByFileNames(referenceName);
            }
            if (this.myModuleFixCreator.isEmpty()) {
                this.processCandidatesFromImportedFiles(referenceName);
            }
        }
    }

    private void processDefaultExportsByFileNames(@NotNull String referenceName) {
        if (referenceName == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(16);
        }
        ArrayList filesList = new ArrayList();
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(this.myNode);
        for (String extension : FILES_WITH_EXPORTS) {
            ContainerUtil.addAll(filesList, (Object[])FilenameIndex.getFilesByName((Project)this.myNode.getProject(), (String)(referenceName + "." + extension), (GlobalSearchScope)scope));
        }
        for (PsiFile psiFile : filesList) {
            JSModuleFixDescriptor descriptor2;
            JSElement export;
            if (!(psiFile instanceof JSFile) || (export = ES6PsiUtil.findDefaultExport((PsiElement)psiFile)) == null || (descriptor2 = this.addFixFromFile(null, psiFile, null, ModuleFixCreator.ModuleType.es6)) == null) continue;
            descriptor2.setDefaultExport(true);
        }
    }

    private void searchWithSymbolNameIndex(@NotNull Project project, @NotNull String referenceName) {
        if (project == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(17);
        }
        if (referenceName == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(18);
        }
        ArrayList elementsToProcess = new ArrayList();
        DelegatingGlobalSearchScope scope = this.getModulesOnlyScope();
        StubIndex.getInstance().processElements(JSSymbolIndex2.KEY, (Object)referenceName, project, (GlobalSearchScope)scope, JSElement.class, Processors.cancelableCollectProcessor(elementsToProcess));
        for (JSElement element : elementsToProcess) {
            this.processCandidate((PsiElement)element, false);
        }
    }

    @NotNull
    private List<JSElement> getES6OnlyCandidates(@NotNull String referenceName) {
        if (referenceName == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(19);
        }
        List<JSElement> list = new ES6ImportAction(this.myNode, referenceName, this.getES6ImportFilter()).getCandidates();
        if (list == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    private ES6ImportAction.ImportElementFilter getES6ImportFilter() {
        ES6ImportAction.ImportElementFilter importElementFilter = new ES6ImportAction.ImportElementFilter(){

            @Override
            @NotNull
            public List<JSElement> filterByContext(@NotNull PsiElement context, @NotNull List<JSElement> result2) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (result2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                List list = ((StreamEx)StreamEx.of(result2).filter(NodeJSModulesSearcher.this.myModuleReferenceInfo::isAcceptable)).toList();
                if (list == null) {
                    1.$$$reportNull$$$0(2);
                }
                return list;
            }

            @Override
            public boolean isValidContext(@NotNull PsiElement context) {
                if (context == null) {
                    1.$$$reportNull$$$0(3);
                }
                return context.isValid();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/modules/NodeJSModulesSearcher$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/modules/NodeJSModulesSearcher$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "filterByContext";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "filterByContext";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "isValidContext";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (importElementFilter == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(21);
        }
        return importElementFilter;
    }

    private void processES6Candidates(@NotNull Collection<JSElement> es6Candidates, @NotNull String name) {
        if (es6Candidates == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(22);
        }
        if (name == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(23);
        }
        for (JSElement candidate : es6Candidates) {
            if (candidate instanceof JSExportAssignment) {
                this.addDescriptorForES6Element((PsiElement)candidate, name, true);
                continue;
            }
            if (!(candidate instanceof JSElementBase)) continue;
            this.addDescriptorForES6Element((PsiElement)candidate, name, ((JSElementBase)candidate).isExportedWithDefault());
        }
    }

    @NotNull
    private DelegatingGlobalSearchScope getModulesOnlyScope() {
        final PsiManager manager = this.myNode.getManager();
        DelegatingGlobalSearchScope delegatingGlobalSearchScope = new DelegatingGlobalSearchScope(GlobalSearchScope.allScope((Project)this.myNode.getProject())){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!super.contains(file2)) {
                    return false;
                }
                PsiFile psiFile = manager.findFile(file2);
                return psiFile instanceof JSFile && ((JSFile)psiFile).isCommonJSModule();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher$2", "contains"));
            }
        };
        if (delegatingGlobalSearchScope == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(24);
        }
        return delegatingGlobalSearchScope;
    }

    private void processCandidate(@NotNull PsiElement element, boolean isUnqualifiedReference) {
        PsiFile file2;
        if (element == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(25);
        }
        if (!((file2 = element.getContainingFile()) instanceof JSFile && element.isValid() && file2.isValid())) {
            return;
        }
        if (!(element instanceof JSQualifiedNamedElement)) {
            return;
        }
        JSQualifiedName elementNamespace = ((JSQualifiedNamedElement)element).getJSNamespace().getQualifiedName();
        if (!this.myModuleReferenceInfo.isAcceptable(element)) {
            return;
        }
        JSFile jsFile = (JSFile)file2;
        if (!this.processModuleExports(element, isUnqualifiedReference, elementNamespace, jsFile)) {
            return;
        }
        if (!NodeJSModulesSearcher.isES6Context(file2)) {
            return;
        }
        this.processES6Exports((JSQualifiedNamedElement)element, isUnqualifiedReference);
    }

    private boolean processModuleExports(@NotNull PsiElement element, boolean isUnqualifiedReference, @Nullable JSQualifiedName elementNamespace, @NotNull JSFile jsFile) {
        String namespaceName;
        if (element == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(26);
        }
        if (jsFile == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(27);
        }
        String aliasText = jsFile.getExportsInnerAlias() == null ? null : jsFile.getExportsInnerAlias().getTypeText();
        String string = namespaceName = elementNamespace == null ? null : elementNamespace.getName();
        if (elementNamespace != null) {
            String exportName;
            JSModuleFixDescriptor descriptor2;
            boolean isAlias = namespaceName.equals(aliasText);
            if ((NodeJSModulesSearcher.isExports(namespaceName) || isAlias) && (descriptor2 = this.addFixFromFile(element, (PsiFile)jsFile, exportName = isUnqualifiedReference ? ((JSQualifiedNamedElement)element).getName() : null, ModuleFixCreator.ModuleType.nodejs)) != null) {
                if (isUnqualifiedReference) {
                    descriptor2.moduleElementIsMissing();
                }
                if (ES6ImportPsiUtil.isFlowTypeDefinition(element)) {
                    descriptor2.setIsFlowType(true);
                }
                return false;
            }
        }
        return true;
    }

    private static boolean isES6Context(@NotNull PsiFile file2) {
        if (file2 == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(28);
        }
        return DialectDetector.isES6((PsiElement)file2) || DialectDetector.isTypeScript((PsiElement)file2);
    }

    private void processES6Exports(@NotNull JSQualifiedNamedElement element, boolean isUnqualifiedReference) {
        if (element == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(29);
        }
        String nameInExports = isUnqualifiedReference ? element.getName() : null;
        ContextInfo contextStatement = null;
        if (element.isExported() || (contextStatement = new ContextInfo(element)).isExported()) {
            if (!element.isExported() && contextStatement != null && contextStatement.getExportedName() != null) {
                nameInExports = contextStatement.getExportedName();
            }
            boolean isDefault = contextStatement != null && contextStatement.myIsDefaultExported;
            this.addDescriptorForES6Element((PsiElement)element, nameInExports, isDefault);
        }
    }

    private void addDescriptorForES6Element(@NotNull PsiElement importedElement, @Nullable String nameInExports, boolean isDefault) {
        JSModuleFixDescriptor descriptor2;
        if (importedElement == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(30);
        }
        if ((descriptor2 = this.addFixFromFile(importedElement, importedElement.getContainingFile(), nameInExports, ModuleFixCreator.ModuleType.es6)) != null) {
            descriptor2.setDefaultExport(isDefault);
            descriptor2.setIsFlowType(ES6ImportPsiUtil.isFlowTypeDefinition(importedElement));
        }
    }

    private static boolean isExports(String text) {
        return "exports".equals(text) || "module.exports".equals(text);
    }

    private void processVariantsForQualifiedReference(@NotNull ModuleReferenceInfo moduleReferenceInfo) {
        if (moduleReferenceInfo == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(31);
        }
        Collection<PsiElement> results = this.myModuleReferenceInfo.getResolvedParent();
        for (PsiElement resolveResult : results) {
            this.processCandidate(resolveResult, false);
        }
        if (moduleReferenceInfo.getParentName() != null && results.isEmpty()) {
            this.searchWithSymbolNameIndex(this.myNode.getProject(), this.myModuleReferenceInfo.getParentName());
        }
    }

    private JSModuleFixDescriptor addFixFromFile(@Nullable PsiElement importedElement, @NotNull PsiFile targetPsiFile, @Nullable String nameInExports, @NotNull ModuleFixCreator.ModuleType moduleType) {
        VirtualFile targetFile;
        VirtualFile file2;
        if (targetPsiFile == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(32);
        }
        if (moduleType == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(33);
        }
        if ((file2 = this.myNode.getContainingFile().getVirtualFile()).equals(targetFile = targetPsiFile.getVirtualFile())) {
            return null;
        }
        if (!NodeModuleUtil.checkNodeModulesAssociation(targetPsiFile, this.myOnlyCommonJs) && !NodeJSModulesSearcher.isCoreModuleFile(this.myNode, targetFile)) {
            return null;
        }
        JSModuleNameInfo info = NodeJSModulesSearcher.getModuleInfo(this.myNode, importedElement, targetPsiFile);
        JSModuleFixDescriptor descriptor2 = NodeJSModulesSearcher.createFixDescriptionFromFile(info, moduleType, this.myModuleReferenceInfo.getContextName(), nameInExports);
        if (descriptor2 != null) {
            this.myModuleFixCreator.addFix(descriptor2);
        }
        return this.myModuleFixCreator.isNoFixesShouldBeSuggested() ? null : descriptor2;
    }

    public static JSModuleFixDescriptor createFixDescriptionFromFile(@Nullable JSModuleNameInfo info, @NotNull ModuleFixCreator.ModuleType moduleType, @Nullable String refName, @Nullable String nameInExports) {
        if (moduleType == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(34);
        }
        if (info == null) {
            return null;
        }
        VirtualFile module = info.getResolvedFile();
        if (refName == null) {
            return null;
        }
        return new JSModuleFixDescriptor(moduleType, info.getModuleName(), module, refName, nameInExports);
    }

    @Nullable
    public static JSModuleNameInfo getModuleInfo(@NotNull PsiElement place, @Nullable PsiElement importedElement, @NotNull PsiFile targetPsiFile) {
        if (place == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(35);
        }
        if (targetPsiFile == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(36);
        }
        VirtualFile targetFile = targetPsiFile.getVirtualFile();
        return ES6CreateImportUtil.getExternalFileModuleName(JSImportPathBuilder.createBuilder(place, importedElement, targetFile, false));
    }

    public static boolean isCoreModuleFile(@NotNull PsiElement place, @NotNull VirtualFile targetFile) {
        if (place == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(37);
        }
        if (targetFile == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(38);
        }
        return NodeCoreLibraryManager.getInstance(place.getProject()).isCoreModuleLibraryFile(targetFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 20: 
            case 21: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 20: 
            case 21: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRoot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedFiles";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 20: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/NodeJSModulesSearcher";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 14: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "es6Candidates";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 25: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedElement";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleReferenceInfo";
                break;
            }
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPsiFile";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/NodeJSModulesSearcher";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFilesFromImports";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getES6OnlyCandidates";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getES6ImportFilter";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesOnlyScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 20: 
            case 21: 
            case 24: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processForName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processAsNodeModuleName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processCoreModule";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processCandidatesFromImportedFiles";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectFilesFromImports";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findImportsInFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processMatchingExports";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processDefaultExportsByFileNames";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "searchWithSymbolNameIndex";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getES6OnlyCandidates";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processES6Candidates";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processCandidate";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processModuleExports";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isES6Context";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processES6Exports";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addDescriptorForES6Element";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processVariantsForQualifiedReference";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addFixFromFile";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createFixDescriptionFromFile";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getModuleInfo";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isCoreModuleFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 20: 
            case 21: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ContextInfo {
        private boolean myIsExported;
        private boolean myIsDefaultExported;
        private final PsiElement myContextElement;
        private String myExportedName;

        ContextInfo(@NotNull JSQualifiedNamedElement element) {
            JSQualifiedNamedElement current;
            if (element == null) {
                ContextInfo.$$$reportNull$$$0(0);
            }
            for (current = element; !(current instanceof JSStatement) && !(current instanceof JSFile) && current != null; current = current.getContext()) {
                if (this.myIsExported || !(current instanceof JSElementBase) || !(current instanceof JSNamedElement)) continue;
                JSElementBase elementBase = (JSElementBase)current;
                boolean directlyExported = elementBase.isExported();
                this.myIsDefaultExported = elementBase.isExportedWithDefault();
                if (!directlyExported && !this.myIsDefaultExported) continue;
                this.myExportedName = ((JSNamedElement)current).getName();
                this.myIsExported = true;
            }
            this.myContextElement = current;
            if (this.myContextElement instanceof ES6ExportDefaultAssignment) {
                this.myExportedName = ((ES6ExportDefaultAssignment)this.myContextElement).getInitializerReference();
                this.myIsExported = true;
                this.myIsDefaultExported = true;
            }
        }

        public boolean isExported() {
            return this.myIsExported;
        }

        public PsiElement getContextElement() {
            return this.myContextElement;
        }

        public String getExportedName() {
            return this.myExportedName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/modules/NodeJSModulesSearcher$ContextInfo", "<init>"));
        }
    }
}

