/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.ecmascript6.types.JSTypeResolvedHashCodeUtil;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSCompositeTypeBaseImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure {
    protected static final JSType.LocalTypeKey COMPOSITE_SUBSTITUTE_RESULT = JSType.createLocalTypeKey((String)"js.composite.type.substitute.result");
    @NotNull
    private final List<JSType> myTypes;

    @Contract(value="null -> true")
    public static boolean isEmptyType(@Nullable JSType type) {
        return type == null || type instanceof TypeScriptNeverJSTypeImpl;
    }

    public static boolean isNullOrUndefinedType(@Nullable JSType type) {
        return type instanceof JSUndefinedType || type instanceof JSNullType;
    }

    @NotNull
    public static List<JSType> flattenTypes(@NotNull Stream<? extends JSType> stream, @NotNull Class<? extends JSUnionOrIntersectionType> toFlatClass) {
        if (stream == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(0);
        }
        if (toFlatClass == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(1);
        }
        List list = JSCompositeTypeBaseImpl.flattenTypesStream((StreamEx<? extends JSType>)StreamEx.of(stream), toFlatClass).toList();
        if (list == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static StreamEx<JSType> flattenTypesStream(@NotNull StreamEx<? extends JSType> stream, @NotNull Class<? extends JSUnionOrIntersectionType> toFlatClass) {
        if (stream == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(3);
        }
        if (toFlatClass == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(4);
        }
        ProgressManager.checkCanceled();
        StreamEx streamEx = stream.flatMap(el -> {
            if (toFlatClass == null) {
                JSCompositeTypeBaseImpl.$$$reportNull$$$0(33);
            }
            return toFlatClass.isInstance(el) ? JSCompositeTypeBaseImpl.flattenTypesStream((StreamEx<? extends JSType>)StreamEx.of(((JSUnionOrIntersectionType)el).getTypes()), toFlatClass) : StreamEx.of((Object)el);
        });
        if (streamEx == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(5);
        }
        return streamEx;
    }

    @Nullable
    protected static JSType getTypeOfType(@Nullable JSType type, boolean allowResolve) {
        if (!allowResolve) {
            return type;
        }
        if (type instanceof JSTypeImpl && ((JSTypeImpl)type).isWidened()) {
            return ((JSTypeImpl)type).widen(true);
        }
        return type instanceof JSEvaluableType ? type.substitute() : type;
    }

    @NotNull
    private static JSType asNotNull(@Nullable JSType el, @NotNull JSTypeSource source) {
        if (source == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(6);
        }
        JSType jSType = el == null ? new JSUndefinedType(source) : el;
        if (jSType == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(7);
        }
        return jSType;
    }

    public JSCompositeTypeBaseImpl(JSTypeSource source, JSType ... _types) {
        this(source, (StreamEx<? extends JSType>)StreamEx.of((Object[])_types));
    }

    public JSCompositeTypeBaseImpl(@NotNull JSTypeSource source, Collection<? extends JSType> _types) {
        if (source == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(8);
        }
        this(source, (StreamEx<? extends JSType>)StreamEx.of(_types));
    }

    public JSCompositeTypeBaseImpl(@NotNull JSTypeSource source, StreamEx<? extends JSType> _types) {
        if (source == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(9);
        }
        super(source);
        this.myTypes = _types.map(el -> {
            if (source == null) {
                JSCompositeTypeBaseImpl.$$$reportNull$$$0(32);
            }
            return JSCompositeTypeBaseImpl.asNotNull(el, source);
        }).toImmutableList();
    }

    protected JSCompositeTypeBaseImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(10);
        }
        if (inputStream == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(11);
        }
        super(source);
        this.myTypes = JSTypeSerializer.TYPES_SERIALIZER.read(source, inputStream);
    }

    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(12);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPES_SERIALIZER.write(this.myTypes, outputStream);
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        String delimiter = this.getTypeSeparatorForTypeText(format);
        String string = this.getPresentableTypes(this.myTypes, format).stream().filter(el -> el != null).map(currentType -> {
            String presentation = this.getNestedTypePresentation(format, (JSType)currentType);
            return this.shouldWrapNestedType((JSType)currentType) ? "(" + presentation + ")" : presentation;
        }).collect(Collectors.joining(delimiter));
        if (string == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    protected String getTypeSeparatorForTypeText(@NotNull JSType.TypeTextFormat format) {
        if (format == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(14);
        }
        String string = format == JSType.TypeTextFormat.PRESENTABLE || this.isTypeScript() && format == JSType.TypeTextFormat.CODE ? " " + this.getTypeSeparator() + " " : this.getTypeSeparator();
        if (string == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    private List<JSType> getPresentableTypes(List<JSType> types, JSType.TypeTextFormat format) {
        if (format != JSType.TypeTextFormat.CODE) {
            return types;
        }
        ArrayList newTypes = ContainerUtil.newArrayList();
        ProcessingContext ctx = new ProcessingContext();
        for (JSType type : types) {
            if (newTypes.stream().anyMatch(t -> this.areTypesPresentablyEquivalent((JSType)t, type, ctx))) continue;
            newTypes.add(type);
        }
        return newTypes;
    }

    protected boolean areTypesPresentablyEquivalent(JSType t, JSType type, ProcessingContext ctx) {
        if (t.isEquivalentTo(type, ctx)) {
            return true;
        }
        if (t instanceof JSPrimitiveLiteralType && type instanceof JSPrimitiveLiteralType && ((JSPrimitiveLiteralType)t).allowWidening() && ((JSPrimitiveLiteralType)type).allowWidening()) {
            return ((JSPrimitiveLiteralType)t).asPrimitiveType().isEquivalentTo(((JSPrimitiveLiteralType)type).asPrimitiveType(), ctx);
        }
        return false;
    }

    private boolean shouldWrapNestedType(@NotNull JSType currentType) {
        if (currentType == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(16);
        }
        return currentType instanceof JSUnionOrIntersectionType && this.getClass() != currentType.getClass() || currentType instanceof JSFunctionTypeImpl;
    }

    protected String getNestedTypePresentation(JSType.TypeTextFormat format, JSType t) {
        return t.getTypeText(format);
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(17);
        }
        Iterator<JSType> iterator = ((JSCompositeTypeBaseImpl)type).getTypes().iterator();
        for (JSType jsType : this.getTypes()) {
            if (iterator.hasNext() && jsType.isEquivalentTo(iterator.next(), processingContext, allowResolve)) continue;
            return false;
        }
        return !iterator.hasNext();
    }

    @NotNull
    public final List<JSType> getTypes() {
        List<JSType> list = this.myTypes;
        if (list == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(18);
        }
        return list;
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSCompositeBaseType((JSType)this);
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        for (JSType type : this.myTypes) {
            type.accept(visitor);
        }
    }

    @Override
    @NotNull
    protected abstract String getTypeSeparator();

    @Override
    @NotNull
    protected final JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(19);
        }
        ArrayList newTypes = ContainerUtil.newArrayList();
        List<JSType> oldTypes = this.getTypes();
        for (JSType jsType : oldTypes) {
            newTypes.add(JSTypeUtils.transformTypeHierarchySafe(jsType, childTransform));
        }
        if (ContainerUtil.equalsIdentity((List)newTypes, oldTypes)) {
            JSCompositeTypeBaseImpl jSCompositeTypeBaseImpl = this;
            if (jSCompositeTypeBaseImpl == null) {
                JSCompositeTypeBaseImpl.$$$reportNull$$$0(20);
            }
            return jSCompositeTypeBaseImpl;
        }
        JSType jSType = this.createType(newTypes, this.getSource(), false);
        if (jSType == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(21);
        }
        return jSType;
    }

    @NotNull
    protected abstract JSType createType(@NotNull List<JSType> var1, @NotNull JSTypeSource var2, boolean var3);

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(22);
        }
        JSType jSType = this.createType(this.getTypes(), source, true);
        if (jSType == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(23);
        }
        return jSType;
    }

    @Nullable
    protected JSType getSimpleCompositeTypeResult() {
        List<JSType> types = this.getTypes();
        if (types.size() == 1) {
            return (JSType)ContainerUtil.getFirstItem(types, null);
        }
        if (types.isEmpty()) {
            return JSAnyType.get(this.getSource().getSourceElement(), this.getSource().isStrict());
        }
        return null;
    }

    @Override
    @NotNull
    public final JSType substitute() {
        JSType jSType = this.getLocalCachedType(this::substituteCompositeImpl, COMPOSITE_SUBSTITUTE_RESULT);
        if (jSType == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(24);
        }
        return jSType;
    }

    @NotNull
    protected abstract JSType substituteCompositeImpl();

    @Override
    protected int resolvedHashCodeImpl() {
        return Objects.hash(this.getClass(), JSTypeResolvedHashCodeUtil.getResolvedHashCode(this.getTypes()));
    }

    @NotNull
    protected Collection<JSRecordType> getNestedTypesAsRecordType() {
        List list = ContainerUtil.map(this.getTypes(), JSType::asRecordType);
        if (list == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(25);
        }
        return list;
    }

    @NotNull
    public final JSType transformTypes(@NotNull NullableFunction<? super JSType, JSType> converter) {
        List<JSType> originalTypes;
        List result2;
        if (converter == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(26);
        }
        if (ContainerUtil.equalsIdentity((List)(result2 = StreamEx.of(originalTypes = this.getTypes()).map(el -> {
            if (converter == null) {
                JSCompositeTypeBaseImpl.$$$reportNull$$$0(31);
            }
            return (JSType)converter.fun(el);
        }).nonNull().toList()), originalTypes)) {
            JSCompositeTypeBaseImpl jSCompositeTypeBaseImpl = this;
            if (jSCompositeTypeBaseImpl == null) {
                JSCompositeTypeBaseImpl.$$$reportNull$$$0(27);
            }
            return jSCompositeTypeBaseImpl;
        }
        if (result2.isEmpty()) {
            TypeScriptNeverJSTypeImpl typeScriptNeverJSTypeImpl = new TypeScriptNeverJSTypeImpl(this.getSource());
            if (typeScriptNeverJSTypeImpl == null) {
                JSCompositeTypeBaseImpl.$$$reportNull$$$0(28);
            }
            return typeScriptNeverJSTypeImpl;
        }
        if (result2.size() == 1) {
            JSType jSType = (JSType)result2.get(0);
            if (jSType == null) {
                JSCompositeTypeBaseImpl.$$$reportNull$$$0(29);
            }
            return jSType;
        }
        JSType jSType = this.createType(result2, this.getSource(), false);
        if (jSType == null) {
            JSCompositeTypeBaseImpl.$$$reportNull$$$0(30);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 1: 
            case 4: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toFlatClass";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSCompositeTypeBaseImpl";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 22: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSCompositeTypeBaseImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenTypesStream";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "asNotNull";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSeparatorForTypeText";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getNestedTypesAsRecordType";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "transformTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "flattenTypes";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "flattenTypesStream";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "asNotNull";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSeparatorForTypeText";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "shouldWrapNestedType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "transformTypes";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$transformTypes$5";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$1";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$flattenTypesStream$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

