/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.documentation.JSExternalLibraryDocBundle;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSProjectUtil {
    public static boolean isInLibrary(@NotNull PsiElement element) {
        JSClass jsClass;
        if (element == null) {
            JSProjectUtil.$$$reportNull$$$0(0);
        }
        if ((jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)element, JSClass.class, (boolean)false)) != null && JSResolveUtil.isObjectClass(jsClass)) {
            return true;
        }
        return JSProjectUtil.isInLibrary(element.getContainingFile());
    }

    public static boolean isInLibrary(@Nullable PsiFile file2) {
        if (file2 == null) {
            return false;
        }
        if (file2.getContext() != null) {
            file2 = file2.getContext().getContainingFile();
        }
        if (file2 == null) {
            return false;
        }
        VirtualFile vFile = file2.getOriginalFile().getVirtualFile();
        return JSProjectUtil.isInLibrary(vFile, file2.getProject());
    }

    public static boolean isInLibrary(@Nullable VirtualFile vFile, @NotNull Project project) {
        if (project == null) {
            JSProjectUtil.$$$reportNull$$$0(1);
        }
        if (vFile == null) {
            return false;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return index.isInLibrarySource(vFile) || index.isInLibraryClasses(vFile);
    }

    @Nullable
    public static ScriptingFrameworkDescriptor detectFramework(@NotNull String url) {
        String baseKey;
        if (url == null) {
            JSProjectUtil.$$$reportNull$$$0(2);
        }
        if ((baseKey = JSDocumentationUtils.getBaseKey(url)) == null) {
            return null;
        }
        String name = JSExternalLibraryDocBundle.getLibraryName(baseKey);
        if (name == null) {
            return null;
        }
        String versionMatcher = JSExternalLibraryDocBundle.getVersionMatcher(baseKey);
        String version = null;
        if (versionMatcher != null && url.matches("^.*(" + versionMatcher + ").*$")) {
            version = url.replaceFirst("^.*(" + versionMatcher + ").*$", "$1");
        }
        return new ScriptingFrameworkDescriptor(name, version);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSProjectUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInLibrary";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "detectFramework";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

