/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla.injection;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiModificationTracker;
import com.jetbrains.php.joomla.injection.builder.JDatabaseQuery;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.Map;

public class JoomlaSQLCaches
implements BaseComponent,
Disposable {
    public Map<PsiElement, JDatabaseQuery> SQL_CACHE = Collections.synchronizedMap(new THashMap());
    final Project myProject;

    public JoomlaSQLCaches(Project project) {
        this.myProject = project;
        LowMemoryWatcher.register(() -> this.clearCaches(), (Disposable)project);
    }

    public void initComponent() {
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(PsiModificationTracker.TOPIC, (Object)new PsiModificationTracker.Listener(){

            public void modificationCountChanged() {
                JoomlaSQLCaches.this.clearCaches();
            }
        });
    }

    public void dispose() {
        this.clearCaches();
    }

    private void clearCaches() {
        Map<PsiElement, JDatabaseQuery> type_cache = this.SQL_CACHE;
        if (this.SQL_CACHE.size() > 0) {
            this.SQL_CACHE = Collections.synchronizedMap(new THashMap());
            type_cache.clear();
        }
    }

    public static JoomlaSQLCaches getInstance(Project project) {
        return (JoomlaSQLCaches)project.getComponent(JoomlaSQLCaches.class);
    }
}

