/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.plugins.cucumber.psi.GherkinKeywordTable;
import org.jetbrains.plugins.cucumber.psi.PlainGherkinKeywordProvider;

public class GherkinKeywordList {
    private final Map<String, String> myKeyword2BaseNameTable = new THashMap();
    private final Set<String> myKeywordsWithNoSpaceAfter = new THashSet();
    private final GherkinKeywordTable myKeywordsTable = new GherkinKeywordTable();

    public GherkinKeywordList() {
    }

    public GherkinKeywordList(HashMap<Object, Object> hashMap) {
        Boolean forceSpaceAfterKeyword = null;
        for (Map.Entry<Object, Object> e : hashMap.entrySet()) {
            String key = e.getKey().toString();
            String value = e.getValue().toString();
            if (key.equals("space_after_keyword")) {
                forceSpaceAfterKeyword = Boolean.valueOf(value);
            } else if (!(key.equals("name") || key.equals("native") || key.equals("encoding"))) {
                String[] keywords = value.split("\\|");
                String baseKeyword = StringUtil.toTitleCase((String)key.replace("_", " "));
                IElementType type = GherkinKeywordList.getTokenTypeByBaseKeyword(baseKeyword);
                for (String keyword : keywords) {
                    if (keyword.endsWith("<")) {
                        keyword = keyword.substring(0, keyword.length() - 1);
                        this.myKeywordsWithNoSpaceAfter.add(keyword);
                    }
                    this.myKeyword2BaseNameTable.put(keyword, baseKeyword);
                    this.myKeywordsTable.put(type, keyword);
                }
            }
            if (forceSpaceAfterKeyword == null) continue;
            if (forceSpaceAfterKeyword.booleanValue()) {
                this.myKeywordsWithNoSpaceAfter.clear();
                continue;
            }
            this.myKeywordsWithNoSpaceAfter.addAll(this.myKeyword2BaseNameTable.keySet());
        }
    }

    public Collection<String> getAllKeywords() {
        return this.myKeyword2BaseNameTable.keySet();
    }

    public GherkinKeywordTable getKeywordsTable() {
        return this.myKeywordsTable;
    }

    public boolean isSpaceAfterKeyword(String keyword) {
        return !this.myKeywordsWithNoSpaceAfter.contains(keyword);
    }

    public IElementType getTokenType(String keyword) {
        return GherkinKeywordList.getTokenTypeByBaseKeyword(this.getBaseKeyword(keyword));
    }

    private static IElementType getTokenTypeByBaseKeyword(String baseKeyword) {
        return PlainGherkinKeywordProvider.DEFAULT_KEYWORDS.get(baseKeyword);
    }

    public String getBaseKeyword(String keyword) {
        return this.myKeyword2BaseNameTable.get(keyword);
    }
}

