/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.parser;

import org.w3c.css.parser.AtRule;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssValue;

public class AtRuleKeyframes
extends AtRule {
    static final CssIdent to = CssIdent.getIdent("to");
    static final CssIdent from = CssIdent.getIdent("from");
    String name = null;

    public static void checkSelectorValue(CssValue selector, ApplContext ac) throws InvalidParamException {
        switch (selector.getType()) {
            case 4: {
                CssPercentage percentage = selector.getPercentage();
                if (percentage.isPositive() && !(percentage.floatValue() > 100.0f)) break;
                throw new InvalidParamException("range", ac);
            }
            case 0: {
                CssIdent id = (CssIdent)selector;
                if (to.equals(id) || from.equals(id)) break;
            }
            default: {
                throw new InvalidParamException("selectorname", selector.toString(), ac);
            }
        }
    }

    @Override
    public String keyword() {
        return "keyframes";
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean canApply(AtRule atRule) {
        return false;
    }

    @Override
    public boolean canMatch(AtRule atRule) {
        return false;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String lookupPrefix() {
        return "";
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append('@');
        ret.append(this.keyword());
        ret.append(' ');
        ret.append(this.name);
        return ret.toString();
    }

    public AtRuleKeyframes(String name) {
        this.name = name;
    }
}

