/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.injection;

import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.blade.injection.BladeInjectionInfo;
import com.jetbrains.php.blade.injection.BladeInjectionMappingService;
import com.jetbrains.php.blade.lexer.BladeCustomizedLexer;
import com.jetbrains.php.blade.lexer.BladeLexer;
import com.jetbrains.php.blade.parser.BladeElementTypes;
import com.jetbrains.php.blade.psi.BladeTokenSets;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import com.jetbrains.php.lang.highlighter.PhpHighlightingLexer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BladeInjectingLexer
extends DelegateLexer {
    private static final Logger LOG = Logger.getInstance(BladeInjectingLexer.class);
    private static final boolean FORCE_SYSTEM_OUT_PRINTLN = false;
    @Nullable
    private final Project myProject;
    private final Lexer myPhpLexer;
    private boolean isInPhp = false;
    private int phpCodeBeginningOffset = 0;
    private int phpCodeIgnoredPrefixLength = 0;
    private int phpCodeEndOffset = 0;
    @Nullable
    private String myLatestDirectiveText;

    public BladeInjectingLexer(@Nullable Project project) {
        super((Lexer)new BladeLexer(project));
        this.myProject = project;
        this.myPhpLexer = new PhpHighlightingLexer();
    }

    private int getBladeOffsetFromPhp(int offsetInPhp) {
        return BladeInjectingLexer.getBladeOffsetFromPhp(offsetInPhp, this.phpCodeBeginningOffset, this.phpCodeIgnoredPrefixLength);
    }

    private static int getBladeOffsetFromPhp(int offsetInPhp, int phpCodeBeginningOffset1, int phpCodeIgnoredPrefixLength1) {
        return phpCodeBeginningOffset1 + offsetInPhp - phpCodeIgnoredPrefixLength1;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            BladeInjectingLexer.$$$reportNull$$$0(0);
        }
        if (initialState <= BladeCustomizedLexer.getMaximumState()) {
            this.isInPhp = false;
            super.start(buffer, startOffset, endOffset, initialState);
        } else {
            this.isInPhp = true;
            super.start(buffer, startOffset, endOffset, initialState % BladeCustomizedLexer.getMaximumState());
            this.myPhpLexer.start(buffer, startOffset, endOffset, initialState / BladeCustomizedLexer.getMaximumState() - 1);
        }
        this.updateLatestDirectiveText(this.myDelegate.getTokenType());
        this.debug("Started:", true);
    }

    public int getState() {
        if (this.isInPhp) {
            return (this.myPhpLexer.getState() + 1) * BladeCustomizedLexer.getMaximumState() + this.myDelegate.getState();
        }
        return this.myDelegate.getState();
    }

    @Nullable
    public IElementType getTokenType() {
        return this.isInPhp ? this.myPhpLexer.getTokenType() : this.myDelegate.getTokenType();
    }

    public int getTokenStart() {
        if (this.isInPhp) {
            int bladeOffset = this.getUnvalidatedPhpTokenStart();
            this.debug("Got token start with offset " + bladeOffset, false);
            this.assertInLog(bladeOffset <= this.phpCodeEndOffset);
            return Math.max(bladeOffset, this.phpCodeBeginningOffset);
        }
        return this.myDelegate.getTokenStart();
    }

    private int getUnvalidatedPhpTokenStart() {
        int phpTokenStart = this.myPhpLexer.getTokenStart();
        return this.getBladeOffsetFromPhp(phpTokenStart);
    }

    public int getTokenEnd() {
        if (this.isInPhp) {
            int bladeOffset = this.getUnvalidatedPhpTokenEnd();
            this.debug("Got token end with offset " + bladeOffset, false);
            this.assertInLog(bladeOffset > this.phpCodeBeginningOffset);
            return Math.min(bladeOffset, this.phpCodeEndOffset);
        }
        return this.myDelegate.getTokenEnd();
    }

    private int getUnvalidatedPhpTokenEnd() {
        int phpTokenEnd = this.myPhpLexer.getTokenEnd();
        return this.getBladeOffsetFromPhp(phpTokenEnd);
    }

    public void advance() {
        if (this.isInPhp) {
            this.advanceInPhp();
        } else {
            this.advanceInBlade();
        }
    }

    private void advanceInBlade() {
        this.myDelegate.advance();
        IElementType currentTokenType = this.myDelegate.getTokenType();
        BladeInjectionInfo injectionInfo = null;
        if (currentTokenType != null) {
            IElementType parsingCompatibleType = BladeInjectingLexer.getParsingCompatibleType(currentTokenType);
            injectionInfo = BladeInjectionMappingService.getInstance(this.myProject).getInfo(parsingCompatibleType, this.myLatestDirectiveText);
        }
        if (injectionInfo == null) {
            this.updateLatestDirectiveText(currentTokenType);
            this.debug("Advanced in Blade:", true);
            return;
        }
        this.myLatestDirectiveText = null;
        this.debug("Advanced in Blade too far:", true);
        this.enterPhpPart(injectionInfo);
        String phpText = injectionInfo.getPhpPrefix() + this.myDelegate.getTokenText() + injectionInfo.getPhpSuffix();
        this.debug("Advance: moved to php text: " + phpText, false);
        this.myPhpLexer.start((CharSequence)phpText);
        this.debug("Advance: started in  PHP. Now", true);
        while (this.myPhpLexer.getTokenEnd() <= this.phpCodeIgnoredPrefixLength) {
            this.myPhpLexer.advance();
            this.debug("Advanced in PHP a little more to", true);
        }
        this.assertInLog(this.phpCodeIgnoredPrefixLength >= this.myPhpLexer.getTokenStart());
        if (this.phpCodeIgnoredPrefixLength > this.myPhpLexer.getTokenStart()) {
            this.debug("Php element intersects code border", true);
        }
    }

    private static IElementType getParsingCompatibleType(IElementType type) {
        if (type == BladeTokenTypes.DIRECTIVE_PARAMETER_CONTENT) {
            return BladeElementTypes.DIRECTIVE_PARAMETER;
        }
        if (type == BladeElementTypes.DIRECTIVE_PARAMETER) {
            return BladeTokenTypes.DIRECTIVE_PARAMETER_CONTENT;
        }
        if (type == BladeTokenTypes.TEXT_BLOCK_CONTENT) {
            return BladeElementTypes.TEXT_BLOCK;
        }
        if (type == BladeElementTypes.TEXT_BLOCK) {
            return BladeTokenTypes.TEXT_BLOCK_CONTENT;
        }
        if (type == BladeTokenTypes.ESCAPED_TEXT_BLOCK_CONTENT) {
            return BladeElementTypes.ESCAPED_TEXT_BLOCK;
        }
        if (type == BladeElementTypes.ESCAPED_TEXT_BLOCK) {
            return BladeTokenTypes.ESCAPED_TEXT_BLOCK_CONTENT;
        }
        if (type == BladeTokenTypes.RAW_TEXT_BLOCK_CONTENT) {
            return BladeElementTypes.RAW_TEXT_BLOCK;
        }
        if (type == BladeElementTypes.RAW_TEXT_BLOCK) {
            return BladeTokenTypes.RAW_TEXT_BLOCK_CONTENT;
        }
        return type;
    }

    private void updateLatestDirectiveText(IElementType currentTokenType) {
        if (currentTokenType != BladeTokenTypes.WHITESPACE && currentTokenType != BladeTokenTypes.DIRECTIVE_LBRACE) {
            this.myLatestDirectiveText = BladeTokenSets.DIRECTIVES.contains(currentTokenType) ? this.myDelegate.getTokenText() : null;
        }
    }

    private void enterPhpPart(@NotNull BladeInjectionInfo injectionInfo) {
        if (injectionInfo == null) {
            BladeInjectingLexer.$$$reportNull$$$0(1);
        }
        this.isInPhp = true;
        this.phpCodeBeginningOffset = this.myDelegate.getTokenStart();
        this.debug("phpCodeBeginningOffset=" + this.phpCodeBeginningOffset, false);
        this.phpCodeEndOffset = this.myDelegate.getTokenEnd();
        this.debug("phpCodeEndOffset=" + this.phpCodeEndOffset, false);
        this.phpCodeIgnoredPrefixLength = injectionInfo.getPhpPrefix().length();
        this.debug("phpCodeIgnoredPrefixLength=" + this.phpCodeIgnoredPrefixLength, false);
    }

    private void advanceInPhp() {
        this.myPhpLexer.advance();
        this.debug("First advance in php", true);
        int phpTokenInBladeEndOffset = this.getUnvalidatedPhpTokenEnd();
        if (phpTokenInBladeEndOffset >= this.phpCodeEndOffset) {
            int phpTokenInBladeStartOffset = this.getUnvalidatedPhpTokenStart();
            if (phpTokenInBladeEndOffset == this.phpCodeEndOffset && phpTokenInBladeStartOffset <= this.phpCodeEndOffset && this.myPhpLexer.getTokenType() != null) {
                this.debug("Php code still belongs to us:", true);
                return;
            }
            if (phpTokenInBladeStartOffset < this.phpCodeEndOffset) {
                this.debug("Php element intersects code border", true);
                return;
            }
            this.debug("Advanced in php too far, changed to blade:", true);
            this.exitPhpPart();
            this.advanceInBlade();
        }
    }

    private void exitPhpPart() {
        this.isInPhp = false;
        this.phpCodeBeginningOffset = 0;
        this.phpCodeIgnoredPrefixLength = 0;
        this.phpCodeEndOffset = 0;
        this.debug("Left php part", false);
        this.myLatestDirectiveText = null;
    }

    private void debug(@NonNls String message, boolean provideInfo) {
        if (!provideInfo) {
            LOG.debug(message);
        } else if (LOG.isDebugEnabled()) {
            String textRange;
            String text;
            String lang;
            if (this.isInPhp) {
                lang = "PHP";
                int start = this.getUnvalidatedPhpTokenStart();
                int end = this.getUnvalidatedPhpTokenEnd();
                text = this.myPhpLexer.getTokenText();
                textRange = start > this.phpCodeEndOffset || start == this.phpCodeEndOffset && end > this.phpCodeEndOffset ? "Fully after php element: (" + start + ", " + end + ")" : (end < this.phpCodeBeginningOffset || end == this.phpCodeBeginningOffset && start < this.phpCodeBeginningOffset ? "Fully before php element: (" + start + ", " + end + ")" : "(" + start + ", " + end + ")");
            } else {
                lang = "Blade";
                int start = this.myDelegate.getTokenStart();
                int end = this.myDelegate.getTokenEnd();
                text = this.myDelegate.getTokenText();
                textRange = "(" + start + ", " + end + ")";
            }
            this.debug(message + " " + lang + " " + this.getTokenType() + " " + textRange + " " + text, false);
        }
    }

    private void assertInLog(boolean assertion) {
        if (assertion) {
            return;
        }
        LOG.error(this.getBufferSequence() + "\n" + this.getCurrentPosition());
    }

    @NotNull
    public LexerPosition getCurrentPosition() {
        BladeInjectingLexerPosition bladeInjectingLexerPosition = new BladeInjectingLexerPosition((BladeLexer)this.myDelegate, this.myPhpLexer, this.isInPhp, this.phpCodeBeginningOffset, this.phpCodeEndOffset, this.phpCodeIgnoredPrefixLength, this.myLatestDirectiveText);
        if (bladeInjectingLexerPosition == null) {
            BladeInjectingLexer.$$$reportNull$$$0(2);
        }
        return bladeInjectingLexerPosition;
    }

    public void restore(@NotNull LexerPosition position) {
        if (position == null) {
            BladeInjectingLexer.$$$reportNull$$$0(3);
        }
        this.restore((BladeInjectingLexerPosition)position);
    }

    private void restore(@NotNull BladeInjectingLexerPosition position) {
        if (position == null) {
            BladeInjectingLexer.$$$reportNull$$$0(4);
        }
        this.debug("Restored, before ", true);
        this.isInPhp = position.isInPhp();
        this.phpCodeBeginningOffset = position.getPhpCodeBeginningOffset();
        this.phpCodeEndOffset = position.getPhpCodeEndOffset();
        this.phpCodeIgnoredPrefixLength = position.getPhpCodeIgnoredPrefixLength();
        this.myLatestDirectiveText = position.getLatestDirectiveText();
        this.myDelegate.restore(position.getBladePosition());
        this.myPhpLexer.restore(position.getPhpPosition());
        this.debug("Restored, after", true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/blade/injection/BladeInjectingLexer";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/blade/injection/BladeInjectingLexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "enterPhpPart";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BladeInjectingLexerPosition
    implements LexerPosition {
        private final LexerPosition myBladePosition;
        private final LexerPosition myPhpPosition;
        private final boolean isInPhp;
        private final int phpCodeBeginningOffset;
        private final int phpCodeIgnoredPrefixLength;
        private final int phpCodeEndOffset;
        @Nullable
        private final String myLatestDirectiveText;

        private BladeInjectingLexerPosition(BladeLexer bladeLexer, Lexer phpLexer, boolean isInPhp, int phpCodeBeginningOffset, int phpCodeEndOffset, int phpCodeIgnoredPrefixLength, @Nullable String latestDirectiveText) {
            this.phpCodeIgnoredPrefixLength = phpCodeIgnoredPrefixLength;
            this.phpCodeBeginningOffset = phpCodeBeginningOffset;
            this.phpCodeEndOffset = phpCodeEndOffset;
            this.myBladePosition = bladeLexer.getCurrentPosition();
            this.myPhpPosition = phpLexer.getCurrentPosition();
            this.isInPhp = isInPhp;
            this.myLatestDirectiveText = latestDirectiveText;
        }

        public int getOffset() {
            if (this.isInPhp) {
                return BladeInjectingLexer.getBladeOffsetFromPhp(this.myPhpPosition.getOffset(), this.phpCodeBeginningOffset, this.phpCodeIgnoredPrefixLength);
            }
            return this.myBladePosition.getOffset();
        }

        public int getState() {
            return this.isInPhp ? this.myPhpPosition.getState() : this.myBladePosition.getState();
        }

        public LexerPosition getBladePosition() {
            return this.myBladePosition;
        }

        public LexerPosition getPhpPosition() {
            return this.myPhpPosition;
        }

        public boolean isInPhp() {
            return this.isInPhp;
        }

        public int getPhpCodeBeginningOffset() {
            return this.phpCodeBeginningOffset;
        }

        public int getPhpCodeIgnoredPrefixLength() {
            return this.phpCodeIgnoredPrefixLength;
        }

        public int getPhpCodeEndOffset() {
            return this.phpCodeEndOffset;
        }

        @Nullable
        public String getLatestDirectiveText() {
            return this.myLatestDirectiveText;
        }

        @NonNls
        public String toString() {
            return "BladeInjectingLexerPosition{\n myBladePosition=" + BladeInjectingLexerPosition.toString(this.myBladePosition) + ",\n myPhpPosition=" + BladeInjectingLexerPosition.toString(this.myPhpPosition) + ",\n isInPhp=" + this.isInPhp + ",\n phpCodeBeginningOffset=" + this.phpCodeBeginningOffset + ",\n phpCodeIgnoredPrefixLength=" + this.phpCodeIgnoredPrefixLength + ",\n phpCodeEndOffset=" + this.phpCodeEndOffset + "\n}";
        }

        @NonNls
        private static String toString(LexerPosition position) {
            return "LexerPosition{\n offset=" + position.getOffset() + ",\n state=" + position.getState() + "\n}";
        }
    }
}

