/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ComponentStoreWithExtraComponents;
import com.intellij.configurationStore.DefaultProjectElementNormalizerKt;
import com.intellij.configurationStore.DefaultProjectStoreImpl;
import com.intellij.configurationStore.ProjectStoreImplKt;
import com.intellij.configurationStore.StateLoadPolicy;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.configurationStore.StreamProviderFactory;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.StringKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u001b\u001a\u00020\u001cJ\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0007H\u0016J\b\u0010\"\u001a\u00020 H\u0016J\u0006\u0010#\u001a\u00020 J\n\u0010$\u001a\u0004\u0018\u00010 H\u0016J\b\u0010%\u001a\u00020 H\u0016J\u0006\u0010&\u001a\u00020\u0012J2\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(\"\u0004\b\u0000\u0010*2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H*0,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0014J\u0006\u00101\u001a\u00020 J\u0006\u00102\u001a\u00020\u0007J\u0010\u00103\u001a\u00020\u00072\u0006\u00104\u001a\u00020\u001eH\u0016J\u000e\u00105\u001a\u00020\u001c2\u0006\u00106\u001a\u00020\u0004J\u000e\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u0007J\u0018\u00109\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020 2\u0006\u0010;\u001a\u00020\u0007H\u0004R\u0014\u0010\u0006\u001a\u00020\u00078DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00020\u0018X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006<"}, d2={"Lcom/intellij/configurationStore/ProjectStoreBase;", "Lcom/intellij/configurationStore/ComponentStoreWithExtraComponents;", "Lcom/intellij/openapi/components/impl/stores/IProjectStore;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "isDirectoryBased", "", "()Z", "loadPolicy", "Lcom/intellij/configurationStore/StateLoadPolicy;", "getLoadPolicy", "()Lcom/intellij/configurationStore/StateLoadPolicy;", "setLoadPolicy", "(Lcom/intellij/configurationStore/StateLoadPolicy;)V", "getProject$intellij_platform_configurationStore_impl", "()Lcom/intellij/openapi/project/Project;", "scheme", "Lcom/intellij/openapi/components/StorageScheme;", "getScheme", "()Lcom/intellij/openapi/components/StorageScheme;", "setScheme", "(Lcom/intellij/openapi/components/StorageScheme;)V", "storageManager", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "getStorageManager", "()Lcom/intellij/configurationStore/StateStorageManagerImpl;", "clearStorages", "", "getDirectoryStoreFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDirectoryStorePath", "", "ignoreProjectStorageScheme", "getDirectoryStorePathOrBase", "getProjectBasePath", "getProjectConfigDir", "getProjectFilePath", "getStorageScheme", "getStorageSpecs", "", "Lcom/intellij/openapi/components/Storage;", "T", "component", "Lcom/intellij/openapi/components/PersistentStateComponent;", "stateSpec", "Lcom/intellij/openapi/components/State;", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "getWorkspaceFilePath", "isOptimiseTestLoadSpeed", "isProjectFile", "file", "loadProjectFromTemplate", "defaultProject", "setOptimiseTestLoadSpeed", "value", "setPath", "filePath", "refreshVfs", "intellij.platform.configurationStore.impl"})
public abstract class ProjectStoreBase
extends ComponentStoreWithExtraComponents
implements IProjectStore {
    @NotNull
    private StorageScheme scheme;
    @NotNull
    private StateLoadPolicy loadPolicy;
    @NotNull
    private final Project project;

    @NotNull
    public final StorageScheme getScheme() {
        return this.scheme;
    }

    public final void setScheme(@NotNull StorageScheme storageScheme) {
        Intrinsics.checkParameterIsNotNull((Object)storageScheme, (String)"<set-?>");
        this.scheme = storageScheme;
    }

    @Override
    @NotNull
    public final StateLoadPolicy getLoadPolicy() {
        return this.loadPolicy;
    }

    public final void setLoadPolicy(@NotNull StateLoadPolicy stateLoadPolicy) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)stateLoadPolicy), (String)"<set-?>");
        this.loadPolicy = stateLoadPolicy;
    }

    @Override
    public final boolean isOptimiseTestLoadSpeed() {
        return this.loadPolicy != StateLoadPolicy.LOAD;
    }

    @Override
    @NotNull
    public final StorageScheme getStorageScheme() {
        return this.scheme;
    }

    @Override
    @NotNull
    public abstract StateStorageManagerImpl getStorageManager();

    protected final boolean isDirectoryBased() {
        return this.scheme == StorageScheme.DIRECTORY_BASED;
    }

    @Override
    public final void setOptimiseTestLoadSpeed(boolean value) {
        this.loadPolicy = value ? StateLoadPolicy.NOT_LOAD : StateLoadPolicy.LOAD;
    }

    @Override
    @NotNull
    public String getProjectFilePath() {
        return this.getStorageManager().expandMacro("$PROJECT_FILE$");
    }

    @Override
    @Nullable
    public String getProjectConfigDir() {
        return this.isDirectoryBased() ? this.getStorageManager().expandMacro("$PROJECT_CONFIG_DIR$") : null;
    }

    @Override
    @NotNull
    public final String getWorkspaceFilePath() {
        return this.getStorageManager().expandMacro("$WORKSPACE_FILE$");
    }

    @Override
    public final void clearStorages() {
        this.getStorageManager().clearStorages();
    }

    @Override
    public final void loadProjectFromTemplate(@NotNull Project defaultProject) {
        Intrinsics.checkParameterIsNotNull((Object)defaultProject, (String)"defaultProject");
        defaultProject.save();
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)defaultProject);
        if (iComponentStore == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.DefaultProjectStoreImpl");
        }
        Element element = ((DefaultProjectStoreImpl)iComponentStore).getStateCopy();
        if (element == null) {
            return;
        }
        Element element2 = element;
        Logger $receiver$iv = ComponentStoreImplKt.getLOG();
        try {
            if (this.isDirectoryBased()) {
                Path path = Paths.get(this.getStorageManager().expandMacro("$PROJECT_CONFIG_DIR$"), new String[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(storageManager\u2026acro(PROJECT_CONFIG_DIR))");
                DefaultProjectElementNormalizerKt.normalizeDefaultProjectElement(defaultProject, element2, path);
            } else {
                Logger $receiver$iv2 = ComponentStoreImplKt.getLOG();
                try {
                    DefaultProjectElementNormalizerKt.moveComponentConfiguration(defaultProject, element2, (Function1<? super String, ? extends Path>)((Function1)new Function1<String, Path>(this, defaultProject, element2){
                        final /* synthetic */ ProjectStoreBase this$0;
                        final /* synthetic */ Project $defaultProject$inlined;
                        final /* synthetic */ Element $element$inlined;
                        {
                            this.this$0 = projectStoreBase;
                            this.$defaultProject$inlined = project;
                            this.$element$inlined = element;
                            super(1);
                        }

                        @NotNull
                        public final Path invoke(@NotNull String it) {
                            Path path;
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            if (Intrinsics.areEqual((Object)it, (Object)"workspace.xml")) {
                                Path path2 = Paths.get(this.this$0.getWorkspaceFilePath(), new String[0]);
                                path = path2;
                                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(workspaceFilePath)");
                            } else {
                                Path path3 = Paths.get(this.this$0.getProjectFilePath(), new String[0]);
                                path = path3;
                                Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"Paths.get(projectFilePath)");
                            }
                            return path;
                        }
                    }));
                }
                catch (ProcessCanceledException e$iv) {
                }
                catch (Throwable e$iv) {
                    $receiver$iv2.error(e$iv);
                }
            }
        }
        catch (ProcessCanceledException e$iv) {
        }
        catch (Throwable e$iv) {
            $receiver$iv.error(e$iv);
        }
        StateStorage stateStorage = StateStorageManagerImpl.getOrCreateStorage$default(this.getStorageManager(), "$PROJECT_FILE$", null, null, null, false, null, null, 126, null);
        if (stateStorage == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.XmlElementStorage");
        }
        ((XmlElementStorage)stateStorage).setDefaultState(element2);
    }

    @Override
    @NotNull
    public final String getProjectBasePath() {
        if (this.isDirectoryBased()) {
            String string = PathUtilRt.getParentPath((String)this.getStorageManager().expandMacro("$PROJECT_CONFIG_DIR$"));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathUtilRt.getParentPath\u2026acro(PROJECT_CONFIG_DIR))");
            String path = string;
            if (Registry.is((String)"store.basedir.parent.detection", (boolean)true)) {
                String string2 = PathUtilRt.getFileName((String)path);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"PathUtilRt.getFileName(path)");
                if (StringsKt.startsWith$default((String)string2, (String)".idea.", (boolean)false, (int)2, null)) {
                    String string3 = PathUtilRt.getParentPath((String)PathUtilRt.getParentPath((String)path));
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"PathUtilRt.getParentPath\u2026ilRt.getParentPath(path))");
                    return string3;
                }
            }
            return path;
        }
        String string = PathUtilRt.getParentPath((String)this.getProjectFilePath());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathUtilRt.getParentPath(projectFilePath)");
        return string;
    }

    protected final void setPath(@NotNull String filePath, boolean refreshVfs) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        StateStorageManagerImpl storageManager2 = this.getStorageManager();
        LocalFileSystem fs = LocalFileSystem.getInstance();
        if (StringsKt.endsWith$default((String)filePath, (String)".ipr", (boolean)false, (int)2, null)) {
            this.scheme = StorageScheme.DEFAULT;
            storageManager2.addMacro("$PROJECT_FILE$", filePath);
            String workspacePath = ProjectStoreImplKt.access$composeFileBasedProjectWorkSpacePath(filePath);
            storageManager2.addMacro("$WORKSPACE_FILE$", workspacePath);
            if (refreshVfs) {
                ActionsKt.invokeAndWaitIfNeed$default(null, (Function0)((Function0)new Function0<Unit>(fs, filePath, workspacePath){
                    final /* synthetic */ LocalFileSystem $fs;
                    final /* synthetic */ String $filePath;
                    final /* synthetic */ String $workspacePath;

                    public final void invoke() {
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{this.$fs.refreshAndFindFileByPath(this.$filePath), this.$fs.refreshAndFindFileByPath(this.$workspacePath)});
                    }
                    {
                        this.$fs = localFileSystem2;
                        this.$filePath = string;
                        this.$workspacePath = string2;
                        super(0);
                    }
                }), (int)1, null);
            }
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isUnitTestMode()) {
                Path path = Paths.get(filePath, new String[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(filePath)");
                this.setOptimiseTestLoadSpeed(!PathKt.exists((Path)path));
            }
        } else {
            this.scheme = StorageScheme.DIRECTORY_BASED;
            String configDir = filePath + "/.idea";
            storageManager2.addMacro("$PROJECT_CONFIG_DIR$", configDir);
            storageManager2.addMacro("$PROJECT_FILE$", configDir + "/misc.xml");
            storageManager2.addMacro("$WORKSPACE_FILE$", configDir + "/workspace.xml");
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isUnitTestMode()) {
                Path path = Paths.get(filePath, new String[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(filePath)");
                this.setOptimiseTestLoadSpeed(!PathKt.exists((Path)path));
            }
            if (refreshVfs) {
                ActionsKt.invokeAndWaitIfNeed$default(null, (Function0)((Function0)new Function0<Unit>(fs, configDir){
                    final /* synthetic */ LocalFileSystem $fs;
                    final /* synthetic */ String $configDir;

                    public final void invoke() {
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{this.$fs.refreshAndFindFileByPath(this.$configDir)});
                    }
                    {
                        this.$fs = localFileSystem2;
                        this.$configDir = string;
                        super(0);
                    }
                }), (int)1, null);
            }
        }
        storageManager2.addMacro("$CACHE_FILE$", FileUtilRt.toSystemIndependentName((String)((Object)ProjectUtil.getProjectCachePath$default((Project)this.project, (String)"workspace", (boolean)false, (int)2, null)).toString()) + ".xml");
    }

    @Override
    @NotNull
    protected <T> List<Storage> getStorageSpecs(@NotNull PersistentStateComponent<T> component, @NotNull State stateSpec, @NotNull StateStorageOperation operation) {
        List result2;
        Storage[] storages;
        Intrinsics.checkParameterIsNotNull(component, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)stateSpec, (String)"stateSpec");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Storage[] storageArray = storages = stateSpec.storages();
        if (storageArray.length == 0) {
            return CollectionsKt.listOf((Object)ProjectStoreImplKt.getPROJECT_FILE_STORAGE_ANNOTATION());
        }
        if (this.isDirectoryBased()) {
            result2 = null;
            for (Storage storage2 : storages) {
                if (!(Intrinsics.areEqual((Object)StateStorageManagerImplKt.getPath(storage2), (Object)"$PROJECT_FILE$") ^ true)) continue;
                if (result2 == null) {
                    result2 = (List)new SmartList();
                }
                result2.add(storage2);
            }
            if (UtilKt.isNullOrEmpty((Collection)result2)) {
                return CollectionsKt.listOf((Object)ProjectStoreImplKt.getPROJECT_FILE_STORAGE_ANNOTATION());
            }
            List list2 = result2;
            if (list2 == null) {
                Intrinsics.throwNpe();
            }
            CollectionsKt.sortWith((List)list2, ComponentStoreImplKt.getDeprecatedComparator());
            if (this.isDirectoryBased()) {
                List<Storage> list3;
                Object[] $receiver$iv;
                block20: {
                    Object[] objectArray = StreamProviderFactory.Companion.getEP_NAME().getExtensions((AreaInstance)this.project);
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"StreamProviderFactory.EP\u2026ME.getExtensions(project)");
                    $receiver$iv = objectArray;
                    int n = $receiver$iv.length;
                    for (int i = 0; i < n; ++i) {
                        List<Storage> list4;
                        Object file$iv = $receiver$iv[i];
                        StreamProviderFactory it = (StreamProviderFactory)file$iv;
                        Logger $receiver$iv2 = ComponentStoreImplKt.getLOG();
                        try {
                            StateStorageManager stateStorageManager = this.getStorageManager();
                            List list5 = result2;
                            if (list5 == null) {
                                Intrinsics.throwNpe();
                            }
                            list4 = it.customizeStorageSpecs(component, stateStorageManager, stateSpec, list5, operation);
                        }
                        catch (ProcessCanceledException e$iv) {
                            list4 = null;
                        }
                        catch (Throwable e$iv) {
                            $receiver$iv2.error(e$iv);
                            list4 = null;
                        }
                        List<Storage> result$iv = list4;
                        if (result$iv == null) continue;
                        list3 = result$iv;
                        break block20;
                    }
                    list3 = null;
                }
                if (list3 != null) {
                    Object[] it = $receiver$iv = list3;
                    return it;
                }
            }
            if (Intrinsics.areEqual((Object)StateStorageManagerImplKt.getPath((Storage)CollectionsKt.first((List)result2)), (Object)"$CACHE_FILE$") ^ true) {
                result2.add(ProjectStoreImplKt.getDEPRECATED_PROJECT_FILE_STORAGE_ANNOTATION());
            }
            return result2;
        }
        result2 = null;
        boolean hasOnlyDeprecatedStorages = true;
        for (Storage storage3 : storages) {
            if (!Intrinsics.areEqual((Object)StateStorageManagerImplKt.getPath(storage3), (Object)"$PROJECT_FILE$") && !Intrinsics.areEqual((Object)StateStorageManagerImplKt.getPath(storage3), (Object)"$WORKSPACE_FILE$") && !Intrinsics.areEqual((Object)StateStorageManagerImplKt.getPath(storage3), (Object)"$CACHE_FILE$")) continue;
            if (result2 == null) {
                result2 = (List)new SmartList();
            }
            result2.add(storage3);
            if (storage3.deprecated()) continue;
            hasOnlyDeprecatedStorages = false;
        }
        if (UtilKt.isNullOrEmpty((Collection)result2)) {
            return CollectionsKt.listOf((Object)ProjectStoreImplKt.getPROJECT_FILE_STORAGE_ANNOTATION());
        }
        if (hasOnlyDeprecatedStorages) {
            List list6 = result2;
            if (list6 == null) {
                Intrinsics.throwNpe();
            }
            list6.add(ProjectStoreImplKt.getPROJECT_FILE_STORAGE_ANNOTATION());
        }
        List list7 = result2;
        if (list7 == null) {
            Intrinsics.throwNpe();
        }
        CollectionsKt.sortWith((List)list7, ComponentStoreImplKt.getDeprecatedComparator());
        return result2;
    }

    @Override
    public boolean isProjectFile(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (!file2.isInLocalFileSystem() || !ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)file2)) {
            return false;
        }
        String string = file2.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.path");
        String filePath = string;
        if (!this.isDirectoryBased()) {
            return Intrinsics.areEqual((Object)filePath, (Object)this.getProjectFilePath()) || Intrinsics.areEqual((Object)filePath, (Object)this.getWorkspaceFilePath());
        }
        return FileUtil.isAncestor((String)PathUtilRt.getParentPath((String)this.getProjectFilePath()), (String)filePath, (boolean)false);
    }

    @Override
    @Nullable
    public String getDirectoryStorePath(boolean ignoreProjectStorageScheme) {
        return !ignoreProjectStorageScheme && !this.isDirectoryBased() ? null : StringKt.nullize$default((String)PathUtilRt.getParentPath((String)this.getProjectFilePath()), (boolean)false, (int)1, null);
    }

    @Override
    @Nullable
    public VirtualFile getDirectoryStoreFile() {
        VirtualFile virtualFile;
        String string = this.getDirectoryStorePath();
        if (string != null) {
            String string2;
            String it = string2 = string;
            virtualFile = LocalFileSystem.getInstance().findFileByPath(it);
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public String getDirectoryStorePathOrBase() {
        String string = PathUtilRt.getParentPath((String)this.getProjectFilePath());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathUtilRt.getParentPath(projectFilePath)");
        return string;
    }

    @Override
    @NotNull
    public final Project getProject$intellij_platform_configurationStore_impl() {
        return this.project;
    }

    public ProjectStoreBase(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.scheme = StorageScheme.DEFAULT;
        this.loadPolicy = StateLoadPolicy.LOAD;
    }
}

