/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.google.common.collect.Lists;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.actions.BigPopupUI;
import com.intellij.ide.actions.SearchEverywhereClassifier;
import com.intellij.ide.actions.bigPopup.ShowFilterAction;
import com.intellij.ide.actions.searcheverywhere.MultithreadSearcher;
import com.intellij.ide.actions.searcheverywhere.SEResultsEqualityProvider;
import com.intellij.ide.actions.searcheverywhere.SESearcher;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereCommandInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereDataKeys;
import com.intellij.ide.actions.searcheverywhere.SingleThreadSearcher;
import com.intellij.ide.actions.searcheverywhere.ThrottlingListenerWrapper;
import com.intellij.ide.actions.searcheverywhere.statistics.SearchEverywhereUsageTriggerCollector;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.ide.util.gotoByName.QuickSearchComponent;
import com.intellij.internal.statistic.service.fus.collectors.FUSUsageContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TextIcon;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.MatcherHolder;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchEverywhereUI
extends BigPopupUI
implements DataProvider,
QuickSearchComponent {
    private static final Logger LOG = Logger.getInstance(SearchEverywhereUI.class);
    public static final String SEARCH_EVERYWHERE_SEARCH_FILED_KEY = "search-everywhere-textfield";
    public static final int SINGLE_CONTRIBUTOR_ELEMENTS_LIMIT = 30;
    public static final int MULTIPLE_CONTRIBUTORS_ELEMENTS_LIMIT = 15;
    public static final int THROTTLING_TIMEOUT = 200;
    private final List<? extends SearchEverywhereContributor> myServiceContributors;
    private final List<? extends SearchEverywhereContributor> myShownContributors;
    private final Map<String, SearchEverywhereContributorFilter<?>> myContributorFilters;
    private SearchListModel myListModel;
    private SETab mySelectedTab;
    private final JCheckBox myNonProjectCB;
    private final List<SETab> myTabs = new ArrayList<SETab>();
    private boolean nonProjectCheckBoxAutoSet = true;
    private String notFoundString;
    private JBPopup myHint;
    private final Alarm mySearchAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)ApplicationManager.getApplication());
    private final SESearcher mySearcher;
    private final ThrottlingListenerWrapper myBufferedListener;
    private ProgressIndicator mySearchProgressIndicator;
    private static final CommandRenderer commandRenderer = new CommandRenderer();
    private final MoreRenderer moreRenderer = new MoreRenderer();
    private final GroupTitleRenderer groupTitleRenderer = new GroupTitleRenderer();
    private final SESearcher.Listener mySearchListener = new SESearcher.Listener(){

        @Override
        public void elementsAdded(@NotNull List<SESearcher.ElementInfo> list2) {
            if (list2 == null) {
                7.$$$reportNull$$$0(0);
            }
            int index = SearchEverywhereUI.this.myResultsList.getSelectedIndex();
            Map<SearchEverywhereContributor, List<SESearcher.ElementInfo>> map = list2.stream().collect(Collectors.groupingBy(info -> info.getContributor()));
            map.forEach((key, lst) -> SearchEverywhereUI.this.myListModel.addElements((List<SESearcher.ElementInfo>)lst, (SearchEverywhereContributor)key));
            if (index == 0 || index == -1) {
                SearchEverywhereUI.this.myResultsList.setSelectedIndex(0);
            }
        }

        @Override
        public void elementsRemoved(@NotNull List<SESearcher.ElementInfo> list2) {
            if (list2 == null) {
                7.$$$reportNull$$$0(1);
            }
            list2.forEach(info -> SearchEverywhereUI.this.myListModel.removeElement(info.getElement(), info.getContributor()));
            ScrollingUtil.ensureSelectionExists((JList)SearchEverywhereUI.this.myResultsList);
        }

        @Override
        public void searchFinished(@NotNull Map<SearchEverywhereContributor<?>, Boolean> hasMoreContributors) {
            if (hasMoreContributors == null) {
                7.$$$reportNull$$$0(2);
            }
            if (SearchEverywhereUI.this.myResultsList.isEmpty()) {
                if (SearchEverywhereUI.this.nonProjectCheckBoxAutoSet && !SearchEverywhereUI.this.isUseNonProjectItems() && !SearchEverywhereUI.this.getSearchPattern().isEmpty()) {
                    SearchEverywhereUI.this.doSetUseNonProjectItems(true, true);
                    SearchEverywhereUI.this.notFoundString = SearchEverywhereUI.this.getSearchPattern();
                    return;
                }
                SearchEverywhereUI.this.hideHint();
            }
            SearchEverywhereUI.this.myResultsList.setEmptyText(SearchEverywhereUI.this.getSearchPattern().isEmpty() ? "" : SearchEverywhereUI.this.getNotFoundText());
            hasMoreContributors.forEach(SearchEverywhereUI.this.myListModel::setHasMore);
            ScrollingUtil.ensureSelectionExists((JList)SearchEverywhereUI.this.myResultsList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hasMoreContributors";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$7";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "elementsAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "elementsRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "searchFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final SearchEverywhereContributor<Void> stubCommandContributor = new SearchEverywhereContributor<Void>(){

        @NotNull
        public String getSearchProviderId() {
            if ("CommandsContributor" == null) {
                8.$$$reportNull$$$0(0);
            }
            return "CommandsContributor";
        }

        @NotNull
        public String getGroupName() {
            String string = IdeBundle.message((String)"searcheverywhere.commands.tab.name", (Object[])new Object[0]);
            if (string == null) {
                8.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public String includeNonProjectItemsText() {
            return null;
        }

        public int getSortWeight() {
            return 10;
        }

        public boolean showInFindResults() {
            return false;
        }

        public void fetchElements(@NotNull String pattern, boolean everywhere, @Nullable SearchEverywhereContributorFilter<Void> filter, @NotNull ProgressIndicator progressIndicator, @NotNull Function<Object, Boolean> consumer) {
            if (pattern == null) {
                8.$$$reportNull$$$0(2);
            }
            if (progressIndicator == null) {
                8.$$$reportNull$$$0(3);
            }
            if (consumer == null) {
                8.$$$reportNull$$$0(4);
            }
        }

        public boolean processSelectedItem(@NotNull Object selected, int modifiers, @NotNull String searchText) {
            if (selected == null) {
                8.$$$reportNull$$$0(5);
            }
            if (searchText == null) {
                8.$$$reportNull$$$0(6);
            }
            SearchEverywhereUI.this.mySearchField.setText(((SearchEverywhereCommandInfo)selected).getCommandWithPrefix() + " ");
            SearchEverywhereUI.this.featureTriggered("commandCompleted", null);
            return false;
        }

        @NotNull
        public ListCellRenderer getElementsRenderer(@NotNull JList<?> list2) {
            if (list2 == null) {
                8.$$$reportNull$$$0(7);
            }
            CommandRenderer commandRenderer = commandRenderer;
            if (commandRenderer == null) {
                8.$$$reportNull$$$0(8);
            }
            return commandRenderer;
        }

        @Nullable
        public Object getDataForItem(@NotNull Object element, @NotNull String dataId) {
            if (element == null) {
                8.$$$reportNull$$$0(9);
            }
            if (dataId == null) {
                8.$$$reportNull$$$0(10);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$8";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selected";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "searchText";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSearchProviderId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroupName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$8";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementsRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "fetchElements";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "processSelectedItem";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getElementsRenderer";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getDataForItem";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private final ExtendableTextComponent.Extension hintExtension = new ExtendableTextComponent.Extension(){
        private final TextIcon icon;
        {
            String message = IdeBundle.message((String)"searcheverywhere.textfield.hint", (Object[])new Object[]{SearchTopHitProvider.getTopHitAccelerator()});
            Color color = JBUI.CurrentTheme.BigPopup.searchFieldGrayForeground();
            this.icon = new TextIcon(message, color, null, 0);
            this.icon.setFont(RelativeFont.SMALL.derive(SearchEverywhereUI.this.getFont()));
        }

        public Icon getIcon(boolean hovered) {
            return this.icon;
        }
    };

    public SearchEverywhereUI(Project project, List<? extends SearchEverywhereContributor> serviceContributors, List<? extends SearchEverywhereContributor> contributors, Map<String, SearchEverywhereContributorFilter<?>> filters) {
        super(project);
        List<SEResultsEqualityProvider> equalityProviders = SEResultsEqualityProvider.getProviders();
        if (Registry.is((String)"new.search.everywhere.single.thread.search")) {
            this.mySearcher = new SingleThreadSearcher(this.mySearchListener, run2 -> ApplicationManager.getApplication().invokeLater(run2), equalityProviders);
            this.myBufferedListener = null;
        } else {
            this.myBufferedListener = new ThrottlingListenerWrapper(200, this.mySearchListener, Runnable::run);
            this.mySearcher = new MultithreadSearcher(this.myBufferedListener, run2 -> ApplicationManager.getApplication().invokeLater(run2), equalityProviders);
        }
        this.myServiceContributors = serviceContributors;
        this.myShownContributors = contributors;
        this.myContributorFilters = filters;
        this.myNonProjectCB = new JBCheckBox();
        this.myNonProjectCB.setOpaque(false);
        this.myNonProjectCB.setFocusable(false);
        this.init();
        this.initSearchActions();
        this.myResultsList.setSelectionMode(2);
        this.myResultsList.addListSelectionListener(e -> {
            boolean multiselectAllowed;
            int[] selectedIndices = this.myResultsList.getSelectedIndices();
            if (selectedIndices.length > 1 && !(multiselectAllowed = Arrays.stream(selectedIndices).allMatch(i -> this.myListModel.getContributorForIndex(i).isMultiselectSupported()))) {
                int index = this.myResultsList.getLeadSelectionIndex();
                this.myResultsList.setSelectedIndex(index);
            }
        });
    }

    @NotNull
    protected CompositeCellRenderer createCellRenderer() {
        CompositeCellRenderer compositeCellRenderer = new CompositeCellRenderer();
        if (compositeCellRenderer == null) {
            SearchEverywhereUI.$$$reportNull$$$0(0);
        }
        return compositeCellRenderer;
    }

    @Override
    @NotNull
    public JBList<Object> createList() {
        this.myListModel = new SearchListModel();
        this.addListDataListener(this.myListModel);
        JBList jBList = new JBList((ListModel)this.myListModel);
        if (jBList == null) {
            SearchEverywhereUI.$$$reportNull$$$0(1);
        }
        return jBList;
    }

    public void setUseNonProjectItems(boolean use2) {
        this.doSetUseNonProjectItems(use2, false);
    }

    private void doSetUseNonProjectItems(boolean use2, boolean isAutoSet) {
        this.myNonProjectCB.setSelected(use2);
        this.nonProjectCheckBoxAutoSet = isAutoSet;
    }

    public boolean isUseNonProjectItems() {
        return this.myNonProjectCB.isSelected();
    }

    public void switchToContributor(String contributorID) {
        SETab selectedTab = this.myTabs.stream().filter(tab -> tab.getID().equals(contributorID)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("Contributor %s is not supported", contributorID)));
        this.switchToTab(selectedTab);
    }

    private void switchToNextTab() {
        int currentIndex = this.myTabs.indexOf(this.mySelectedTab);
        SETab nextTab = currentIndex == this.myTabs.size() - 1 ? this.myTabs.get(0) : this.myTabs.get(currentIndex + 1);
        this.switchToTab(nextTab);
    }

    private void switchToPrevTab() {
        int currentIndex = this.myTabs.indexOf(this.mySelectedTab);
        SETab prevTab = currentIndex == 0 ? this.myTabs.get(this.myTabs.size() - 1) : this.myTabs.get(currentIndex - 1);
        this.switchToTab(prevTab);
    }

    private void switchToTab(SETab tab) {
        this.mySelectedTab = tab;
        String checkBoxText = tab.getContributor().map(SearchEverywhereContributor::includeNonProjectItemsText).orElse(IdeBundle.message((String)"checkbox.include.non.project.items", (Object[])new Object[]{IdeUICustomization.getInstance().getProjectConceptName()}));
        if (checkBoxText.indexOf(27) != -1) {
            DialogUtil.setTextWithMnemonic((AbstractButton)this.myNonProjectCB, (String)checkBoxText);
        } else {
            this.myNonProjectCB.setText(checkBoxText);
            this.myNonProjectCB.setDisplayedMnemonicIndex(-1);
            this.myNonProjectCB.setMnemonic(0);
        }
        if (this.nonProjectCheckBoxAutoSet && this.isUseNonProjectItems()) {
            this.doSetUseNonProjectItems(false, true);
        }
        if (this.mySearchField instanceof ExtendableTextField) {
            ExtendableTextField textField2 = (ExtendableTextField)this.mySearchField;
            Boolean commandsSupported = this.mySelectedTab.getContributor().map(contributor -> !contributor.getSupportedCommands().isEmpty()).orElse(true);
            if (commandsSupported.booleanValue()) {
                textField2.addExtension(this.hintExtension);
            } else {
                textField2.removeExtension(this.hintExtension);
            }
        }
        this.repaint();
        this.rebuildList();
    }

    public String getSelectedContributorID() {
        return this.mySelectedTab.getID();
    }

    public void dispose() {
        this.stopSearching();
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            SearchEverywhereUI.$$$reportNull$$$0(2);
        }
        IntStream indicesStream = Arrays.stream(this.myResultsList.getSelectedIndices()).filter(i -> !this.myListModel.isMoreElement(i));
        if (PlatformDataKeys.PREDEFINED_TEXT.is(dataId)) {
            return this.getSearchPattern();
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            List elements = indicesStream.mapToObj(i -> {
                SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(i);
                Object item = this.myListModel.getElementAt(i);
                Object psi = contributor.getDataForItem(item, CommonDataKeys.PSI_ELEMENT.getName());
                return (PsiElement)psi;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            return PsiUtilCore.toPsiElementArray(elements);
        }
        return indicesStream.mapToObj(i -> {
            if (dataId == null) {
                SearchEverywhereUI.$$$reportNull$$$0(12);
            }
            SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(i);
            Object item = this.myListModel.getElementAt(i);
            return contributor.getDataForItem(item, dataId);
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public void registerHint(JBPopup h) {
        if (this.myHint != null && this.myHint.isVisible() && this.myHint != h) {
            this.myHint.cancel();
        }
        this.myHint = h;
    }

    public void unregisterHint() {
        this.registerHint(null);
    }

    public Component asComponent() {
        return this;
    }

    private void hideHint() {
        if (this.myHint != null && this.myHint.isVisible()) {
            this.myHint.cancel();
        }
    }

    private void updateHint(Object element) {
        if (this.myHint == null || !this.myHint.isVisible()) {
            return;
        }
        PopupUpdateProcessor updateProcessor = (PopupUpdateProcessor)((Object)this.myHint.getUserData(PopupUpdateProcessor.class));
        if (updateProcessor != null) {
            updateProcessor.updatePopup(element);
        }
    }

    private boolean isAllTabSelected() {
        return "SearchEverywhereContributor.All".equals(this.getSelectedContributorID());
    }

    @Override
    @NotNull
    protected JPanel createSettingsPanel() {
        JPanel res2 = new JPanel();
        BoxLayout bl = new BoxLayout(res2, 0);
        res2.setLayout(bl);
        res2.setOpaque(false);
        res2.add(this.myNonProjectCB);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.addAction((AnAction)new ShowInFindToolWindowAction());
        actionGroup.addAction((AnAction)new SearchEverywhereShowFilterAction(this));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("search.everywhere.toolbar", (ActionGroup)actionGroup, true);
        toolbar.setLayoutPolicy(0);
        toolbar.updateActionsImmediately();
        JComponent toolbarComponent = toolbar.getComponent();
        toolbarComponent.setOpaque(false);
        toolbarComponent.setBorder((Border)JBUI.Borders.empty((int)2, (int)18, (int)2, (int)9));
        res2.add(toolbarComponent);
        JPanel jPanel = res2;
        if (jPanel == null) {
            SearchEverywhereUI.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @Override
    @NotNull
    protected String getInitialHint() {
        String string = IdeBundle.message((String)"searcheverywhere.history.shortcuts.hint", (Object[])new Object[]{KeymapUtil.getKeystrokeText((KeyStroke)SearchTextField.ALT_SHOW_HISTORY_KEYSTROKE), KeymapUtil.getKeystrokeText((KeyStroke)SearchTextField.SHOW_HISTORY_KEYSTROKE)});
        if (string == null) {
            SearchEverywhereUI.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    protected ExtendableTextField createSearchField() {
        BigPopupUI.SearchField res2 = new BigPopupUI.SearchField(){

            @Override
            @NotNull
            protected ExtendableTextComponent.Extension getLeftExtension() {
                ExtendableTextComponent.Extension extension = new ExtendableTextComponent.Extension(){

                    public Icon getIcon(boolean hovered) {
                        return AllIcons.Actions.Find;
                    }

                    public boolean isIconBeforeText() {
                        return true;
                    }

                    public int getIconGap() {
                        return JBUI.scale((int)10);
                    }
                };
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                return extension;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$1", "getLeftExtension"));
            }
        };
        res2.putClientProperty(SEARCH_EVERYWHERE_SEARCH_FILED_KEY, true);
        BigPopupUI.SearchField searchField = res2;
        if (searchField == null) {
            SearchEverywhereUI.$$$reportNull$$$0(5);
        }
        return searchField;
    }

    @Override
    protected void installScrollingActions() {
        ScrollingUtil.installMoveUpAction((JList)this.myResultsList, (JComponent)this.getSearchField());
        ScrollingUtil.installMoveDownAction((JList)this.myResultsList, (JComponent)this.getSearchField());
    }

    @Override
    @NotNull
    protected JPanel createTopLeftPanel() {
        JPanel contributorsPanel = new JPanel(new FlowLayout(0, 0, 0));
        contributorsPanel.setOpaque(false);
        SETab allTab = new SETab(null);
        contributorsPanel.add(allTab);
        this.myTabs.add(allTab);
        this.myShownContributors.stream().filter(SearchEverywhereContributor::isShownInSeparateTab).forEach(contributor -> {
            SETab tab = new SETab((SearchEverywhereContributor)contributor);
            contributorsPanel.add(tab);
            this.myTabs.add(tab);
        });
        this.switchToTab(allTab);
        JPanel jPanel = contributorsPanel;
        if (jPanel == null) {
            SearchEverywhereUI.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    private void rebuildList() {
        assert (EventQueue.isDispatchThread()) : "Must be EDT";
        this.stopSearching();
        this.myResultsList.setEmptyText(IdeBundle.message((String)"label.choosebyname.searching", (Object[])new Object[0]));
        String pattern = this.getSearchPattern();
        this.updateViewType(pattern.isEmpty() ? BigPopupUI.ViewType.SHORT : BigPopupUI.ViewType.FULL);
        String matcherString = this.mySelectedTab.getContributor().map(contributor -> contributor.filterControlSymbols(pattern)).orElse(pattern);
        MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + matcherString), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
        MatcherHolder.associateMatcher((JComponent)this.myResultsList, (Matcher)matcher);
        this.mySearchAlarm.addRequest(() -> {
            String typedCommand;
            List<SearchEverywhereCommandInfo> commands;
            this.myListModel.clear();
            HashMap contributorsMap = new HashMap();
            Optional<SearchEverywhereContributor> selectedContributor = this.mySelectedTab.getContributor();
            if (selectedContributor.isPresent()) {
                contributorsMap.put(selectedContributor.get(), 30);
            } else {
                contributorsMap.putAll(this.getUsedContributors().stream().collect(Collectors.toMap(c -> c, c -> 15)));
            }
            Set<SearchEverywhereContributor<?>> contributors = contributorsMap.keySet();
            boolean dumbModeSupported = contributors.stream().anyMatch(c -> c.isDumbModeSupported());
            if (!dumbModeSupported && DumbService.getInstance((Project)this.myProject).isDumb()) {
                String tabName = this.mySelectedTab.getText();
                String productName = ApplicationNamesInfo.getInstance().getFullProductName();
                this.myResultsList.setEmptyText(IdeBundle.message((String)"searcheverywhere.indexing.mode.not.supported", (Object[])new Object[]{tabName, productName}));
                return;
            }
            String commandPrefix = SearchTopHitProvider.getTopHitAccelerator();
            if (pattern.startsWith(commandPrefix) && !(commands = SearchEverywhereUI.getCommandsForCompletion(contributors, typedCommand = pattern.split(" ")[0].substring(commandPrefix.length()))).isEmpty()) {
                if (pattern.contains(" ")) {
                    contributors.retainAll(commands.stream().map(SearchEverywhereCommandInfo::getContributor).collect(Collectors.toSet()));
                } else {
                    List<SESearcher.ElementInfo> lst = commands.stream().map(command -> new SESearcher.ElementInfo(command, 0, this.stubCommandContributor)).collect(Collectors.toList());
                    this.myListModel.addElements(lst, this.stubCommandContributor);
                    ScrollingUtil.ensureSelectionExists((JList)this.myResultsList);
                }
            }
            this.mySearchProgressIndicator = this.mySearcher.search(contributorsMap, pattern, this.isUseNonProjectItems(), c -> this.myContributorFilters.get(c.getSearchProviderId()));
        }, 200);
    }

    private void initSearchActions() {
        MouseAdapter listMouseListener = new MouseAdapter(){
            private int currentDescriptionIndex = -1;

            @Override
            public void mouseClicked(MouseEvent e) {
                SearchEverywhereUI.this.onMouseClicked(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int index = SearchEverywhereUI.this.myResultsList.locationToIndex(e.getPoint());
                this.indexChanged(index);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                int index = SearchEverywhereUI.this.myResultsList.getSelectedIndex();
                this.indexChanged(index);
            }

            private void indexChanged(int index) {
                if (index != this.currentDescriptionIndex) {
                    this.currentDescriptionIndex = index;
                    SearchEverywhereUI.this.showDescriptionForIndex(index);
                }
            }
        };
        this.myResultsList.addMouseMotionListener((MouseMotionListener)listMouseListener);
        this.myResultsList.addMouseListener((MouseListener)listMouseListener);
        this.mySearchField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isShiftDown()) {
                    if (e.getKeyCode() == 40) {
                        SearchEverywhereUI.this.myResultsList.dispatchEvent((AWTEvent)e);
                        e.consume();
                    }
                    if (e.getKeyCode() == 38) {
                        SearchEverywhereUI.this.myResultsList.dispatchEvent((AWTEvent)e);
                        e.consume();
                    }
                }
            }
        });
        Consumer nextTabAction = e -> {
            this.switchToNextTab();
            this.triggerTabSwitched((AnActionEvent)e);
        };
        Consumer prevTabAction = e -> {
            this.switchToPrevTab();
            this.triggerTabSwitched((AnActionEvent)e);
        };
        this.registerAction("SearchEverywhere.CompleteCommand", () -> new CompleteCommandAction());
        this.registerAction("SearchEverywhere.NextTab", (Consumer<AnActionEvent>)nextTabAction);
        this.registerAction("SearchEverywhere.PrevTab", (Consumer<AnActionEvent>)prevTabAction);
        this.registerAction("NextTab", (Consumer<AnActionEvent>)nextTabAction);
        this.registerAction("PreviousTab", (Consumer<AnActionEvent>)prevTabAction);
        this.registerAction("Switcher", (Consumer<AnActionEvent>)((Consumer)e -> {
            if (e.getInputEvent().isShiftDown()) {
                this.switchToPrevTab();
            } else {
                this.switchToNextTab();
            }
            this.triggerTabSwitched((AnActionEvent)e);
        }));
        this.registerAction("SearchEverywhere.NavigateToNextGroup", (Consumer<AnActionEvent>)((Consumer)e -> {
            this.fetchGroups(true);
            FUSUsageContext context = SearchEverywhereUI.getEventShortcut(e).map(shortcut -> FUSUsageContext.create(shortcut)).orElse(null);
            this.featureTriggered("navigateThroughGroups", context);
        }));
        this.registerAction("SearchEverywhere.NavigateToPrevGroup", (Consumer<AnActionEvent>)((Consumer)e -> {
            this.fetchGroups(false);
            FUSUsageContext context = SearchEverywhereUI.getEventShortcut(e).map(shortcut -> FUSUsageContext.create(shortcut)).orElse(null);
            this.featureTriggered("navigateThroughGroups", context);
        }));
        this.registerSelectItemAction();
        AnAction escape = ActionManager.getInstance().getAction("EditorEscape");
        DumbAwareAction.create(__ -> this.closePopup()).registerCustomShortcutSet(escape == null ? CommonShortcuts.ESCAPE : escape.getShortcutSet(), (JComponent)((Object)this));
        this.mySearchField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                String newSearchString = SearchEverywhereUI.this.getSearchPattern();
                if (SearchEverywhereUI.this.nonProjectCheckBoxAutoSet && SearchEverywhereUI.this.isUseNonProjectItems() && !newSearchString.contains(SearchEverywhereUI.this.notFoundString)) {
                    SearchEverywhereUI.this.doSetUseNonProjectItems(false, true);
                } else {
                    SearchEverywhereUI.this.rebuildList();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$4", "textChanged"));
            }
        });
        this.myNonProjectCB.addItemListener(e -> this.rebuildList());
        this.myNonProjectCB.addActionListener(e -> {
            this.nonProjectCheckBoxAutoSet = false;
        });
        this.myResultsList.addListSelectionListener(e -> {
            Object selectedValue = this.myResultsList.getSelectedValue();
            if (selectedValue != null && this.myHint != null && this.myHint.isVisible()) {
                this.updateHint(selectedValue);
            }
            this.showDescriptionForIndex(this.myResultsList.getSelectedIndex());
        });
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void exitDumbMode() {
                ApplicationManager.getApplication().invokeLater(() -> SearchEverywhereUI.this.rebuildList());
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(ProgressWindow.TOPIC, pw -> Disposer.register((Disposable)pw, () -> this.myResultsList.repaint()));
        this.mySearchField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Component oppositeComponent = e.getOppositeComponent();
                if (!SearchEverywhereUI.this.isHintComponent(oppositeComponent) && !UIUtil.haveCommonOwner((Component)((Object)SearchEverywhereUI.this), (Component)oppositeComponent)) {
                    SearchEverywhereUI.this.closePopup();
                }
            }
        });
    }

    private void showDescriptionForIndex(int index) {
        if (index >= 0 && !this.myListModel.isMoreElement(index)) {
            SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(index);
            String description = (String)contributor.getDataForItem(this.myListModel.getElementAt(index), SearchEverywhereDataKeys.ITEM_STRING_DESCRIPTION.getName());
            ActionMenu.showDescriptionInStatusBar(true, (Component)this.myResultsList, description);
        }
    }

    private void registerAction(String actionID, Supplier<AnAction> actionSupplier) {
        Optional.ofNullable(ActionManager.getInstance().getAction(actionID)).map(a -> a.getShortcutSet()).ifPresent(shortcuts -> ((AnAction)actionSupplier.get()).registerCustomShortcutSet(shortcuts, (JComponent)((Object)this), (Disposable)this));
    }

    private void registerAction(String actionID, Consumer<AnActionEvent> action) {
        this.registerAction(actionID, () -> DumbAwareAction.create((Consumer)action));
    }

    private void registerSelectItemAction() {
        int[] allowedModifiers = new int[]{0, 1, 2, 4, 8};
        ShortcutSet selectShortcuts = ActionManager.getInstance().getAction("SearchEverywhere.SelectItem").getShortcutSet();
        Collection keyboardShortcuts = Arrays.stream(selectShortcuts.getShortcuts()).filter(shortcut -> shortcut instanceof KeyboardShortcut).map(shortcut -> (KeyboardShortcut)shortcut).collect(Collectors.toList());
        for (int modifiers : allowedModifiers) {
            ArrayList<KeyboardShortcut> newShortcuts = new ArrayList<KeyboardShortcut>();
            for (KeyboardShortcut shortcut2 : keyboardShortcuts) {
                KeyStroke originalStroke;
                boolean hasSecondStroke = shortcut2.getSecondKeyStroke() != null;
                KeyStroke keyStroke = originalStroke = hasSecondStroke ? shortcut2.getSecondKeyStroke() : shortcut2.getFirstKeyStroke();
                if ((originalStroke.getModifiers() & modifiers) != 0) continue;
                KeyStroke newStroke = KeyStroke.getKeyStroke(originalStroke.getKeyCode(), originalStroke.getModifiers() | modifiers);
                newShortcuts.add(hasSecondStroke ? new KeyboardShortcut(shortcut2.getFirstKeyStroke(), newStroke) : new KeyboardShortcut(newStroke, null));
            }
            if (newShortcuts.isEmpty()) continue;
            CustomShortcutSet newShortcutSet = new CustomShortcutSet(newShortcuts.toArray(Shortcut.EMPTY_ARRAY));
            DumbAwareAction.create(event -> {
                int[] indices = this.myResultsList.getSelectedIndices();
                this.elementsSelected(indices, modifiers);
            }).registerCustomShortcutSet((ShortcutSet)newShortcutSet, (JComponent)((Object)this), (Disposable)this);
        }
    }

    private static Optional<String> getEventShortcut(AnActionEvent event) {
        return Optional.ofNullable(KeymapUtil.getEventCallerKeystrokeText((AnActionEvent)event));
    }

    private void triggerTabSwitched(AnActionEvent e) {
        String selectedContributorID = this.getSelectedContributorID();
        FUSUsageContext context = SearchEverywhereUI.getEventShortcut(e).map(shortcut -> FUSUsageContext.create(selectedContributorID, shortcut)).orElseGet(() -> FUSUsageContext.create(selectedContributorID));
        this.featureTriggered("tabSwitched", context);
    }

    private void fetchGroups(boolean down) {
        int index = this.myResultsList.getSelectedIndex();
        while ((index += down ? 1 : -1) >= 0 && index < this.myListModel.getSize() && !this.myListModel.isGroupFirstItem(index) && !this.myListModel.isMoreElement(index)) {
        }
        if (index >= 0 && index < this.myListModel.getSize()) {
            this.myResultsList.setSelectedIndex(index);
            ScrollingUtil.ensureIndexIsVisible((JList)this.myResultsList, (int)index, (int)0);
        }
    }

    private Optional<SearchEverywhereCommandInfo> getSelectedCommand(String typedCommand) {
        int index = this.myResultsList.getSelectedIndex();
        if (index < 0) {
            return Optional.empty();
        }
        SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(index);
        if (contributor != this.stubCommandContributor) {
            return Optional.empty();
        }
        SearchEverywhereCommandInfo selectedCommand = (SearchEverywhereCommandInfo)this.myListModel.getElementAt(index);
        return selectedCommand.getCommand().contains(typedCommand) ? Optional.of(selectedCommand) : Optional.empty();
    }

    @NotNull
    private static List<SearchEverywhereCommandInfo> getCommandsForCompletion(Collection<SearchEverywhereContributor<?>> contributors, String enteredCommandPart) {
        Comparator cmdComparator = (cmd1, cmd2) -> {
            String cmdName1 = cmd1.getCommand();
            String cmdName2 = cmd2.getCommand();
            if (!enteredCommandPart.isEmpty()) {
                if (cmdName1.startsWith(enteredCommandPart) && !cmdName2.startsWith(enteredCommandPart)) {
                    return -1;
                }
                if (!cmdName1.startsWith(enteredCommandPart) && cmdName2.startsWith(enteredCommandPart)) {
                    return 1;
                }
            }
            return String.CASE_INSENSITIVE_ORDER.compare(cmdName1, cmd2.getCommand());
        };
        List<SearchEverywhereCommandInfo> list2 = contributors.stream().flatMap(contributor -> contributor.getSupportedCommands().stream()).filter(command -> command.getCommand().contains(enteredCommandPart)).sorted(cmdComparator).collect(Collectors.toList());
        if (list2 == null) {
            SearchEverywhereUI.$$$reportNull$$$0(7);
        }
        return list2;
    }

    private void onMouseClicked(@NotNull MouseEvent e) {
        boolean multiSelectMode;
        if (e == null) {
            SearchEverywhereUI.$$$reportNull$$$0(8);
        }
        boolean bl = multiSelectMode = e.isShiftDown() || UIUtil.isControlKeyDown((MouseEvent)e);
        if (e.getButton() == 1 && !multiSelectMode) {
            e.consume();
            int i = this.myResultsList.locationToIndex(e.getPoint());
            if (i > -1) {
                this.myResultsList.setSelectedIndex(i);
                this.elementsSelected(new int[]{i}, e.getModifiers());
            }
        }
    }

    private boolean isHintComponent(Component component) {
        if (this.myHint != null && !this.myHint.isDisposed() && component != null) {
            return SwingUtilities.isDescendingFrom(component, this.myHint.getContent());
        }
        return false;
    }

    private void elementsSelected(int[] indexes, int modifiers) {
        if (indexes.length == 1 && this.myListModel.isMoreElement(indexes[0])) {
            SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(indexes[0]);
            this.showMoreElements(contributor);
            return;
        }
        indexes = Arrays.stream(indexes).filter(i -> !this.myListModel.isMoreElement(i)).toArray();
        String searchText = this.getSearchPattern();
        if (searchText.startsWith(SearchTopHitProvider.getTopHitAccelerator()) && searchText.contains(" ")) {
            this.featureTriggered("commandUsed", null);
        }
        boolean closePopup = false;
        boolean isAllTab = this.isAllTabSelected();
        for (int i2 : indexes) {
            SearchEverywhereContributor contributor = this.myListModel.getContributorForIndex(i2);
            Object value = this.myListModel.getElementAt(i2);
            if (isAllTab) {
                this.featureTriggered("contributorItemChosen", FUSUsageContext.create(contributor.getSearchProviderId()));
            }
            closePopup |= contributor.processSelectedItem(value, modifiers, searchText);
        }
        if (closePopup) {
            this.closePopup();
        } else {
            this.myResultsList.repaint();
        }
    }

    private void showMoreElements(SearchEverywhereContributor contributor) {
        this.featureTriggered("moreItemChosen", null);
        Map<SearchEverywhereContributor<?>, Collection<SESearcher.ElementInfo>> found = this.myListModel.getFoundElementsMap();
        int limit = this.myListModel.getItemsForContributor(contributor) + (this.mySelectedTab.getContributor().isPresent() ? 30 : 15);
        this.mySearchProgressIndicator = this.mySearcher.findMoreItems(found, this.getSearchPattern(), this.isUseNonProjectItems(), contributor, limit, c -> this.myContributorFilters.get(c.getSearchProviderId()));
    }

    private void stopSearching() {
        this.mySearchAlarm.cancelAllRequests();
        if (this.mySearchProgressIndicator != null && !this.mySearchProgressIndicator.isCanceled()) {
            this.mySearchProgressIndicator.cancel();
        }
        if (this.myBufferedListener != null) {
            this.myBufferedListener.clearBuffer();
        }
    }

    private void closePopup() {
        ActionMenu.showDescriptionInStatusBar(true, (Component)this.myResultsList, null);
        this.stopSearching();
        this.searchFinishedHandler.run();
    }

    @NotNull
    private List<SearchEverywhereContributor<?>> getUsedContributors() {
        SearchEverywhereContributorFilter<?> contributorsFilter = this.myContributorFilters.get("SearchEverywhereContributor.All");
        ArrayList contributors = new ArrayList();
        this.myServiceContributors.forEach(contributor -> contributors.add((SearchEverywhereContributor<?>)contributor));
        this.myShownContributors.stream().filter(contributor -> contributorsFilter.isSelected((Object)contributor.getSearchProviderId())).forEach(contributor -> contributors.add((SearchEverywhereContributor<?>)contributor));
        ArrayList arrayList = contributors;
        if (arrayList == null) {
            SearchEverywhereUI.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    private Collection<SearchEverywhereContributor<?>> getContributorsForCurrentTab() {
        Collection<Object> collection = this.isAllTabSelected() ? this.getUsedContributors() : Collections.singleton(this.mySelectedTab.getContributor().get());
        if (collection == null) {
            SearchEverywhereUI.$$$reportNull$$$0(10);
        }
        return collection;
    }

    private static JLabel groupInfoLabel(String text) {
        JLabel label2 = new JLabel(text);
        label2.setForeground(JBUI.CurrentTheme.BigPopup.listTitleLabelForeground());
        label2.setFont(UIUtil.getLabelFont().deriveFont(UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL)));
        label2.setOpaque(false);
        return label2;
    }

    private String getNotFoundText() {
        return this.mySelectedTab.getContributor().map(c -> IdeBundle.message((String)"searcheverywhere.nothing.found.for.contributor.anywhere", (Object[])new Object[]{c.getFullGroupName()})).orElse(IdeBundle.message((String)"searcheverywhere.nothing.found.for.all.anywhere", (Object[])new Object[0]));
    }

    private void featureTriggered(@NotNull String featureID, @Nullable FUSUsageContext context) {
        if (featureID == null) {
            SearchEverywhereUI.$$$reportNull$$$0(11);
        }
        SearchEverywhereUsageTriggerCollector.trigger(this.myProject, featureID, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "featureID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCellRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createList";
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettingsPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialHint";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchField";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTopLeftPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandsForCompletion";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedContributors";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getContributorsForCurrentTab";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onMouseClicked";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "featureTriggered";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getData$9";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CompleteCommandAction
    extends DumbAwareAction {
        private CompleteCommandAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CompleteCommandAction.$$$reportNull$$$0(0);
            }
            if (this.completeCommand()) {
                FUSUsageContext context = SearchEverywhereUI.getEventShortcut(e).map(shortcut -> FUSUsageContext.create(shortcut)).orElse(null);
                SearchEverywhereUI.this.featureTriggered("commandCompleted", context);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CompleteCommandAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(this.getCompleteCommand().isPresent());
        }

        private boolean completeCommand() {
            Optional<SearchEverywhereCommandInfo> suggestedCommand = this.getCompleteCommand();
            if (suggestedCommand.isPresent()) {
                SearchEverywhereUI.this.mySearchField.setText(suggestedCommand.get().getCommandWithPrefix() + " ");
                return true;
            }
            return false;
        }

        private Optional<SearchEverywhereCommandInfo> getCompleteCommand() {
            String commandPrefix;
            String pattern = SearchEverywhereUI.this.getSearchPattern();
            if (pattern.startsWith(commandPrefix = SearchTopHitProvider.getTopHitAccelerator()) && !pattern.contains(" ")) {
                String typedCommand = pattern.substring(commandPrefix.length());
                SearchEverywhereCommandInfo command = SearchEverywhereUI.this.getSelectedCommand(typedCommand).orElseGet(() -> {
                    List completions = SearchEverywhereUI.getCommandsForCompletion(SearchEverywhereUI.this.getContributorsForCurrentTab(), typedCommand);
                    return completions.isEmpty() ? null : (SearchEverywhereCommandInfo)completions.get(0);
                });
                return Optional.ofNullable(command);
            }
            return Optional.empty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$CompleteCommandAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SearchEverywhereShowFilterAction
    extends ShowFilterAction {
        public SearchEverywhereShowFilterAction(Disposable parentDisposable) {
            if (parentDisposable == null) {
                SearchEverywhereShowFilterAction.$$$reportNull$$$0(0);
            }
            super(parentDisposable, SearchEverywhereUI.this.myProject);
        }

        @Override
        public boolean isEnabled() {
            return SearchEverywhereUI.this.myContributorFilters.get(SearchEverywhereUI.this.getSelectedContributorID()) != null;
        }

        @Override
        protected boolean isActive() {
            String contributorID = SearchEverywhereUI.this.getSelectedContributorID();
            SearchEverywhereContributorFilter filter = (SearchEverywhereContributorFilter)SearchEverywhereUI.this.myContributorFilters.get(contributorID);
            if (filter == null) {
                return false;
            }
            return filter.getAllElements().size() != filter.getSelectedElements().size();
        }

        @Override
        protected ElementsChooser<?> createChooser() {
            SearchEverywhereContributorFilter filter = (SearchEverywhereContributorFilter)SearchEverywhereUI.this.myContributorFilters.get(SearchEverywhereUI.this.getSelectedContributorID());
            return this.createChooser(filter);
        }

        private <T> ElementsChooser<T> createChooser(final SearchEverywhereContributorFilter<T> filter) {
            ElementsChooser res2 = new ElementsChooser<T>(filter.getAllElements(), false){

                @Override
                protected String getItemText(@NotNull T value) {
                    if (value == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return filter.getElementText(value);
                }

                @Override
                @Nullable
                protected Icon getItemIcon(@NotNull T value) {
                    if (value == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return filter.getElementIcon(value);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "value";
                    objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$SearchEverywhereShowFilterAction$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getItemText";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getItemIcon";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            res2.markElements(filter.getSelectedElements());
            ElementsChooser.ElementsMarkListener<Object> listener2 = (element, isMarked) -> {
                filter.setSelected(element, isMarked);
                SearchEverywhereUI.this.rebuildList();
            };
            res2.addElementsMarkListener(listener2);
            return res2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$SearchEverywhereShowFilterAction", "<init>"));
        }
    }

    private class ShowInFindToolWindowAction
    extends DumbAwareAction {
        ShowInFindToolWindowAction() {
            super(IdeBundle.message((String)"searcheverywhere.show.in.find.window.button.name", (Object[])new Object[0]), IdeBundle.message((String)"searcheverywhere.show.in.find.window.button.name", (Object[])new Object[0]), AllIcons.General.Pin_tab);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowInFindToolWindowAction.$$$reportNull$$$0(0);
            }
            SearchEverywhereUI.this.stopSearching();
            Collection contributors = SearchEverywhereUI.this.getContributorsForCurrentTab();
            contributors = ContainerUtil.filter((Collection)contributors, SearchEverywhereContributor::showInFindResults);
            if (contributors.isEmpty()) {
                return;
            }
            final String searchText = SearchEverywhereUI.this.getSearchPattern();
            final boolean everywhere = SearchEverywhereUI.this.isUseNonProjectItems();
            String contributorsString = contributors.stream().map(SearchEverywhereContributor::getGroupName).collect(Collectors.joining(", "));
            final UsageViewPresentation presentation = new UsageViewPresentation();
            String tabCaptionText = IdeBundle.message((String)"searcheverywhere.found.matches.title", (Object[])new Object[]{searchText, contributorsString});
            presentation.setCodeUsagesString(tabCaptionText);
            presentation.setUsagesInGeneratedCodeString(IdeBundle.message((String)"searcheverywhere.found.matches.generated.code.title", (Object[])new Object[]{searchText, contributorsString}));
            presentation.setTargetsNodeText(IdeBundle.message((String)"searcheverywhere.found.targets.title", (Object[])new Object[]{searchText, contributorsString}));
            presentation.setTabName(tabCaptionText);
            presentation.setTabText(tabCaptionText);
            final LinkedHashSet<Usage> usages = new LinkedHashSet<Usage>();
            final LinkedHashSet<PsiElement> targets = new LinkedHashSet<PsiElement>();
            final Collection cached = contributors.stream().flatMap(contributor -> SearchEverywhereUI.this.myListModel.getFoundItems((SearchEverywhereContributor)contributor).stream()).collect(Collectors.toSet());
            this.fillUsages(cached, usages, targets);
            final List contributorsForAdditionalSearch = ContainerUtil.filter((Collection)contributors, contributor -> SearchEverywhereUI.this.myListModel.hasMoreElements((SearchEverywhereContributor)contributor));
            SearchEverywhereUI.this.closePopup();
            if (!contributorsForAdditionalSearch.isEmpty()) {
                ProgressManager.getInstance().run((Task)new Task.Modal(SearchEverywhereUI.this.myProject, tabCaptionText, true){
                    private final ProgressIndicator progressIndicator;
                    {
                        super(arg0, arg1, arg2);
                        this.progressIndicator = new ProgressIndicatorBase();
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        this.progressIndicator.start();
                        TooManyUsagesStatus tooManyUsagesStatus = TooManyUsagesStatus.createFor(this.progressIndicator);
                        ArrayList foundElements = new ArrayList();
                        int alreadyFoundCount = cached.size();
                        contributorsForAdditionalSearch.forEach(contributor -> {
                            if (!this.progressIndicator.isCanceled()) {
                                try {
                                    contributor.fetchElements(searchText, everywhere, (SearchEverywhereContributorFilter)SearchEverywhereUI.this.myContributorFilters.get(contributor.getSearchProviderId()), this.progressIndicator, o -> {
                                        if (this.progressIndicator.isCanceled()) {
                                            return false;
                                        }
                                        if (cached.contains(o)) {
                                            return true;
                                        }
                                        foundElements.add(o);
                                        tooManyUsagesStatus.pauseProcessingIfTooManyUsages();
                                        if (foundElements.size() + alreadyFoundCount >= 1000 && tooManyUsagesStatus.switchTooManyUsagesStatus()) {
                                            int usageCount = foundElements.size() + alreadyFoundCount;
                                            UsageViewManagerImpl.showTooManyUsagesWarningLater((Project)this.getProject(), (TooManyUsagesStatus)tooManyUsagesStatus, (ProgressIndicator)this.progressIndicator, (UsageViewPresentation)presentation, (int)usageCount, null);
                                            return !this.progressIndicator.isCanceled();
                                        }
                                        return true;
                                    });
                                }
                                catch (ProcessCanceledException e) {
                                    return;
                                }
                            }
                        });
                        ShowInFindToolWindowAction.this.fillUsages(foundElements, usages, targets);
                    }

                    public void onCancel() {
                        this.progressIndicator.cancel();
                    }

                    public void onSuccess() {
                        ShowInFindToolWindowAction.this.showInFindWindow(targets, usages, presentation);
                    }

                    public void onThrowable(@NotNull Throwable error) {
                        if (error == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        this.progressIndicator.cancel();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "indicator";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "error";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$ShowInFindToolWindowAction$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "run";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onThrowable";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            } else {
                this.showInFindWindow(targets, usages, presentation);
            }
        }

        private void fillUsages(Collection<Object> foundElements, Collection<Usage> usages, Collection<PsiElement> targets) {
            ReadAction.run(() -> foundElements.stream().filter(o -> o instanceof PsiElement).forEach(o -> {
                PsiElement element = (PsiElement)o;
                if (element.getTextRange() != null) {
                    UsageInfo usageInfo = new UsageInfo(element);
                    usages.add((Usage)new UsageInfo2UsageAdapter(usageInfo));
                } else {
                    targets.add(element);
                }
            }));
        }

        private void showInFindWindow(Collection<PsiElement> targets, Collection<Usage> usages, UsageViewPresentation presentation) {
            UsageTarget[] targetsArray = targets.isEmpty() ? UsageTarget.EMPTY_ARRAY : PsiElement2UsageTargetAdapter.convert(PsiUtilCore.toPsiElementArray(targets));
            Usage[] usagesArray = usages.toArray(Usage.EMPTY_ARRAY);
            UsageViewManager.getInstance((Project)SearchEverywhereUI.this.myProject).showUsages(targetsArray, usagesArray, presentation);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowInFindToolWindowAction.$$$reportNull$$$0(1);
            }
            Boolean enabled = SearchEverywhereUI.this.mySelectedTab.getContributor().map(contributor -> contributor.showInFindResults()).orElse(true);
            e.getPresentation().setEnabled(enabled.booleanValue());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$ShowInFindToolWindowAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SearchListModel
    extends AbstractListModel<Object> {
        private static final Object MORE_ELEMENT = new Object();
        private final List<SESearcher.ElementInfo> listElements = new ArrayList<SESearcher.ElementInfo>();

        @Override
        public int getSize() {
            return this.listElements.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.listElements.get(index).getElement();
        }

        public Collection<Object> getFoundItems(SearchEverywhereContributor contributor) {
            return this.listElements.stream().filter(info -> info.getContributor() == contributor && info.getElement() != MORE_ELEMENT).map(info -> info.getElement()).collect(Collectors.toList());
        }

        public boolean hasMoreElements(SearchEverywhereContributor contributor) {
            return this.listElements.stream().anyMatch(info -> info.getElement() == MORE_ELEMENT && info.getContributor() == contributor);
        }

        public void addElements(List<SESearcher.ElementInfo> items, SearchEverywhereContributor contributor) {
            if (items.isEmpty()) {
                return;
            }
            int startIndex = this.getInsertionPoint(contributor);
            int endIndex = startIndex + items.size() - 1;
            this.listElements.addAll(startIndex, items);
            this.fireIntervalAdded(this, startIndex, endIndex);
        }

        public void removeElement(@NotNull Object item, SearchEverywhereContributor contributor) {
            int index;
            if (item == null) {
                SearchListModel.$$$reportNull$$$0(0);
            }
            if ((index = this.contributors().indexOf(contributor)) < 0) {
                return;
            }
            while (index < this.listElements.size() && this.listElements.get(index).getContributor() == contributor) {
                if (item.equals(this.listElements.get(index).getElement())) {
                    this.listElements.remove(index);
                    this.fireIntervalRemoved(this, index, index);
                    return;
                }
                ++index;
            }
        }

        public void setHasMore(SearchEverywhereContributor<?> contributor, boolean newVal) {
            int index = this.contributors().lastIndexOf(contributor);
            if (index < 0) {
                return;
            }
            boolean alreadyHas = this.isMoreElement(index);
            if (alreadyHas && !newVal) {
                this.listElements.remove(index);
                this.fireIntervalRemoved(this, index, index);
            }
            if (!alreadyHas && newVal) {
                this.listElements.add(++index, new SESearcher.ElementInfo(MORE_ELEMENT, 0, contributor));
                this.fireIntervalAdded(this, index, index);
            }
        }

        public void clear() {
            int index = this.listElements.size() - 1;
            this.listElements.clear();
            if (index >= 0) {
                this.fireIntervalRemoved(this, 0, index);
            }
        }

        public boolean contains(Object val) {
            return this.values().contains(val);
        }

        public boolean isMoreElement(int index) {
            return this.listElements.get(index).getElement() == MORE_ELEMENT;
        }

        public SearchEverywhereContributor getContributorForIndex(int index) {
            return this.listElements.get(index).getContributor();
        }

        public boolean isGroupFirstItem(int index) {
            return index == 0 || this.listElements.get(index).getContributor() != this.listElements.get(index - 1).getContributor();
        }

        public int getItemsForContributor(SearchEverywhereContributor contributor) {
            List<SearchEverywhereContributor> contributorsList = this.contributors();
            int first = contributorsList.indexOf(contributor);
            int last = contributorsList.lastIndexOf(contributor);
            if (this.isMoreElement(last)) {
                --last;
            }
            return last - first + 1;
        }

        public Map<SearchEverywhereContributor<?>, Collection<SESearcher.ElementInfo>> getFoundElementsMap() {
            return this.listElements.stream().filter(info -> info.element != MORE_ELEMENT).collect(Collectors.groupingBy(o -> o.getContributor(), Collectors.toCollection(ArrayList::new)));
        }

        @NotNull
        private List<SearchEverywhereContributor> contributors() {
            List list2 = Lists.transform(this.listElements, info -> info.getContributor());
            if (list2 == null) {
                SearchListModel.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @NotNull
        private List<Object> values() {
            List list2 = Lists.transform(this.listElements, info -> info.getElement());
            if (list2 == null) {
                SearchListModel.$$$reportNull$$$0(2);
            }
            return list2;
        }

        private int getInsertionPoint(SearchEverywhereContributor contributor) {
            if (this.listElements.isEmpty()) {
                return 0;
            }
            List<SearchEverywhereContributor> list2 = this.contributors();
            int index = list2.lastIndexOf(contributor);
            if (index >= 0) {
                return this.isMoreElement(index) ? index : index + 1;
            }
            for (int i = 0; i < list2.size(); ++i) {
                if (list2.get(i).getSortWeight() <= contributor.getSortWeight()) continue;
                return i;
            }
            return this.listElements.size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$SearchListModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$SearchListModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "contributors";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "values";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "removeElement";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class GroupTitleRenderer
    extends JPanel {
        private final JLabel titleLabel;
        private final BorderLayout myLayout = new BorderLayout();

        public GroupTitleRenderer() {
            this.setLayout(this.myLayout);
            this.setBackground(UIUtil.getListBackground((boolean)false));
            this.titleLabel = SearchEverywhereUI.groupInfoLabel("Group");
            SeparatorComponent separatorComponent = new SeparatorComponent(this.titleLabel.getPreferredSize().height / 2, JBUI.CurrentTheme.BigPopup.listSeparatorColor(), null);
            JBPanel topPanel = ((BorderLayoutPanel)JBUI.Panels.simplePanel((int)5, (int)0).addToCenter((Component)separatorComponent).addToLeft((Component)this.titleLabel).withBorder((Border)JBUI.Borders.empty((int)0, (int)7))).withBackground(UIUtil.getListBackground());
            this.add((Component)topPanel, "North");
        }

        public GroupTitleRenderer withDisplayedData(String title, Component itemContent) {
            this.titleLabel.setText(title);
            Component prevContent = this.myLayout.getLayoutComponent("Center");
            if (prevContent != null) {
                this.remove(prevContent);
            }
            this.add(itemContent, "Center");
            return this;
        }
    }

    public static class MoreRenderer
    extends JPanel
    implements ListCellRenderer<Object> {
        final JLabel label = SearchEverywhereUI.access$2300("... more");

        private MoreRenderer() {
            super(new BorderLayout());
            this.add((Component)this.label, "Center");
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBackground(UIUtil.getListBackground((boolean)isSelected));
            return this;
        }
    }

    public static class CommandRenderer
    extends ColoredListCellRenderer<Object> {
        protected void customizeCellRenderer(@NotNull JList<?> list2, Object value, int index, boolean selected, boolean hasFocus) {
            if (list2 == null) {
                CommandRenderer.$$$reportNull$$$0(0);
            }
            this.setPaintFocusBorder(false);
            this.setIcon(EmptyIcon.ICON_16);
            this.setFont(list2.getFont());
            SearchEverywhereCommandInfo command = (SearchEverywhereCommandInfo)value;
            this.append(command.getCommandWithPrefix() + " ", new SimpleTextAttributes(0, list2.getForeground()));
            this.append(command.getDefinition(), new SimpleTextAttributes(0, (Color)JBColor.GRAY));
            this.setBackground(UIUtil.getListBackground((boolean)selected));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/actions/searcheverywhere/SearchEverywhereUI$CommandRenderer", "customizeCellRenderer"));
        }
    }

    private class CompositeCellRenderer
    implements ListCellRenderer<Object> {
        private CompositeCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (SearchEverywhereUI.this.myListModel.isMoreElement(index)) {
                Component cmp = SearchEverywhereUI.this.moreRenderer.getListCellRendererComponent((JList<?>)list2, value, index, isSelected, cellHasFocus);
                return this.wrap(cmp, 1, 7);
            }
            SearchEverywhereContributor contributor = SearchEverywhereUI.this.myListModel.getContributorForIndex(index);
            Component component = SearchEverywhereClassifier.EP_Manager.getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
            if (component == null) {
                component = contributor.getElementsRenderer((JList)SearchEverywhereUI.this.myResultsList).getListCellRendererComponent(list2, value, index, isSelected, cellHasFocus);
            }
            if (SearchEverywhereUI.this.isAllTabSelected() && SearchEverywhereUI.this.myListModel.isGroupFirstItem(index)) {
                component = SearchEverywhereUI.this.groupTitleRenderer.withDisplayedData(contributor.getFullGroupName(), component);
            }
            return this.wrap(component, 1, 0);
        }

        private Component wrap(Component cmp, int verticalGap, int hotizontalGap) {
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.setOpaque(cmp.isOpaque());
            if (cmp.isOpaque()) {
                panel2.setBackground(cmp.getBackground());
            }
            panel2.add(cmp, "Center");
            panel2.setBorder((Border)JBUI.Borders.empty((int)verticalGap, (int)hotizontalGap));
            return panel2;
        }
    }

    private class SETab
    extends JLabel {
        private final SearchEverywhereContributor myContributor;

        SETab(SearchEverywhereContributor contributor) {
            super(contributor == null ? IdeBundle.message((String)"searcheverywhere.allelements.tab.name", (Object[])new Object[0]) : contributor.getGroupName());
            this.myContributor = contributor;
            Insets insets = JBUI.CurrentTheme.BigPopup.tabInsets();
            this.setBorder((Border)JBUI.Borders.empty((int)insets.top, (int)insets.left, (int)insets.bottom, (int)insets.right));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    SearchEverywhereUI.this.switchToTab(SETab.this);
                    SearchEverywhereUI.this.featureTriggered("tabSwitched", FUSUsageContext.create(SETab.this.getID(), "mouseClick"));
                }
            });
        }

        public String getID() {
            return this.getContributor().map(SearchEverywhereContributor::getSearchProviderId).orElse("SearchEverywhereContributor.All");
        }

        public Optional<SearchEverywhereContributor> getContributor() {
            return Optional.ofNullable(this.myContributor);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.height = JBUI.scale((int)29);
            return size;
        }

        @Override
        public boolean isOpaque() {
            return SearchEverywhereUI.this.mySelectedTab == this;
        }

        @Override
        public Color getBackground() {
            return SearchEverywhereUI.this.mySelectedTab == this ? JBUI.CurrentTheme.BigPopup.selectedTabColor() : super.getBackground();
        }

        @Override
        public Color getForeground() {
            return SearchEverywhereUI.this.mySelectedTab == this ? JBUI.CurrentTheme.BigPopup.selectedTabTextColor() : super.getForeground();
        }
    }
}

