/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.editor;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.json.editor.JsonEditorOptions;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonCopyPasteProcessor
implements CopyPastePreProcessor {
    @Override
    @Nullable
    public String preprocessOnCopy(PsiFile file2, int[] startOffsets, int[] endOffsets, String text) {
        if (!JsonEditorOptions.getInstance().ESCAPE_PASTED_TEXT) {
            return null;
        }
        if (!file2.isPhysical() || startOffsets.length > 1 || endOffsets.length > 1) {
            return null;
        }
        int selectionStart = startOffsets[0];
        int selectionEnd = endOffsets[0];
        JsonStringLiteral literalExpression = JsonCopyPasteProcessor.getSingleElementFromSelectionOrNull(file2, selectionStart, selectionEnd);
        if (literalExpression == null) {
            return null;
        }
        return StringUtil.unescapeStringCharacters((String)StringUtil.replaceUnicodeEscapeSequences((String)text));
    }

    @Nullable
    private static JsonStringLiteral getSingleElementFromSelectionOrNull(PsiFile file2, int start2, int end) {
        PsiElement element = file2.findElementAt(start2);
        JsonStringLiteral literalExpression = (JsonStringLiteral)PsiTreeUtil.getParentOfType((PsiElement)element, JsonStringLiteral.class);
        if (literalExpression == null) {
            return null;
        }
        TextRange textRange = literalExpression.getTextRange();
        if (start2 <= textRange.getStartOffset() || end >= textRange.getEndOffset()) {
            return null;
        }
        String text = literalExpression.getText();
        if (!text.startsWith("\"") || !text.endsWith("\"")) {
            return null;
        }
        return literalExpression;
    }

    @Override
    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file2, Editor editor, String text, RawText rawText) {
        int selectionEnd;
        if (!JsonEditorOptions.getInstance().ESCAPE_PASTED_TEXT) {
            String string = text;
            if (string == null) {
                JsonCopyPasteProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (!file2.isPhysical()) {
            String string = text;
            if (string == null) {
                JsonCopyPasteProcessor.$$$reportNull$$$0(1);
            }
            return string;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        JsonStringLiteral literalExpression = JsonCopyPasteProcessor.getSingleElementFromSelectionOrNull(file2, selectionStart, selectionEnd = selectionModel.getSelectionEnd());
        if (literalExpression == null) {
            String string = text;
            if (string == null) {
                JsonCopyPasteProcessor.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = StringUtil.escapeStringCharacters((String)text);
        if (string == null) {
            JsonCopyPasteProcessor.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/editor/JsonCopyPasteProcessor", "preprocessOnPaste"));
    }
}

